// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreviewRequest
type CreateExclusionsPreviewInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template for which you want to create
	// an exclusions preview.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateExclusionsPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExclusionsPreviewInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateExclusionsPreviewInput"}

	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreviewResponse
type CreateExclusionsPreviewOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique identifier of the requested exclusions preview. You
	// can use the unique identifier to retrieve the exclusions preview when running
	// the GetExclusionsPreview API.
	//
	// PreviewToken is a required field
	PreviewToken *string `locationName:"previewToken" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateExclusionsPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateExclusionsPreview = "CreateExclusionsPreview"

// CreateExclusionsPreviewRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Starts the generation of an exclusions preview for the specified assessment
// template. The exclusions preview lists the potential exclusions (ExclusionPreview)
// that Inspector can detect before it runs the assessment.
//
//    // Example sending a request using CreateExclusionsPreviewRequest.
//    req := client.CreateExclusionsPreviewRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview
func (c *Client) CreateExclusionsPreviewRequest(input *CreateExclusionsPreviewInput) CreateExclusionsPreviewRequest {
	op := &aws.Operation{
		Name:       opCreateExclusionsPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExclusionsPreviewInput{}
	}

	req := c.newRequest(op, input, &CreateExclusionsPreviewOutput{})
	return CreateExclusionsPreviewRequest{Request: req, Input: input, Copy: c.CreateExclusionsPreviewRequest}
}

// CreateExclusionsPreviewRequest is the request type for the
// CreateExclusionsPreview API operation.
type CreateExclusionsPreviewRequest struct {
	*aws.Request
	Input *CreateExclusionsPreviewInput
	Copy  func(*CreateExclusionsPreviewInput) CreateExclusionsPreviewRequest
}

// Send marshals and sends the CreateExclusionsPreview API request.
func (r CreateExclusionsPreviewRequest) Send(ctx context.Context) (*CreateExclusionsPreviewResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateExclusionsPreviewResponse{
		CreateExclusionsPreviewOutput: r.Request.Data.(*CreateExclusionsPreviewOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateExclusionsPreviewResponse is the response type for the
// CreateExclusionsPreview API operation.
type CreateExclusionsPreviewResponse struct {
	*CreateExclusionsPreviewOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateExclusionsPreview request.
func (r *CreateExclusionsPreviewResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
