// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeThingRegistrationTaskInput struct {
	_ struct{} `type:"structure"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingRegistrationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingRegistrationTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeThingRegistrationTaskInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThingRegistrationTaskInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeThingRegistrationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task creation date.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The number of things that failed to be provisioned.
	FailureCount *int64 `locationName:"failureCount" type:"integer"`

	// The S3 bucket that contains the input file.
	InputFileBucket *string `locationName:"inputFileBucket" min:"3" type:"string"`

	// The input file key.
	InputFileKey *string `locationName:"inputFileKey" min:"1" type:"string"`

	// The date when the task was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The message.
	Message *string `locationName:"message" type:"string"`

	// The progress of the bulk provisioning task expressed as a percentage.
	PercentageProgress *int64 `locationName:"percentageProgress" type:"integer"`

	// The role ARN that grants access to the input file bucket.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The status of the bulk thing provisioning task.
	Status Status `locationName:"status" type:"string" enum:"true"`

	// The number of things successfully provisioned.
	SuccessCount *int64 `locationName:"successCount" type:"integer"`

	// The task ID.
	TaskId *string `locationName:"taskId" type:"string"`

	// The task's template.
	TemplateBody *string `locationName:"templateBody" type:"string"`
}

// String returns the string representation
func (s DescribeThingRegistrationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeThingRegistrationTaskOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.FailureCount != nil {
		v := *s.FailureCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCount", protocol.Int64Value(v), metadata)
	}
	if s.InputFileBucket != nil {
		v := *s.InputFileBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputFileBucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputFileKey != nil {
		v := *s.InputFileKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputFileKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PercentageProgress != nil {
		v := *s.PercentageProgress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "percentageProgress", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SuccessCount != nil {
		v := *s.SuccessCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "successCount", protocol.Int64Value(v), metadata)
	}
	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateBody != nil {
		v := *s.TemplateBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeThingRegistrationTask = "DescribeThingRegistrationTask"

// DescribeThingRegistrationTaskRequest returns a request value for making API operation for
// AWS IoT.
//
// Describes a bulk thing provisioning task.
//
//    // Example sending a request using DescribeThingRegistrationTaskRequest.
//    req := client.DescribeThingRegistrationTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeThingRegistrationTaskRequest(input *DescribeThingRegistrationTaskInput) DescribeThingRegistrationTaskRequest {
	op := &aws.Operation{
		Name:       opDescribeThingRegistrationTask,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeThingRegistrationTaskInput{}
	}

	req := c.newRequest(op, input, &DescribeThingRegistrationTaskOutput{})
	return DescribeThingRegistrationTaskRequest{Request: req, Input: input, Copy: c.DescribeThingRegistrationTaskRequest}
}

// DescribeThingRegistrationTaskRequest is the request type for the
// DescribeThingRegistrationTask API operation.
type DescribeThingRegistrationTaskRequest struct {
	*aws.Request
	Input *DescribeThingRegistrationTaskInput
	Copy  func(*DescribeThingRegistrationTaskInput) DescribeThingRegistrationTaskRequest
}

// Send marshals and sends the DescribeThingRegistrationTask API request.
func (r DescribeThingRegistrationTaskRequest) Send(ctx context.Context) (*DescribeThingRegistrationTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeThingRegistrationTaskResponse{
		DescribeThingRegistrationTaskOutput: r.Request.Data.(*DescribeThingRegistrationTaskOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeThingRegistrationTaskResponse is the response type for the
// DescribeThingRegistrationTask API operation.
type DescribeThingRegistrationTaskResponse struct {
	*DescribeThingRegistrationTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeThingRegistrationTask request.
func (r *DescribeThingRegistrationTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
