// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RemoveThingFromBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The ARN of the thing to be removed from the billing group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing to be removed from the billing group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveThingFromBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveThingFromBillingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveThingFromBillingGroupInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveThingFromBillingGroupInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.BillingGroupArn != nil {
		v := *s.BillingGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "billingGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BillingGroupName != nil {
		v := *s.BillingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "billingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RemoveThingFromBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveThingFromBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveThingFromBillingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opRemoveThingFromBillingGroup = "RemoveThingFromBillingGroup"

// RemoveThingFromBillingGroupRequest returns a request value for making API operation for
// AWS IoT.
//
// Removes the given thing from the billing group.
//
//    // Example sending a request using RemoveThingFromBillingGroupRequest.
//    req := client.RemoveThingFromBillingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RemoveThingFromBillingGroupRequest(input *RemoveThingFromBillingGroupInput) RemoveThingFromBillingGroupRequest {
	op := &aws.Operation{
		Name:       opRemoveThingFromBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/removeThingFromBillingGroup",
	}

	if input == nil {
		input = &RemoveThingFromBillingGroupInput{}
	}

	req := c.newRequest(op, input, &RemoveThingFromBillingGroupOutput{})
	return RemoveThingFromBillingGroupRequest{Request: req, Input: input, Copy: c.RemoveThingFromBillingGroupRequest}
}

// RemoveThingFromBillingGroupRequest is the request type for the
// RemoveThingFromBillingGroup API operation.
type RemoveThingFromBillingGroupRequest struct {
	*aws.Request
	Input *RemoveThingFromBillingGroupInput
	Copy  func(*RemoveThingFromBillingGroupInput) RemoveThingFromBillingGroupRequest
}

// Send marshals and sends the RemoveThingFromBillingGroup API request.
func (r RemoveThingFromBillingGroupRequest) Send(ctx context.Context) (*RemoveThingFromBillingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveThingFromBillingGroupResponse{
		RemoveThingFromBillingGroupOutput: r.Request.Data.(*RemoveThingFromBillingGroupOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveThingFromBillingGroupResponse is the response type for the
// RemoveThingFromBillingGroup API operation.
type RemoveThingFromBillingGroupResponse struct {
	*RemoveThingFromBillingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveThingFromBillingGroup request.
func (r *RemoveThingFromBillingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
