// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastoreRequest
type CreateDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// Metadata which can be used to manage the data store.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatastoreInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDatastoreInput"}

	if s.DatastoreName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDatastoreInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DatastoreName != nil {
		v := *s.DatastoreName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datastoreName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetentionPeriod != nil {
		v := s.RetentionPeriod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retentionPeriod", v, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastoreResponse
type CreateDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the data store.
	DatastoreArn *string `locationName:"datastoreArn" type:"string"`

	// The name of the data store.
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s CreateDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDatastoreOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DatastoreArn != nil {
		v := *s.DatastoreArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datastoreArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DatastoreName != nil {
		v := *s.DatastoreName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datastoreName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetentionPeriod != nil {
		v := s.RetentionPeriod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retentionPeriod", v, metadata)
	}
	return nil
}

const opCreateDatastore = "CreateDatastore"

// CreateDatastoreRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Creates a data store, which is a repository for messages.
//
//    // Example sending a request using CreateDatastoreRequest.
//    req := client.CreateDatastoreRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastore
func (c *Client) CreateDatastoreRequest(input *CreateDatastoreInput) CreateDatastoreRequest {
	op := &aws.Operation{
		Name:       opCreateDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/datastores",
	}

	if input == nil {
		input = &CreateDatastoreInput{}
	}

	req := c.newRequest(op, input, &CreateDatastoreOutput{})
	return CreateDatastoreRequest{Request: req, Input: input, Copy: c.CreateDatastoreRequest}
}

// CreateDatastoreRequest is the request type for the
// CreateDatastore API operation.
type CreateDatastoreRequest struct {
	*aws.Request
	Input *CreateDatastoreInput
	Copy  func(*CreateDatastoreInput) CreateDatastoreRequest
}

// Send marshals and sends the CreateDatastore API request.
func (r CreateDatastoreRequest) Send(ctx context.Context) (*CreateDatastoreResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDatastoreResponse{
		CreateDatastoreOutput: r.Request.Data.(*CreateDatastoreOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDatastoreResponse is the response type for the
// CreateDatastore API operation.
type CreateDatastoreResponse struct {
	*CreateDatastoreOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDatastore request.
func (r *CreateDatastoreResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
