// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImportRequest
type GetParametersForImportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the CMK into which you will import key material. The CMK's
	// Origin must be EXTERNAL.
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The algorithm you will use to encrypt the key material before importing it
	// with ImportKeyMaterial. For more information, see Encrypt the Key Material
	// (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
	// in the AWS Key Management Service Developer Guide.
	//
	// WrappingAlgorithm is a required field
	WrappingAlgorithm AlgorithmSpec `type:"string" required:"true" enum:"true"`

	// The type of wrapping key (public key) to return in the response. Only 2048-bit
	// RSA public keys are supported.
	//
	// WrappingKeySpec is a required field
	WrappingKeySpec WrappingKeySpec `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetParametersForImportInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersForImportInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetParametersForImportInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}
	if len(s.WrappingAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("WrappingAlgorithm"))
	}
	if len(s.WrappingKeySpec) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("WrappingKeySpec"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImportResponse
type GetParametersForImportOutput struct {
	_ struct{} `type:"structure"`

	// The import token to send in a subsequent ImportKeyMaterial request.
	//
	// ImportToken is automatically base64 encoded/decoded by the SDK.
	ImportToken []byte `min:"1" type:"blob"`

	// The identifier of the CMK to use in a subsequent ImportKeyMaterial request.
	// This is the same CMK specified in the GetParametersForImport request.
	KeyId *string `min:"1" type:"string"`

	// The time at which the import token and public key are no longer valid. After
	// this time, you cannot use them to make an ImportKeyMaterial request and you
	// must send another GetParametersForImport request to get new ones.
	ParametersValidTo *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The public key to use to encrypt the key material before importing it with
	// ImportKeyMaterial.
	//
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GetParametersForImportOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetParametersForImport = "GetParametersForImport"

// GetParametersForImportRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Returns the items you need in order to import key material into AWS KMS from
// your existing key management infrastructure. For more information about importing
// key material into AWS KMS, see Importing Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// You must specify the key ID of the customer master key (CMK) into which you
// will import key material. This CMK's Origin must be EXTERNAL. You must also
// specify the wrapping algorithm and type of wrapping key (public key) that
// you will use to encrypt the key material. You cannot perform this operation
// on a CMK in a different AWS account.
//
// This operation returns a public key and an import token. Use the public key
// to encrypt the key material. Store the import token to send with a subsequent
// ImportKeyMaterial request. The public key and import token from the same
// response must be used together. These items are valid for 24 hours. When
// they expire, they cannot be used for a subsequent ImportKeyMaterial request.
// To get new ones, send another GetParametersForImport request.
//
// The result of this operation varies with the key state of the CMK. For details,
// see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using GetParametersForImportRequest.
//    req := client.GetParametersForImportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImport
func (c *Client) GetParametersForImportRequest(input *GetParametersForImportInput) GetParametersForImportRequest {
	op := &aws.Operation{
		Name:       opGetParametersForImport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersForImportInput{}
	}

	req := c.newRequest(op, input, &GetParametersForImportOutput{})
	return GetParametersForImportRequest{Request: req, Input: input, Copy: c.GetParametersForImportRequest}
}

// GetParametersForImportRequest is the request type for the
// GetParametersForImport API operation.
type GetParametersForImportRequest struct {
	*aws.Request
	Input *GetParametersForImportInput
	Copy  func(*GetParametersForImportInput) GetParametersForImportRequest
}

// Send marshals and sends the GetParametersForImport API request.
func (r GetParametersForImportRequest) Send(ctx context.Context) (*GetParametersForImportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetParametersForImportResponse{
		GetParametersForImportOutput: r.Request.Data.(*GetParametersForImportOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetParametersForImportResponse is the response type for the
// GetParametersForImport API operation.
type GetParametersForImportResponse struct {
	*GetParametersForImportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetParametersForImport request.
func (r *GetParametersForImportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
