// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImportRequest
type StartImportInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that the StartImport operation should take when there
	// is an existing resource with the same name.
	//
	//    * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict
	//    between a resource in the import file and an existing resource. The name
	//    of the resource causing the conflict is in the failureReason field of
	//    the response to the GetImport operation. OVERWRITE_LATEST - The import
	//    operation proceeds even if there is a conflict with an existing resource.
	//    The $LASTEST version of the existing resource is overwritten with the
	//    data from the import file.
	//
	// MergeStrategy is a required field
	MergeStrategy MergeStrategy `locationName:"mergeStrategy" type:"string" required:"true" enum:"true"`

	// A zip archive in binary format. The archive should contain one file, a JSON
	// file containing the resource to import. The resource should match the type
	// specified in the resourceType field.
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`

	// Specifies the type of resource to export. Each resource also exports any
	// resources that it depends on.
	//
	//    * A bot exports dependent intents.
	//
	//    * An intent exports dependent slot types.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StartImportInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartImportInput"}
	if len(s.MergeStrategy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MergeStrategy"))
	}

	if s.Payload == nil {
		invalidParams.Add(aws.NewErrParamRequired("Payload"))
	}
	if len(s.ResourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartImportInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.MergeStrategy) > 0 {
		v := s.MergeStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mergeStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Payload != nil {
		v := s.Payload

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "payload", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImportResponse
type StartImportOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp for the date and time that the import job was requested.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The identifier for the specific import job.
	ImportId *string `locationName:"importId" type:"string"`

	// The status of the import job. If the status is FAILED, you can get the reason
	// for the failure using the GetImport operation.
	ImportStatus ImportStatus `locationName:"importStatus" type:"string" enum:"true"`

	// The action to take when there is a merge conflict.
	MergeStrategy MergeStrategy `locationName:"mergeStrategy" type:"string" enum:"true"`

	// The name given to the import job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The type of resource to import.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s StartImportOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartImportOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ImportId != nil {
		v := *s.ImportId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "importId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ImportStatus) > 0 {
		v := s.ImportStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "importStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MergeStrategy) > 0 {
		v := s.MergeStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mergeStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opStartImport = "StartImport"

// StartImportRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Starts a job to import a resource to Amazon Lex.
//
//    // Example sending a request using StartImportRequest.
//    req := client.StartImportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/StartImport
func (c *Client) StartImportRequest(input *StartImportInput) StartImportRequest {
	op := &aws.Operation{
		Name:       opStartImport,
		HTTPMethod: "POST",
		HTTPPath:   "/imports/",
	}

	if input == nil {
		input = &StartImportInput{}
	}

	req := c.newRequest(op, input, &StartImportOutput{})
	return StartImportRequest{Request: req, Input: input, Copy: c.StartImportRequest}
}

// StartImportRequest is the request type for the
// StartImport API operation.
type StartImportRequest struct {
	*aws.Request
	Input *StartImportInput
	Copy  func(*StartImportInput) StartImportRequest
}

// Send marshals and sends the StartImport API request.
func (r StartImportRequest) Send(ctx context.Context) (*StartImportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartImportResponse{
		StartImportOutput: r.Request.Data.(*StartImportOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartImportResponse is the response type for the
// StartImport API operation.
type StartImportResponse struct {
	*StartImportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartImport request.
func (r *StartImportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
