// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshotRequest
type CreateInstancesFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// An object containing information about one or more disk mappings.
	AttachedDiskMapping map[string][]DiskMap `locationName:"attachedDiskMapping" type:"map"`

	// The Availability Zone where you want to create your instances. Use the following
	// formatting: us-east-2a (case sensitive). You can get a list of Availability
	// Zones by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// The names for your new instances.
	//
	// InstanceNames is a required field
	InstanceNames []string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the instance snapshot on which you are basing your new instances.
	// Use the get instance snapshots operation to return information about your
	// existing snapshots.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`

	// The name for your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`

	// You can create a launch script that configures a server with additional user
	// data. For example, apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesFromSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInstancesFromSnapshotInput"}

	if s.AvailabilityZone == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZone"))
	}

	if s.BundleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BundleId"))
	}

	if s.InstanceNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceNames"))
	}

	if s.InstanceSnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshotResult
type CreateInstancesFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances from snapshot request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"

// CreateInstancesFromSnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Uses a specific snapshot as a blueprint for creating one or more new instances
// that are based on that identical configuration.
//
// The create instances from snapshot operation supports tag-based access control
// via request tags and resource tags applied to the resource identified by
// instanceSnapshotName. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateInstancesFromSnapshotRequest.
//    req := client.CreateInstancesFromSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Client) CreateInstancesFromSnapshotRequest(input *CreateInstancesFromSnapshotInput) CreateInstancesFromSnapshotRequest {
	op := &aws.Operation{
		Name:       opCreateInstancesFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesFromSnapshotInput{}
	}

	req := c.newRequest(op, input, &CreateInstancesFromSnapshotOutput{})
	return CreateInstancesFromSnapshotRequest{Request: req, Input: input, Copy: c.CreateInstancesFromSnapshotRequest}
}

// CreateInstancesFromSnapshotRequest is the request type for the
// CreateInstancesFromSnapshot API operation.
type CreateInstancesFromSnapshotRequest struct {
	*aws.Request
	Input *CreateInstancesFromSnapshotInput
	Copy  func(*CreateInstancesFromSnapshotInput) CreateInstancesFromSnapshotRequest
}

// Send marshals and sends the CreateInstancesFromSnapshot API request.
func (r CreateInstancesFromSnapshotRequest) Send(ctx context.Context) (*CreateInstancesFromSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInstancesFromSnapshotResponse{
		CreateInstancesFromSnapshotOutput: r.Request.Data.(*CreateInstancesFromSnapshotOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInstancesFromSnapshotResponse is the response type for the
// CreateInstancesFromSnapshot API operation.
type CreateInstancesFromSnapshotResponse struct {
	*CreateInstancesFromSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInstancesFromSnapshot request.
func (r *CreateInstancesFromSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
