// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mq

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypesRequest
type DescribeBrokerEngineTypesInput struct {
	_ struct{} `type:"structure"`

	EngineType *string `location:"querystring" locationName:"engineType" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerEngineTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBrokerEngineTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBrokerEngineTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeBrokerEngineTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.EngineType != nil {
		v := *s.EngineType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "engineType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypesResponse
type DescribeBrokerEngineTypesOutput struct {
	_ struct{} `type:"structure"`

	BrokerEngineTypes []BrokerEngineType `locationName:"brokerEngineTypes" type:"list"`

	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerEngineTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeBrokerEngineTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.BrokerEngineTypes) > 0 {
		v := s.BrokerEngineTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "brokerEngineTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeBrokerEngineTypes = "DescribeBrokerEngineTypes"

// DescribeBrokerEngineTypesRequest returns a request value for making API operation for
// AmazonMQ.
//
// Describe available engine types and versions.
//
//    // Example sending a request using DescribeBrokerEngineTypesRequest.
//    req := client.DescribeBrokerEngineTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes
func (c *Client) DescribeBrokerEngineTypesRequest(input *DescribeBrokerEngineTypesInput) DescribeBrokerEngineTypesRequest {
	op := &aws.Operation{
		Name:       opDescribeBrokerEngineTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/broker-engine-types",
	}

	if input == nil {
		input = &DescribeBrokerEngineTypesInput{}
	}

	req := c.newRequest(op, input, &DescribeBrokerEngineTypesOutput{})
	return DescribeBrokerEngineTypesRequest{Request: req, Input: input, Copy: c.DescribeBrokerEngineTypesRequest}
}

// DescribeBrokerEngineTypesRequest is the request type for the
// DescribeBrokerEngineTypes API operation.
type DescribeBrokerEngineTypesRequest struct {
	*aws.Request
	Input *DescribeBrokerEngineTypesInput
	Copy  func(*DescribeBrokerEngineTypesInput) DescribeBrokerEngineTypesRequest
}

// Send marshals and sends the DescribeBrokerEngineTypes API request.
func (r DescribeBrokerEngineTypesRequest) Send(ctx context.Context) (*DescribeBrokerEngineTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBrokerEngineTypesResponse{
		DescribeBrokerEngineTypesOutput: r.Request.Data.(*DescribeBrokerEngineTypesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBrokerEngineTypesResponse is the response type for the
// DescribeBrokerEngineTypes API operation.
type DescribeBrokerEngineTypesResponse struct {
	*DescribeBrokerEngineTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBrokerEngineTypes request.
func (r *DescribeBrokerEngineTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
