// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImportRequest
type ListEnabledProductsForImportInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the ListEnabledProductsForImport operation. For subsequent calls
	// to the operation, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListEnabledProductsForImportInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnabledProductsForImportInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListEnabledProductsForImportInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEnabledProductsForImportInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImportResponse
type ListEnabledProductsForImportOutput struct {
	_ struct{} `type:"structure"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`

	// A list of ARNs for the resources that represent your subscriptions to products.
	ProductSubscriptions []string `type:"list"`
}

// String returns the string representation
func (s ListEnabledProductsForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEnabledProductsForImportOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductSubscriptions) > 0 {
		v := s.ProductSubscriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductSubscriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Lists all findings-generating solutions (products) whose findings you've
// subscribed to receive in Security Hub.
//
//    // Example sending a request using ListEnabledProductsForImportRequest.
//    req := client.ListEnabledProductsForImportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *Client) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) ListEnabledProductsForImportRequest {
	op := &aws.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	req := c.newRequest(op, input, &ListEnabledProductsForImportOutput{})
	return ListEnabledProductsForImportRequest{Request: req, Input: input, Copy: c.ListEnabledProductsForImportRequest}
}

// ListEnabledProductsForImportRequest is the request type for the
// ListEnabledProductsForImport API operation.
type ListEnabledProductsForImportRequest struct {
	*aws.Request
	Input *ListEnabledProductsForImportInput
	Copy  func(*ListEnabledProductsForImportInput) ListEnabledProductsForImportRequest
}

// Send marshals and sends the ListEnabledProductsForImport API request.
func (r ListEnabledProductsForImportRequest) Send(ctx context.Context) (*ListEnabledProductsForImportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEnabledProductsForImportResponse{
		ListEnabledProductsForImportOutput: r.Request.Data.(*ListEnabledProductsForImportOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListEnabledProductsForImportRequestPaginator returns a paginator for ListEnabledProductsForImport.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListEnabledProductsForImportRequest(input)
//   p := securityhub.NewListEnabledProductsForImportRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListEnabledProductsForImportPaginator(req ListEnabledProductsForImportRequest) ListEnabledProductsForImportPaginator {
	return ListEnabledProductsForImportPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListEnabledProductsForImportInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListEnabledProductsForImportPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEnabledProductsForImportPaginator struct {
	aws.Pager
}

func (p *ListEnabledProductsForImportPaginator) CurrentPage() *ListEnabledProductsForImportOutput {
	return p.Pager.CurrentPage().(*ListEnabledProductsForImportOutput)
}

// ListEnabledProductsForImportResponse is the response type for the
// ListEnabledProductsForImport API operation.
type ListEnabledProductsForImportResponse struct {
	*ListEnabledProductsForImportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEnabledProductsForImport request.
func (r *ListEnabledProductsForImportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
