// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package serverlessapplicationrepository

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A nested application summary.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ApplicationDependencySummary
type ApplicationDependencySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the nested application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The semantic version of the nested application.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s ApplicationDependencySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationDependencySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SemanticVersion != nil {
		v := *s.SemanticVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "semanticVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Policy statement applied to the application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ApplicationPolicyStatement
type ApplicationPolicyStatement struct {
	_ struct{} `type:"structure"`

	// For the list of actions supported for this operation, see Application Permissions
	// (https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions).
	//
	// Actions is a required field
	Actions []string `locationName:"actions" type:"list" required:"true"`

	// An array of AWS account IDs, or * to make the application public.
	//
	// Principals is a required field
	Principals []string `locationName:"principals" type:"list" required:"true"`

	// A unique ID for the statement.
	StatementId *string `locationName:"statementId" type:"string"`
}

// String returns the string representation
func (s ApplicationPolicyStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationPolicyStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationPolicyStatement"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}

	if s.Principals == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principals"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationPolicyStatement) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Actions) > 0 {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Principals) > 0 {
		v := s.Principals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "principals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.StatementId != nil {
		v := *s.StatementId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statementId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Summary of details about the application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ApplicationSummary
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The name of the author publishing the app.
	//
	// Minimum length=1. Maximum length=127.
	//
	// Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
	//
	// Author is a required field
	Author *string `locationName:"author" type:"string" required:"true"`

	// The date and time this resource was created.
	CreationTime *string `locationName:"creationTime" type:"string"`

	// The description of the application.
	//
	// Minimum length=1. Maximum length=256
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// A URL with more information about the application, for example the location
	// of your GitHub repository for the application.
	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	// Labels to improve discovery of apps in search results.
	//
	// Minimum length=1. Maximum length=127. Maximum number of labels: 10
	//
	// Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
	Labels []string `locationName:"labels" type:"list"`

	// The name of the application.
	//
	// Minimum length=1. Maximum length=140
	//
	// Pattern: "[a-zA-Z0-9\\-]+";
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A valid identifier from https://spdx.org/licenses/ (https://spdx.org/licenses/).
	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`
}

// String returns the string representation
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Author != nil {
		v := *s.Author

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "author", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HomePageUrl != nil {
		v := *s.HomePageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "homePageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Labels) > 0 {
		v := s.Labels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "labels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SpdxLicenseId != nil {
		v := *s.SpdxLicenseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spdxLicenseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Parameters supported by the application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ParameterDefinition
type ParameterDefinition struct {
	_ struct{} `type:"structure"`

	// A regular expression that represents the patterns to allow for String types.
	AllowedPattern *string `locationName:"allowedPattern" type:"string"`

	// An array containing the list of values allowed for the parameter.
	AllowedValues []string `locationName:"allowedValues" type:"list"`

	// A string that explains a constraint when the constraint is violated. For
	// example, without a constraint description, a parameter that has an allowed
	// pattern of [A-Za-z0-9]+ displays the following error message when the user
	// specifies an invalid value:
	//
	// Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
	//
	// By adding a constraint description, such as "must contain only uppercase
	// and lowercase letters and numbers," you can display the following customized
	// error message:
	//
	// Malformed input-Parameter MyParameter must contain only uppercase and lowercase
	// letters and numbers.
	ConstraintDescription *string `locationName:"constraintDescription" type:"string"`

	// A value of the appropriate type for the template to use if no value is specified
	// when a stack is created. If you define constraints for the parameter, you
	// must specify a value that adheres to those constraints.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// A string of up to 4,000 characters that describes the parameter.
	Description *string `locationName:"description" type:"string"`

	// An integer value that determines the largest number of characters that you
	// want to allow for String types.
	MaxLength *int64 `locationName:"maxLength" type:"integer"`

	// A numeric value that determines the largest numeric value that you want to
	// allow for Number types.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// An integer value that determines the smallest number of characters that you
	// want to allow for String types.
	MinLength *int64 `locationName:"minLength" type:"integer"`

	// A numeric value that determines the smallest numeric value that you want
	// to allow for Number types.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the parameter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Whether to mask the parameter value whenever anyone makes a call that describes
	// the stack. If you set the value to true, the parameter value is masked with
	// asterisks (*****).
	NoEcho *bool `locationName:"noEcho" type:"boolean"`

	// A list of AWS SAM resources that use this parameter.
	//
	// ReferencedByResources is a required field
	ReferencedByResources []string `locationName:"referencedByResources" type:"list" required:"true"`

	// The type of the parameter.
	//
	// Valid values: String | Number | List<Number> | CommaDelimitedList
	//
	// String: A literal string.
	//
	// For example, users can specify "MyUserName".
	//
	// Number: An integer or float. AWS CloudFormation validates the parameter value
	// as a number. However, when you use the parameter elsewhere in your template
	// (for example, by using the Ref intrinsic function), the parameter value becomes
	// a string.
	//
	// For example, users might specify "8888".
	//
	// List<Number>: An array of integers or floats that are separated by commas.
	// AWS CloudFormation validates the parameter value as numbers. However, when
	// you use the parameter elsewhere in your template (for example, by using the
	// Ref intrinsic function), the parameter value becomes a list of strings.
	//
	// For example, users might specify "80,20", and then Ref results in ["80","20"].
	//
	// CommaDelimitedList: An array of literal strings that are separated by commas.
	// The total number of strings should be one more than the total number of commas.
	// Also, each member string is space-trimmed.
	//
	// For example, users might specify "test,dev,prod", and then Ref results in
	// ["test","dev","prod"].
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s ParameterDefinition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParameterDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowedPattern != nil {
		v := *s.AllowedPattern

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowedPattern", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AllowedValues) > 0 {
		v := s.AllowedValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "allowedValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ConstraintDescription != nil {
		v := *s.ConstraintDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "constraintDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultValue != nil {
		v := *s.DefaultValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxLength != nil {
		v := *s.MaxLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxLength", protocol.Int64Value(v), metadata)
	}
	if s.MaxValue != nil {
		v := *s.MaxValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxValue", protocol.Int64Value(v), metadata)
	}
	if s.MinLength != nil {
		v := *s.MinLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minLength", protocol.Int64Value(v), metadata)
	}
	if s.MinValue != nil {
		v := *s.MinValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minValue", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NoEcho != nil {
		v := *s.NoEcho

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noEcho", protocol.BoolValue(v), metadata)
	}
	if len(s.ReferencedByResources) > 0 {
		v := s.ReferencedByResources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "referencedByResources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Parameter value of the application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ParameterValue
type ParameterValue struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The input value associated with the parameter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s ParameterValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterValue"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParameterValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// This property corresponds to the AWS CloudFormation RollbackConfiguration
// (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
// Data Type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/RollbackConfiguration
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackConfiguration (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
	// Data Type.
	MonitoringTimeInMinutes *int64 `locationName:"monitoringTimeInMinutes" type:"integer"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackConfiguration (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
	// Data Type.
	RollbackTriggers []RollbackTrigger `locationName:"rollbackTriggers" type:"list"`
}

// String returns the string representation
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RollbackConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.MonitoringTimeInMinutes != nil {
		v := *s.MonitoringTimeInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "monitoringTimeInMinutes", protocol.Int64Value(v), metadata)
	}
	if len(s.RollbackTriggers) > 0 {
		v := s.RollbackTriggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "rollbackTriggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// This property corresponds to the AWS CloudFormation RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
// Data Type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/RollbackTrigger
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
	// Data Type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
	// Data Type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackTrigger"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RollbackTrigger) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// This property corresponds to the AWS CloudFormation Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
// Data Type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
	// Data Type.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
	// Data Type.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Application version details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/Version
type Version struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The date and time this resource was created.
	//
	// CreationTime is a required field
	CreationTime *string `locationName:"creationTime" type:"string" required:"true"`

	// An array of parameter types supported by the application.
	//
	// ParameterDefinitions is a required field
	ParameterDefinitions []ParameterDefinition `locationName:"parameterDefinitions" type:"list" required:"true"`

	// A list of values that you must specify before you can deploy certain applications.
	// Some applications might include resources that can affect permissions in
	// your AWS account, for example, by creating new AWS Identity and Access Management
	// (IAM) users. For those applications, you must explicitly acknowledge their
	// capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY,
	// and CAPABILITY_AUTO_EXPAND.
	//
	// The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM:
	// AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	// AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	// AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
	// and AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html).
	// If the application contains IAM resources, you can specify either CAPABILITY_IAM
	// or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom
	// names, you must specify CAPABILITY_NAMED_IAM.
	//
	// The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
	// AWS::Lambda::Permission (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html),
	// AWS::IAM:Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
	// AWS::ApplicationAutoScaling::ScalingPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html),
	// AWS::S3::BucketPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html),
	// AWS::SQS::QueuePolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html),
	// and AWS::SNS::TopicPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html).
	//
	// Applications that contain one or more nested applications require you to
	// specify CAPABILITY_AUTO_EXPAND.
	//
	// If your application template contains any of the above resources, we recommend
	// that you review all permissions associated with the application before deploying.
	// If you don't specify this parameter for an application that requires capabilities,
	// the call will fail.
	//
	// RequiredCapabilities is a required field
	RequiredCapabilities []Capability `locationName:"requiredCapabilities" type:"list" required:"true"`

	// Whether all of the AWS resources contained in this application are supported
	// in the region in which it is being retrieved.
	//
	// ResourcesSupported is a required field
	ResourcesSupported *bool `locationName:"resourcesSupported" type:"boolean" required:"true"`

	// The semantic version of the application:
	//
	// https://semver.org/ (https://semver.org/)
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// A link to the S3 object that contains the ZIP archive of the source code
	// for this version of your application.
	//
	// Maximum size 50 MB
	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	// A link to a public repository for the source code of your application, for
	// example the URL of a specific GitHub commit.
	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	// A link to the packaged AWS SAM template of your application.
	//
	// TemplateUrl is a required field
	TemplateUrl *string `locationName:"templateUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s Version) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Version) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ParameterDefinitions) > 0 {
		v := s.ParameterDefinitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "parameterDefinitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RequiredCapabilities) > 0 {
		v := s.RequiredCapabilities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "requiredCapabilities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ResourcesSupported != nil {
		v := *s.ResourcesSupported

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourcesSupported", protocol.BoolValue(v), metadata)
	}
	if s.SemanticVersion != nil {
		v := *s.SemanticVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "semanticVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeArchiveUrl != nil {
		v := *s.SourceCodeArchiveUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceCodeArchiveUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeUrl != nil {
		v := *s.SourceCodeUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceCodeUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateUrl != nil {
		v := *s.TemplateUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An application version summary.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/VersionSummary
type VersionSummary struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The date and time this resource was created.
	//
	// CreationTime is a required field
	CreationTime *string `locationName:"creationTime" type:"string" required:"true"`

	// The semantic version of the application:
	//
	// https://semver.org/ (https://semver.org/)
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// A link to a public repository for the source code of your application, for
	// example the URL of a specific GitHub commit.
	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`
}

// String returns the string representation
func (s VersionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SemanticVersion != nil {
		v := *s.SemanticVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "semanticVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeUrl != nil {
		v := *s.SourceCodeUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceCodeUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
