// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterRequest
type GetParameterInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter you want to query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Return decrypted values for secure string parameters. This flag is ignored
	// for String and StringList parameter types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParameterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParameterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetParameterInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterResult
type GetParameterOutput struct {
	_ struct{} `type:"structure"`

	// Information about a parameter.
	Parameter *Parameter `type:"structure"`
}

// String returns the string representation
func (s GetParameterOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetParameter = "GetParameter"

// GetParameterRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Get information about a parameter by using the parameter name. Don't confuse
// this API action with the GetParameters API action.
//
//    // Example sending a request using GetParameterRequest.
//    req := client.GetParameterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter
func (c *Client) GetParameterRequest(input *GetParameterInput) GetParameterRequest {
	op := &aws.Operation{
		Name:       opGetParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParameterInput{}
	}

	req := c.newRequest(op, input, &GetParameterOutput{})
	return GetParameterRequest{Request: req, Input: input, Copy: c.GetParameterRequest}
}

// GetParameterRequest is the request type for the
// GetParameter API operation.
type GetParameterRequest struct {
	*aws.Request
	Input *GetParameterInput
	Copy  func(*GetParameterInput) GetParameterRequest
}

// Send marshals and sends the GetParameter API request.
func (r GetParameterRequest) Send(ctx context.Context) (*GetParameterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetParameterResponse{
		GetParameterOutput: r.Request.Data.(*GetParameterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetParameterResponse is the response type for the
// GetParameter API operation.
type GetParameterResponse struct {
	*GetParameterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetParameter request.
func (r *GetParameterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
