// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssmiface provides an interface to enable mocking the Amazon Simple Systems Manager (SSM) service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssmiface

import (
	"github.com/aws/aws-sdk-go-v2/service/ssm"
)

// ClientAPI provides an interface to enable mocking the
// ssm.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon SSM.
//    func myFunc(svc ssmiface.ClientAPI) bool {
//        // Make svc.AddTagsToResource request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ssm.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ssmiface.ClientPI
//    }
//    func (m *mockClientClient) AddTagsToResource(input *ssm.AddTagsToResourceInput) (*ssm.AddTagsToResourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsToResourceRequest(*ssm.AddTagsToResourceInput) ssm.AddTagsToResourceRequest

	CancelCommandRequest(*ssm.CancelCommandInput) ssm.CancelCommandRequest

	CancelMaintenanceWindowExecutionRequest(*ssm.CancelMaintenanceWindowExecutionInput) ssm.CancelMaintenanceWindowExecutionRequest

	CreateActivationRequest(*ssm.CreateActivationInput) ssm.CreateActivationRequest

	CreateAssociationRequest(*ssm.CreateAssociationInput) ssm.CreateAssociationRequest

	CreateAssociationBatchRequest(*ssm.CreateAssociationBatchInput) ssm.CreateAssociationBatchRequest

	CreateDocumentRequest(*ssm.CreateDocumentInput) ssm.CreateDocumentRequest

	CreateMaintenanceWindowRequest(*ssm.CreateMaintenanceWindowInput) ssm.CreateMaintenanceWindowRequest

	CreatePatchBaselineRequest(*ssm.CreatePatchBaselineInput) ssm.CreatePatchBaselineRequest

	CreateResourceDataSyncRequest(*ssm.CreateResourceDataSyncInput) ssm.CreateResourceDataSyncRequest

	DeleteActivationRequest(*ssm.DeleteActivationInput) ssm.DeleteActivationRequest

	DeleteAssociationRequest(*ssm.DeleteAssociationInput) ssm.DeleteAssociationRequest

	DeleteDocumentRequest(*ssm.DeleteDocumentInput) ssm.DeleteDocumentRequest

	DeleteInventoryRequest(*ssm.DeleteInventoryInput) ssm.DeleteInventoryRequest

	DeleteMaintenanceWindowRequest(*ssm.DeleteMaintenanceWindowInput) ssm.DeleteMaintenanceWindowRequest

	DeleteParameterRequest(*ssm.DeleteParameterInput) ssm.DeleteParameterRequest

	DeleteParametersRequest(*ssm.DeleteParametersInput) ssm.DeleteParametersRequest

	DeletePatchBaselineRequest(*ssm.DeletePatchBaselineInput) ssm.DeletePatchBaselineRequest

	DeleteResourceDataSyncRequest(*ssm.DeleteResourceDataSyncInput) ssm.DeleteResourceDataSyncRequest

	DeregisterManagedInstanceRequest(*ssm.DeregisterManagedInstanceInput) ssm.DeregisterManagedInstanceRequest

	DeregisterPatchBaselineForPatchGroupRequest(*ssm.DeregisterPatchBaselineForPatchGroupInput) ssm.DeregisterPatchBaselineForPatchGroupRequest

	DeregisterTargetFromMaintenanceWindowRequest(*ssm.DeregisterTargetFromMaintenanceWindowInput) ssm.DeregisterTargetFromMaintenanceWindowRequest

	DeregisterTaskFromMaintenanceWindowRequest(*ssm.DeregisterTaskFromMaintenanceWindowInput) ssm.DeregisterTaskFromMaintenanceWindowRequest

	DescribeActivationsRequest(*ssm.DescribeActivationsInput) ssm.DescribeActivationsRequest

	DescribeAssociationRequest(*ssm.DescribeAssociationInput) ssm.DescribeAssociationRequest

	DescribeAssociationExecutionTargetsRequest(*ssm.DescribeAssociationExecutionTargetsInput) ssm.DescribeAssociationExecutionTargetsRequest

	DescribeAssociationExecutionsRequest(*ssm.DescribeAssociationExecutionsInput) ssm.DescribeAssociationExecutionsRequest

	DescribeAutomationExecutionsRequest(*ssm.DescribeAutomationExecutionsInput) ssm.DescribeAutomationExecutionsRequest

	DescribeAutomationStepExecutionsRequest(*ssm.DescribeAutomationStepExecutionsInput) ssm.DescribeAutomationStepExecutionsRequest

	DescribeAvailablePatchesRequest(*ssm.DescribeAvailablePatchesInput) ssm.DescribeAvailablePatchesRequest

	DescribeDocumentRequest(*ssm.DescribeDocumentInput) ssm.DescribeDocumentRequest

	DescribeDocumentPermissionRequest(*ssm.DescribeDocumentPermissionInput) ssm.DescribeDocumentPermissionRequest

	DescribeEffectiveInstanceAssociationsRequest(*ssm.DescribeEffectiveInstanceAssociationsInput) ssm.DescribeEffectiveInstanceAssociationsRequest

	DescribeEffectivePatchesForPatchBaselineRequest(*ssm.DescribeEffectivePatchesForPatchBaselineInput) ssm.DescribeEffectivePatchesForPatchBaselineRequest

	DescribeInstanceAssociationsStatusRequest(*ssm.DescribeInstanceAssociationsStatusInput) ssm.DescribeInstanceAssociationsStatusRequest

	DescribeInstanceInformationRequest(*ssm.DescribeInstanceInformationInput) ssm.DescribeInstanceInformationRequest

	DescribeInstancePatchStatesRequest(*ssm.DescribeInstancePatchStatesInput) ssm.DescribeInstancePatchStatesRequest

	DescribeInstancePatchStatesForPatchGroupRequest(*ssm.DescribeInstancePatchStatesForPatchGroupInput) ssm.DescribeInstancePatchStatesForPatchGroupRequest

	DescribeInstancePatchesRequest(*ssm.DescribeInstancePatchesInput) ssm.DescribeInstancePatchesRequest

	DescribeInventoryDeletionsRequest(*ssm.DescribeInventoryDeletionsInput) ssm.DescribeInventoryDeletionsRequest

	DescribeMaintenanceWindowExecutionTaskInvocationsRequest(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput) ssm.DescribeMaintenanceWindowExecutionTaskInvocationsRequest

	DescribeMaintenanceWindowExecutionTasksRequest(*ssm.DescribeMaintenanceWindowExecutionTasksInput) ssm.DescribeMaintenanceWindowExecutionTasksRequest

	DescribeMaintenanceWindowExecutionsRequest(*ssm.DescribeMaintenanceWindowExecutionsInput) ssm.DescribeMaintenanceWindowExecutionsRequest

	DescribeMaintenanceWindowScheduleRequest(*ssm.DescribeMaintenanceWindowScheduleInput) ssm.DescribeMaintenanceWindowScheduleRequest

	DescribeMaintenanceWindowTargetsRequest(*ssm.DescribeMaintenanceWindowTargetsInput) ssm.DescribeMaintenanceWindowTargetsRequest

	DescribeMaintenanceWindowTasksRequest(*ssm.DescribeMaintenanceWindowTasksInput) ssm.DescribeMaintenanceWindowTasksRequest

	DescribeMaintenanceWindowsRequest(*ssm.DescribeMaintenanceWindowsInput) ssm.DescribeMaintenanceWindowsRequest

	DescribeMaintenanceWindowsForTargetRequest(*ssm.DescribeMaintenanceWindowsForTargetInput) ssm.DescribeMaintenanceWindowsForTargetRequest

	DescribeParametersRequest(*ssm.DescribeParametersInput) ssm.DescribeParametersRequest

	DescribePatchBaselinesRequest(*ssm.DescribePatchBaselinesInput) ssm.DescribePatchBaselinesRequest

	DescribePatchGroupStateRequest(*ssm.DescribePatchGroupStateInput) ssm.DescribePatchGroupStateRequest

	DescribePatchGroupsRequest(*ssm.DescribePatchGroupsInput) ssm.DescribePatchGroupsRequest

	DescribePatchPropertiesRequest(*ssm.DescribePatchPropertiesInput) ssm.DescribePatchPropertiesRequest

	DescribeSessionsRequest(*ssm.DescribeSessionsInput) ssm.DescribeSessionsRequest

	GetAutomationExecutionRequest(*ssm.GetAutomationExecutionInput) ssm.GetAutomationExecutionRequest

	GetCommandInvocationRequest(*ssm.GetCommandInvocationInput) ssm.GetCommandInvocationRequest

	GetConnectionStatusRequest(*ssm.GetConnectionStatusInput) ssm.GetConnectionStatusRequest

	GetDefaultPatchBaselineRequest(*ssm.GetDefaultPatchBaselineInput) ssm.GetDefaultPatchBaselineRequest

	GetDeployablePatchSnapshotForInstanceRequest(*ssm.GetDeployablePatchSnapshotForInstanceInput) ssm.GetDeployablePatchSnapshotForInstanceRequest

	GetDocumentRequest(*ssm.GetDocumentInput) ssm.GetDocumentRequest

	GetInventoryRequest(*ssm.GetInventoryInput) ssm.GetInventoryRequest

	GetInventorySchemaRequest(*ssm.GetInventorySchemaInput) ssm.GetInventorySchemaRequest

	GetMaintenanceWindowRequest(*ssm.GetMaintenanceWindowInput) ssm.GetMaintenanceWindowRequest

	GetMaintenanceWindowExecutionRequest(*ssm.GetMaintenanceWindowExecutionInput) ssm.GetMaintenanceWindowExecutionRequest

	GetMaintenanceWindowExecutionTaskRequest(*ssm.GetMaintenanceWindowExecutionTaskInput) ssm.GetMaintenanceWindowExecutionTaskRequest

	GetMaintenanceWindowExecutionTaskInvocationRequest(*ssm.GetMaintenanceWindowExecutionTaskInvocationInput) ssm.GetMaintenanceWindowExecutionTaskInvocationRequest

	GetMaintenanceWindowTaskRequest(*ssm.GetMaintenanceWindowTaskInput) ssm.GetMaintenanceWindowTaskRequest

	GetParameterRequest(*ssm.GetParameterInput) ssm.GetParameterRequest

	GetParameterHistoryRequest(*ssm.GetParameterHistoryInput) ssm.GetParameterHistoryRequest

	GetParametersRequest(*ssm.GetParametersInput) ssm.GetParametersRequest

	GetParametersByPathRequest(*ssm.GetParametersByPathInput) ssm.GetParametersByPathRequest

	GetPatchBaselineRequest(*ssm.GetPatchBaselineInput) ssm.GetPatchBaselineRequest

	GetPatchBaselineForPatchGroupRequest(*ssm.GetPatchBaselineForPatchGroupInput) ssm.GetPatchBaselineForPatchGroupRequest

	GetServiceSettingRequest(*ssm.GetServiceSettingInput) ssm.GetServiceSettingRequest

	LabelParameterVersionRequest(*ssm.LabelParameterVersionInput) ssm.LabelParameterVersionRequest

	ListAssociationVersionsRequest(*ssm.ListAssociationVersionsInput) ssm.ListAssociationVersionsRequest

	ListAssociationsRequest(*ssm.ListAssociationsInput) ssm.ListAssociationsRequest

	ListCommandInvocationsRequest(*ssm.ListCommandInvocationsInput) ssm.ListCommandInvocationsRequest

	ListCommandsRequest(*ssm.ListCommandsInput) ssm.ListCommandsRequest

	ListComplianceItemsRequest(*ssm.ListComplianceItemsInput) ssm.ListComplianceItemsRequest

	ListComplianceSummariesRequest(*ssm.ListComplianceSummariesInput) ssm.ListComplianceSummariesRequest

	ListDocumentVersionsRequest(*ssm.ListDocumentVersionsInput) ssm.ListDocumentVersionsRequest

	ListDocumentsRequest(*ssm.ListDocumentsInput) ssm.ListDocumentsRequest

	ListInventoryEntriesRequest(*ssm.ListInventoryEntriesInput) ssm.ListInventoryEntriesRequest

	ListResourceComplianceSummariesRequest(*ssm.ListResourceComplianceSummariesInput) ssm.ListResourceComplianceSummariesRequest

	ListResourceDataSyncRequest(*ssm.ListResourceDataSyncInput) ssm.ListResourceDataSyncRequest

	ListTagsForResourceRequest(*ssm.ListTagsForResourceInput) ssm.ListTagsForResourceRequest

	ModifyDocumentPermissionRequest(*ssm.ModifyDocumentPermissionInput) ssm.ModifyDocumentPermissionRequest

	PutComplianceItemsRequest(*ssm.PutComplianceItemsInput) ssm.PutComplianceItemsRequest

	PutInventoryRequest(*ssm.PutInventoryInput) ssm.PutInventoryRequest

	PutParameterRequest(*ssm.PutParameterInput) ssm.PutParameterRequest

	RegisterDefaultPatchBaselineRequest(*ssm.RegisterDefaultPatchBaselineInput) ssm.RegisterDefaultPatchBaselineRequest

	RegisterPatchBaselineForPatchGroupRequest(*ssm.RegisterPatchBaselineForPatchGroupInput) ssm.RegisterPatchBaselineForPatchGroupRequest

	RegisterTargetWithMaintenanceWindowRequest(*ssm.RegisterTargetWithMaintenanceWindowInput) ssm.RegisterTargetWithMaintenanceWindowRequest

	RegisterTaskWithMaintenanceWindowRequest(*ssm.RegisterTaskWithMaintenanceWindowInput) ssm.RegisterTaskWithMaintenanceWindowRequest

	RemoveTagsFromResourceRequest(*ssm.RemoveTagsFromResourceInput) ssm.RemoveTagsFromResourceRequest

	ResetServiceSettingRequest(*ssm.ResetServiceSettingInput) ssm.ResetServiceSettingRequest

	ResumeSessionRequest(*ssm.ResumeSessionInput) ssm.ResumeSessionRequest

	SendAutomationSignalRequest(*ssm.SendAutomationSignalInput) ssm.SendAutomationSignalRequest

	SendCommandRequest(*ssm.SendCommandInput) ssm.SendCommandRequest

	StartAssociationsOnceRequest(*ssm.StartAssociationsOnceInput) ssm.StartAssociationsOnceRequest

	StartAutomationExecutionRequest(*ssm.StartAutomationExecutionInput) ssm.StartAutomationExecutionRequest

	StartSessionRequest(*ssm.StartSessionInput) ssm.StartSessionRequest

	StopAutomationExecutionRequest(*ssm.StopAutomationExecutionInput) ssm.StopAutomationExecutionRequest

	TerminateSessionRequest(*ssm.TerminateSessionInput) ssm.TerminateSessionRequest

	UpdateAssociationRequest(*ssm.UpdateAssociationInput) ssm.UpdateAssociationRequest

	UpdateAssociationStatusRequest(*ssm.UpdateAssociationStatusInput) ssm.UpdateAssociationStatusRequest

	UpdateDocumentRequest(*ssm.UpdateDocumentInput) ssm.UpdateDocumentRequest

	UpdateDocumentDefaultVersionRequest(*ssm.UpdateDocumentDefaultVersionInput) ssm.UpdateDocumentDefaultVersionRequest

	UpdateMaintenanceWindowRequest(*ssm.UpdateMaintenanceWindowInput) ssm.UpdateMaintenanceWindowRequest

	UpdateMaintenanceWindowTargetRequest(*ssm.UpdateMaintenanceWindowTargetInput) ssm.UpdateMaintenanceWindowTargetRequest

	UpdateMaintenanceWindowTaskRequest(*ssm.UpdateMaintenanceWindowTaskInput) ssm.UpdateMaintenanceWindowTaskRequest

	UpdateManagedInstanceRoleRequest(*ssm.UpdateManagedInstanceRoleInput) ssm.UpdateManagedInstanceRoleRequest

	UpdatePatchBaselineRequest(*ssm.UpdatePatchBaselineInput) ssm.UpdatePatchBaselineRequest

	UpdateServiceSettingRequest(*ssm.UpdateServiceSettingInput) ssm.UpdateServiceSettingRequest
}

var _ ClientAPI = (*ssm.Client)(nil)
