// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRuleRequest
type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the metrics for this Rule. The name can
	// contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the Rule.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the Rule. You can't change the name of
	// a Rule after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRuleInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRuleResponse
type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The Rule returned in the CreateRule response.
	Rule *waf.Rule `type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateRule = "CreateRule"

// CreateRuleRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Creates a Rule, which contains the IPSet objects, ByteMatchSet objects, and
// other predicates that identify the requests that you want to block. If you
// add more than one predicate to a Rule, a request must match all of the specifications
// to be allowed or blocked. For example, suppose that you add the following
// to a Rule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// You then add the Rule to a WebACL and specify that you want to blocks requests
// that satisfy the Rule. For a request to be blocked, it must come from the
// IP address 192.0.2.44 and the User-Agent header in the request must contain
// the value BadBot.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to specify the predicates that you want to include
// in the Rule.
//
// Create and update a WebACL that contains the Rule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using CreateRuleRequest.
//    req := client.CreateRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRule
func (c *Client) CreateRuleRequest(input *CreateRuleInput) CreateRuleRequest {
	op := &aws.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	req := c.newRequest(op, input, &CreateRuleOutput{})
	return CreateRuleRequest{Request: req, Input: input, Copy: c.CreateRuleRequest}
}

// CreateRuleRequest is the request type for the
// CreateRule API operation.
type CreateRuleRequest struct {
	*aws.Request
	Input *CreateRuleInput
	Copy  func(*CreateRuleInput) CreateRuleRequest
}

// Send marshals and sends the CreateRule API request.
func (r CreateRuleRequest) Send(ctx context.Context) (*CreateRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRuleResponse{
		CreateRuleOutput: r.Request.Data.(*CreateRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRuleResponse is the response type for the
// CreateRule API operation.
type CreateRuleResponse struct {
	*CreateRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRule request.
func (r *CreateRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
