// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACLRequest
type ListResourcesForWebACLInput struct {
	_ struct{} `type:"structure"`

	// The type of resource to list, either an application load balancer or Amazon
	// API Gateway.
	ResourceType ResourceType `type:"string" enum:"true"`

	// The unique identifier (ID) of the web ACL for which to list the associated
	// resources.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesForWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesForWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourcesForWebACLInput"}

	if s.WebACLId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACLResponse
type ListResourcesForWebACLOutput struct {
	_ struct{} `type:"structure"`

	// An array of ARNs (Amazon Resource Names) of the resources associated with
	// the specified web ACL. An array with zero elements is returned if there are
	// no resources associated with the web ACL.
	ResourceArns []string `type:"list"`
}

// String returns the string representation
func (s ListResourcesForWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResourcesForWebACL = "ListResourcesForWebACL"

// ListResourcesForWebACLRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Returns an array of resources associated with the specified web ACL.
//
//    // Example sending a request using ListResourcesForWebACLRequest.
//    req := client.ListResourcesForWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACL
func (c *Client) ListResourcesForWebACLRequest(input *ListResourcesForWebACLInput) ListResourcesForWebACLRequest {
	op := &aws.Operation{
		Name:       opListResourcesForWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesForWebACLInput{}
	}

	req := c.newRequest(op, input, &ListResourcesForWebACLOutput{})
	return ListResourcesForWebACLRequest{Request: req, Input: input, Copy: c.ListResourcesForWebACLRequest}
}

// ListResourcesForWebACLRequest is the request type for the
// ListResourcesForWebACL API operation.
type ListResourcesForWebACLRequest struct {
	*aws.Request
	Input *ListResourcesForWebACLInput
	Copy  func(*ListResourcesForWebACLInput) ListResourcesForWebACLRequest
}

// Send marshals and sends the ListResourcesForWebACL API request.
func (r ListResourcesForWebACLRequest) Send(ctx context.Context) (*ListResourcesForWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourcesForWebACLResponse{
		ListResourcesForWebACLOutput: r.Request.Data.(*ListResourcesForWebACLOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourcesForWebACLResponse is the response type for the
// ListResourcesForWebACL API operation.
type ListResourcesForWebACLResponse struct {
	*ListResourcesForWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourcesForWebACL request.
func (r *ListResourcesForWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
