// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package androidmanagement provides access to the Android Management API.
//
// For product documentation, see: https://developers.google.com/android/management
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/androidmanagement/v1"
//	...
//	ctx := context.Background()
//	androidmanagementService, err := androidmanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	androidmanagementService, err := androidmanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	androidmanagementService, err := androidmanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package androidmanagement // import "google.golang.org/api/androidmanagement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "androidmanagement:v1"
const apiName = "androidmanagement"
const apiVersion = "v1"
const basePath = "https://androidmanagement.googleapis.com/"
const basePathTemplate = "https://androidmanagement.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://androidmanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage Android devices and apps for your customers
	AndroidmanagementScope = "https://www.googleapis.com/auth/androidmanagement"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/androidmanagement",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Enterprises = NewEnterprisesService(s)
	s.ProvisioningInfo = NewProvisioningInfoService(s)
	s.SignupUrls = NewSignupUrlsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Enterprises *EnterprisesService

	ProvisioningInfo *ProvisioningInfoService

	SignupUrls *SignupUrlsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewEnterprisesService(s *Service) *EnterprisesService {
	rs := &EnterprisesService{s: s}
	rs.Applications = NewEnterprisesApplicationsService(s)
	rs.Devices = NewEnterprisesDevicesService(s)
	rs.EnrollmentTokens = NewEnterprisesEnrollmentTokensService(s)
	rs.MigrationTokens = NewEnterprisesMigrationTokensService(s)
	rs.Policies = NewEnterprisesPoliciesService(s)
	rs.WebApps = NewEnterprisesWebAppsService(s)
	rs.WebTokens = NewEnterprisesWebTokensService(s)
	return rs
}

type EnterprisesService struct {
	s *Service

	Applications *EnterprisesApplicationsService

	Devices *EnterprisesDevicesService

	EnrollmentTokens *EnterprisesEnrollmentTokensService

	MigrationTokens *EnterprisesMigrationTokensService

	Policies *EnterprisesPoliciesService

	WebApps *EnterprisesWebAppsService

	WebTokens *EnterprisesWebTokensService
}

func NewEnterprisesApplicationsService(s *Service) *EnterprisesApplicationsService {
	rs := &EnterprisesApplicationsService{s: s}
	return rs
}

type EnterprisesApplicationsService struct {
	s *Service
}

func NewEnterprisesDevicesService(s *Service) *EnterprisesDevicesService {
	rs := &EnterprisesDevicesService{s: s}
	rs.Operations = NewEnterprisesDevicesOperationsService(s)
	return rs
}

type EnterprisesDevicesService struct {
	s *Service

	Operations *EnterprisesDevicesOperationsService
}

func NewEnterprisesDevicesOperationsService(s *Service) *EnterprisesDevicesOperationsService {
	rs := &EnterprisesDevicesOperationsService{s: s}
	return rs
}

type EnterprisesDevicesOperationsService struct {
	s *Service
}

func NewEnterprisesEnrollmentTokensService(s *Service) *EnterprisesEnrollmentTokensService {
	rs := &EnterprisesEnrollmentTokensService{s: s}
	return rs
}

type EnterprisesEnrollmentTokensService struct {
	s *Service
}

func NewEnterprisesMigrationTokensService(s *Service) *EnterprisesMigrationTokensService {
	rs := &EnterprisesMigrationTokensService{s: s}
	return rs
}

type EnterprisesMigrationTokensService struct {
	s *Service
}

func NewEnterprisesPoliciesService(s *Service) *EnterprisesPoliciesService {
	rs := &EnterprisesPoliciesService{s: s}
	return rs
}

type EnterprisesPoliciesService struct {
	s *Service
}

func NewEnterprisesWebAppsService(s *Service) *EnterprisesWebAppsService {
	rs := &EnterprisesWebAppsService{s: s}
	return rs
}

type EnterprisesWebAppsService struct {
	s *Service
}

func NewEnterprisesWebTokensService(s *Service) *EnterprisesWebTokensService {
	rs := &EnterprisesWebTokensService{s: s}
	return rs
}

type EnterprisesWebTokensService struct {
	s *Service
}

func NewProvisioningInfoService(s *Service) *ProvisioningInfoService {
	rs := &ProvisioningInfoService{s: s}
	return rs
}

type ProvisioningInfoService struct {
	s *Service
}

func NewSignupUrlsService(s *Service) *SignupUrlsService {
	rs := &SignupUrlsService{s: s}
	return rs
}

type SignupUrlsService struct {
	s *Service
}

// AdbShellCommandEvent: A shell command was issued over ADB via “adb shell
// command”.
type AdbShellCommandEvent struct {
	// ShellCmd: Shell command that was issued over ADB via "adb shell command".
	// Redacted to empty string on organization-owned managed profile devices.
	ShellCmd string `json:"shellCmd,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ShellCmd") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShellCmd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdbShellCommandEvent) MarshalJSON() ([]byte, error) {
	type NoMethod AdbShellCommandEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdbShellInteractiveEvent: An ADB interactive shell was opened via “adb
// shell”. Intentionally empty.
type AdbShellInteractiveEvent struct {
}

// AddEsimParams: Parameters associated with the ADD_ESIM command to add an
// eSIM profile to the device.
type AddEsimParams struct {
	// ActivationCode: Required. The activation code for the eSIM profile.
	ActivationCode string `json:"activationCode,omitempty"`
	// ActivationState: Required. The activation state of the eSIM profile once it
	// is downloaded.
	//
	// Possible values:
	//   "ACTIVATION_STATE_UNSPECIFIED" - eSIM activation state is not specified.
	// This defaults to the eSIM profile being NOT_ACTIVATED on personally-owned
	// devices and ACTIVATED on company-owned devices.
	//   "ACTIVATED" - The eSIM is automatically activated after downloading.
	// Setting this as the activation state for personally-owned devices will
	// result in the command being rejected.
	//   "NOT_ACTIVATED" - The eSIM profile is downloaded but not activated. In
	// this case, the user will need to activate the eSIM manually on the device.
	ActivationState string `json:"activationState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddEsimParams) MarshalJSON() ([]byte, error) {
	type NoMethod AddEsimParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdvancedSecurityOverrides: Advanced security settings. In most cases,
// setting these is not needed.
type AdvancedSecurityOverrides struct {
	// CommonCriteriaMode: Controls Common Criteria Mode—security standards
	// defined in the Common Criteria for Information Technology Security
	// Evaluation (https://www.commoncriteriaportal.org/) (CC). Enabling Common
	// Criteria Mode increases certain security components on a device, see
	// CommonCriteriaMode for details.Warning: Common Criteria Mode enforces a
	// strict security model typically only required for IT products used in
	// national security systems and other highly sensitive organizations. Standard
	// device use may be affected. Only enabled if required. If Common Criteria
	// Mode is turned off after being enabled previously, all user-configured Wi-Fi
	// networks may be lost and any enterprise-configured Wi-Fi networks that
	// require user input may need to be reconfigured.
	//
	// Possible values:
	//   "COMMON_CRITERIA_MODE_UNSPECIFIED" - Unspecified. Defaults to
	// COMMON_CRITERIA_MODE_DISABLED.
	//   "COMMON_CRITERIA_MODE_DISABLED" - Default. Disables Common Criteria Mode.
	//   "COMMON_CRITERIA_MODE_ENABLED" - Enables Common Criteria Mode.
	CommonCriteriaMode string `json:"commonCriteriaMode,omitempty"`
	// ContentProtectionPolicy: Optional. Controls whether content protection,
	// which scans for deceptive apps, is enabled. This is supported on Android 15
	// and above.
	//
	// Possible values:
	//   "CONTENT_PROTECTION_POLICY_UNSPECIFIED" - Unspecified. Defaults to
	// CONTENT_PROTECTION_DISABLED.
	//   "CONTENT_PROTECTION_DISABLED" - Content protection is disabled and the
	// user cannot change this.
	//   "CONTENT_PROTECTION_ENFORCED" - Content protection is enabled and the user
	// cannot change this.Supported on Android 15 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 15.
	//   "CONTENT_PROTECTION_USER_CHOICE" - Content protection is not controlled by
	// the policy. The user is allowed to choose the behavior of content
	// protection.Supported on Android 15 and above. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 15.
	ContentProtectionPolicy string `json:"contentProtectionPolicy,omitempty"`
	// DeveloperSettings: Controls access to developer settings: developer options
	// and safe boot. Replaces safeBootDisabled (deprecated) and
	// debuggingFeaturesAllowed (deprecated). On personally-owned devices with a
	// work profile, setting this policy will not disable safe boot. In this case,
	// a NonComplianceDetail with MANAGEMENT_MODE is reported.
	//
	// Possible values:
	//   "DEVELOPER_SETTINGS_UNSPECIFIED" - Unspecified. Defaults to
	// DEVELOPER_SETTINGS_DISABLED.
	//   "DEVELOPER_SETTINGS_DISABLED" - Default. Disables all developer settings
	// and prevents the user from accessing them.
	//   "DEVELOPER_SETTINGS_ALLOWED" - Allows all developer settings. The user can
	// access and optionally configure the settings.
	DeveloperSettings string `json:"developerSettings,omitempty"`
	// GooglePlayProtectVerifyApps: Whether Google Play Protect verification
	// (https://support.google.com/accounts/answer/2812853) is enforced. Replaces
	// ensureVerifyAppsEnabled (deprecated).
	//
	// Possible values:
	//   "GOOGLE_PLAY_PROTECT_VERIFY_APPS_UNSPECIFIED" - Unspecified. Defaults to
	// VERIFY_APPS_ENFORCED.
	//   "VERIFY_APPS_ENFORCED" - Default. Force-enables app verification.
	//   "VERIFY_APPS_USER_CHOICE" - Allows the user to choose whether to enable
	// app verification.
	GooglePlayProtectVerifyApps string `json:"googlePlayProtectVerifyApps,omitempty"`
	// MtePolicy: Optional. Controls Memory Tagging Extension (MTE)
	// (https://source.android.com/docs/security/test/memory-safety/arm-mte) on the
	// device. The device needs to be rebooted to apply changes to the MTE policy.
	// On Android 15 and above, a NonComplianceDetail with PENDING is reported if
	// the policy change is pending a device reboot.
	//
	// Possible values:
	//   "MTE_POLICY_UNSPECIFIED" - Unspecified. Defaults to MTE_USER_CHOICE.
	//   "MTE_USER_CHOICE" - The user can choose to enable or disable MTE on the
	// device if the device supports this.
	//   "MTE_ENFORCED" - MTE is enabled on the device and the user is not allowed
	// to change this setting. This can be set on fully managed devices and work
	// profiles on company-owned devices. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for other management modes. A
	// NonComplianceDetail with DEVICE_INCOMPATIBLE is reported if the device does
	// not support MTE.Supported on Android 14 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 14.
	//   "MTE_DISABLED" - MTE is disabled on the device and the user is not allowed
	// to change this setting. This applies only on fully managed devices. In other
	// cases, a NonComplianceDetail with MANAGEMENT_MODE is reported. A
	// NonComplianceDetail with DEVICE_INCOMPATIBLE is reported if the device does
	// not support MTE.Supported on Android 14 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 14.
	MtePolicy string `json:"mtePolicy,omitempty"`
	// PersonalAppsThatCanReadWorkNotifications: Personal apps that can read work
	// profile notifications using a NotificationListenerService
	// (https://developer.android.com/reference/android/service/notification/NotificationListenerService).
	// By default, no personal apps (aside from system apps) can read work
	// notifications. Each value in the list must be a package name.
	PersonalAppsThatCanReadWorkNotifications []string `json:"personalAppsThatCanReadWorkNotifications,omitempty"`
	// UntrustedAppsPolicy: The policy for untrusted apps (apps from unknown
	// sources) enforced on the device. Replaces install_unknown_sources_allowed
	// (deprecated).
	//
	// Possible values:
	//   "UNTRUSTED_APPS_POLICY_UNSPECIFIED" - Unspecified. Defaults to
	// DISALLOW_INSTALL.
	//   "DISALLOW_INSTALL" - Default. Disallow untrusted app installs on entire
	// device.
	//   "ALLOW_INSTALL_IN_PERSONAL_PROFILE_ONLY" - For devices with work profiles,
	// allow untrusted app installs in the device's personal profile only.
	//   "ALLOW_INSTALL_DEVICE_WIDE" - Allow untrusted app installs on entire
	// device.
	UntrustedAppsPolicy string `json:"untrustedAppsPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonCriteriaMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonCriteriaMode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdvancedSecurityOverrides) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedSecurityOverrides
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AlwaysOnVpnPackage: Configuration for an always-on VPN connection.
type AlwaysOnVpnPackage struct {
	// LockdownEnabled: Disallows networking when the VPN is not connected.
	LockdownEnabled bool `json:"lockdownEnabled,omitempty"`
	// PackageName: The package name of the VPN app.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LockdownEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LockdownEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AlwaysOnVpnPackage) MarshalJSON() ([]byte, error) {
	type NoMethod AlwaysOnVpnPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApiLevelCondition: A compliance rule condition which is satisfied if the
// Android Framework API level on the device doesn't meet a minimum
// requirement. There can only be one rule with this type of condition per
// policy.
type ApiLevelCondition struct {
	// MinApiLevel: The minimum desired Android Framework API level. If the device
	// doesn't meet the minimum requirement, this condition is satisfied. Must be
	// greater than zero.
	MinApiLevel int64 `json:"minApiLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MinApiLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MinApiLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApiLevelCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ApiLevelCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApnPolicy: Access Point Name (APN) policy. Configuration for Access Point
// Names (APNs) which may override any other APNs on the device. See
// OVERRIDE_APNS_ENABLED and overrideApns for details.
type ApnPolicy struct {
	// ApnSettings: Optional. APN settings for override APNs. There must not be any
	// conflict between any of APN settings provided, otherwise the policy will be
	// rejected. Two ApnSettings are considered to conflict when all of the
	// following fields match on both: numericOperatorId, apn, proxyAddress,
	// proxyPort, mmsProxyAddress, mmsProxyPort, mmsc, mvnoType, protocol,
	// roamingProtocol. If some of the APN settings result in non-compliance of
	// INVALID_VALUE , they will be ignored. This can be set on fully managed
	// devices on Android 10 and above. This can also be set on work profiles on
	// Android 13 and above and only with ApnSetting's with ENTERPRISE APN type. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 10. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// work profiles on Android versions less than 13.
	ApnSettings []*ApnSetting `json:"apnSettings,omitempty"`
	// OverrideApns: Optional. Whether override APNs are disabled or enabled. See
	// DevicePolicyManager.setOverrideApnsEnabled
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#setOverrideApnsEnabled)
	// for more details.
	//
	// Possible values:
	//   "OVERRIDE_APNS_UNSPECIFIED" - Unspecified. Defaults to
	// OVERRIDE_APNS_DISABLED.
	//   "OVERRIDE_APNS_DISABLED" - Override APNs disabled. Any configured
	// apnSettings are saved on the device, but are disabled and have no effect.
	// Any other APNs on the device remain in use.
	//   "OVERRIDE_APNS_ENABLED" - Override APNs enabled. Only override APNs are in
	// use, any other APNs are ignored. This can only be set on fully managed
	// devices on Android 10 and above. For work profiles override APNs are enabled
	// via preferentialNetworkServiceSettings and this value cannot be set. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 10. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// work profiles.
	OverrideApns string `json:"overrideApns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApnSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApnSettings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ApnPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApnSetting: An Access Point Name (APN) configuration for a carrier data
// connection. The APN provides configuration to connect a cellular network
// device to an IP data network. A carrier uses this setting to decide which IP
// address to assign, any security methods to apply, and how the device might
// be connected to private networks.
type ApnSetting struct {
	// AlwaysOnSetting: Optional. Whether User Plane resources have to be activated
	// during every transition from CM-IDLE mode to CM-CONNECTED state for this
	// APN. See 3GPP TS 23.501 section 5.6.13.
	//
	// Possible values:
	//   "ALWAYS_ON_SETTING_UNSPECIFIED" - Unspecified. Defaults to NOT_ALWAYS_ON.
	//   "NOT_ALWAYS_ON" - The PDU session brought up by this APN should not be
	// always on.
	//   "ALWAYS_ON" - The PDU session brought up by this APN should always be on.
	// Supported on Android 15 and above. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 15.
	AlwaysOnSetting string `json:"alwaysOnSetting,omitempty"`
	// Apn: Required. Name of the APN. Policy will be rejected if this field is
	// empty.
	Apn string `json:"apn,omitempty"`
	// ApnTypes: Required. Usage categories for the APN. Policy will be rejected if
	// this field is empty or contains APN_TYPE_UNSPECIFIED or duplicates. Multiple
	// APN types can be set on fully managed devices. ENTERPRISE is the only
	// allowed APN type on work profiles. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for any other value on work profiles. APN types
	// that are not supported on the device or management mode will be ignored. If
	// this results in the empty list, the APN setting will be ignored, because
	// apnTypes is a required field. A NonComplianceDetail with INVALID_VALUE is
	// reported if none of the APN types are supported on the device or management
	// mode.
	//
	// Possible values:
	//   "APN_TYPE_UNSPECIFIED" - Unspecified. This value is not used.
	//   "ENTERPRISE" - APN type for enterprise traffic. Supported on Android 13
	// and above. A NonComplianceDetail with API_LEVEL is reported if the Android
	// version is less than 13.
	//   "BIP" - APN type for BIP (Bearer Independent Protocol). This can only be
	// set on fully managed devices on Android 12 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 12. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported for work profiles.
	//   "CBS" - APN type for CBS (Carrier Branded Services). This can only be set
	// on fully managed devices. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for work profiles.
	//   "DEFAULT" - APN type for default data traffic. This can only be set on
	// fully managed devices. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for work profiles.
	//   "DUN" - APN type for DUN (Dial-up networking) traffic. This can only be
	// set on fully managed devices. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for work profiles.
	//   "EMERGENCY" - APN type for Emergency PDN. This is not an IA apn, but is
	// used for access to carrier services in an emergency call situation. This can
	// only be set on fully managed devices. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for work profiles.
	//   "FOTA" - APN type for accessing the carrier's FOTA (Firmware Over-the-Air)
	// portal, used for over the air updates. This can only be set on fully managed
	// devices. A NonComplianceDetail with MANAGEMENT_MODE is reported for work
	// profiles.
	//   "HIPRI" - APN type for HiPri (high-priority) traffic. This can only be set
	// on fully managed devices. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for work profiles.
	//   "IA" - APN type for IA (Initial Attach) APN. This can only be set on fully
	// managed devices. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// work profiles.
	//   "IMS" - APN type for IMS (IP Multimedia Subsystem) traffic. This can only
	// be set on fully managed devices. A NonComplianceDetail with MANAGEMENT_MODE
	// is reported for work profiles.
	//   "MCX" - APN type for MCX (Mission Critical Service) where X can be
	// PTT/Video/Data. This can only be set on fully managed devices. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported for work profiles.
	//   "MMS" - APN type for MMS (Multimedia Messaging Service) traffic. This can
	// only be set on fully managed devices. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for work profiles.
	//   "RCS" - APN type for RCS (Rich Communication Services). This can only be
	// set on fully managed devices on Android 15 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 15. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported for work profiles.
	//   "SUPL" - APN type for SUPL (Secure User Plane Location) assisted GPS. This
	// can only be set on fully managed devices. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for work profiles.
	//   "VSIM" - APN type for VSIM (Virtual SIM) service. This can only be set on
	// fully managed devices on Android 12 and above. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 12. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported for work profiles.
	//   "XCAP" - APN type for XCAP (XML Configuration Access Protocol) traffic.
	// This can only be set on fully managed devices on Android 11 and above. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 11. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// work profiles.
	ApnTypes []string `json:"apnTypes,omitempty"`
	// AuthType: Optional. Authentication type of the APN.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED" - Unspecified. If username is empty, defaults to
	// NONE. Otherwise, defaults to PAP_OR_CHAP.
	//   "NONE" - Authentication is not required.
	//   "PAP" - Authentication type for PAP.
	//   "CHAP" - Authentication type for CHAP.
	//   "PAP_OR_CHAP" - Authentication type for PAP or CHAP.
	AuthType string `json:"authType,omitempty"`
	// CarrierId: Optional. Carrier ID for the APN. A value of 0 (default) means
	// not set and negative values are rejected.
	CarrierId int64 `json:"carrierId,omitempty"`
	// DisplayName: Required. Human-readable name that describes the APN. Policy
	// will be rejected if this field is empty.
	DisplayName string `json:"displayName,omitempty"`
	// MmsProxyAddress: Optional. MMS (Multimedia Messaging Service) proxy address
	// of the APN which can be an IP address or hostname (not a URL).
	MmsProxyAddress string `json:"mmsProxyAddress,omitempty"`
	// MmsProxyPort: Optional. MMS (Multimedia Messaging Service) proxy port of the
	// APN. A value of 0 (default) means not set and negative values are rejected.
	MmsProxyPort int64 `json:"mmsProxyPort,omitempty"`
	// Mmsc: Optional. MMSC (Multimedia Messaging Service Center) URI of the APN.
	Mmsc string `json:"mmsc,omitempty"`
	// MtuV4: Optional. The default MTU (Maximum Transmission Unit) size in bytes
	// of the IPv4 routes brought up by this APN setting. A value of 0 (default)
	// means not set and negative values are rejected. Supported on Android 13 and
	// above. A NonComplianceDetail with API_LEVEL is reported if the Android
	// version is less than 13.
	MtuV4 int64 `json:"mtuV4,omitempty"`
	// MtuV6: Optional. The MTU (Maximum Transmission Unit) size of the IPv6 mobile
	// interface to which the APN connected. A value of 0 (default) means not set
	// and negative values are rejected. Supported on Android 13 and above. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13.
	MtuV6 int64 `json:"mtuV6,omitempty"`
	// MvnoType: Optional. MVNO match type for the APN.
	//
	// Possible values:
	//   "MVNO_TYPE_UNSPECIFIED" - The MVNO type is not specified.
	//   "GID" - MVNO type for group identifier level 1.
	//   "ICCID" - MVNO type for ICCID.
	//   "IMSI" - MVNO type for IMSI.
	//   "SPN" - MVNO type for SPN (service provider name).
	MvnoType string `json:"mvnoType,omitempty"`
	// NetworkTypes: Optional. Radio technologies (network types) the APN may use.
	// Policy will be rejected if this field contains NETWORK_TYPE_UNSPECIFIED or
	// duplicates.
	//
	// Possible values:
	//   "NETWORK_TYPE_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "EDGE" - Radio technology EDGE.
	//   "GPRS" - Radio technology GPRS.
	//   "GSM" - Radio technology GSM.
	//   "HSDPA" - Radio technology HSDPA.
	//   "HSPA" - Radio technology HSPA.
	//   "HSPAP" - Radio technology HSPAP.
	//   "HSUPA" - Radio technology HSUPA.
	//   "IWLAN" - Radio technology IWLAN.
	//   "LTE" - Radio technology LTE.
	//   "NR" - Radio technology NR (New Radio) 5G.
	//   "TD_SCDMA" - Radio technology TD_SCDMA.
	//   "UMTS" - Radio technology UMTS.
	NetworkTypes []string `json:"networkTypes,omitempty"`
	// NumericOperatorId: Optional. The numeric operator ID of the APN. Numeric
	// operator ID is defined as MCC (Mobile Country Code) + MNC (Mobile Network
	// Code).
	NumericOperatorId string `json:"numericOperatorId,omitempty"`
	// Password: Optional. APN password of the APN.
	Password string `json:"password,omitempty"`
	// Protocol: Optional. The protocol to use to connect to this APN.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - The protocol is not specified.
	//   "IP" - Internet protocol.
	//   "IPV4V6" - Virtual PDP type introduced to handle dual IP stack UE
	// capability.
	//   "IPV6" - Internet protocol, version 6.
	//   "NON_IP" - Transfer of Non-IP data to external packet data network.
	//   "PPP" - Point to point protocol.
	//   "UNSTRUCTURED" - Transfer of Unstructured data to the Data Network via N6.
	Protocol string `json:"protocol,omitempty"`
	// ProxyAddress: Optional. The proxy address of the APN.
	ProxyAddress string `json:"proxyAddress,omitempty"`
	// ProxyPort: Optional. The proxy port of the APN. A value of 0 (default) means
	// not set and negative values are rejected.
	ProxyPort int64 `json:"proxyPort,omitempty"`
	// RoamingProtocol: Optional. The protocol to use to connect to this APN while
	// the device is roaming.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - The protocol is not specified.
	//   "IP" - Internet protocol.
	//   "IPV4V6" - Virtual PDP type introduced to handle dual IP stack UE
	// capability.
	//   "IPV6" - Internet protocol, version 6.
	//   "NON_IP" - Transfer of Non-IP data to external packet data network.
	//   "PPP" - Point to point protocol.
	//   "UNSTRUCTURED" - Transfer of Unstructured data to the Data Network via N6.
	RoamingProtocol string `json:"roamingProtocol,omitempty"`
	// Username: Optional. APN username of the APN.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlwaysOnSetting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlwaysOnSetting") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApnSetting) MarshalJSON() ([]byte, error) {
	type NoMethod ApnSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppProcessInfo: Information about a process. It contains process name, start
// time, app Uid, app Pid, seinfo tag, hash of the base APK.
type AppProcessInfo struct {
	// ApkSha256Hash: SHA-256 hash of the base APK, in hexadecimal format.
	ApkSha256Hash string `json:"apkSha256Hash,omitempty"`
	// PackageNames: Package names of all packages that are associated with the
	// particular user ID. In most cases, this will be a single package name, the
	// package that has been assigned that user ID. If multiple application share a
	// UID then all packages sharing UID will be included.
	PackageNames []string `json:"packageNames,omitempty"`
	// Pid: Process ID.
	Pid int64 `json:"pid,omitempty"`
	// ProcessName: Process name.
	ProcessName string `json:"processName,omitempty"`
	// Seinfo: SELinux policy info.
	Seinfo string `json:"seinfo,omitempty"`
	// StartTime: Process start time.
	StartTime string `json:"startTime,omitempty"`
	// Uid: UID of the package.
	Uid int64 `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApkSha256Hash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApkSha256Hash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppProcessInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppProcessInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppProcessStartEvent: An app process was started. This is available
// device-wide on fully managed devices and within the work profile on
// organization-owned devices with a work profile.
type AppProcessStartEvent struct {
	// ProcessInfo: Information about a process.
	ProcessInfo *AppProcessInfo `json:"processInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppProcessStartEvent) MarshalJSON() ([]byte, error) {
	type NoMethod AppProcessStartEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppTrackInfo: Id to name association of a app track.
type AppTrackInfo struct {
	// TrackAlias: The track name associated with the trackId, set in the Play
	// Console. The name is modifiable from Play Console.
	TrackAlias string `json:"trackAlias,omitempty"`
	// TrackId: The unmodifiable unique track identifier, taken from the
	// releaseTrackId in the URL of the Play Console page that displays the app’s
	// track information.
	TrackId string `json:"trackId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrackAlias") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrackAlias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppTrackInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppTrackInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppVersion: This represents a single version of the app.
type AppVersion struct {
	// Production: If the value is True, it indicates that this version is a
	// production track.
	Production bool `json:"production,omitempty"`
	// TrackIds: Track identifiers that the app version is published in. This does
	// not include the production track (see production instead).
	TrackIds []string `json:"trackIds,omitempty"`
	// VersionCode: Unique increasing identifier for the app version.
	VersionCode int64 `json:"versionCode,omitempty"`
	// VersionString: The string used in the Play store by the app developer to
	// identify the version. The string is not necessarily unique or localized (for
	// example, the string could be "1.4").
	VersionString string `json:"versionString,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Production") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Production") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AppVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Application: Information about an app.
type Application struct {
	// AppPricing: Whether this app is free, free with in-app purchases, or paid.
	// If the pricing is unspecified, this means the app is not generally available
	// anymore (even though it might still be available to people who own it).
	//
	// Possible values:
	//   "APP_PRICING_UNSPECIFIED" - Unknown pricing, used to denote an approved
	// app that is not generally available.
	//   "FREE" - The app is free.
	//   "FREE_WITH_IN_APP_PURCHASE" - The app is free, but offers in-app
	// purchases.
	//   "PAID" - The app is paid.
	AppPricing string `json:"appPricing,omitempty"`
	// AppTracks: Application tracks visible to the enterprise.
	AppTracks []*AppTrackInfo `json:"appTracks,omitempty"`
	// AppVersions: Versions currently available for this app.
	AppVersions []*AppVersion `json:"appVersions,omitempty"`
	// Author: The name of the author of the apps (for example, the app developer).
	Author string `json:"author,omitempty"`
	// AvailableCountries: The countries which this app is available in as per ISO
	// 3166-1 alpha-2.
	AvailableCountries []string `json:"availableCountries,omitempty"`
	// Category: The app category (e.g. RACING, SOCIAL, etc.)
	Category string `json:"category,omitempty"`
	// ContentRating: The content rating for this app.
	//
	// Possible values:
	//   "CONTENT_RATING_UNSPECIFIED" - Unspecified.
	//   "THREE_YEARS" - Content suitable for ages 3 and above only.
	//   "SEVEN_YEARS" - Content suitable for ages 7 and above only.
	//   "TWELVE_YEARS" - Content suitable for ages 12 and above only.
	//   "SIXTEEN_YEARS" - Content suitable for ages 16 and above only.
	//   "EIGHTEEN_YEARS" - Content suitable for ages 18 and above only.
	ContentRating string `json:"contentRating,omitempty"`
	// Description: The localized promotional description, if available.
	Description string `json:"description,omitempty"`
	// DistributionChannel: How and to whom the package is made available.
	//
	// Possible values:
	//   "DISTRIBUTION_CHANNEL_UNSPECIFIED" - Unspecified.
	//   "PUBLIC_GOOGLE_HOSTED" - Package is available through the Play store and
	// not restricted to a specific enterprise.
	//   "PRIVATE_GOOGLE_HOSTED" - Package is a private app (restricted to an
	// enterprise) but hosted by Google.
	//   "PRIVATE_SELF_HOSTED" - Private app (restricted to an enterprise) and is
	// privately hosted.
	DistributionChannel string `json:"distributionChannel,omitempty"`
	// Features: Noteworthy features (if any) of this app.
	//
	// Possible values:
	//   "APP_FEATURE_UNSPECIFIED" - Unspecified.
	//   "VPN_APP" - The app is a VPN.
	Features []string `json:"features,omitempty"`
	// FullDescription: Full app description, if available.
	FullDescription string `json:"fullDescription,omitempty"`
	// IconUrl: A link to an image that can be used as an icon for the app. This
	// image is suitable for use up to a pixel size of 512 x 512.
	IconUrl string `json:"iconUrl,omitempty"`
	// ManagedProperties: The set of managed properties available to be
	// pre-configured for the app.
	ManagedProperties []*ManagedProperty `json:"managedProperties,omitempty"`
	// MinAndroidSdkVersion: The minimum Android SDK necessary to run the app.
	MinAndroidSdkVersion int64 `json:"minAndroidSdkVersion,omitempty"`
	// Name: The name of the app in the form
	// enterprises/{enterprise}/applications/{package_name}.
	Name string `json:"name,omitempty"`
	// Permissions: The permissions required by the app.
	Permissions []*ApplicationPermission `json:"permissions,omitempty"`
	// PlayStoreUrl: A link to the (consumer) Google Play details page for the app.
	PlayStoreUrl string `json:"playStoreUrl,omitempty"`
	// RecentChanges: A localised description of the recent changes made to the
	// app.
	RecentChanges string `json:"recentChanges,omitempty"`
	// ScreenshotUrls: A list of screenshot links representing the app.
	ScreenshotUrls []string `json:"screenshotUrls,omitempty"`
	// SmallIconUrl: A link to a smaller image that can be used as an icon for the
	// app. This image is suitable for use up to a pixel size of 128 x 128.
	SmallIconUrl string `json:"smallIconUrl,omitempty"`
	// Title: The title of the app. Localized.
	Title string `json:"title,omitempty"`
	// UpdateTime: Output only. The approximate time (within 7 days) the app was
	// last published.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppPricing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppPricing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Application) MarshalJSON() ([]byte, error) {
	type NoMethod Application
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationEvent: An app-related event.
type ApplicationEvent struct {
	// CreateTime: The creation time of the event.
	CreateTime string `json:"createTime,omitempty"`
	// EventType: App event type.
	//
	// Possible values:
	//   "APPLICATION_EVENT_TYPE_UNSPECIFIED" - This value is disallowed.
	//   "INSTALLED" - The app was installed.
	//   "CHANGED" - The app was changed, for example, a component was enabled or
	// disabled.
	//   "DATA_CLEARED" - The app data was cleared.
	//   "REMOVED" - The app was removed.
	//   "REPLACED" - A new version of the app has been installed, replacing the
	// old version.
	//   "RESTARTED" - The app was restarted.
	//   "PINNED" - The app was pinned to the foreground.
	//   "UNPINNED" - The app was unpinned.
	EventType string `json:"eventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationPermission: A permission required by the app.
type ApplicationPermission struct {
	// Description: A longer description of the permission, providing more detail
	// on what it affects. Localized.
	Description string `json:"description,omitempty"`
	// Name: The name of the permission. Localized.
	Name string `json:"name,omitempty"`
	// PermissionId: An opaque string uniquely identifying the permission. Not
	// localized.
	PermissionId string `json:"permissionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationPermission) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationPermission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationPolicy: Policy for an individual app. Note: Application
// availability on a given device cannot be changed using this policy if
// installAppsDisabled is enabled. The maximum number of applications that you
// can specify per policy is 3,000.
type ApplicationPolicy struct {
	// AccessibleTrackIds: List of the app’s track IDs that a device belonging to
	// the enterprise can access. If the list contains multiple track IDs, devices
	// receive the latest version among all accessible tracks. If the list contains
	// no track IDs, devices only have access to the app’s production track. More
	// details about each track are available in AppTrackInfo.
	AccessibleTrackIds []string `json:"accessibleTrackIds,omitempty"`
	// AlwaysOnVpnLockdownExemption: Specifies whether the app is allowed
	// networking when the VPN is not connected and
	// alwaysOnVpnPackage.lockdownEnabled is enabled. If set to
	// VPN_LOCKDOWN_ENFORCED, the app is not allowed networking, and if set to
	// VPN_LOCKDOWN_EXEMPTION, the app is allowed networking. Only supported on
	// devices running Android 10 and above. If this is not supported by the
	// device, the device will contain a NonComplianceDetail with
	// non_compliance_reason set to API_LEVEL and a fieldPath. If this is not
	// applicable to the app, the device will contain a NonComplianceDetail with
	// non_compliance_reason set to UNSUPPORTED and a fieldPath. The fieldPath is
	// set to applications[i].alwaysOnVpnLockdownExemption, where i is the index of
	// the package in the applications policy.
	//
	// Possible values:
	//   "ALWAYS_ON_VPN_LOCKDOWN_EXEMPTION_UNSPECIFIED" - Unspecified. Defaults to
	// VPN_LOCKDOWN_ENFORCED.
	//   "VPN_LOCKDOWN_ENFORCED" - The app respects the always-on VPN lockdown
	// setting.
	//   "VPN_LOCKDOWN_EXEMPTION" - The app is exempt from the always-on VPN
	// lockdown setting.
	AlwaysOnVpnLockdownExemption string `json:"alwaysOnVpnLockdownExemption,omitempty"`
	// AutoUpdateMode: Controls the auto-update mode for the app.
	//
	// Possible values:
	//   "AUTO_UPDATE_MODE_UNSPECIFIED" - Unspecified. Defaults to
	// AUTO_UPDATE_DEFAULT.
	//   "AUTO_UPDATE_DEFAULT" - The default update mode.The app is automatically
	// updated with low priority to minimize the impact on the user.The app is
	// updated when all of the following constraints are met: The device is not
	// actively used. The device is connected to an unmetered network. The device
	// is charging. The app to be updated is not running in the foreground.The
	// device is notified about a new update within 24 hours after it is published
	// by the developer, after which the app is updated the next time the
	// constraints above are met.
	//   "AUTO_UPDATE_POSTPONED" - The app is not automatically updated for a
	// maximum of 90 days after the app becomes out of date.90 days after the app
	// becomes out of date, the latest available version is installed automatically
	// with low priority (see AUTO_UPDATE_DEFAULT). After the app is updated it is
	// not automatically updated again until 90 days after it becomes out of date
	// again.The user can still manually update the app from the Play Store at any
	// time.
	//   "AUTO_UPDATE_HIGH_PRIORITY" - The app is updated as soon as possible. No
	// constraints are applied.The device is notified as soon as possible about a
	// new update after it becomes available.*NOTE:* Updates to apps with larger
	// deployments across Android's ecosystem can take up to 24h.
	AutoUpdateMode string `json:"autoUpdateMode,omitempty"`
	// ConnectedWorkAndPersonalApp: Controls whether the app can communicate with
	// itself across a device’s work and personal profiles, subject to user
	// consent.
	//
	// Possible values:
	//   "CONNECTED_WORK_AND_PERSONAL_APP_UNSPECIFIED" - Unspecified. Defaults to
	// CONNECTED_WORK_AND_PERSONAL_APPS_DISALLOWED.
	//   "CONNECTED_WORK_AND_PERSONAL_APP_DISALLOWED" - Default. Prevents the app
	// from communicating cross-profile.
	//   "CONNECTED_WORK_AND_PERSONAL_APP_ALLOWED" - Allows the app to communicate
	// across profiles after receiving user consent.
	ConnectedWorkAndPersonalApp string `json:"connectedWorkAndPersonalApp,omitempty"`
	// CredentialProviderPolicy: Optional. Whether the app is allowed to act as a
	// credential provider on Android 14 and above.
	//
	// Possible values:
	//   "CREDENTIAL_PROVIDER_POLICY_UNSPECIFIED" - Unspecified. The behaviour is
	// governed by credentialProviderPolicyDefault.
	//   "CREDENTIAL_PROVIDER_ALLOWED" - App is allowed to act as a credential
	// provider.
	CredentialProviderPolicy string `json:"credentialProviderPolicy,omitempty"`
	// CustomAppConfig: Optional. Configuration for this custom app.install_type
	// must be set to CUSTOM for this to be set.
	CustomAppConfig *CustomAppConfig `json:"customAppConfig,omitempty"`
	// DefaultPermissionPolicy: The default policy for all permissions requested by
	// the app. If specified, this overrides the policy-level
	// default_permission_policy which applies to all apps. It does not override
	// the permission_grants which applies to all apps.
	//
	// Possible values:
	//   "PERMISSION_POLICY_UNSPECIFIED" - Policy not specified. If no policy is
	// specified for a permission at any level, then the PROMPT behavior is used by
	// default.
	//   "PROMPT" - Prompt the user to grant a permission.
	//   "GRANT" - Automatically grant a permission.On Android 12 and above,
	// READ_SMS
	// (https://developer.android.com/reference/android/Manifest.permission#READ_SMS)
	// and following sensor-related permissions can only be granted on fully
	// managed devices: ACCESS_FINE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION)
	// ACCESS_BACKGROUND_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_BACKGROUND_LOCATION)
	// ACCESS_COARSE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_COARSE_LOCATION)
	// CAMERA
	// (https://developer.android.com/reference/android/Manifest.permission#CAMERA)
	// RECORD_AUDIO
	// (https://developer.android.com/reference/android/Manifest.permission#RECORD_AUDIO)
	// ACTIVITY_RECOGNITION
	// (https://developer.android.com/reference/android/Manifest.permission#ACTIVITY_RECOGNITION)
	// BODY_SENSORS
	// (https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS)
	//   "DENY" - Automatically deny a permission.
	DefaultPermissionPolicy string `json:"defaultPermissionPolicy,omitempty"`
	// DelegatedScopes: The scopes delegated to the app from Android Device Policy.
	// These provide additional privileges for the applications they are applied
	// to.
	//
	// Possible values:
	//   "DELEGATED_SCOPE_UNSPECIFIED" - No delegation scope specified.
	//   "CERT_INSTALL" - Grants access to certificate installation and management.
	// This scope can be delegated to multiple applications.
	//   "MANAGED_CONFIGURATIONS" - Grants access to managed configurations
	// management. This scope can be delegated to multiple applications.
	//   "BLOCK_UNINSTALL" - Grants access to blocking uninstallation. This scope
	// can be delegated to multiple applications.
	//   "PERMISSION_GRANT" - Grants access to permission policy and permission
	// grant state. This scope can be delegated to multiple applications.
	//   "PACKAGE_ACCESS" - Grants access to package access state. This scope can
	// be delegated to multiple applications.
	//   "ENABLE_SYSTEM_APP" - Grants access for enabling system apps. This scope
	// can be delegated to multiple applications.
	//   "NETWORK_ACTIVITY_LOGS" - Grants access to network activity logs. Allows
	// the delegated application to call setNetworkLoggingEnabled
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#setNetworkLoggingEnabled%28android.content.ComponentName,%20boolean%29),
	// isNetworkLoggingEnabled
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#isNetworkLoggingEnabled%28android.content.ComponentName%29)
	// and retrieveNetworkLogs
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#retrieveNetworkLogs%28android.content.ComponentName,%20long%29)
	// methods. This scope can be delegated to at most one application. Supported
	// for fully managed devices on Android 10 and above. Supported for a work
	// profile on Android 12 and above. When delegation is supported and set,
	// NETWORK_ACTIVITY_LOGS is ignored.
	//   "SECURITY_LOGS" - Grants access to security logs. Allows the delegated
	// application to call setSecurityLoggingEnabled
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#setSecurityLoggingEnabled%28android.content.ComponentName,%20boolean%29),
	// isSecurityLoggingEnabled
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#isSecurityLoggingEnabled%28android.content.ComponentName%29),
	// retrieveSecurityLogs
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#retrieveSecurityLogs%28android.content.ComponentName%29)
	// and retrievePreRebootSecurityLogs
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#retrievePreRebootSecurityLogs%28android.content.ComponentName%29)
	// methods. This scope can be delegated to at most one application. Supported
	// for fully managed devices and company-owned devices with a work profile on
	// Android 12 and above. When delegation is supported and set, SECURITY_LOGS is
	// ignored.
	//   "CERT_SELECTION" - Grants access to selection of KeyChain certificates on
	// behalf of requesting apps. Once granted, the delegated application will
	// start receiving DelegatedAdminReceiver#onChoosePrivateKeyAlias
	// (https://developer.android.com/reference/android/app/admin/DelegatedAdminReceiver#onChoosePrivateKeyAlias%28android.content.Context,%20android.content.Intent,%20int,%20android.net.Uri,%20java.lang.String%29).
	// Allows the delegated application to call grantKeyPairToApp
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#grantKeyPairToApp%28android.content.ComponentName,%20java.lang.String,%20java.lang.String%29)
	// and revokeKeyPairFromApp
	// (https://developer.android.com/reference/android/app/admin/DevicePolicyManager#revokeKeyPairFromApp%28android.content.ComponentName,%20java.lang.String,%20java.lang.String%29)
	// methods. This scope can be delegated to at most one application.
	// choosePrivateKeyRules must be empty and privateKeySelectionEnabled has no
	// effect if certificate selection is delegated to an application.
	DelegatedScopes []string `json:"delegatedScopes,omitempty"`
	// Disabled: Whether the app is disabled. When disabled, the app data is still
	// preserved.
	Disabled bool `json:"disabled,omitempty"`
	// ExtensionConfig: Configuration to enable this app as an extension app, with
	// the capability of interacting with Android Device Policy offline.This field
	// can be set for at most one app. If there is any app with COMPANION_APP role,
	// this field cannot be set.The signing key certificate fingerprint of the app
	// on the device must match one of the entries in
	// ApplicationPolicy.signingKeyCerts or
	// ExtensionConfig.signingKeyFingerprintsSha256 (deprecated) or the signing key
	// certificate fingerprints obtained from Play Store for the app to be able to
	// communicate with Android Device Policy. If the app is not on Play Store and
	// if ApplicationPolicy.signingKeyCerts and
	// ExtensionConfig.signingKeyFingerprintsSha256 (deprecated) are not set, a
	// NonComplianceDetail with INVALID_VALUE is reported.
	ExtensionConfig *ExtensionConfig `json:"extensionConfig,omitempty"`
	// InstallConstraint: Optional. The constraints for installing the app. You can
	// specify a maximum of one InstallConstraint. Multiple constraints are
	// rejected.
	InstallConstraint []*InstallConstraint `json:"installConstraint,omitempty"`
	// InstallPriority: Optional. Amongst apps with installType set to:
	// FORCE_INSTALLED PREINSTALLEDthis controls the relative priority of
	// installation. A value of 0 (default) means this app has no priority over
	// other apps. For values between 1 and 10,000, a lower value means a higher
	// priority. Values outside of the range 0 to 10,000 inclusive are rejected.
	InstallPriority int64 `json:"installPriority,omitempty"`
	// InstallType: The type of installation to perform.
	//
	// Possible values:
	//   "INSTALL_TYPE_UNSPECIFIED" - Unspecified. Defaults to AVAILABLE.
	//   "PREINSTALLED" - The app is automatically installed and can be removed by
	// the user.
	//   "FORCE_INSTALLED" - The app is automatically installed regardless of a set
	// maintenance window and can't be removed by the user.
	//   "BLOCKED" - The app is blocked and can't be installed. If the app was
	// installed under a previous policy, it will be uninstalled. This also blocks
	// its instant app functionality.
	//   "AVAILABLE" - The app is available to install.
	//   "REQUIRED_FOR_SETUP" - The app is automatically installed and can't be
	// removed by the user and will prevent setup from completion until
	// installation is complete.
	//   "KIOSK" - The app is automatically installed in kiosk mode: it's set as
	// the preferred home intent and whitelisted for lock task mode. Device setup
	// won't complete until the app is installed. After installation, users won't
	// be able to remove the app. You can only set this installType for one app per
	// policy. When this is present in the policy, status bar will be automatically
	// disabled.If there is any app with KIOSK role, then this install type cannot
	// be set for any app.
	//   "CUSTOM" - The app can only be installed and updated via AMAPI SDK command
	// (https://developers.google.com/android/management/extensibility-sdk-integration).Note:
	// This only affects fully managed devices. Play related fields
	// minimumVersionCode, accessibleTrackIds, autoUpdateMode, installConstraint
	// and installPriority cannot be set for the app. The app isn't available in
	// the Play Store. The app installed on the device has applicationSource set to
	// CUSTOM. When the current installType is CUSTOM, the signing key certificate
	// fingerprint of the existing custom app on the device must match one of the
	// entries in ApplicationPolicy.signingKeyCerts . Otherwise, a
	// NonComplianceDetail with APP_SIGNING_CERT_MISMATCH is reported. Changing the
	// installType from CUSTOM to another value must match the playstore version of
	// the application signing key certificate fingerprint. Otherwise a
	// NonComplianceDetail with APP_SIGNING_CERT_MISMATCH is reported. Changing the
	// installType to CUSTOM uninstalls the existing app if its signing key
	// certificate fingerprint of the installed app doesn't match the one from the
	// ApplicationPolicy.signingKeyCerts . Removing the app from applications
	// doesn't uninstall the existing app if it conforms to playStoreMode. See also
	// customAppConfig. This is different from the Google Play Custom App
	// Publishing
	// (https://developers.google.com/android/work/play/custom-app-api/get-started)
	// feature.
	InstallType string `json:"installType,omitempty"`
	// LockTaskAllowed: Whether the app is allowed to lock itself in full-screen
	// mode. DEPRECATED. Use InstallType KIOSK or kioskCustomLauncherEnabled to
	// configure a dedicated device.
	LockTaskAllowed bool `json:"lockTaskAllowed,omitempty"`
	// ManagedConfiguration: Managed configuration applied to the app. The format
	// for the configuration is dictated by the ManagedProperty values supported by
	// the app. Each field name in the managed configuration must match the key
	// field of the ManagedProperty. The field value must be compatible with the
	// type of the ManagedProperty: *type* *JSON value* BOOL true or false STRING
	// string INTEGER number CHOICE string MULTISELECT array of strings HIDDEN
	// string BUNDLE_ARRAY array of objects
	ManagedConfiguration googleapi.RawMessage `json:"managedConfiguration,omitempty"`
	// ManagedConfigurationTemplate: The managed configurations template for the
	// app, saved from the managed configurations iframe. This field is ignored if
	// managed_configuration is set.
	ManagedConfigurationTemplate *ManagedConfigurationTemplate `json:"managedConfigurationTemplate,omitempty"`
	// MinimumVersionCode: The minimum version of the app that runs on the device.
	// If set, the device attempts to update the app to at least this version code.
	// If the app is not up-to-date, the device will contain a NonComplianceDetail
	// with non_compliance_reason set to APP_NOT_UPDATED. The app must already be
	// published to Google Play with a version code greater than or equal to this
	// value. At most 20 apps may specify a minimum version code per policy.
	MinimumVersionCode int64 `json:"minimumVersionCode,omitempty"`
	// PackageName: The package name of the app. For example,
	// com.google.android.youtube for the YouTube app.
	PackageName string `json:"packageName,omitempty"`
	// PermissionGrants: Explicit permission grants or denials for the app. These
	// values override the default_permission_policy and permission_grants which
	// apply to all apps.
	PermissionGrants []*PermissionGrant `json:"permissionGrants,omitempty"`
	// PreferentialNetworkId: Optional. ID of the preferential network the
	// application uses. There must be a configuration for the specified network ID
	// in preferentialNetworkServiceConfigs. If set to
	// PREFERENTIAL_NETWORK_ID_UNSPECIFIED, the application will use the default
	// network ID specified in defaultPreferentialNetworkId. See the documentation
	// of defaultPreferentialNetworkId for the list of apps excluded from this
	// defaulting. This applies on both work profiles and fully managed devices on
	// Android 13 and above.
	//
	// Possible values:
	//   "PREFERENTIAL_NETWORK_ID_UNSPECIFIED" - Whether this value is valid and
	// what it means depends on where it is used, and this is documented on the
	// relevant fields.
	//   "NO_PREFERENTIAL_NETWORK" - Application does not use any preferential
	// network.
	//   "PREFERENTIAL_NETWORK_ID_ONE" - Preferential network identifier 1.
	//   "PREFERENTIAL_NETWORK_ID_TWO" - Preferential network identifier 2.
	//   "PREFERENTIAL_NETWORK_ID_THREE" - Preferential network identifier 3.
	//   "PREFERENTIAL_NETWORK_ID_FOUR" - Preferential network identifier 4.
	//   "PREFERENTIAL_NETWORK_ID_FIVE" - Preferential network identifier 5.
	PreferentialNetworkId string `json:"preferentialNetworkId,omitempty"`
	// Roles: Optional. Roles the app has.Apps having certain roles can be exempted
	// from power and background execution restrictions, suspension and hibernation
	// on Android 14 and above. The user control can also be disallowed for apps
	// with certain roles on Android 11 and above. Refer to the documentation of
	// each RoleType for more details.The app is notified about the roles that are
	// set for it if the app has a notification receiver service with . The app is
	// notified whenever its roles are updated or after the app is installed when
	// it has nonempty list of roles. The app can use this notification to
	// bootstrap itself after the installation. See Integrate with the AMAPI SDK
	// (https://developers.google.com/android/management/sdk-integration) and
	// Manage app roles
	// (https://developers.google.com/android/management/app-roles) guides for more
	// details on the requirements for the service.For the exemptions to be applied
	// and the app to be notified about the roles, the signing key certificate
	// fingerprint of the app on the device must match one of the signing key
	// certificate fingerprints obtained from Play Store or one of the entries in
	// ApplicationPolicy.signingKeyCerts. Otherwise, a NonComplianceDetail with
	// APP_SIGNING_CERT_MISMATCH is reported.There must not be duplicate roles with
	// the same roleType. Multiple apps cannot hold a role with the same roleType.
	// A role with type ROLE_TYPE_UNSPECIFIED is not allowed.
	Roles []*Role `json:"roles,omitempty"`
	// SigningKeyCerts: Optional. Signing key certificates of the app.This field is
	// required in the following cases: The app has installType set to CUSTOM (i.e.
	// a custom app). The app has roles set to a nonempty list and the app does not
	// exist on the Play Store. The app has extensionConfig set (i.e. an extension
	// app) but ExtensionConfig.signingKeyFingerprintsSha256 (deprecated) is not
	// set and the app does not exist on the Play Store.If this field is not set
	// for a custom app, the policy is rejected. If it is not set when required for
	// a non-custom app, a NonComplianceDetail with INVALID_VALUE is reported.For
	// other cases, this field is optional and the signing key certificates
	// obtained from Play Store are used.See following policy settings to see how
	// this field is used: choosePrivateKeyRules
	// ApplicationPolicy.InstallType.CUSTOM ApplicationPolicy.extensionConfig
	// ApplicationPolicy.roles
	SigningKeyCerts []*ApplicationSigningKeyCert `json:"signingKeyCerts,omitempty"`
	// UserControlSettings: Optional. Specifies whether user control is permitted
	// for the app. User control includes user actions like force-stopping and
	// clearing app data. Certain types of apps have special treatment, see
	// USER_CONTROL_SETTINGS_UNSPECIFIED and USER_CONTROL_ALLOWED for more details.
	//
	// Possible values:
	//   "USER_CONTROL_SETTINGS_UNSPECIFIED" - Uses the default behaviour of the
	// app to determine if user control is allowed or disallowed. User control is
	// allowed by default for most apps but disallowed for following types of apps:
	// extension apps (see extensionConfig for more details) kiosk apps (see KIOSK
	// install type for more details) apps with roles set to a nonempty list other
	// critical system apps
	//   "USER_CONTROL_ALLOWED" - User control is allowed for the app. Kiosk apps
	// can use this to allow user control. For extension apps (see extensionConfig
	// for more details), user control is disallowed even if this value is set.For
	// apps with roles set to a nonempty list (except roles containing only KIOSK
	// role), this value cannot be set.For kiosk apps (see KIOSK install type and
	// KIOSK role type for more details), this value can be used to allow user
	// control.
	//   "USER_CONTROL_DISALLOWED" - User control is disallowed for the app. This
	// is supported on Android 11 and above. A NonComplianceDetail with API_LEVEL
	// is reported if the Android version is less than 11.
	UserControlSettings string `json:"userControlSettings,omitempty"`
	// WorkProfileWidgets: Specifies whether the app installed in the work profile
	// is allowed to add widgets to the home screen.
	//
	// Possible values:
	//   "WORK_PROFILE_WIDGETS_UNSPECIFIED" - Unspecified. Defaults to
	// work_profile_widgets_default
	//   "WORK_PROFILE_WIDGETS_ALLOWED" - Work profile widgets are allowed. This
	// means the application will be able to add widgets to the home screen.
	//   "WORK_PROFILE_WIDGETS_DISALLOWED" - Work profile widgets are disallowed.
	// This means the application will not be able to add widgets to the home
	// screen.
	WorkProfileWidgets string `json:"workProfileWidgets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibleTrackIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibleTrackIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationPolicyChange: A change to be made to a single ApplicationPolicy
// object.
type ApplicationPolicyChange struct {
	// Application: If ApplicationPolicy.packageName matches an existing
	// ApplicationPolicy object within the Policy being modified, then that object
	// will be updated. Otherwise, it will be added to the end of the
	// Policy.applications.
	Application *ApplicationPolicy `json:"application,omitempty"`
	// UpdateMask: The field mask indicating the fields to update. If omitted, all
	// modifiable fields are updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Application") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Application") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationPolicyChange) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationPolicyChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationReport: Information reported about an installed app.
type ApplicationReport struct {
	// ApplicationSource: The source of the package.
	//
	// Possible values:
	//   "APPLICATION_SOURCE_UNSPECIFIED" - The app was sideloaded from an
	// unspecified source.
	//   "SYSTEM_APP_FACTORY_VERSION" - This is a system app from the device's
	// factory image.
	//   "SYSTEM_APP_UPDATED_VERSION" - This is an updated system app.
	//   "INSTALLED_FROM_PLAY_STORE" - The app was installed from the Google Play
	// Store.
	//   "CUSTOM" - The app was installed using the AMAPI SDK command
	// (https://developers.google.com/android/management/extensibility-sdk-integration).
	// See also: CUSTOM
	ApplicationSource string `json:"applicationSource,omitempty"`
	// DisplayName: The display name of the app.
	DisplayName string `json:"displayName,omitempty"`
	// Events: The list of app events which have occurred in the last 30 hours.
	Events []*ApplicationEvent `json:"events,omitempty"`
	// InstallerPackageName: The package name of the app that installed this app.
	InstallerPackageName string `json:"installerPackageName,omitempty"`
	// KeyedAppStates: List of keyed app states reported by the app.
	KeyedAppStates []*KeyedAppState `json:"keyedAppStates,omitempty"`
	// PackageName: Package name of the app.
	PackageName string `json:"packageName,omitempty"`
	// PackageSha256Hash: The SHA-256 hash of the app's APK file, which can be used
	// to verify the app hasn't been modified. Each byte of the hash value is
	// represented as a two-digit hexadecimal number.
	PackageSha256Hash string `json:"packageSha256Hash,omitempty"`
	// SigningKeyCertFingerprints: The SHA-1 hash of each
	// android.content.pm.Signature
	// (https://developer.android.com/reference/android/content/pm/Signature.html)
	// associated with the app package. Each byte of each hash value is represented
	// as a two-digit hexadecimal number.
	SigningKeyCertFingerprints []string `json:"signingKeyCertFingerprints,omitempty"`
	// State: Application state.
	//
	// Possible values:
	//   "APPLICATION_STATE_UNSPECIFIED" - App state is unspecified
	//   "REMOVED" - App was removed from the device
	//   "INSTALLED" - App is installed on the device
	State string `json:"state,omitempty"`
	// UserFacingType: Whether the app is user facing.
	//
	// Possible values:
	//   "USER_FACING_TYPE_UNSPECIFIED" - App user facing type is unspecified.
	//   "NOT_USER_FACING" - App is not user facing.
	//   "USER_FACING" - App is user facing.
	UserFacingType string `json:"userFacingType,omitempty"`
	// VersionCode: The app version code, which can be used to determine whether
	// one version is more recent than another.
	VersionCode int64 `json:"versionCode,omitempty"`
	// VersionName: The app version as displayed to the user.
	VersionName string `json:"versionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationReport) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationReportingSettings: Settings controlling the behavior of
// application reports.
type ApplicationReportingSettings struct {
	// IncludeRemovedApps: Whether removed apps are included in application
	// reports.
	IncludeRemovedApps bool `json:"includeRemovedApps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeRemovedApps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeRemovedApps") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationReportingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationReportingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationSigningKeyCert: The application signing key certificate.
type ApplicationSigningKeyCert struct {
	// SigningKeyCertFingerprintSha256: Required. The SHA-256 hash value of the
	// signing key certificate of the app. This must be a valid SHA-256 hash value,
	// i.e. 32 bytes. Otherwise, the policy is rejected.
	SigningKeyCertFingerprintSha256 string `json:"signingKeyCertFingerprintSha256,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "SigningKeyCertFingerprintSha256") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SigningKeyCertFingerprintSha256")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationSigningKeyCert) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationSigningKeyCert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupServiceToggledEvent: An admin has enabled or disabled backup service.
type BackupServiceToggledEvent struct {
	// AdminPackageName: Package name of the admin app requesting the change.
	AdminPackageName string `json:"adminPackageName,omitempty"`
	// AdminUserId: User ID of the admin app from the which the change was
	// requested.
	AdminUserId int64 `json:"adminUserId,omitempty"`
	// BackupServiceState: Whether the backup service is enabled
	//
	// Possible values:
	//   "BACKUP_SERVICE_STATE_UNSPECIFIED" - No value is set
	//   "BACKUP_SERVICE_DISABLED" - Backup service is enabled
	//   "BACKUP_SERVICE_ENABLED" - Backup service is disabled
	BackupServiceState string `json:"backupServiceState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdminPackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminPackageName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupServiceToggledEvent) MarshalJSON() ([]byte, error) {
	type NoMethod BackupServiceToggledEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUsageLogEvents: Batched event logs of events from the device.
type BatchUsageLogEvents struct {
	// Device: If present, the name of the device in the form
	// ‘enterprises/{enterpriseId}/devices/{deviceId}’
	Device string `json:"device,omitempty"`
	// RetrievalTime: The device timestamp when the batch of events were collected
	// from the device.
	RetrievalTime string `json:"retrievalTime,omitempty"`
	// UsageLogEvents: The list of UsageLogEvent that were reported by the device,
	// sorted chronologically by the event time.
	UsageLogEvents []*UsageLogEvent `json:"usageLogEvents,omitempty"`
	// User: If present, the resource name of the user that owns this device in the
	// form ‘enterprises/{enterpriseId}/users/{userId}’.
	User string `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Device") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUsageLogEvents) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUsageLogEvents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlockAction: An action to block access to apps and data on a fully managed
// device or in a work profile. This action also triggers a device or work
// profile to displays a user-facing notification with information (where
// possible) on how to correct the compliance issue. Note: wipeAction must also
// be specified.
type BlockAction struct {
	// BlockAfterDays: Number of days the policy is non-compliant before the device
	// or work profile is blocked. To block access immediately, set to 0.
	// blockAfterDays must be less than wipeAfterDays.
	BlockAfterDays int64 `json:"blockAfterDays,omitempty"`
	// BlockScope: Specifies the scope of this BlockAction. Only applicable to
	// devices that are company-owned.
	//
	// Possible values:
	//   "BLOCK_SCOPE_UNSPECIFIED" - Unspecified. Defaults to
	// BLOCK_SCOPE_WORK_PROFILE.
	//   "BLOCK_SCOPE_WORK_PROFILE" - Block action is only applied to apps in the
	// work profile. Apps in the personal profile are unaffected.
	//   "BLOCK_SCOPE_DEVICE" - Block action is applied to the entire device,
	// including apps in the personal profile.
	BlockScope string `json:"blockScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockAfterDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockAfterDays") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlockAction) MarshalJSON() ([]byte, error) {
	type NoMethod BlockAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertAuthorityInstalledEvent: A new root certificate was installed into the
// system's trusted credential storage. This is available device-wide on fully
// managed devices and within the work profile on organization-owned devices
// with a work profile.
type CertAuthorityInstalledEvent struct {
	// Certificate: Subject of the certificate.
	Certificate string `json:"certificate,omitempty"`
	// Success: Whether the installation event succeeded.
	Success bool `json:"success,omitempty"`
	// UserId: The user in which the certificate install event happened. Only
	// available for devices running Android 11 and above.
	UserId int64 `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Certificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Certificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertAuthorityInstalledEvent) MarshalJSON() ([]byte, error) {
	type NoMethod CertAuthorityInstalledEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertAuthorityRemovedEvent: A root certificate was removed from the system's
// trusted credential storage. This is available device-wide on fully managed
// devices and within the work profile on organization-owned devices with a
// work profile.
type CertAuthorityRemovedEvent struct {
	// Certificate: Subject of the certificate.
	Certificate string `json:"certificate,omitempty"`
	// Success: Whether the removal succeeded.
	Success bool `json:"success,omitempty"`
	// UserId: The user in which the certificate removal event occurred. Only
	// available for devices running Android 11 and above.
	UserId int64 `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Certificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Certificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertAuthorityRemovedEvent) MarshalJSON() ([]byte, error) {
	type NoMethod CertAuthorityRemovedEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CertValidationFailureEvent: An X.509v3 certificate failed to validate,
// currently this validation is performed on the Wi-FI access point and failure
// may be due to a mismatch upon server certificate validation. However it may
// in the future include other validation events of an X.509v3 certificate.
type CertValidationFailureEvent struct {
	// FailureReason: The reason why certification validation failed.
	FailureReason string `json:"failureReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertValidationFailureEvent) MarshalJSON() ([]byte, error) {
	type NoMethod CertValidationFailureEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChoosePrivateKeyRule: Controls apps' access to private keys. The rule
// determines which private key, if any, Android Device Policy grants to the
// specified app. Access is granted either when the app calls
// KeyChain.choosePrivateKeyAlias
// (https://developer.android.com/reference/android/security/KeyChain#choosePrivateKeyAlias%28android.app.Activity,%20android.security.KeyChainAliasCallback,%20java.lang.String[],%20java.security.Principal[],%20java.lang.String,%20int,%20java.lang.String%29)
// (or any overloads) to request a private key alias for a given URL, or for
// rules that are not URL-specific (that is, if urlPattern is not set, or set
// to the empty string or .*) on Android 11 and above, directly so that the app
// can call KeyChain.getPrivateKey
// (https://developer.android.com/reference/android/security/KeyChain#getPrivateKey%28android.content.Context,%20java.lang.String%29),
// without first having to call KeyChain.choosePrivateKeyAlias.When an app
// calls KeyChain.choosePrivateKeyAlias if more than one choosePrivateKeyRules
// matches, the last matching rule defines which key alias to return.
type ChoosePrivateKeyRule struct {
	// PackageNames: The package names to which this rule applies. The signing key
	// certificate fingerprint of the app is verified against the signing key
	// certificate fingerprints provided by Play Store and
	// ApplicationPolicy.signingKeyCerts . If no package names are specified, then
	// the alias is provided to all apps that call KeyChain.choosePrivateKeyAlias
	// (https://developer.android.com/reference/android/security/KeyChain#choosePrivateKeyAlias%28android.app.Activity,%20android.security.KeyChainAliasCallback,%20java.lang.String[],%20java.security.Principal[],%20java.lang.String,%20int,%20java.lang.String%29)
	// or any overloads (but not without calling KeyChain.choosePrivateKeyAlias,
	// even on Android 11 and above). Any app with the same Android UID as a
	// package specified here will have access when they call
	// KeyChain.choosePrivateKeyAlias.
	PackageNames []string `json:"packageNames,omitempty"`
	// PrivateKeyAlias: The alias of the private key to be used.
	PrivateKeyAlias string `json:"privateKeyAlias,omitempty"`
	// UrlPattern: The URL pattern to match against the URL of the request. If not
	// set or empty, it matches all URLs. This uses the regular expression syntax
	// of java.util.regex.Pattern.
	UrlPattern string `json:"urlPattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChoosePrivateKeyRule) MarshalJSON() ([]byte, error) {
	type NoMethod ChoosePrivateKeyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClearAppsDataParams: Parameters associated with the CLEAR_APP_DATA command
// to clear the data of specified apps from the device.
type ClearAppsDataParams struct {
	// PackageNames: The package names of the apps whose data will be cleared when
	// the command is executed.
	PackageNames []string `json:"packageNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClearAppsDataParams) MarshalJSON() ([]byte, error) {
	type NoMethod ClearAppsDataParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClearAppsDataStatus: Status of the CLEAR_APP_DATA command to clear the data
// of specified apps from the device.
type ClearAppsDataStatus struct {
	// Results: The per-app results, a mapping from package names to the respective
	// clearing result.
	Results map[string]PerAppResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClearAppsDataStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ClearAppsDataStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Command: A command.
type Command struct {
	// AddEsimParams: Optional. Parameters for the ADD_ESIM command to add an eSIM
	// profile to the device. If this is set, then it is suggested that type should
	// not be set. In this case, the server automatically sets it to ADD_ESIM. It
	// is also acceptable to explicitly set type to ADD_ESIM.
	AddEsimParams *AddEsimParams `json:"addEsimParams,omitempty"`
	// ClearAppsDataParams: Parameters for the CLEAR_APP_DATA command to clear the
	// data of specified apps from the device. See ClearAppsDataParams. If this is
	// set, then it is suggested that type should not be set. In this case, the
	// server automatically sets it to CLEAR_APP_DATA. It is also acceptable to
	// explicitly set type to CLEAR_APP_DATA.
	ClearAppsDataParams *ClearAppsDataParams `json:"clearAppsDataParams,omitempty"`
	// ClearAppsDataStatus: Output only. Status of the CLEAR_APP_DATA command to
	// clear the data of specified apps from the device. See ClearAppsDataStatus.
	ClearAppsDataStatus *ClearAppsDataStatus `json:"clearAppsDataStatus,omitempty"`
	// CreateTime: The timestamp at which the command was created. The timestamp is
	// automatically generated by the server.
	CreateTime string `json:"createTime,omitempty"`
	// Duration: The duration for which the command is valid. The command will
	// expire if not executed by the device during this time. The default duration
	// if unspecified is ten minutes. There is no maximum duration.
	Duration string `json:"duration,omitempty"`
	// ErrorCode: If the command failed, an error code explaining the failure. This
	// is not set when the command is cancelled by the caller. For reasoning about
	// command errors, prefer fields in the following order (most preferred first):
	// 1. Command-specific fields like clearAppsDataStatus, startLostModeStatus, or
	// similar, if they exist. 2. This field, if set. 3. The generic error field in
	// the Operation that wraps the command.
	//
	// Possible values:
	//   "COMMAND_ERROR_CODE_UNSPECIFIED" - There was no error.
	//   "UNKNOWN" - An unknown error occurred.
	//   "API_LEVEL" - The API level of the device does not support this command.
	//   "MANAGEMENT_MODE" - The management mode (profile owner, device owner,
	// etc.) does not support the command.
	//   "INVALID_VALUE" - The command has an invalid parameter value.
	//   "UNSUPPORTED" - The device doesn't support the command. Updating Android
	// Device Policy to the latest version may resolve the issue.
	ErrorCode string `json:"errorCode,omitempty"`
	// EsimStatus: Output only. Status of an ADD_ESIM or REMOVE_ESIM command.
	EsimStatus *EsimCommandStatus `json:"esimStatus,omitempty"`
	// NewPassword: For commands of type RESET_PASSWORD, optionally specifies the
	// new password. Note: The new password must be at least 6 characters long if
	// it is numeric in case of Android 14 devices. Else the command will fail with
	// INVALID_VALUE.
	NewPassword string `json:"newPassword,omitempty"`
	// RemoveEsimParams: Optional. Parameters for the REMOVE_ESIM command to remove
	// an eSIM profile from the device. If this is set, then it is suggested that
	// type should not be set. In this case, the server automatically sets it to
	// REMOVE_ESIM. It is also acceptable to explicitly set type to REMOVE_ESIM.
	RemoveEsimParams *RemoveEsimParams `json:"removeEsimParams,omitempty"`
	// RequestDeviceInfoParams: Optional. Parameters for the REQUEST_DEVICE_INFO
	// command to get device related information. If this is set, then it is
	// suggested that type should not be set. In this case, the server
	// automatically sets it to REQUEST_DEVICE_INFO . It is also acceptable to
	// explicitly set type to REQUEST_DEVICE_INFO.
	RequestDeviceInfoParams *RequestDeviceInfoParams `json:"requestDeviceInfoParams,omitempty"`
	// RequestDeviceInfoStatus: Output only. Status of the REQUEST_DEVICE_INFO
	// command.
	RequestDeviceInfoStatus *RequestDeviceInfoStatus `json:"requestDeviceInfoStatus,omitempty"`
	// ResetPasswordFlags: For commands of type RESET_PASSWORD, optionally
	// specifies flags.
	//
	// Possible values:
	//   "RESET_PASSWORD_FLAG_UNSPECIFIED" - This value is ignored.
	//   "REQUIRE_ENTRY" - Don't allow other admins to change the password again
	// until the user has entered it.
	//   "DO_NOT_ASK_CREDENTIALS_ON_BOOT" - Don't ask for user credentials on
	// device boot.
	//   "LOCK_NOW" - Lock the device after password reset.
	ResetPasswordFlags []string `json:"resetPasswordFlags,omitempty"`
	// StartLostModeParams: Parameters for the START_LOST_MODE command to put the
	// device into lost mode. See StartLostModeParams. If this is set, then it is
	// suggested that type should not be set. In this case, the server
	// automatically sets it to START_LOST_MODE. It is also acceptable to
	// explicitly set type to START_LOST_MODE.
	StartLostModeParams *StartLostModeParams `json:"startLostModeParams,omitempty"`
	// StartLostModeStatus: Output only. Status of the START_LOST_MODE command to
	// put the device into lost mode. See StartLostModeStatus.
	StartLostModeStatus *StartLostModeStatus `json:"startLostModeStatus,omitempty"`
	// StopLostModeParams: Parameters for the STOP_LOST_MODE command to take the
	// device out of lost mode. See StopLostModeParams. If this is set, then it is
	// suggested that type should not be set. In this case, the server
	// automatically sets it to STOP_LOST_MODE. It is also acceptable to explicitly
	// set type to STOP_LOST_MODE.
	StopLostModeParams *StopLostModeParams `json:"stopLostModeParams,omitempty"`
	// StopLostModeStatus: Output only. Status of the STOP_LOST_MODE command to
	// take the device out of lost mode. See StopLostModeStatus.
	StopLostModeStatus *StopLostModeStatus `json:"stopLostModeStatus,omitempty"`
	// Type: The type of the command.
	//
	// Possible values:
	//   "COMMAND_TYPE_UNSPECIFIED" - This value is disallowed.
	//   "LOCK" - Lock the device, as if the lock screen timeout had expired. For a
	// work profile, if there is a separate work profile lock, this only locks the
	// work profile, with one exception: on work profiles on an organization-owned
	// device running Android 8, 9, or 10, this locks the entire device.
	//   "RESET_PASSWORD" - Reset the user's password.
	//   "REBOOT" - Reboot the device. Only supported on fully managed devices
	// running Android 7.0 (API level 24) or higher.
	//   "RELINQUISH_OWNERSHIP" - Removes the work profile and all policies from a
	// company-owned Android 8.0+ device, relinquishing the device for personal
	// use. Apps and data associated with the personal profile(s) are preserved.
	// The device will be deleted from the server after it acknowledges the
	// command.
	//   "CLEAR_APP_DATA" - Clears the application data of specified apps. This is
	// supported on Android 9 and above. Note that an application can store data
	// outside of its application data, for example in external storage or in a
	// user dictionary. See also clear_apps_data_params.
	//   "START_LOST_MODE" - Puts the device into lost mode. Only supported on
	// fully managed devices or organization-owned devices with a managed profile.
	// See also start_lost_mode_params.
	//   "STOP_LOST_MODE" - Takes the device out of lost mode. Only supported on
	// fully managed devices or organization-owned devices with a managed profile.
	// See also stop_lost_mode_params.
	//   "ADD_ESIM" - Adds an eSIM profile to the device. This is supported on
	// Android 15 and above. See also addEsimParams. To remove an eSIM profile, use
	// the REMOVE_ESIM command. To determine what happens to the eSIM profile when
	// a device is wiped, set wipeDataFlags in the policy. Note: To provision
	// multiple eSIMs on a single device, it is recommended to introduce a delay of
	// a few minutes between successive executions of the command.
	//   "REMOVE_ESIM" - Removes an eSIM profile from the device. This is supported
	// on Android 15 and above. See also removeEsimParams.
	//   "REQUEST_DEVICE_INFO" - Request information related to the device.
	//   "WIPE" - Wipes the device, via a factory reset for a company owned device,
	// or by deleting the work profile for a personally owned device with work
	// profile. The wipe only occurs once the device acknowledges the command. The
	// command can be cancelled before then.
	Type string `json:"type,omitempty"`
	// UserName: The resource name of the user that owns the device in the form
	// enterprises/{enterpriseId}/users/{userId}. This is automatically generated
	// by the server based on the device the command is sent to.
	UserName string `json:"userName,omitempty"`
	// WipeParams: Optional. Parameters for the WIPE command to wipe the device. If
	// this is set, then it is suggested that type should not be set. In this case,
	// the server automatically sets it to WIPE. It is also acceptable to
	// explicitly set type to WIPE.
	WipeParams *WipeParams `json:"wipeParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddEsimParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddEsimParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Command) MarshalJSON() ([]byte, error) {
	type NoMethod Command
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommonCriteriaModeInfo: Information about Common Criteria Mode—security
// standards defined in the Common Criteria for Information Technology Security
// Evaluation (https://www.commoncriteriaportal.org/) (CC).This information is
// only available if statusReportingSettings.commonCriteriaModeEnabled is true
// in the device's policy.
type CommonCriteriaModeInfo struct {
	// CommonCriteriaModeStatus: Whether Common Criteria Mode is enabled.
	//
	// Possible values:
	//   "COMMON_CRITERIA_MODE_STATUS_UNKNOWN" - Unknown status.
	//   "COMMON_CRITERIA_MODE_DISABLED" - Common Criteria Mode is currently
	// disabled.
	//   "COMMON_CRITERIA_MODE_ENABLED" - Common Criteria Mode is currently
	// enabled.
	CommonCriteriaModeStatus string `json:"commonCriteriaModeStatus,omitempty"`
	// PolicySignatureVerificationStatus: Output only. The status of policy
	// signature verification.
	//
	// Possible values:
	//   "POLICY_SIGNATURE_VERIFICATION_STATUS_UNSPECIFIED" - Unspecified. The
	// verification status has not been reported. This is set only if
	// statusReportingSettings.commonCriteriaModeEnabled is false.
	//   "POLICY_SIGNATURE_VERIFICATION_DISABLED" - Policy signature verification
	// is disabled on the device as common_criteria_mode is set to false.
	//   "POLICY_SIGNATURE_VERIFICATION_SUCCEEDED" - Policy signature verification
	// succeeded.
	//   "POLICY_SIGNATURE_VERIFICATION_NOT_SUPPORTED" - Policy signature
	// verification is not supported, e.g. because the device has been enrolled
	// with a CloudDPC version that does not support the policy signature
	// verification.
	//   "POLICY_SIGNATURE_VERIFICATION_FAILED" - The policy signature verification
	// failed. The policy has not been applied.
	PolicySignatureVerificationStatus string `json:"policySignatureVerificationStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonCriteriaModeStatus")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonCriteriaModeStatus") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommonCriteriaModeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CommonCriteriaModeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComplianceRule: A rule declaring which mitigating actions to take when a
// device is not compliant with its policy. For every rule, there is always an
// implicit mitigating action to set policy_compliant to false for the Device
// resource, and display a message on the device indicating that the device is
// not compliant with its policy. Other mitigating actions may optionally be
// taken as well, depending on the field values in the rule.
type ComplianceRule struct {
	// ApiLevelCondition: A condition which is satisfied if the Android Framework
	// API level on the device doesn't meet a minimum requirement.
	ApiLevelCondition *ApiLevelCondition `json:"apiLevelCondition,omitempty"`
	// DisableApps: If set to true, the rule includes a mitigating action to
	// disable apps so that the device is effectively disabled, but app data is
	// preserved. If the device is running an app in locked task mode, the app will
	// be closed and a UI showing the reason for non-compliance will be displayed.
	DisableApps bool `json:"disableApps,omitempty"`
	// NonComplianceDetailCondition: A condition which is satisfied if there exists
	// any matching NonComplianceDetail for the device.
	NonComplianceDetailCondition *NonComplianceDetailCondition `json:"nonComplianceDetailCondition,omitempty"`
	// PackageNamesToDisable: If set, the rule includes a mitigating action to
	// disable apps specified in the list, but app data is preserved.
	PackageNamesToDisable []string `json:"packageNamesToDisable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiLevelCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiLevelCondition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceRule) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectEvent: A TCP connect event was initiated through the standard network
// stack.
type ConnectEvent struct {
	// DestinationIpAddress: The destination IP address of the connect call.
	DestinationIpAddress string `json:"destinationIpAddress,omitempty"`
	// DestinationPort: The destination port of the connect call.
	DestinationPort int64 `json:"destinationPort,omitempty"`
	// PackageName: The package name of the UID that performed the connect call.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationIpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationIpAddress") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectEvent) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContactInfo: Contact details for managed Google Play enterprises.
type ContactInfo struct {
	// ContactEmail: Email address for a point of contact, which will be used to
	// send important announcements related to managed Google Play.
	ContactEmail string `json:"contactEmail,omitempty"`
	// DataProtectionOfficerEmail: The email of the data protection officer. The
	// email is validated but not verified.
	DataProtectionOfficerEmail string `json:"dataProtectionOfficerEmail,omitempty"`
	// DataProtectionOfficerName: The name of the data protection officer.
	DataProtectionOfficerName string `json:"dataProtectionOfficerName,omitempty"`
	// DataProtectionOfficerPhone: The phone number of the data protection officer
	// The phone number is validated but not verified.
	DataProtectionOfficerPhone string `json:"dataProtectionOfficerPhone,omitempty"`
	// EuRepresentativeEmail: The email of the EU representative. The email is
	// validated but not verified.
	EuRepresentativeEmail string `json:"euRepresentativeEmail,omitempty"`
	// EuRepresentativeName: The name of the EU representative.
	EuRepresentativeName string `json:"euRepresentativeName,omitempty"`
	// EuRepresentativePhone: The phone number of the EU representative. The phone
	// number is validated but not verified.
	EuRepresentativePhone string `json:"euRepresentativePhone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContactEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContactEmail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContactInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ContactInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContentProviderEndpoint: This feature is not generally available.
type ContentProviderEndpoint struct {
	// PackageName: This feature is not generally available.
	PackageName string `json:"packageName,omitempty"`
	// SigningCertsSha256: Required. This feature is not generally available.
	SigningCertsSha256 []string `json:"signingCertsSha256,omitempty"`
	// Uri: This feature is not generally available.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContentProviderEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod ContentProviderEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CrossProfilePolicies: Controls the data from the work profile that can be
// accessed from the personal profile and vice versa. A NonComplianceDetail
// with MANAGEMENT_MODE is reported if the device does not have a work profile.
type CrossProfilePolicies struct {
	// CrossProfileAppFunctions: Optional. Controls whether personal profile apps
	// can invoke app functions exposed by apps in the work profile.
	//
	// Possible values:
	//   "CROSS_PROFILE_APP_FUNCTIONS_UNSPECIFIED" - Unspecified. If appFunctions
	// is set to APP_FUNCTIONS_ALLOWED, defaults to
	// CROSS_PROFILE_APP_FUNCTIONS_ALLOWED. If appFunctions is set to
	// APP_FUNCTIONS_DISALLOWED, defaults to
	// CROSS_PROFILE_APP_FUNCTIONS_DISALLOWED.
	//   "CROSS_PROFILE_APP_FUNCTIONS_DISALLOWED" - Personal profile apps are not
	// allowed to invoke app functions exposed by apps in the work profile.
	//   "CROSS_PROFILE_APP_FUNCTIONS_ALLOWED" - Personal profile apps can invoke
	// app functions exposed by apps in the work profile. If this is set,
	// appFunctions must not be set to APP_FUNCTIONS_DISALLOWED, otherwise the
	// policy will be rejected.
	CrossProfileAppFunctions string `json:"crossProfileAppFunctions,omitempty"`
	// CrossProfileCopyPaste: Whether text copied from one profile (personal or
	// work) can be pasted in the other profile.
	//
	// Possible values:
	//   "CROSS_PROFILE_COPY_PASTE_UNSPECIFIED" - Unspecified. Defaults to
	// COPY_FROM_WORK_TO_PERSONAL_DISALLOWED
	//   "COPY_FROM_WORK_TO_PERSONAL_DISALLOWED" - Default. Prevents users from
	// pasting into the personal profile text copied from the work profile. Text
	// copied from the personal profile can be pasted into the work profile, and
	// text copied from the work profile can be pasted into the work profile.
	//   "CROSS_PROFILE_COPY_PASTE_ALLOWED" - Text copied in either profile can be
	// pasted in the other profile.
	CrossProfileCopyPaste string `json:"crossProfileCopyPaste,omitempty"`
	// CrossProfileDataSharing: Whether data from one profile (personal or work)
	// can be shared with apps in the other profile. Specifically controls simple
	// data sharing via intents. Management of other cross-profile communication
	// channels, such as contact search, copy/paste, or connected work & personal
	// apps, are configured separately.
	//
	// Possible values:
	//   "CROSS_PROFILE_DATA_SHARING_UNSPECIFIED" - Unspecified. Defaults to
	// DATA_SHARING_FROM_WORK_TO_PERSONAL_DISALLOWED.
	//   "CROSS_PROFILE_DATA_SHARING_DISALLOWED" - Prevents data from being shared
	// from both the personal profile to the work profile and the work profile to
	// the personal profile.
	//   "DATA_SHARING_FROM_WORK_TO_PERSONAL_DISALLOWED" - Default. Prevents users
	// from sharing data from the work profile to apps in the personal profile.
	// Personal data can be shared with work apps.
	//   "CROSS_PROFILE_DATA_SHARING_ALLOWED" - Data from either profile can be
	// shared with the other profile.
	CrossProfileDataSharing string `json:"crossProfileDataSharing,omitempty"`
	// ExemptionsToShowWorkContactsInPersonalProfile: List of apps which are
	// excluded from the ShowWorkContactsInPersonalProfile setting. For this to be
	// set, ShowWorkContactsInPersonalProfile must be set to one of the following
	// values: SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_ALLOWED. In this case, these
	// exemptions act as a blocklist.
	// SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_DISALLOWED. In this case, these
	// exemptions act as an allowlist.
	// SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_DISALLOWED_EXCEPT_SYSTEM. In this
	// case, these exemptions act as an allowlist, in addition to the already
	// allowlisted system apps.Supported on Android 14 and above. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 14.
	ExemptionsToShowWorkContactsInPersonalProfile *PackageNameList `json:"exemptionsToShowWorkContactsInPersonalProfile,omitempty"`
	// ShowWorkContactsInPersonalProfile: Whether personal apps can access contacts
	// stored in the work profile.See also
	// exemptions_to_show_work_contacts_in_personal_profile.
	//
	// Possible values:
	//   "SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_UNSPECIFIED" - Unspecified.
	// Defaults to SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_ALLOWED.When this is set,
	// exemptions_to_show_work_contacts_in_personal_profile must not be set.
	//   "SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_DISALLOWED" - Prevents personal
	// apps from accessing work profile contacts and looking up work contacts.When
	// this is set, personal apps specified in
	// exemptions_to_show_work_contacts_in_personal_profile are allowlisted and can
	// access work profile contacts directly.Supported on Android 7.0 and above. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 7.0.
	//   "SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_ALLOWED" - Default. Allows apps in
	// the personal profile to access work profile contacts including contact
	// searches and incoming calls.When this is set, personal apps specified in
	// exemptions_to_show_work_contacts_in_personal_profile are blocklisted and can
	// not access work profile contacts directly.Supported on Android 7.0 and
	// above. A NonComplianceDetail with API_LEVEL is reported if the Android
	// version is less than 7.0.
	//   "SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_DISALLOWED_EXCEPT_SYSTEM" -
	// Prevents most personal apps from accessing work profile contacts including
	// contact searches and incoming calls, except for the OEM default Dialer,
	// Messages, and Contacts apps. Neither user-configured Dialer, Messages, and
	// Contacts apps, nor any other system or play installed apps, will be able to
	// query work contacts directly.When this is set, personal apps specified in
	// exemptions_to_show_work_contacts_in_personal_profile are allowlisted and can
	// access work profile contacts.Supported on Android 14 and above. If this is
	// set on a device with Android version less than 14, the behaviour falls back
	// to SHOW_WORK_CONTACTS_IN_PERSONAL_PROFILE_DISALLOWED and a
	// NonComplianceDetail with API_LEVEL is reported.
	ShowWorkContactsInPersonalProfile string `json:"showWorkContactsInPersonalProfile,omitempty"`
	// WorkProfileWidgetsDefault: Specifies the default behaviour for work profile
	// widgets. If the policy does not specify work_profile_widgets for a specific
	// application, it will behave according to the value specified here.
	//
	// Possible values:
	//   "WORK_PROFILE_WIDGETS_DEFAULT_UNSPECIFIED" - Unspecified. Defaults to
	// WORK_PROFILE_WIDGETS_DEFAULT_DISALLOWED.
	//   "WORK_PROFILE_WIDGETS_DEFAULT_ALLOWED" - Work profile widgets are allowed
	// by default. This means that if the policy does not specify
	// work_profile_widgets as WORK_PROFILE_WIDGETS_DISALLOWED for the application,
	// it will be able to add widgets to the home screen.
	//   "WORK_PROFILE_WIDGETS_DEFAULT_DISALLOWED" - Work profile widgets are
	// disallowed by default. This means that if the policy does not specify
	// work_profile_widgets as WORK_PROFILE_WIDGETS_ALLOWED for the application, it
	// will be unable to add widgets to the home screen.
	WorkProfileWidgetsDefault string `json:"workProfileWidgetsDefault,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrossProfileAppFunctions")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrossProfileAppFunctions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CrossProfilePolicies) MarshalJSON() ([]byte, error) {
	type NoMethod CrossProfilePolicies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CryptoSelfTestCompletedEvent: Validates whether Android’s built-in
// cryptographic library (BoringSSL) is valid. Should always succeed on device
// boot, if it fails, the device should be considered untrusted.
type CryptoSelfTestCompletedEvent struct {
	// Success: Whether the test succeeded.
	Success bool `json:"success,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Success") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Success") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CryptoSelfTestCompletedEvent) MarshalJSON() ([]byte, error) {
	type NoMethod CryptoSelfTestCompletedEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomAppConfig: Configuration for a custom app.
type CustomAppConfig struct {
	// UserUninstallSettings: Optional. User uninstall settings of the custom app.
	//
	// Possible values:
	//   "USER_UNINSTALL_SETTINGS_UNSPECIFIED" - Unspecified. Defaults to
	// DISALLOW_UNINSTALL_BY_USER.
	//   "DISALLOW_UNINSTALL_BY_USER" - User is not allowed to uninstall the custom
	// app.
	//   "ALLOW_UNINSTALL_BY_USER" - User is allowed to uninstall the custom app.
	UserUninstallSettings string `json:"userUninstallSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserUninstallSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserUninstallSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAppConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: A full date, with non-zero year, month, and
// day values. A month and day, with a zero year (for example, an anniversary).
// A year on its own, with a zero month and a zero day. A year and month, with
// a zero day (for example, a credit card expiration date).Related types:
// google.type.TimeOfDay google.type.DateTime google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultApplication: Information about the application to be set as the
// default.
type DefaultApplication struct {
	// PackageName: Required. The package name that should be set as the default
	// application. The policy is rejected if the package name is invalid.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultApplication) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultApplicationContext: Additional context for non-compliance related to
// default application settings.
type DefaultApplicationContext struct {
	// DefaultApplicationScope: Output only. The scope of non-compliant default
	// application setting.
	//
	// Possible values:
	//   "DEFAULT_APPLICATION_SCOPE_UNSPECIFIED" - Unspecified. This value must not
	// be used.
	//   "SCOPE_FULLY_MANAGED" - Sets the application as the default on fully
	// managed devices.
	//   "SCOPE_WORK_PROFILE" - Sets the application as the work profile
	// default.Only supported for DEFAULT_BROWSER, DEFAULT_CALL_REDIRECTION,
	// DEFAULT_CALL_SCREENING, DEFAULT_DIALER and DEFAULT_WALLET.
	//   "SCOPE_PERSONAL_PROFILE" - Sets the application as the personal profile
	// default on company-owned devices with a work profile. Only pre-installed
	// system apps can be set as the default.Only supported for DEFAULT_BROWSER,
	// DEFAULT_DIALER, DEFAULT_SMS and DEFAULT_WALLET.
	DefaultApplicationScope string `json:"defaultApplicationScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultApplicationScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultApplicationScope") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultApplicationContext) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultApplicationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultApplicationInfo: The default application information for a specific
// DefaultApplicationType.
type DefaultApplicationInfo struct {
	// DefaultApplicationSettingAttempts: Output only. Details on the default
	// application setting attempts, in the same order as listed in
	// defaultApplications.
	DefaultApplicationSettingAttempts []*DefaultApplicationSettingAttempt `json:"defaultApplicationSettingAttempts,omitempty"`
	// DefaultApplicationType: Output only. The default application type.
	//
	// Possible values:
	//   "DEFAULT_APPLICATION_TYPE_UNSPECIFIED" - Unspecified. This value must not
	// be used.
	//   "DEFAULT_ASSISTANT" - The assistant app type. This app type is only
	// allowed to be set for SCOPE_FULLY_MANAGED.Supported on fully managed devices
	// on Android 16 and above. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for other management modes. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 16.
	//   "DEFAULT_BROWSER" - The browser app type.Supported on Android 16 and
	// above. A NonComplianceDetail with API_LEVEL is reported if the Android
	// version is less than 16.
	//   "DEFAULT_CALL_REDIRECTION" - The call redirection app type. This app type
	// cannot be set for SCOPE_PERSONAL_PROFILE.Supported on Android 16 and above.
	// A NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	//   "DEFAULT_CALL_SCREENING" - The call screening app type. This app type
	// cannot be set for SCOPE_PERSONAL_PROFILE.Supported on Android 16 and above.
	// A NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	//   "DEFAULT_DIALER" - The dialer app type.Supported on fully managed devices
	// on Android 14 and 15. A NonComplianceDetail with MANAGEMENT_MODE is reported
	// for other management modes. A NonComplianceDetail with API_LEVEL is reported
	// if the Android version is less than 14.Supported on all management modes on
	// Android 16 and above.
	//   "DEFAULT_HOME" - The home app type. This app type is only allowed to be
	// set for SCOPE_FULLY_MANAGED.Supported on fully managed devices on Android 16
	// and above. A NonComplianceDetail with MANAGEMENT_MODE is reported for other
	// management modes. A NonComplianceDetail with API_LEVEL is reported if the
	// Android version is less than 16.
	//   "DEFAULT_SMS" - The SMS app type. This app type cannot be set for
	// SCOPE_WORK_PROFILE.Supported on company-owned devices on Android 16 and
	// above. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// personally-owned devices. A NonComplianceDetail with API_LEVEL is reported
	// if the Android version is less than 16.
	//   "DEFAULT_WALLET" - The wallet app type. The default application of this
	// type applies across profiles.On a company-owned device with a work profile,
	// admins can set the scope to SCOPE_PERSONAL_PROFILE to set a personal profile
	// pre-installed system app as the default, or to SCOPE_WORK_PROFILE to set a
	// work profile app as the default. It is not allowed to specify both scopes at
	// the same time.Due to a known issue, the user may be able to change the
	// default wallet even when this is set on a fully managed device.Supported on
	// company-owned devices on Android 16 and above. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for personally-owned devices. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	DefaultApplicationType string `json:"defaultApplicationType,omitempty"`
	// PackageName: Output only. The package name of the current default
	// application.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DefaultApplicationSettingAttempts") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "DefaultApplicationSettingAttempts") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s DefaultApplicationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultApplicationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultApplicationSetting: The default application setting for a
// DefaultApplicationType.
type DefaultApplicationSetting struct {
	// DefaultApplicationScopes: Required. The scopes to which the policy should be
	// applied. This list must not be empty or contain duplicates.A
	// NonComplianceDetail with MANAGEMENT_MODE reason and
	// DEFAULT_APPLICATION_SETTING_UNSUPPORTED_SCOPES specific reason is reported
	// if none of the specified scopes can be applied to the management mode (e.g.
	// a fully managed device receives a policy with only SCOPE_PERSONAL_PROFILE in
	// the list).
	//
	// Possible values:
	//   "DEFAULT_APPLICATION_SCOPE_UNSPECIFIED" - Unspecified. This value must not
	// be used.
	//   "SCOPE_FULLY_MANAGED" - Sets the application as the default on fully
	// managed devices.
	//   "SCOPE_WORK_PROFILE" - Sets the application as the work profile
	// default.Only supported for DEFAULT_BROWSER, DEFAULT_CALL_REDIRECTION,
	// DEFAULT_CALL_SCREENING, DEFAULT_DIALER and DEFAULT_WALLET.
	//   "SCOPE_PERSONAL_PROFILE" - Sets the application as the personal profile
	// default on company-owned devices with a work profile. Only pre-installed
	// system apps can be set as the default.Only supported for DEFAULT_BROWSER,
	// DEFAULT_DIALER, DEFAULT_SMS and DEFAULT_WALLET.
	DefaultApplicationScopes []string `json:"defaultApplicationScopes,omitempty"`
	// DefaultApplicationType: Required. The app type to set the default
	// application.
	//
	// Possible values:
	//   "DEFAULT_APPLICATION_TYPE_UNSPECIFIED" - Unspecified. This value must not
	// be used.
	//   "DEFAULT_ASSISTANT" - The assistant app type. This app type is only
	// allowed to be set for SCOPE_FULLY_MANAGED.Supported on fully managed devices
	// on Android 16 and above. A NonComplianceDetail with MANAGEMENT_MODE is
	// reported for other management modes. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 16.
	//   "DEFAULT_BROWSER" - The browser app type.Supported on Android 16 and
	// above. A NonComplianceDetail with API_LEVEL is reported if the Android
	// version is less than 16.
	//   "DEFAULT_CALL_REDIRECTION" - The call redirection app type. This app type
	// cannot be set for SCOPE_PERSONAL_PROFILE.Supported on Android 16 and above.
	// A NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	//   "DEFAULT_CALL_SCREENING" - The call screening app type. This app type
	// cannot be set for SCOPE_PERSONAL_PROFILE.Supported on Android 16 and above.
	// A NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	//   "DEFAULT_DIALER" - The dialer app type.Supported on fully managed devices
	// on Android 14 and 15. A NonComplianceDetail with MANAGEMENT_MODE is reported
	// for other management modes. A NonComplianceDetail with API_LEVEL is reported
	// if the Android version is less than 14.Supported on all management modes on
	// Android 16 and above.
	//   "DEFAULT_HOME" - The home app type. This app type is only allowed to be
	// set for SCOPE_FULLY_MANAGED.Supported on fully managed devices on Android 16
	// and above. A NonComplianceDetail with MANAGEMENT_MODE is reported for other
	// management modes. A NonComplianceDetail with API_LEVEL is reported if the
	// Android version is less than 16.
	//   "DEFAULT_SMS" - The SMS app type. This app type cannot be set for
	// SCOPE_WORK_PROFILE.Supported on company-owned devices on Android 16 and
	// above. A NonComplianceDetail with MANAGEMENT_MODE is reported for
	// personally-owned devices. A NonComplianceDetail with API_LEVEL is reported
	// if the Android version is less than 16.
	//   "DEFAULT_WALLET" - The wallet app type. The default application of this
	// type applies across profiles.On a company-owned device with a work profile,
	// admins can set the scope to SCOPE_PERSONAL_PROFILE to set a personal profile
	// pre-installed system app as the default, or to SCOPE_WORK_PROFILE to set a
	// work profile app as the default. It is not allowed to specify both scopes at
	// the same time.Due to a known issue, the user may be able to change the
	// default wallet even when this is set on a fully managed device.Supported on
	// company-owned devices on Android 16 and above. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for personally-owned devices. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 16.
	DefaultApplicationType string `json:"defaultApplicationType,omitempty"`
	// DefaultApplications: Required. The list of applications that can be set as
	// the default app for a given type. This list must not be empty or contain
	// duplicates. The first app in the list that is installed and qualified for
	// the defaultApplicationType (e.g. SMS app for DEFAULT_SMS) is set as the
	// default app. The signing key certificate fingerprint of the app on the
	// device must also match one of the signing key certificate fingerprints
	// obtained from Play Store or one of the entries in
	// ApplicationPolicy.signingKeyCerts in order to be set as the default.If the
	// defaultApplicationScopes contains SCOPE_FULLY_MANAGED or SCOPE_WORK_PROFILE,
	// the app must have an entry in applications with installType set to a value
	// other than BLOCKED.A NonComplianceDetail with APP_NOT_INSTALLED reason and
	// DEFAULT_APPLICATION_SETTING_FAILED_FOR_SCOPE specific reason is reported if
	// none of the apps in the list are installed. A NonComplianceDetail with
	// INVALID_VALUE reason and DEFAULT_APPLICATION_SETTING_FAILED_FOR_SCOPE
	// specific reason is reported if at least one app is installed but the policy
	// fails to apply due to other reasons (e.g. the app is not of the right
	// type).When applying to SCOPE_PERSONAL_PROFILE on a company-owned device with
	// a work profile, only pre-installed system apps can be set as the default. A
	// NonComplianceDetail with INVALID_VALUE reason and
	// DEFAULT_APPLICATION_SETTING_FAILED_FOR_SCOPE specific reason is reported if
	// the policy fails to apply to the personal profile.
	DefaultApplications []*DefaultApplication `json:"defaultApplications,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultApplicationScopes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultApplicationScopes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultApplicationSetting) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultApplicationSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultApplicationSettingAttempt: Details on a default application setting
// attempt.
type DefaultApplicationSettingAttempt struct {
	// AttemptOutcome: Output only. The outcome of setting the app as the default.
	//
	// Possible values:
	//   "ATTEMPT_OUTCOME_UNSPECIFIED" - Attempt outcome is unspecified. This is
	// not used.
	//   "SUCCESS" - App is successfully set as the default.
	//   "APP_NOT_INSTALLED" - Attempt failed as the app is not installed.
	//   "APP_SIGNING_CERT_MISMATCH" - Attempt failed as the signing key
	// certificate fingerprint of the app from Play Store or from
	// ApplicationPolicy.signingKeyCerts does not match the one on the device.
	//   "OTHER_FAILURE" - Attempt failed due to other reasons.
	AttemptOutcome string `json:"attemptOutcome,omitempty"`
	// PackageName: Output only. The package name of the attempted application.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttemptOutcome") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttemptOutcome") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultApplicationSettingAttempt) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultApplicationSettingAttempt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Device: A device owned by an enterprise. Unless otherwise noted, all fields
// are read-only and can't be modified by enterprises.devices.patch.
type Device struct {
	// ApiLevel: The API level of the Android platform version running on the
	// device.
	ApiLevel int64 `json:"apiLevel,omitempty"`
	// ApplicationReports: Reports for apps installed on the device. This
	// information is only available when application_reports_enabled is true in
	// the device's policy.
	ApplicationReports []*ApplicationReport `json:"applicationReports,omitempty"`
	// AppliedPasswordPolicies: The password requirements currently applied to the
	// device. This field exists because the applied requirements may be slightly
	// different from those specified in passwordPolicies in some cases. Note that
	// this field does not provide information about password compliance. For
	// non-compliance information, see nonComplianceDetails.
	// NonComplianceDetail.fieldPath, is set based on passwordPolicies, not based
	// on this field.
	AppliedPasswordPolicies []*PasswordRequirements `json:"appliedPasswordPolicies,omitempty"`
	// AppliedPolicyName: The name of the policy currently applied to the device.
	AppliedPolicyName string `json:"appliedPolicyName,omitempty"`
	// AppliedPolicyVersion: The version of the policy currently applied to the
	// device.
	AppliedPolicyVersion int64 `json:"appliedPolicyVersion,omitempty,string"`
	// AppliedState: The state currently applied to the device.
	//
	// Possible values:
	//   "DEVICE_STATE_UNSPECIFIED" - This value is disallowed.
	//   "ACTIVE" - The device is active.
	//   "DISABLED" - The device is disabled.
	//   "DELETED" - The device was deleted. This state is never returned by an API
	// call, but is used in the final status report when the device acknowledges
	// the deletion. If the device is deleted via the API call, this state is
	// published to Pub/Sub. If the user deletes the work profile or resets the
	// device, the device state will remain unknown to the server.
	//   "PROVISIONING" - The device is being provisioned. Newly enrolled devices
	// are in this state until they have a policy applied.
	//   "LOST" - The device is lost. This state is only possible on
	// organization-owned devices.
	//   "PREPARING_FOR_MIGRATION" - The device is preparing for migrating to
	// Android Management API. No further action is needed for the migration to
	// continue.
	//   "DEACTIVATED_BY_DEVICE_FINANCE" - This is a financed device that has been
	// "locked" by the financing agent. This means certain policy settings have
	// been applied which limit device functionality until the device has been
	// "unlocked" by the financing agent. The device will continue to apply policy
	// settings excluding those overridden by the financing agent. When the device
	// is "locked", the state is reported in appliedState as
	// DEACTIVATED_BY_DEVICE_FINANCE.
	AppliedState string `json:"appliedState,omitempty"`
	// CommonCriteriaModeInfo: Information about Common Criteria Mode—security
	// standards defined in the Common Criteria for Information Technology Security
	// Evaluation (https://www.commoncriteriaportal.org/) (CC).This information is
	// only available if statusReportingSettings.commonCriteriaModeEnabled is true
	// in the device's policy the device is company-owned.
	CommonCriteriaModeInfo *CommonCriteriaModeInfo `json:"commonCriteriaModeInfo,omitempty"`
	// DefaultApplicationInfo: Output only. The default application information for
	// the DefaultApplicationType. This information is only available if
	// defaultApplicationInfoReportingEnabled is true in the device's policy.
	// Available on Android 16 and above.All app types are reported on fully
	// managed devices. DEFAULT_BROWSER, DEFAULT_CALL_REDIRECTION,
	// DEFAULT_CALL_SCREENING and DEFAULT_DIALER types are reported for the work
	// profiles on company-owned devices with a work profile and personally-owned
	// devices. DEFAULT_WALLET is also reported for company-owned devices with a
	// work profile, but will only include work profile information.
	DefaultApplicationInfo []*DefaultApplicationInfo `json:"defaultApplicationInfo,omitempty"`
	// DeviceSettings: Device settings information. This information is only
	// available if deviceSettingsEnabled is true in the device's policy.
	DeviceSettings *DeviceSettings `json:"deviceSettings,omitempty"`
	// DisabledReason: If the device state is DISABLED, an optional message that is
	// displayed on the device indicating the reason the device is disabled. This
	// field can be modified by a patch request.
	DisabledReason *UserFacingMessage `json:"disabledReason,omitempty"`
	// Displays: Detailed information about displays on the device. This
	// information is only available if displayInfoEnabled is true in the device's
	// policy.
	Displays []*Display `json:"displays,omitempty"`
	// DpcMigrationInfo: Output only. Information related to whether this device
	// was migrated from being managed by another Device Policy Controller (DPC).
	DpcMigrationInfo *DpcMigrationInfo `json:"dpcMigrationInfo,omitempty"`
	// EnrollmentTime: The time of device enrollment.
	EnrollmentTime string `json:"enrollmentTime,omitempty"`
	// EnrollmentTokenData: If the device was enrolled with an enrollment token
	// with additional data provided, this field contains that data.
	EnrollmentTokenData string `json:"enrollmentTokenData,omitempty"`
	// EnrollmentTokenName: If the device was enrolled with an enrollment token,
	// this field contains the name of the token.
	EnrollmentTokenName string `json:"enrollmentTokenName,omitempty"`
	// HardwareInfo: Detailed information about the device hardware.
	HardwareInfo *HardwareInfo `json:"hardwareInfo,omitempty"`
	// HardwareStatusSamples: Hardware status samples in chronological order. This
	// information is only available if hardwareStatusEnabled is true in the
	// device's policy.
	HardwareStatusSamples []*HardwareStatus `json:"hardwareStatusSamples,omitempty"`
	// LastPolicyComplianceReportTime: Deprecated.
	LastPolicyComplianceReportTime string `json:"lastPolicyComplianceReportTime,omitempty"`
	// LastPolicySyncTime: The last time the device fetched its policy.
	LastPolicySyncTime string `json:"lastPolicySyncTime,omitempty"`
	// LastStatusReportTime: The last time the device sent a status report.
	LastStatusReportTime string `json:"lastStatusReportTime,omitempty"`
	// ManagementMode: The type of management mode Android Device Policy takes on
	// the device. This influences which policy settings are supported.
	//
	// Possible values:
	//   "MANAGEMENT_MODE_UNSPECIFIED" - This value is disallowed.
	//   "DEVICE_OWNER" - Device owner. Android Device Policy has full control over
	// the device.
	//   "PROFILE_OWNER" - Profile owner. Android Device Policy has control over a
	// managed profile on the device.
	ManagementMode string `json:"managementMode,omitempty"`
	// MemoryEvents: Events related to memory and storage measurements in
	// chronological order. This information is only available if memoryInfoEnabled
	// is true in the device's policy.Events are retained for a certain period of
	// time and old events are deleted.
	MemoryEvents []*MemoryEvent `json:"memoryEvents,omitempty"`
	// MemoryInfo: Memory information: contains information about device memory and
	// storage.
	MemoryInfo *MemoryInfo `json:"memoryInfo,omitempty"`
	// Name: The name of the device in the form
	// enterprises/{enterpriseId}/devices/{deviceId}.
	Name string `json:"name,omitempty"`
	// NetworkInfo: Device network information. This information is only available
	// if networkInfoEnabled is true in the device's policy.
	NetworkInfo *NetworkInfo `json:"networkInfo,omitempty"`
	// NonComplianceDetails: Details about policy settings that the device is not
	// compliant with.
	NonComplianceDetails []*NonComplianceDetail `json:"nonComplianceDetails,omitempty"`
	// Ownership: Ownership of the managed device.
	//
	// Possible values:
	//   "OWNERSHIP_UNSPECIFIED" - Ownership is unspecified.
	//   "COMPANY_OWNED" - Device is company-owned.
	//   "PERSONALLY_OWNED" - Device is personally-owned.
	Ownership string `json:"ownership,omitempty"`
	// PolicyCompliant: Whether the device is compliant with its policy.
	PolicyCompliant bool `json:"policyCompliant,omitempty"`
	// PolicyName: The name of the policy applied to the device, in the form
	// enterprises/{enterpriseId}/policies/{policyId}. If not specified, the
	// policy_name for the device's user is applied. This field can be modified by
	// a patch request. You can specify only the policyId when calling
	// enterprises.devices.patch, as long as the policyId doesn’t contain any
	// slashes. The rest of the policy name is inferred.
	PolicyName string `json:"policyName,omitempty"`
	// PowerManagementEvents: Power management events on the device in
	// chronological order. This information is only available if
	// powerManagementEventsEnabled is true in the device's policy.
	PowerManagementEvents []*PowerManagementEvent `json:"powerManagementEvents,omitempty"`
	// PreviousDeviceNames: If the same physical device has been enrolled multiple
	// times, this field contains its previous device names. The serial number is
	// used as the unique identifier to determine if the same physical device has
	// enrolled previously. The names are in chronological order.
	PreviousDeviceNames []string `json:"previousDeviceNames,omitempty"`
	// SecurityPosture: Device's security posture value that reflects how secure
	// the device is.
	SecurityPosture *SecurityPosture `json:"securityPosture,omitempty"`
	// SoftwareInfo: Detailed information about the device software. This
	// information is only available if softwareInfoEnabled is true in the device's
	// policy.
	SoftwareInfo *SoftwareInfo `json:"softwareInfo,omitempty"`
	// State: The state to be applied to the device. This field can be modified by
	// a patch request. Note that when calling enterprises.devices.patch, ACTIVE
	// and DISABLED are the only allowable values. To enter the device into a
	// DELETED state, call enterprises.devices.delete.
	//
	// Possible values:
	//   "DEVICE_STATE_UNSPECIFIED" - This value is disallowed.
	//   "ACTIVE" - The device is active.
	//   "DISABLED" - The device is disabled.
	//   "DELETED" - The device was deleted. This state is never returned by an API
	// call, but is used in the final status report when the device acknowledges
	// the deletion. If the device is deleted via the API call, this state is
	// published to Pub/Sub. If the user deletes the work profile or resets the
	// device, the device state will remain unknown to the server.
	//   "PROVISIONING" - The device is being provisioned. Newly enrolled devices
	// are in this state until they have a policy applied.
	//   "LOST" - The device is lost. This state is only possible on
	// organization-owned devices.
	//   "PREPARING_FOR_MIGRATION" - The device is preparing for migrating to
	// Android Management API. No further action is needed for the migration to
	// continue.
	//   "DEACTIVATED_BY_DEVICE_FINANCE" - This is a financed device that has been
	// "locked" by the financing agent. This means certain policy settings have
	// been applied which limit device functionality until the device has been
	// "unlocked" by the financing agent. The device will continue to apply policy
	// settings excluding those overridden by the financing agent. When the device
	// is "locked", the state is reported in appliedState as
	// DEACTIVATED_BY_DEVICE_FINANCE.
	State string `json:"state,omitempty"`
	// SystemProperties: Map of selected system properties name and value related
	// to the device. This information is only available if systemPropertiesEnabled
	// is true in the device's policy.
	SystemProperties map[string]string `json:"systemProperties,omitempty"`
	// User: The user who owns the device.
	User *User `json:"user,omitempty"`
	// UserName: The resource name of the user that owns this device in the form
	// enterprises/{enterpriseId}/users/{userId}.
	UserName string `json:"userName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Device) MarshalJSON() ([]byte, error) {
	type NoMethod Device
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeviceConnectivityManagement: Covers controls for device connectivity such
// as Wi-Fi, USB data access, keyboard/mouse connections, and more.
type DeviceConnectivityManagement struct {
	// ApnPolicy: Optional. Access Point Name (APN) policy. Configuration for
	// Access Point Names (APNs) which may override any other APNs on the device.
	// See OVERRIDE_APNS_ENABLED and overrideApns for details.
	ApnPolicy *ApnPolicy `json:"apnPolicy,omitempty"`
	// BluetoothSharing: Optional. Controls whether Bluetooth sharing is allowed.
	//
	// Possible values:
	//   "BLUETOOTH_SHARING_UNSPECIFIED" - Unspecified. Defaults to
	// BLUETOOTH_SHARING_DISALLOWED on work profiles and BLUETOOTH_SHARING_ALLOWED
	// on fully managed devices.
	//   "BLUETOOTH_SHARING_ALLOWED" - Bluetooth sharing is allowed.Supported on
	// Android 8 and above. A NonComplianceDetail with API_LEVEL is reported on
	// work profiles if the Android version is less than 8.
	//   "BLUETOOTH_SHARING_DISALLOWED" - Bluetooth sharing is disallowed.Supported
	// on Android 8 and above. A NonComplianceDetail with API_LEVEL is reported on
	// fully managed devices if the Android version is less than 8.
	BluetoothSharing string `json:"bluetoothSharing,omitempty"`
	// ConfigureWifi: Controls Wi-Fi configuring privileges. Based on the option
	// set, user will have either full or limited or no control in configuring
	// Wi-Fi networks.
	//
	// Possible values:
	//   "CONFIGURE_WIFI_UNSPECIFIED" - Unspecified. Defaults to
	// ALLOW_CONFIGURING_WIFI unless wifiConfigDisabled is set to true. If
	// wifiConfigDisabled is set to true, this is equivalent to
	// DISALLOW_CONFIGURING_WIFI.
	//   "ALLOW_CONFIGURING_WIFI" - The user is allowed to configure Wi-Fi.
	// wifiConfigDisabled is ignored.
	//   "DISALLOW_ADD_WIFI_CONFIG" - Adding new Wi-Fi configurations is
	// disallowed. The user is only able to switch between already configured
	// networks. Supported on Android 13 and above, on fully managed devices and
	// work profiles on company-owned devices. If the setting is not supported,
	// ALLOW_CONFIGURING_WIFI is set. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 13. wifiConfigDisabled is
	// ignored.
	//   "DISALLOW_CONFIGURING_WIFI" - Disallows configuring Wi-Fi networks. The
	// setting wifiConfigDisabled is ignored when this value is set. Supported on
	// fully managed devices and work profile on company-owned devices, on all
	// supported API levels. For fully managed devices, setting this removes all
	// configured networks and retains only the networks configured using
	// openNetworkConfiguration policy. For work profiles on company-owned devices,
	// existing configured networks are not affected and the user is not allowed to
	// add, remove, or modify Wi-Fi networks. Note: If a network connection can't
	// be made at boot time and configuring Wi-Fi is disabled then network escape
	// hatch will be shown in order to refresh the device policy (see
	// networkEscapeHatchEnabled).
	ConfigureWifi string `json:"configureWifi,omitempty"`
	// PreferentialNetworkServiceSettings: Optional. Preferential network service
	// configuration. Setting this field will override preferentialNetworkService.
	// This can be set on both work profiles and fully managed devices on Android
	// 13 and above. See 5G network slicing
	// (https://developers.google.com/android/management/5g-network-slicing) guide
	// for more details.
	PreferentialNetworkServiceSettings *PreferentialNetworkServiceSettings `json:"preferentialNetworkServiceSettings,omitempty"`
	// TetheringSettings: Controls tethering settings. Based on the value set, the
	// user is partially or fully disallowed from using different forms of
	// tethering.
	//
	// Possible values:
	//   "TETHERING_SETTINGS_UNSPECIFIED" - Unspecified. Defaults to
	// ALLOW_ALL_TETHERING unless tetheringConfigDisabled is set to true. If
	// tetheringConfigDisabled is set to true, this is equivalent to
	// DISALLOW_ALL_TETHERING.
	//   "ALLOW_ALL_TETHERING" - Allows configuration and use of all forms of
	// tethering. tetheringConfigDisabled is ignored.
	//   "DISALLOW_WIFI_TETHERING" - Disallows the user from using Wi-Fi tethering.
	// Supported on company owned devices running Android 13 and above. If the
	// setting is not supported, ALLOW_ALL_TETHERING will be set. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13. tetheringConfigDisabled is ignored.
	//   "DISALLOW_ALL_TETHERING" - Disallows all forms of tethering. Supported on
	// fully managed devices and work profile on company-owned devices, on all
	// supported android versions. The setting tetheringConfigDisabled is ignored.
	TetheringSettings string `json:"tetheringSettings,omitempty"`
	// UsbDataAccess: Controls what files and/or data can be transferred via USB.
	// Supported only on company-owned devices.
	//
	// Possible values:
	//   "USB_DATA_ACCESS_UNSPECIFIED" - Unspecified. Defaults to
	// DISALLOW_USB_FILE_TRANSFER.
	//   "ALLOW_USB_DATA_TRANSFER" - All types of USB data transfers are allowed.
	// usbFileTransferDisabled is ignored.
	//   "DISALLOW_USB_FILE_TRANSFER" - Transferring files over USB is disallowed.
	// Other types of USB data connections, such as mouse and keyboard connection,
	// are allowed. usbFileTransferDisabled is ignored.
	//   "DISALLOW_USB_DATA_TRANSFER" - When set, all types of USB data transfers
	// are prohibited. Supported for devices running Android 12 or above with USB
	// HAL 1.3 or above. If the setting is not supported,
	// DISALLOW_USB_FILE_TRANSFER will be set. A NonComplianceDetail with API_LEVEL
	// is reported if the Android version is less than 12. A NonComplianceDetail
	// with DEVICE_INCOMPATIBLE is reported if the device does not have USB HAL 1.3
	// or above. usbFileTransferDisabled is ignored.
	UsbDataAccess string `json:"usbDataAccess,omitempty"`
	// WifiDirectSettings: Controls configuring and using Wi-Fi direct settings.
	// Supported on company-owned devices running Android 13 and above.
	//
	// Possible values:
	//   "WIFI_DIRECT_SETTINGS_UNSPECIFIED" - Unspecified. Defaults to
	// ALLOW_WIFI_DIRECT
	//   "ALLOW_WIFI_DIRECT" - The user is allowed to use Wi-Fi direct.
	//   "DISALLOW_WIFI_DIRECT" - The user is not allowed to use Wi-Fi direct. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13.
	WifiDirectSettings string `json:"wifiDirectSettings,omitempty"`
	// WifiRoamingPolicy: Optional. Wi-Fi roaming policy.
	WifiRoamingPolicy *WifiRoamingPolicy `json:"wifiRoamingPolicy,omitempty"`
	// WifiSsidPolicy: Restrictions on which Wi-Fi SSIDs the device can connect to.
	// Note that this does not affect which networks can be configured on the
	// device. Supported on company-owned devices running Android 13 and above.
	WifiSsidPolicy *WifiSsidPolicy `json:"wifiSsidPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApnPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApnPolicy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeviceConnectivityManagement) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceConnectivityManagement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeviceRadioState: Controls for device radio settings.
type DeviceRadioState struct {
	// AirplaneModeState: Controls whether airplane mode can be toggled by the user
	// or not.
	//
	// Possible values:
	//   "AIRPLANE_MODE_STATE_UNSPECIFIED" - Unspecified. Defaults to
	// AIRPLANE_MODE_USER_CHOICE.
	//   "AIRPLANE_MODE_USER_CHOICE" - The user is allowed to toggle airplane mode
	// on or off.
	//   "AIRPLANE_MODE_DISABLED" - Airplane mode is disabled. The user is not
	// allowed to toggle airplane mode on. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 9.
	AirplaneModeState string `json:"airplaneModeState,omitempty"`
	// CellularTwoGState: Controls whether cellular 2G setting can be toggled by
	// the user or not.
	//
	// Possible values:
	//   "CELLULAR_TWO_G_STATE_UNSPECIFIED" - Unspecified. Defaults to
	// CELLULAR_TWO_G_USER_CHOICE.
	//   "CELLULAR_TWO_G_USER_CHOICE" - The user is allowed to toggle cellular 2G
	// on or off.
	//   "CELLULAR_TWO_G_DISABLED" - Cellular 2G is disabled. The user is not
	// allowed to toggle cellular 2G on via settings. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 14.
	CellularTwoGState string `json:"cellularTwoGState,omitempty"`
	// MinimumWifiSecurityLevel: The minimum required security level of Wi-Fi
	// networks that the device can connect to.
	//
	// Possible values:
	//   "MINIMUM_WIFI_SECURITY_LEVEL_UNSPECIFIED" - Defaults to
	// OPEN_NETWORK_SECURITY, which means the device will be able to connect to all
	// types of Wi-Fi networks.
	//   "OPEN_NETWORK_SECURITY" - The device will be able to connect to all types
	// of Wi-Fi networks.
	//   "PERSONAL_NETWORK_SECURITY" - A personal network such as WEP, WPA2-PSK is
	// the minimum required security. The device will not be able to connect to
	// open wifi networks. This is stricter than OPEN_NETWORK_SECURITY. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13.
	//   "ENTERPRISE_NETWORK_SECURITY" - An enterprise EAP network is the minimum
	// required security level. The device will not be able to connect to Wi-Fi
	// network below this security level. This is stricter than
	// PERSONAL_NETWORK_SECURITY. A NonComplianceDetail with API_LEVEL is reported
	// if the Android version is less than 13.
	//   "ENTERPRISE_BIT192_NETWORK_SECURITY" - A 192-bit enterprise network is the
	// minimum required security level. The device will not be able to connect to
	// Wi-Fi network below this security level. This is stricter than
	// ENTERPRISE_NETWORK_SECURITY. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 13.
	MinimumWifiSecurityLevel string `json:"minimumWifiSecurityLevel,omitempty"`
	// UltraWidebandState: Controls the state of the ultra wideband setting and
	// whether the user can toggle it on or off.
	//
	// Possible values:
	//   "ULTRA_WIDEBAND_STATE_UNSPECIFIED" - Unspecified. Defaults to
	// ULTRA_WIDEBAND_USER_CHOICE.
	//   "ULTRA_WIDEBAND_USER_CHOICE" - The user is allowed to toggle ultra
	// wideband on or off.
	//   "ULTRA_WIDEBAND_DISABLED" - Ultra wideband is disabled. The user is not
	// allowed to toggle ultra wideband on via settings. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 14.
	UltraWidebandState string `json:"ultraWidebandState,omitempty"`
	// WifiState: Controls current state of Wi-Fi and if user can change its state.
	//
	// Possible values:
	//   "WIFI_STATE_UNSPECIFIED" - Unspecified. Defaults to WIFI_STATE_USER_CHOICE
	//   "WIFI_STATE_USER_CHOICE" - User is allowed to enable/disable Wi-Fi.
	//   "WIFI_ENABLED" - Wi-Fi is on and the user is not allowed to turn it off. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13.
	//   "WIFI_DISABLED" - Wi-Fi is off and the user is not allowed to turn it on.
	// A NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 13.
	WifiState string `json:"wifiState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AirplaneModeState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AirplaneModeState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeviceRadioState) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceRadioState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeviceSettings: Information about security related device settings on
// device.
type DeviceSettings struct {
	// AdbEnabled: Whether ADB
	// (https://developer.android.com/studio/command-line/adb.html) is enabled on
	// the device.
	AdbEnabled bool `json:"adbEnabled,omitempty"`
	// DevelopmentSettingsEnabled: Whether developer mode is enabled on the device.
	DevelopmentSettingsEnabled bool `json:"developmentSettingsEnabled,omitempty"`
	// EncryptionStatus: Encryption status from DevicePolicyManager.
	//
	// Possible values:
	//   "ENCRYPTION_STATUS_UNSPECIFIED" - Unspecified. No device should have this
	// type.
	//   "UNSUPPORTED" - Encryption is not supported by the device.
	//   "INACTIVE" - Encryption is supported by the device, but is not currently
	// active.
	//   "ACTIVATING" - Encryption is not currently active, but is currently being
	// activated.
	//   "ACTIVE" - Encryption is active.
	//   "ACTIVE_DEFAULT_KEY" - Encryption is active, but an encryption key is not
	// set by the user.
	//   "ACTIVE_PER_USER" - Encryption is active, and the encryption key is tied
	// to the user profile.
	EncryptionStatus string `json:"encryptionStatus,omitempty"`
	// IsDeviceSecure: Whether the device is secured with PIN/password.
	IsDeviceSecure bool `json:"isDeviceSecure,omitempty"`
	// IsEncrypted: Whether the storage encryption is enabled.
	IsEncrypted bool `json:"isEncrypted,omitempty"`
	// UnknownSourcesEnabled: Whether installing apps from unknown sources is
	// enabled.
	UnknownSourcesEnabled bool `json:"unknownSourcesEnabled,omitempty"`
	// VerifyAppsEnabled: Whether Google Play Protect verification
	// (https://support.google.com/accounts/answer/2812853) is enforced on the
	// device.
	VerifyAppsEnabled bool `json:"verifyAppsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdbEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdbEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeviceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Display: Device display information.
type Display struct {
	// Density: Display density expressed as dots-per-inch.
	Density int64 `json:"density,omitempty"`
	// DisplayId: Unique display id.
	DisplayId int64 `json:"displayId,omitempty"`
	// Height: Display height in pixels.
	Height int64 `json:"height,omitempty"`
	// Name: Name of the display.
	Name string `json:"name,omitempty"`
	// RefreshRate: Refresh rate of the display in frames per second.
	RefreshRate int64 `json:"refreshRate,omitempty"`
	// State: State of the display.
	//
	// Possible values:
	//   "DISPLAY_STATE_UNSPECIFIED" - This value is disallowed.
	//   "OFF" - Display is off.
	//   "ON" - Display is on.
	//   "DOZE" - Display is dozing in a low power state
	//   "SUSPENDED" - Display is dozing in a suspended low power state.
	State string `json:"state,omitempty"`
	// Width: Display width in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Density") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Density") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Display) MarshalJSON() ([]byte, error) {
	type NoMethod Display
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DisplaySettings: Controls for the display settings.
type DisplaySettings struct {
	// ScreenBrightnessSettings: Optional. Controls the screen brightness settings.
	ScreenBrightnessSettings *ScreenBrightnessSettings `json:"screenBrightnessSettings,omitempty"`
	// ScreenTimeoutSettings: Optional. Controls the screen timeout settings.
	ScreenTimeoutSettings *ScreenTimeoutSettings `json:"screenTimeoutSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScreenBrightnessSettings")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScreenBrightnessSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DisplaySettings) MarshalJSON() ([]byte, error) {
	type NoMethod DisplaySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsEvent: A DNS lookup event was initiated through the standard network
// stack.
type DnsEvent struct {
	// Hostname: The hostname that was looked up.
	Hostname string `json:"hostname,omitempty"`
	// IpAddresses: The (possibly truncated) list of the IP addresses returned for
	// DNS lookup (max 10 IPv4 or IPv6 addresses).
	IpAddresses []string `json:"ipAddresses,omitempty"`
	// PackageName: The package name of the UID that performed the DNS lookup.
	PackageName string `json:"packageName,omitempty"`
	// TotalIpAddressesReturned: The number of IP addresses returned from the DNS
	// lookup event. May be higher than the amount of ip_addresses if there were
	// too many addresses to log.
	TotalIpAddressesReturned int64 `json:"totalIpAddressesReturned,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Hostname") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hostname") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsEvent) MarshalJSON() ([]byte, error) {
	type NoMethod DnsEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DpcMigrationInfo: Information related to whether this device was migrated
// from being managed by another Device Policy Controller (DPC).
type DpcMigrationInfo struct {
	// AdditionalData: Output only. If this device was migrated from another DPC,
	// the additionalData field of the migration token is populated here.
	AdditionalData string `json:"additionalData,omitempty"`
	// PreviousDpc: Output only. If this device was migrated from another DPC, this
	// is its package name. Not populated otherwise.
	PreviousDpc string `json:"previousDpc,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DpcMigrationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DpcMigrationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Eid: EID information for each eUICC chip.
type Eid struct {
	// Eid: Output only. The EID
	Eid string `json:"eid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Eid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Eid") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Eid) MarshalJSON() ([]byte, error) {
	type NoMethod Eid
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EidInfo: Information related to the EIDs of the device.
type EidInfo struct {
	// Eids: Output only. EID information for each eUICC chip.
	Eids []*Eid `json:"eids,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Eids") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Eids") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EidInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EidInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EnrollmentCompleteEvent: Represents that the device has completed
// enrollment. User should be in the launcher at this point, device at this
// point will be compliant and all setup steps have been completed.
// Intentionally empty.
type EnrollmentCompleteEvent struct {
}

// EnrollmentToken: An enrollment token.
type EnrollmentToken struct {
	// AdditionalData: Optional, arbitrary data associated with the enrollment
	// token. This could contain, for example, the ID of an org unit the device is
	// assigned to after enrollment. After a device enrolls with the token, this
	// data will be exposed in the enrollment_token_data field of the Device
	// resource. The data must be 1024 characters or less; otherwise, the creation
	// request will fail.
	AdditionalData string `json:"additionalData,omitempty"`
	// AllowPersonalUsage: Controls whether personal usage is allowed on a device
	// provisioned with this enrollment token.For company-owned devices: Enabling
	// personal usage allows the user to set up a work profile on the device.
	// Disabling personal usage requires the user provision the device as a fully
	// managed device.For personally-owned devices: Enabling personal usage allows
	// the user to set up a work profile on the device. Disabling personal usage
	// will prevent the device from provisioning. Personal usage cannot be disabled
	// on personally-owned device.
	//
	// Possible values:
	//   "ALLOW_PERSONAL_USAGE_UNSPECIFIED" - Personal usage restriction is not
	// specified
	//   "PERSONAL_USAGE_ALLOWED" - Personal usage is allowed
	//   "PERSONAL_USAGE_DISALLOWED" - Personal usage is disallowed
	//   "PERSONAL_USAGE_DISALLOWED_USERLESS" - Device is not associated with a
	// single user, and thus both personal usage and corporate identity
	// authentication are not expected. Important: This setting is mandatory for
	// dedicated device enrollment and it is a breaking change. This change needs
	// to be implemented before January 2025.For additional details see the
	// dedicated device provisioning guide
	// (https://developers.google.com/android/management/provision-device#company-owned_devices_for_work_use_only).
	AllowPersonalUsage string `json:"allowPersonalUsage,omitempty"`
	// Duration: The length of time the enrollment token is valid, ranging from 1
	// minute to Durations.MAX_VALUE
	// (https://developers.google.com/protocol-buffers/docs/reference/java/com/google/protobuf/util/Durations.html#MAX_VALUE),
	// approximately 10,000 years. If not specified, the default duration is 1
	// hour. Please note that if requested duration causes the resulting
	// expiration_timestamp to exceed Timestamps.MAX_VALUE
	// (https://developers.google.com/protocol-buffers/docs/reference/java/com/google/protobuf/util/Timestamps.html#MAX_VALUE),
	// then expiration_timestamp is coerced to Timestamps.MAX_VALUE.
	Duration string `json:"duration,omitempty"`
	// ExpirationTimestamp: The expiration time of the token. This is a read-only
	// field generated by the server.
	ExpirationTimestamp string `json:"expirationTimestamp,omitempty"`
	// Name: The name of the enrollment token, which is generated by the server
	// during creation, in the form
	// enterprises/{enterpriseId}/enrollmentTokens/{enrollmentTokenId}.
	Name string `json:"name,omitempty"`
	// OneTimeOnly: Whether the enrollment token is for one time use only. If the
	// flag is set to true, only one device can use it for registration.
	OneTimeOnly bool `json:"oneTimeOnly,omitempty"`
	// PolicyName: The name of the policy initially applied to the enrolled device,
	// in the form enterprises/{enterpriseId}/policies/{policyId}. If not
	// specified, the policy_name for the device’s user is applied. If user_name
	// is also not specified, enterprises/{enterpriseId}/policies/default is
	// applied by default. When updating this field, you can specify only the
	// policyId as long as the policyId doesn’t contain any slashes. The rest of
	// the policy name will be inferred.
	PolicyName string `json:"policyName,omitempty"`
	// QrCode: A JSON string whose UTF-8 representation can be used to generate a
	// QR code to enroll a device with this enrollment token. To enroll a device
	// using NFC, the NFC record must contain a serialized java.util.Properties
	// representation of the properties in the JSON.
	QrCode string `json:"qrCode,omitempty"`
	// User: This field is deprecated and the value is ignored.
	User *User `json:"user,omitempty"`
	// Value: The token value that's passed to the device and authorizes the device
	// to enroll. This is a read-only field generated by the server.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdditionalData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnrollmentToken) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollmentToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Enterprise: The configuration applied to an enterprise.
type Enterprise struct {
	// AppAutoApprovalEnabled: Deprecated and unused.
	AppAutoApprovalEnabled bool `json:"appAutoApprovalEnabled,omitempty"`
	// ContactInfo: The enterprise contact info of an EMM-managed enterprise.
	ContactInfo *ContactInfo `json:"contactInfo,omitempty"`
	// EnabledNotificationTypes: The types of Google Pub/Sub notifications enabled
	// for the enterprise.
	//
	// Possible values:
	//   "NOTIFICATION_TYPE_UNSPECIFIED" - This value is ignored.
	//   "ENROLLMENT" - A notification sent when a device enrolls.
	//   "COMPLIANCE_REPORT" - Deprecated.
	//   "STATUS_REPORT" - A notification sent when a device issues a status
	// report.
	//   "COMMAND" - A notification sent when a device command has completed.
	//   "USAGE_LOGS" - A notification sent when device sends BatchUsageLogEvents.
	//   "ENTERPRISE_UPGRADE" - A notification sent for an enterprise upgrade. An
	// enterprise upgrade is a process that upgrades a managed Google Play Accounts
	// enterprise to a managed Google domain.
	EnabledNotificationTypes []string `json:"enabledNotificationTypes,omitempty"`
	// EnterpriseDisplayName: The name of the enterprise displayed to users. This
	// field has a maximum length of 100 characters.
	EnterpriseDisplayName string `json:"enterpriseDisplayName,omitempty"`
	// EnterpriseType: Output only. The type of the enterprise.
	//
	// Possible values:
	//   "ENTERPRISE_TYPE_UNSPECIFIED" - This value is not used.
	//   "MANAGED_GOOGLE_DOMAIN" - The enterprise belongs to a managed Google
	// domain
	// (https://developers.google.com/android/work/terminology#managed_google_domain).
	//   "MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE" - The enterprise is a managed
	// Google Play Accounts enterprise
	// (https://developers.google.com/android/work/terminology#managed_google_play_accounts_enterprise).
	EnterpriseType string `json:"enterpriseType,omitempty"`
	// GoogleAuthenticationSettings: Settings for Google-provided user
	// authentication.
	GoogleAuthenticationSettings *GoogleAuthenticationSettings `json:"googleAuthenticationSettings,omitempty"`
	// Logo: An image displayed as a logo during device provisioning. Supported
	// types are: image/bmp, image/gif, image/x-ico, image/jpeg, image/png,
	// image/webp, image/vnd.wap.wbmp, image/x-adobe-dng.
	Logo *ExternalData `json:"logo,omitempty"`
	// ManagedGoogleDomainType: Output only. The type of managed Google domain.
	//
	// Possible values:
	//   "MANAGED_GOOGLE_DOMAIN_TYPE_UNSPECIFIED" - The managed Google domain type
	// is not specified.
	//   "TYPE_TEAM" - The managed Google domain is an email-verified team.
	//   "TYPE_DOMAIN" - The managed Google domain is domain-verified.
	ManagedGoogleDomainType string `json:"managedGoogleDomainType,omitempty"`
	// ManagedGooglePlayAccountsEnterpriseType: Output only. The type of a managed
	// Google Play Accounts enterprise.
	//
	// Possible values:
	//   "MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_UNSPECIFIED" - The managed
	// Google Play Accounts enterprise type is not specified.
	//   "CUSTOMER_MANAGED" - The enterprise is customer-managed
	//   "EMM_MANAGED" - The enterprise is EMM-managed (deprecated).
	ManagedGooglePlayAccountsEnterpriseType string `json:"managedGooglePlayAccountsEnterpriseType,omitempty"`
	// Name: The name of the enterprise which is generated by the server during
	// creation, in the form enterprises/{enterpriseId}.
	Name string `json:"name,omitempty"`
	// PrimaryColor: A color in RGB format that indicates the predominant color to
	// display in the device management app UI. The color components are stored as
	// follows: (red << 16) | (green << 8) | blue, where the value of each
	// component is between 0 and 255, inclusive.
	PrimaryColor int64 `json:"primaryColor,omitempty"`
	// PubsubTopic: The topic which Pub/Sub notifications are published to, in the
	// form projects/{project}/topics/{topic}. This field is only required if
	// Pub/Sub notifications are enabled.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// SigninDetails: Sign-in details of the enterprise.
	SigninDetails []*SigninDetail `json:"signinDetails,omitempty"`
	// TermsAndConditions: Terms and conditions that must be accepted when
	// provisioning a device for this enterprise. A page of terms is generated for
	// each value in this list.
	TermsAndConditions []*TermsAndConditions `json:"termsAndConditions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppAutoApprovalEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppAutoApprovalEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Enterprise) MarshalJSON() ([]byte, error) {
	type NoMethod Enterprise
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnterpriseUpgradeEvent: An event sent for an enterprise upgrade. An
// enterprise upgrade is a process that upgrades a managed Google Play Accounts
// enterprise to a managed Google domain.
type EnterpriseUpgradeEvent struct {
	// Enterprise: The name of upgraded enterprise in the format
	// "enterprises/{enterprise}"
	Enterprise string `json:"enterprise,omitempty"`
	// UpgradeState: Output only. The upgrade state of the enterprise.
	//
	// Possible values:
	//   "UPGRADE_STATE_UNSPECIFIED" - Unspecified. This value is not used.
	//   "UPGRADE_STATE_SUCCEEDED" - The upgrade has succeeded.
	UpgradeState string `json:"upgradeState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enterprise") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enterprise") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnterpriseUpgradeEvent) MarshalJSON() ([]byte, error) {
	type NoMethod EnterpriseUpgradeEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EsimCommandStatus: Status and error details (if present) of an ADD_ESIM or
// REMOVE_ESIM command.
type EsimCommandStatus struct {
	// EsimInfo: Output only. Information about the eSIM added or removed. This is
	// populated only when the eSIM operation status is SUCCESS.
	EsimInfo *EsimInfo `json:"esimInfo,omitempty"`
	// InternalErrorDetails: Output only. Details of the error if the status is set
	// to INTERNAL_ERROR.
	InternalErrorDetails *InternalErrorDetails `json:"internalErrorDetails,omitempty"`
	// Status: Output only. Status of an ADD_ESIM or REMOVE_ESIM command.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified. This value is not used.
	//   "SUCCESS" - The eSIM operation was successfully performed on the device.
	//   "IN_PROGRESS" - The eSIM operation is in progress.
	//   "PENDING_USER_ACTION" - The user needs to take an action for the eSIM
	// operation to proceed.
	//   "ERROR_SETUP_IN_PROGRESS" - The eSIM operation cannot be executed when
	// setup is in progress.
	//   "ERROR_USER_DENIED" - The user has denied the eSIM operation.
	//   "INTERNAL_ERROR" - An error has occurred while trying to add or remove the
	// eSIM on the device, see internal_error_details.
	//   "ERROR_ICC_ID_NOT_FOUND" - For a REMOVE_ESIM command, the iccId of the
	// eSIM to be removed was not found on the device. This could either mean the
	// eSIM does not belong to the enterprise or the eSIM corresponding to the
	// iccId is not present on the device.
	//   "ERROR_MULTIPLE_ACTIVE_ESIMS_NO_AVAILABLE_SLOT" - The ADD_ESIM command
	// failed when attempting to add a new eSIM with its activation state set to
	// ACTIVATED since multiple eSIM slots on the device contain active eSIM
	// profiles and there is no free eSIM slot available. To resolve this, the new
	// eSIM can be added with its activation state as NOT_ACTIVATED for later
	// manual activation, or the user must first deactivate an existing active eSIM
	// for the operation to proceed.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EsimInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EsimInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EsimCommandStatus) MarshalJSON() ([]byte, error) {
	type NoMethod EsimCommandStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EsimInfo: Details of the eSIM added or removed.
type EsimInfo struct {
	// IccId: Output only. ICC ID of the eSIM.
	IccId string `json:"iccId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IccId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IccId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EsimInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EsimInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EuiccChipInfo: Information related to the eUICC chip.
type EuiccChipInfo struct {
	// Eid: Output only. The Embedded Identity Document (EID) that identifies the
	// eUICC chip for each eUICC chip on the device. This is available on company
	// owned devices running Android 13 and above.
	Eid string `json:"eid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Eid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Eid") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EuiccChipInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EuiccChipInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExtensionConfig: Configuration to enable an app as an extension app, with
// the capability of interacting with Android Device Policy offline. For
// Android versions 11 and above, extension apps are exempt from battery
// restrictions so will not be placed into the restricted App Standby Bucket
// (https://developer.android.com/topic/performance/appstandby#restricted-bucket).
// Extensions apps are also protected against users clearing their data or
// force-closing the application, although admins can continue to use the clear
// app data command on extension apps if needed for Android 11 and above.
type ExtensionConfig struct {
	// NotificationReceiver: Fully qualified class name of the receiver service
	// class for Android Device Policy to notify the extension app of any local
	// command status updates. The service must be exported in the extension app's
	// AndroidManifest.xml and extend NotificationReceiverService
	// (https://developers.google.com/android/management/reference/amapi/com/google/android/managementapi/notification/NotificationReceiverService)
	// (see Integrate with the AMAPI SDK
	// (https://developers.google.com/android/management/sdk-integration) guide for
	// more details).
	NotificationReceiver string `json:"notificationReceiver,omitempty"`
	// SigningKeyFingerprintsSha256: Hex-encoded SHA-256 hashes of the signing key
	// certificates of the extension app. Only hexadecimal string representations
	// of 64 characters are valid.The signing key certificate fingerprints are
	// always obtained from the Play Store and this field is used to provide
	// additional signing key certificate fingerprints. However, if the application
	// is not available on the Play Store, this field needs to be set. A
	// NonComplianceDetail with INVALID_VALUE is reported if this field is not set
	// when the application is not available on the Play Store.The signing key
	// certificate fingerprint of the extension app on the device must match one of
	// the signing key certificate fingerprints obtained from the Play Store or the
	// ones provided in this field for the app to be able to communicate with
	// Android Device Policy.In production use cases, it is recommended to leave
	// this empty.
	SigningKeyFingerprintsSha256 []string `json:"signingKeyFingerprintsSha256,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotificationReceiver") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotificationReceiver") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtensionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExtensionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalData: Data hosted at an external location. The data is to be
// downloaded by Android Device Policy and verified against the hash.
type ExternalData struct {
	// Sha256Hash: The base-64 encoded SHA-256 hash of the content hosted at url.
	// If the content doesn't match this hash, Android Device Policy won't use the
	// data.
	Sha256Hash string `json:"sha256Hash,omitempty"`
	// Url: The absolute URL to the data, which must use either the http or https
	// scheme. Android Device Policy doesn't provide any credentials in the GET
	// request, so the URL must be publicly accessible. Including a long, random
	// component in the URL may be used to prevent attackers from discovering the
	// URL.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sha256Hash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sha256Hash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalData) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FilePulledEvent: A file was downloaded from the device.
type FilePulledEvent struct {
	// FilePath: The path of the file being pulled.
	FilePath string `json:"filePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FilePulledEvent) MarshalJSON() ([]byte, error) {
	type NoMethod FilePulledEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FilePushedEvent: A file was uploaded onto the device.
type FilePushedEvent struct {
	// FilePath: The path of the file being pushed.
	FilePath string `json:"filePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FilePushedEvent) MarshalJSON() ([]byte, error) {
	type NoMethod FilePushedEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FreezePeriod: A system freeze period. When a device’s clock is within the
// freeze period, all incoming system updates (including security patches) are
// blocked and won’t be installed.When the device is outside any set freeze
// periods, the normal policy behavior (automatic, windowed, or postponed)
// applies.Leap years are ignored in freeze period calculations, in particular:
// If Feb. 29th is set as the start or end date of a freeze period, the freeze
// period will start or end on Feb. 28th instead. When a device’s system
// clock reads Feb. 29th, it’s treated as Feb. 28th. When calculating the
// number of days in a freeze period or the time between two freeze periods,
// Feb. 29th is ignored and not counted as a day.Note: For Freeze Periods to
// take effect, SystemUpdateType cannot be specified as
// SYSTEM_UPDATE_TYPE_UNSPECIFIED, because freeze periods require a defined
// policy to be specified.
type FreezePeriod struct {
	// EndDate: The end date (inclusive) of the freeze period. Must be no later
	// than 90 days from the start date. If the end date is earlier than the start
	// date, the freeze period is considered wrapping year-end. Note: day and month
	// must be set. year should not be set as it is not used. For example,
	// {"month": 1,"date": 30}.
	EndDate *Date `json:"endDate,omitempty"`
	// StartDate: The start date (inclusive) of the freeze period. Note: day and
	// month must be set. year should not be set as it is not used. For example,
	// {"month": 1,"date": 30}.
	StartDate *Date `json:"startDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FreezePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod FreezePeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateEnterpriseUpgradeUrlRequest: Request message for generating a URL to
// upgrade an existing managed Google Play Accounts enterprise to a managed
// Google domain.Note: This feature is not generally available.
type GenerateEnterpriseUpgradeUrlRequest struct {
	// AdminEmail: Optional. Email address used to prefill the admin field of the
	// enterprise signup form as part of the upgrade process. This value is a hint
	// only and can be altered by the user. Personal email addresses are not
	// allowed. If allowedDomains is non-empty then this must belong to one of the
	// allowedDomains.
	AdminEmail string `json:"adminEmail,omitempty"`
	// AllowedDomains: Optional. A list of domains that are permitted for the admin
	// email. The IT admin cannot enter an email address with a domain name that is
	// not in this list. Subdomains of domains in this list are not allowed but can
	// be allowed by adding a second entry which has *. prefixed to the domain name
	// (e.g. *.example.com). If the field is not present or is an empty list then
	// the IT admin is free to use any valid domain name. Personal email domains
	// are not allowed.
	AllowedDomains []string `json:"allowedDomains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdminEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminEmail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateEnterpriseUpgradeUrlRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateEnterpriseUpgradeUrlRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateEnterpriseUpgradeUrlResponse: Response message for generating a URL
// to upgrade an existing managed Google Play Accounts enterprise to a managed
// Google domain.Note: This feature is not generally available.
type GenerateEnterpriseUpgradeUrlResponse struct {
	// Url: A URL for an enterprise admin to upgrade their enterprise. The page
	// can't be rendered in an iframe.
	Url string `json:"url,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateEnterpriseUpgradeUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateEnterpriseUpgradeUrlResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAuthenticationSettings: Contains settings for Google-provided user
// authentication.
type GoogleAuthenticationSettings struct {
	// GoogleAuthenticationRequired: Output only. Whether users need to be
	// authenticated by Google during the enrollment process. IT admin can specify
	// if Google authentication is enabled for the enterprise for knowledge worker
	// devices. This value can be set only via the Google Admin Console. Google
	// authentication can be used with signin_url In the case where Google
	// authentication is required and a signin_url is specified, Google
	// authentication will be launched before signin_url.
	//
	// Possible values:
	//   "GOOGLE_AUTHENTICATION_REQUIRED_UNSPECIFIED" - This value is not used.
	//   "NOT_REQUIRED" - Google authentication is not required.
	//   "REQUIRED" - User is required to be successfully authenticated by Google.
	GoogleAuthenticationRequired string `json:"googleAuthenticationRequired,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GoogleAuthenticationRequired") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleAuthenticationRequired") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAuthenticationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAuthenticationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HardwareInfo: Information about device hardware. The fields related to
// temperature thresholds are only available if hardwareStatusEnabled is true
// in the device's policy.
type HardwareInfo struct {
	// BatteryShutdownTemperatures: Battery shutdown temperature thresholds in
	// Celsius for each battery on the device.
	BatteryShutdownTemperatures []float64 `json:"batteryShutdownTemperatures,omitempty"`
	// BatteryThrottlingTemperatures: Battery throttling temperature thresholds in
	// Celsius for each battery on the device.
	BatteryThrottlingTemperatures []float64 `json:"batteryThrottlingTemperatures,omitempty"`
	// Brand: Brand of the device. For example, Google.
	Brand string `json:"brand,omitempty"`
	// CpuShutdownTemperatures: CPU shutdown temperature thresholds in Celsius for
	// each CPU on the device.
	CpuShutdownTemperatures []float64 `json:"cpuShutdownTemperatures,omitempty"`
	// CpuThrottlingTemperatures: CPU throttling temperature thresholds in Celsius
	// for each CPU on the device.
	CpuThrottlingTemperatures []float64 `json:"cpuThrottlingTemperatures,omitempty"`
	// DeviceBasebandVersion: Baseband version. For example,
	// MDM9625_104662.22.05.34p.
	DeviceBasebandVersion string `json:"deviceBasebandVersion,omitempty"`
	// EnterpriseSpecificId: Output only. ID that uniquely identifies a
	// personally-owned device in a particular organization. On the same physical
	// device when enrolled with the same organization, this ID persists across
	// setups and even factory resets. This ID is available on personally-owned
	// devices with a work profile on devices running Android 12 and above.
	EnterpriseSpecificId string `json:"enterpriseSpecificId,omitempty"`
	// EuiccChipInfo: Output only. Information related to the eUICC chip.
	EuiccChipInfo []*EuiccChipInfo `json:"euiccChipInfo,omitempty"`
	// GpuShutdownTemperatures: GPU shutdown temperature thresholds in Celsius for
	// each GPU on the device.
	GpuShutdownTemperatures []float64 `json:"gpuShutdownTemperatures,omitempty"`
	// GpuThrottlingTemperatures: GPU throttling temperature thresholds in Celsius
	// for each GPU on the device.
	GpuThrottlingTemperatures []float64 `json:"gpuThrottlingTemperatures,omitempty"`
	// Hardware: Name of the hardware. For example, Angler.
	Hardware string `json:"hardware,omitempty"`
	// Manufacturer: Manufacturer. For example, Motorola.
	Manufacturer string `json:"manufacturer,omitempty"`
	// Model: The model of the device. For example, Asus Nexus 7.
	Model string `json:"model,omitempty"`
	// SerialNumber: The device serial number. However, for personally-owned
	// devices running Android 12 and above, this is the same as the
	// enterpriseSpecificId.
	SerialNumber string `json:"serialNumber,omitempty"`
	// SkinShutdownTemperatures: Device skin shutdown temperature thresholds in
	// Celsius.
	SkinShutdownTemperatures []float64 `json:"skinShutdownTemperatures,omitempty"`
	// SkinThrottlingTemperatures: Device skin throttling temperature thresholds in
	// Celsius.
	SkinThrottlingTemperatures []float64 `json:"skinThrottlingTemperatures,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BatteryShutdownTemperatures") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatteryShutdownTemperatures") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HardwareInfo) MarshalJSON() ([]byte, error) {
	type NoMethod HardwareInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *HardwareInfo) UnmarshalJSON(data []byte) error {
	type NoMethod HardwareInfo
	var s1 struct {
		BatteryShutdownTemperatures   []gensupport.JSONFloat64 `json:"batteryShutdownTemperatures"`
		BatteryThrottlingTemperatures []gensupport.JSONFloat64 `json:"batteryThrottlingTemperatures"`
		CpuShutdownTemperatures       []gensupport.JSONFloat64 `json:"cpuShutdownTemperatures"`
		CpuThrottlingTemperatures     []gensupport.JSONFloat64 `json:"cpuThrottlingTemperatures"`
		GpuShutdownTemperatures       []gensupport.JSONFloat64 `json:"gpuShutdownTemperatures"`
		GpuThrottlingTemperatures     []gensupport.JSONFloat64 `json:"gpuThrottlingTemperatures"`
		SkinShutdownTemperatures      []gensupport.JSONFloat64 `json:"skinShutdownTemperatures"`
		SkinThrottlingTemperatures    []gensupport.JSONFloat64 `json:"skinThrottlingTemperatures"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BatteryShutdownTemperatures = make([]float64, len(s1.BatteryShutdownTemperatures))
	for i := range s1.BatteryShutdownTemperatures {
		s.BatteryShutdownTemperatures[i] = float64(s1.BatteryShutdownTemperatures[i])
	}
	s.BatteryThrottlingTemperatures = make([]float64, len(s1.BatteryThrottlingTemperatures))
	for i := range s1.BatteryThrottlingTemperatures {
		s.BatteryThrottlingTemperatures[i] = float64(s1.BatteryThrottlingTemperatures[i])
	}
	s.CpuShutdownTemperatures = make([]float64, len(s1.CpuShutdownTemperatures))
	for i := range s1.CpuShutdownTemperatures {
		s.CpuShutdownTemperatures[i] = float64(s1.CpuShutdownTemperatures[i])
	}
	s.CpuThrottlingTemperatures = make([]float64, len(s1.CpuThrottlingTemperatures))
	for i := range s1.CpuThrottlingTemperatures {
		s.CpuThrottlingTemperatures[i] = float64(s1.CpuThrottlingTemperatures[i])
	}
	s.GpuShutdownTemperatures = make([]float64, len(s1.GpuShutdownTemperatures))
	for i := range s1.GpuShutdownTemperatures {
		s.GpuShutdownTemperatures[i] = float64(s1.GpuShutdownTemperatures[i])
	}
	s.GpuThrottlingTemperatures = make([]float64, len(s1.GpuThrottlingTemperatures))
	for i := range s1.GpuThrottlingTemperatures {
		s.GpuThrottlingTemperatures[i] = float64(s1.GpuThrottlingTemperatures[i])
	}
	s.SkinShutdownTemperatures = make([]float64, len(s1.SkinShutdownTemperatures))
	for i := range s1.SkinShutdownTemperatures {
		s.SkinShutdownTemperatures[i] = float64(s1.SkinShutdownTemperatures[i])
	}
	s.SkinThrottlingTemperatures = make([]float64, len(s1.SkinThrottlingTemperatures))
	for i := range s1.SkinThrottlingTemperatures {
		s.SkinThrottlingTemperatures[i] = float64(s1.SkinThrottlingTemperatures[i])
	}
	return nil
}

// HardwareStatus: Hardware status. Temperatures may be compared to the
// temperature thresholds available in hardwareInfo to determine hardware
// health.
type HardwareStatus struct {
	// BatteryTemperatures: Current battery temperatures in Celsius for each
	// battery on the device.
	BatteryTemperatures []float64 `json:"batteryTemperatures,omitempty"`
	// CpuTemperatures: Current CPU temperatures in Celsius for each CPU on the
	// device.
	CpuTemperatures []float64 `json:"cpuTemperatures,omitempty"`
	// CpuUsages: CPU usages in percentage for each core available on the device.
	// Usage is 0 for each unplugged core. Empty array implies that CPU usage is
	// not supported in the system.
	CpuUsages []float64 `json:"cpuUsages,omitempty"`
	// CreateTime: The time the measurements were taken.
	CreateTime string `json:"createTime,omitempty"`
	// FanSpeeds: Fan speeds in RPM for each fan on the device. Empty array means
	// that there are no fans or fan speed is not supported on the system.
	FanSpeeds []float64 `json:"fanSpeeds,omitempty"`
	// GpuTemperatures: Current GPU temperatures in Celsius for each GPU on the
	// device.
	GpuTemperatures []float64 `json:"gpuTemperatures,omitempty"`
	// SkinTemperatures: Current device skin temperatures in Celsius.
	SkinTemperatures []float64 `json:"skinTemperatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatteryTemperatures") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatteryTemperatures") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HardwareStatus) MarshalJSON() ([]byte, error) {
	type NoMethod HardwareStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *HardwareStatus) UnmarshalJSON(data []byte) error {
	type NoMethod HardwareStatus
	var s1 struct {
		BatteryTemperatures []gensupport.JSONFloat64 `json:"batteryTemperatures"`
		CpuTemperatures     []gensupport.JSONFloat64 `json:"cpuTemperatures"`
		CpuUsages           []gensupport.JSONFloat64 `json:"cpuUsages"`
		FanSpeeds           []gensupport.JSONFloat64 `json:"fanSpeeds"`
		GpuTemperatures     []gensupport.JSONFloat64 `json:"gpuTemperatures"`
		SkinTemperatures    []gensupport.JSONFloat64 `json:"skinTemperatures"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BatteryTemperatures = make([]float64, len(s1.BatteryTemperatures))
	for i := range s1.BatteryTemperatures {
		s.BatteryTemperatures[i] = float64(s1.BatteryTemperatures[i])
	}
	s.CpuTemperatures = make([]float64, len(s1.CpuTemperatures))
	for i := range s1.CpuTemperatures {
		s.CpuTemperatures[i] = float64(s1.CpuTemperatures[i])
	}
	s.CpuUsages = make([]float64, len(s1.CpuUsages))
	for i := range s1.CpuUsages {
		s.CpuUsages[i] = float64(s1.CpuUsages[i])
	}
	s.FanSpeeds = make([]float64, len(s1.FanSpeeds))
	for i := range s1.FanSpeeds {
		s.FanSpeeds[i] = float64(s1.FanSpeeds[i])
	}
	s.GpuTemperatures = make([]float64, len(s1.GpuTemperatures))
	for i := range s1.GpuTemperatures {
		s.GpuTemperatures[i] = float64(s1.GpuTemperatures[i])
	}
	s.SkinTemperatures = make([]float64, len(s1.SkinTemperatures))
	for i := range s1.SkinTemperatures {
		s.SkinTemperatures[i] = float64(s1.SkinTemperatures[i])
	}
	return nil
}

// InstallConstraint: Amongst apps with InstallType set to: FORCE_INSTALLED
// PREINSTALLEDthis defines a set of restrictions for the app installation. At
// least one of the fields must be set. When multiple fields are set, then all
// the constraints need to be satisfied for the app to be installed.
type InstallConstraint struct {
	// ChargingConstraint: Optional. Charging constraint.
	//
	// Possible values:
	//   "CHARGING_CONSTRAINT_UNSPECIFIED" - Unspecified. Default to
	// CHARGING_NOT_REQUIRED.
	//   "CHARGING_NOT_REQUIRED" - Device doesn't have to be charging.
	//   "INSTALL_ONLY_WHEN_CHARGING" - Device has to be charging.
	ChargingConstraint string `json:"chargingConstraint,omitempty"`
	// DeviceIdleConstraint: Optional. Device idle constraint.
	//
	// Possible values:
	//   "DEVICE_IDLE_CONSTRAINT_UNSPECIFIED" - Unspecified. Default to
	// DEVICE_IDLE_NOT_REQUIRED.
	//   "DEVICE_IDLE_NOT_REQUIRED" - Device doesn't have to be idle, app can be
	// installed while the user is interacting with the device.
	//   "INSTALL_ONLY_WHEN_DEVICE_IDLE" - Device has to be idle.
	DeviceIdleConstraint string `json:"deviceIdleConstraint,omitempty"`
	// NetworkTypeConstraint: Optional. Network type constraint.
	//
	// Possible values:
	//   "NETWORK_TYPE_CONSTRAINT_UNSPECIFIED" - Unspecified. Default to
	// INSTALL_ON_ANY_NETWORK.
	//   "INSTALL_ON_ANY_NETWORK" - Any active networks (Wi-Fi, cellular, etc.).
	//   "INSTALL_ONLY_ON_UNMETERED_NETWORK" - Any unmetered network (e.g. Wi-FI).
	NetworkTypeConstraint string `json:"networkTypeConstraint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChargingConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChargingConstraint") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstallConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod InstallConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InternalErrorDetails: Internal error details if present for the ADD_ESIM or
// REMOVE_ESIM command.
type InternalErrorDetails struct {
	// ErrorCode: Output only. Integer representation of the error code as
	// specified here
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#EXTRA_EMBEDDED_SUBSCRIPTION_DETAILED_CODE).
	// See also, OPERATION_SMDX_SUBJECT_REASON_CODE. See error_code_detail for more
	// details.
	ErrorCode int64 `json:"errorCode,omitempty,string"`
	// ErrorCodeDetail: Output only. The error code detail corresponding to the
	// error_code.
	//
	// Possible values:
	//   "ERROR_CODE_DETAIL_UNSPECIFIED" - Error code detail is unspecified. The
	// error_code is not recognized by Android Management API. However, see
	// error_code
	//   "ERROR_TIME_OUT" - See EuiccManager.ERROR_TIME_OUT
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_TIME_OUT)
	// for details.
	//   "ERROR_EUICC_MISSING" - See EuiccManager.ERROR_EUICC_MISSING
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_EUICC_MISSING)
	// for details.
	//   "ERROR_UNSUPPORTED_VERSION" - See EuiccManager.ERROR_UNSUPPORTED_VERSION
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_UNSUPPORTED_VERSION)
	// for details.
	//   "ERROR_ADDRESS_MISSING" - See EuiccManager.ERROR_ADDRESS_MISSING
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_ADDRESS_MISSING)
	// for details.
	//   "ERROR_INVALID_CONFIRMATION_CODE" - See
	// EuiccManager.ERROR_INVALID_CONFIRMATION_CODE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INVALID_CONFIRMATION_CODE)
	// for details.
	//   "ERROR_CERTIFICATE_ERROR" - See EuiccManager.ERROR_CERTIFICATE_ERROR
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_CERTIFICATE_ERROR)
	// for details.
	//   "ERROR_NO_PROFILES_AVAILABLE" - See
	// EuiccManager.ERROR_NO_PROFILES_AVAILABLE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_NO_PROFILES_AVAILABLE)
	// for details.
	//   "ERROR_CONNECTION_ERROR" - See EuiccManager.ERROR_CONNECTION_ERROR
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_CONNECTION_ERROR)
	// for details.
	//   "ERROR_INVALID_RESPONSE" - See EuiccManager.ERROR_INVALID_RESPONSE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INVALID_RESPONSE)
	// for details.
	//   "ERROR_CARRIER_LOCKED" - See EuiccManager.ERROR_CARRIER_LOCKED
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_CARRIER_LOCKED)
	// for details.
	//   "ERROR_DISALLOWED_BY_PPR" - See EuiccManager.ERROR_DISALLOWED_BY_PPR
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_DISALLOWED_BY_PPR)
	// for details.
	//   "ERROR_INVALID_ACTIVATION_CODE" - See
	// EuiccManager.ERROR_INVALID_ACTIVATION_CODE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INVALID_ACTIVATION_CODE)
	// for details.
	//   "ERROR_INCOMPATIBLE_CARRIER" - See EuiccManager.ERROR_INCOMPATIBLE_CARRIER
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INCOMPATIBLE_CARRIER)
	// for details.
	//   "ERROR_OPERATION_BUSY" - See EuiccManager.ERROR_OPERATION_BUSY
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_OPERATION_BUSY)
	// for details.
	//   "ERROR_INSTALL_PROFILE" - See EuiccManager.ERROR_INSTALL_PROFILE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INSTALL_PROFILE)
	// for details.
	//   "ERROR_EUICC_INSUFFICIENT_MEMORY" - See
	// EuiccManager.ERROR_EUICC_INSUFFICIENT_MEMORY
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_EUICC_INSUFFICIENT_MEMORY)
	// for details.
	//   "ERROR_INVALID_PORT" - See EuiccManager.ERROR_INVALID_PORT
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_INVALID_PORT)
	// for details.
	//   "ERROR_SIM_MISSING" - See EuiccManager.ERROR_SIM_MISSING
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#ERROR_SIM_MISSING)
	// for details.
	ErrorCodeDetail string `json:"errorCodeDetail,omitempty"`
	// OperationCode: Output only. Integer representation of the operation code as
	// specified here
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#EXTRA_EMBEDDED_SUBSCRIPTION_DETAILED_CODE).
	// See operation_code_detail for more details.
	OperationCode int64 `json:"operationCode,omitempty,string"`
	// OperationCodeDetail: Output only. The operation code detail corresponding to
	// the operation_code.
	//
	// Possible values:
	//   "OPERATION_CODE_DETAIL_UNSPECIFIED" - Operation code detail is
	// unspecified. The operation_code is not recognized by Android Management API.
	// However, see operation_code.
	//   "OPERATION_SYSTEM" - See EuiccManager.OPERATION_SYSTEM
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SYSTEM)
	// for details.
	//   "OPERATION_SIM_SLOT" - See EuiccManager.OPERATION_SIM_SLOT
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SIM_SLOT)
	// for details.
	//   "OPERATION_EUICC_CARD" - See EuiccManager.OPERATION_EUICC_CARD
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_EUICC_CARD)
	// for details.
	//   "OPERATION_SMDX" - See EuiccManager.OPERATION_SMDX
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SMDX)
	// for details.
	//   "OPERATION_SWITCH" - See EuiccManager.OPERATION_SWITCH
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SWITCH)
	// for details.
	//   "OPERATION_DOWNLOAD" - See EuiccManager.OPERATION_DOWNLOAD
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_DOWNLOAD)
	// for details.
	//   "OPERATION_METADATA" - See EuiccManager.OPERATION_METADATA
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_METADATA)
	// for details.
	//   "OPERATION_EUICC_GSMA" - See EuiccManager.OPERATION_EUICC_GSMA
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_EUICC_GSMA)
	// for details.
	//   "OPERATION_APDU" - See EuiccManager.OPERATION_APDU
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_APDU)
	// for details.
	//   "OPERATION_SMDX_SUBJECT_REASON_CODE" - See
	// EuiccManager.OPERATION_SMDX_SUBJECT_REASON_CODE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SMDX_SUBJECT_REASON_CODE)
	// for details. Note that, in this case, error_code is the least significant 3
	// bytes of the EXTRA_EMBEDDED_SUBSCRIPTION_DETAILED_CODE
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#EXTRA_EMBEDDED_SUBSCRIPTION_DETAILED_CODE)
	// specifying the subject code and the reason code as indicated here
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_SMDX_SUBJECT_REASON_CODE).
	// The most significant byte of the integer is zeroed out. For example, a
	// Subject Code of 8.11.1 and a Reason Code of 5.1 is represented in error_code
	// as 0000 0000 1000 1011 0001 0000 0101 0001 in binary, which is 9113681 in
	// decimal.
	//   "OPERATION_HTTP" - See EuiccManager.OPERATION_HTTP
	// (https://developer.android.com/reference/android/telephony/euicc/EuiccManager#OPERATION_HTTP)
	// for details.
	OperationCodeDetail string `json:"operationCodeDetail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InternalErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod InternalErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IssueCommandResponse: Response on issuing a command. This is currently empty
// as a placeholder.
type IssueCommandResponse struct {
}

// KeyDestructionEvent: A cryptographic key including user installed, admin
// installed and system maintained private key is removed from the device
// either by the user or management. This is available device-wide on fully
// managed devices and within the work profile on organization-owned devices
// with a work profile.
type KeyDestructionEvent struct {
	// ApplicationUid: UID of the application which owns the key.
	ApplicationUid int64 `json:"applicationUid,omitempty"`
	// KeyAlias: Alias of the key.
	KeyAlias string `json:"keyAlias,omitempty"`
	// Success: Whether the operation was successful.
	Success bool `json:"success,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationUid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationUid") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyDestructionEvent) MarshalJSON() ([]byte, error) {
	type NoMethod KeyDestructionEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyGeneratedEvent: A cryptographic key including user installed, admin
// installed and system maintained private key is installed on the device
// either by the user or management.This is available device-wide on fully
// managed devices and within the work profile on organization-owned devices
// with a work profile.
type KeyGeneratedEvent struct {
	// ApplicationUid: UID of the application which generated the key.
	ApplicationUid int64 `json:"applicationUid,omitempty"`
	// KeyAlias: Alias of the key.
	KeyAlias string `json:"keyAlias,omitempty"`
	// Success: Whether the operation was successful.
	Success bool `json:"success,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationUid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationUid") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyGeneratedEvent) MarshalJSON() ([]byte, error) {
	type NoMethod KeyGeneratedEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyImportEvent: A cryptographic key including user installed, admin
// installed and system maintained private key is imported on the device either
// by the user or management. This is available device-wide on fully managed
// devices and within the work profile on organization-owned devices with a
// work profile.
type KeyImportEvent struct {
	// ApplicationUid: UID of the application which imported the key
	ApplicationUid int64 `json:"applicationUid,omitempty"`
	// KeyAlias: Alias of the key.
	KeyAlias string `json:"keyAlias,omitempty"`
	// Success: Whether the operation was successful.
	Success bool `json:"success,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationUid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationUid") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyImportEvent) MarshalJSON() ([]byte, error) {
	type NoMethod KeyImportEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyIntegrityViolationEvent: A cryptographic key including user installed,
// admin installed and system maintained private key is determined to be
// corrupted due to storage corruption, hardware failure or some OS issue. This
// is available device-wide on fully managed devices and within the work
// profile on organization-owned devices with a work profile.
type KeyIntegrityViolationEvent struct {
	// ApplicationUid: UID of the application which owns the key
	ApplicationUid int64 `json:"applicationUid,omitempty"`
	// KeyAlias: Alias of the key.
	KeyAlias string `json:"keyAlias,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationUid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationUid") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyIntegrityViolationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod KeyIntegrityViolationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyedAppState: Keyed app state reported by the app.
type KeyedAppState struct {
	// CreateTime: The creation time of the app state on the device.
	CreateTime string `json:"createTime,omitempty"`
	// Data: Optionally, a machine-readable value to be read by the EMM. For
	// example, setting values that the admin can choose to query against in the
	// EMM console (e.g. “notify me if the battery_warning data < 10”).
	Data string `json:"data,omitempty"`
	// Key: The key for the app state. Acts as a point of reference for what the
	// app is providing state for. For example, when providing managed
	// configuration feedback, this key could be the managed configuration key.
	Key string `json:"key,omitempty"`
	// LastUpdateTime: The time the app state was most recently updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Message: Optionally, a free-form message string to explain the app state. If
	// the state was triggered by a particular value (e.g. a managed configuration
	// value), it should be included in the message.
	Message string `json:"message,omitempty"`
	// Severity: The severity of the app state.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity level.
	//   "INFO" - Information severity level.
	//   "ERROR" - Error severity level. This should only be set for genuine error
	// conditions that a management organization needs to take action to fix.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyedAppState) MarshalJSON() ([]byte, error) {
	type NoMethod KeyedAppState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyguardDismissAuthAttemptEvent: An attempt was made to unlock the device.
type KeyguardDismissAuthAttemptEvent struct {
	// StrongAuthMethodUsed: Whether a strong form of authentication (password,
	// PIN, or pattern) was used to unlock device.
	StrongAuthMethodUsed bool `json:"strongAuthMethodUsed,omitempty"`
	// Success: Whether the unlock attempt was successful.
	Success bool `json:"success,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StrongAuthMethodUsed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StrongAuthMethodUsed") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyguardDismissAuthAttemptEvent) MarshalJSON() ([]byte, error) {
	type NoMethod KeyguardDismissAuthAttemptEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyguardDismissedEvent: The keyguard was dismissed. Intentionally empty.
type KeyguardDismissedEvent struct {
}

// KeyguardSecuredEvent: The device was locked either by user or timeout.
// Intentionally empty.
type KeyguardSecuredEvent struct {
}

// KioskCustomization: Settings controlling the behavior of a device in kiosk
// mode. To enable kiosk mode, set kioskCustomLauncherEnabled to true or
// specify an app in the policy with installType KIOSK.
type KioskCustomization struct {
	// DeviceSettings: Specifies whether the Settings app is allowed in kiosk mode.
	//
	// Possible values:
	//   "DEVICE_SETTINGS_UNSPECIFIED" - Unspecified, defaults to
	// SETTINGS_ACCESS_ALLOWED.
	//   "SETTINGS_ACCESS_ALLOWED" - Access to the Settings app is allowed in kiosk
	// mode.
	//   "SETTINGS_ACCESS_BLOCKED" - Access to the Settings app is not allowed in
	// kiosk mode.
	DeviceSettings string `json:"deviceSettings,omitempty"`
	// PowerButtonActions: Sets the behavior of a device in kiosk mode when a user
	// presses and holds (long-presses) the Power button.
	//
	// Possible values:
	//   "POWER_BUTTON_ACTIONS_UNSPECIFIED" - Unspecified, defaults to
	// POWER_BUTTON_AVAILABLE.
	//   "POWER_BUTTON_AVAILABLE" - The power menu (e.g. Power off, Restart) is
	// shown when a user long-presses the Power button of a device in kiosk mode.
	//   "POWER_BUTTON_BLOCKED" - The power menu (e.g. Power off, Restart) is not
	// shown when a user long-presses the Power button of a device in kiosk mode.
	// Note: this may prevent users from turning off the device.
	PowerButtonActions string `json:"powerButtonActions,omitempty"`
	// StatusBar: Specifies whether system info and notifications are disabled in
	// kiosk mode.
	//
	// Possible values:
	//   "STATUS_BAR_UNSPECIFIED" - Unspecified, defaults to
	// INFO_AND_NOTIFICATIONS_DISABLED.
	//   "NOTIFICATIONS_AND_SYSTEM_INFO_ENABLED" - System info and notifications
	// are shown on the status bar in kiosk mode.Note: For this policy to take
	// effect, the device's home button must be enabled using
	// kioskCustomization.systemNavigation.
	//   "NOTIFICATIONS_AND_SYSTEM_INFO_DISABLED" - System info and notifications
	// are disabled in kiosk mode.
	//   "SYSTEM_INFO_ONLY" - Only system info is shown on the status bar.
	StatusBar string `json:"statusBar,omitempty"`
	// SystemErrorWarnings: Specifies whether system error dialogs for crashed or
	// unresponsive apps are blocked in kiosk mode. When blocked, the system will
	// force-stop the app as if the user chooses the "close app" option on the UI.
	//
	// Possible values:
	//   "SYSTEM_ERROR_WARNINGS_UNSPECIFIED" - Unspecified, defaults to
	// ERROR_AND_WARNINGS_MUTED.
	//   "ERROR_AND_WARNINGS_ENABLED" - All system error dialogs such as crash and
	// app not responding (ANR) are displayed.
	//   "ERROR_AND_WARNINGS_MUTED" - All system error dialogs, such as crash and
	// app not responding (ANR) are blocked. When blocked, the system force-stops
	// the app as if the user closes the app from the UI.
	SystemErrorWarnings string `json:"systemErrorWarnings,omitempty"`
	// SystemNavigation: Specifies which navigation features are enabled (e.g.
	// Home, Overview buttons) in kiosk mode.
	//
	// Possible values:
	//   "SYSTEM_NAVIGATION_UNSPECIFIED" - Unspecified, defaults to
	// NAVIGATION_DISABLED.
	//   "NAVIGATION_ENABLED" - Home and overview buttons are enabled.
	//   "NAVIGATION_DISABLED" - The home and Overview buttons are not accessible.
	//   "HOME_BUTTON_ONLY" - Only the home button is enabled.
	SystemNavigation string `json:"systemNavigation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KioskCustomization) MarshalJSON() ([]byte, error) {
	type NoMethod KioskCustomization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LaunchAppAction: An action to launch an app.
type LaunchAppAction struct {
	// PackageName: Package name of app to be launched
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LaunchAppAction) MarshalJSON() ([]byte, error) {
	type NoMethod LaunchAppAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDevicesResponse: Response to a request to list devices for a given
// enterprise.
type ListDevicesResponse struct {
	// Devices: The list of devices.
	Devices []*Device `json:"devices,omitempty"`
	// NextPageToken: If there are more results, a token to retrieve next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Devices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Devices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDevicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEnrollmentTokensResponse: Response to a request to list enrollment
// tokens for a given enterprise.
type ListEnrollmentTokensResponse struct {
	// EnrollmentTokens: The list of enrollment tokens.
	EnrollmentTokens []*EnrollmentToken `json:"enrollmentTokens,omitempty"`
	// NextPageToken: If there are more results, a token to retrieve next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnrollmentTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnrollmentTokens") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEnrollmentTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEnrollmentTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEnterprisesResponse: Response to a request to list enterprises.
type ListEnterprisesResponse struct {
	// Enterprises: The list of enterprises.
	Enterprises []*Enterprise `json:"enterprises,omitempty"`
	// NextPageToken: If there are more results, a token to retrieve next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Enterprises") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enterprises") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEnterprisesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEnterprisesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMigrationTokensResponse: Response to a request to list migration tokens
// for a given enterprise.
type ListMigrationTokensResponse struct {
	// MigrationTokens: The migration tokens from the specified enterprise.
	MigrationTokens []*MigrationToken `json:"migrationTokens,omitempty"`
	// NextPageToken: A token, which can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MigrationTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationTokens") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMigrationTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMigrationTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets ListOperationsRequest.return_partial_success and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPoliciesResponse: Response to a request to list policies for a given
// enterprise.
type ListPoliciesResponse struct {
	// NextPageToken: If there are more results, a token to retrieve next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Policies: The list of policies.
	Policies []*Policy `json:"policies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWebAppsResponse: Response to a request to list web apps for a given
// enterprise.
type ListWebAppsResponse struct {
	// NextPageToken: If there are more results, a token to retrieve next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// WebApps: The list of web apps.
	WebApps []*WebApp `json:"webApps,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWebAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWebAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: The device location containing the latitude and longitude.
type Location struct {
	// Latitude: The latitude position of the location
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude position of the location
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Location) UnmarshalJSON(data []byte) error {
	type NoMethod Location
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// LogBufferSizeCriticalEvent: The usageLog buffer on the device has reached
// 90% of its capacity, therefore older events may be dropped. Intentionally
// empty.
type LogBufferSizeCriticalEvent struct {
}

// LoggingStartedEvent: usageLog policy has been enabled. Intentionally empty.
type LoggingStartedEvent struct {
}

// LoggingStoppedEvent: usageLog policy has been disabled. Intentionally empty.
type LoggingStoppedEvent struct {
}

// LostModeLocationEvent: A lost mode event containing the device location and
// battery level as a percentage.
type LostModeLocationEvent struct {
	// BatteryLevel: The battery level as a number between 0 and 100 inclusive
	BatteryLevel int64 `json:"batteryLevel,omitempty"`
	// Location: The device location
	Location *Location `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatteryLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatteryLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LostModeLocationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod LostModeLocationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LostModeOutgoingPhoneCallEvent: An event indicating an outgoing phone call
// has been made when a device is in lost mode. Intentionally empty.
type LostModeOutgoingPhoneCallEvent struct {
}

// ManagedConfigurationTemplate: The managed configurations template for the
// app, saved from the managed configurations iframe.
type ManagedConfigurationTemplate struct {
	// ConfigurationVariables: Optional, a map containing configuration variables
	// defined for the configuration.
	ConfigurationVariables map[string]string `json:"configurationVariables,omitempty"`
	// TemplateId: The ID of the managed configurations template.
	TemplateId string `json:"templateId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigurationVariables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigurationVariables") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedConfigurationTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedConfigurationTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedProperty: Managed property.
type ManagedProperty struct {
	// DefaultValue: The default value of the property. BUNDLE_ARRAY properties
	// don't have a default value.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// Description: A longer description of the property, providing more detail of
	// what it affects. Localized.
	Description string `json:"description,omitempty"`
	// Entries: For CHOICE or MULTISELECT properties, the list of possible entries.
	Entries []*ManagedPropertyEntry `json:"entries,omitempty"`
	// Key: The unique key that the app uses to identify the property, e.g.
	// "com.google.android.gm.fieldname".
	Key string `json:"key,omitempty"`
	// NestedProperties: For BUNDLE_ARRAY properties, the list of nested
	// properties. A BUNDLE_ARRAY property is at most two levels deep.
	NestedProperties []*ManagedProperty `json:"nestedProperties,omitempty"`
	// Title: The name of the property. Localized.
	Title string `json:"title,omitempty"`
	// Type: The type of the property.
	//
	// Possible values:
	//   "MANAGED_PROPERTY_TYPE_UNSPECIFIED" - Not used.
	//   "BOOL" - A property of boolean type.
	//   "STRING" - A property of string type.
	//   "INTEGER" - A property of integer type.
	//   "CHOICE" - A choice of one item from a set.
	//   "MULTISELECT" - A choice of multiple items from a set.
	//   "HIDDEN" - A hidden restriction of string type (the default value can be
	// used to pass along information that can't be modified, such as a version
	// code).
	//   "BUNDLE" - A bundle of properties
	//   "BUNDLE_ARRAY" - An array of property bundles.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedProperty) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedPropertyEntry: An entry of a managed property.
type ManagedPropertyEntry struct {
	// Name: The human-readable name of the value. Localized.
	Name string `json:"name,omitempty"`
	// Value: The machine-readable value of the entry, which should be used in the
	// configuration. Not localized.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedPropertyEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedPropertyEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MediaMountEvent: Removable media was mounted.
type MediaMountEvent struct {
	// MountPoint: Mount point.
	MountPoint string `json:"mountPoint,omitempty"`
	// VolumeLabel: Volume label. Redacted to empty string on organization-owned
	// managed profile devices.
	VolumeLabel string `json:"volumeLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MountPoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MountPoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MediaMountEvent) MarshalJSON() ([]byte, error) {
	type NoMethod MediaMountEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MediaUnmountEvent: Removable media was unmounted.
type MediaUnmountEvent struct {
	// MountPoint: Mount point.
	MountPoint string `json:"mountPoint,omitempty"`
	// VolumeLabel: Volume label. Redacted to empty string on organization-owned
	// managed profile devices.
	VolumeLabel string `json:"volumeLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MountPoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MountPoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MediaUnmountEvent) MarshalJSON() ([]byte, error) {
	type NoMethod MediaUnmountEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemoryEvent: An event related to memory and storage measurements.To
// distinguish between new and old events, we recommend using the createTime
// field.
type MemoryEvent struct {
	// ByteCount: The number of free bytes in the medium, or for
	// EXTERNAL_STORAGE_DETECTED, the total capacity in bytes of the storage
	// medium.
	ByteCount int64 `json:"byteCount,omitempty,string"`
	// CreateTime: The creation time of the event.
	CreateTime string `json:"createTime,omitempty"`
	// EventType: Event type.
	//
	// Possible values:
	//   "MEMORY_EVENT_TYPE_UNSPECIFIED" - Unspecified. No events have this type.
	//   "RAM_MEASURED" - Free space in RAM was measured.
	//   "INTERNAL_STORAGE_MEASURED" - Free space in internal storage was measured.
	//   "EXTERNAL_STORAGE_DETECTED" - A new external storage medium was detected.
	// The reported byte count is the total capacity of the storage medium.
	//   "EXTERNAL_STORAGE_REMOVED" - An external storage medium was removed. The
	// reported byte count is zero.
	//   "EXTERNAL_STORAGE_MEASURED" - Free space in an external storage medium was
	// measured.
	EventType string `json:"eventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ByteCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ByteCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemoryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemoryInfo: Information about device memory and storage.
type MemoryInfo struct {
	// TotalInternalStorage: Total internal storage on device in bytes.
	TotalInternalStorage int64 `json:"totalInternalStorage,omitempty,string"`
	// TotalRam: Total RAM on device in bytes.
	TotalRam int64 `json:"totalRam,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalInternalStorage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalInternalStorage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemoryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MigrationToken: A token to initiate the migration of a device from being
// managed by a third-party DPC to being managed by Android Management API. A
// migration token is valid only for a single device. See the guide
// (https://developers.google.com/android/management/dpc-migration) for more
// details.
type MigrationToken struct {
	// AdditionalData: Immutable. Optional EMM-specified additional data. Once the
	// device is migrated this will be populated in the migrationAdditionalData
	// field of the Device resource. This must be at most 1024 characters.
	AdditionalData string `json:"additionalData,omitempty"`
	// CreateTime: Output only. Time when this migration token was created.
	CreateTime string `json:"createTime,omitempty"`
	// Device: Output only. Once this migration token is used to migrate a device,
	// the name of the resulting Device resource will be populated here, in the
	// form enterprises/{enterprise}/devices/{device}.
	Device string `json:"device,omitempty"`
	// DeviceId: Required. Immutable. The id of the device, as in the Play EMM API.
	// This corresponds to the deviceId parameter in Play EMM API's Devices.get
	// (https://developers.google.com/android/work/play/emm-api/v1/devices/get#parameters)
	// call.
	DeviceId string `json:"deviceId,omitempty"`
	// ExpireTime: Immutable. The time when this migration token expires. This can
	// be at most seven days from the time of creation. The migration token is
	// deleted seven days after it expires.
	ExpireTime string `json:"expireTime,omitempty"`
	// ManagementMode: Required. Immutable. The management mode of the device or
	// profile being migrated.
	//
	// Possible values:
	//   "MANAGEMENT_MODE_UNSPECIFIED" - This value must not be used.
	//   "WORK_PROFILE_PERSONALLY_OWNED" - A work profile on a personally owned
	// device. Supported only on devices running Android 9 and above.
	//   "WORK_PROFILE_COMPANY_OWNED" - A work profile on a company-owned device.
	// Supported only on devices running Android 11 and above.
	//   "FULLY_MANAGED" - A fully-managed device. Supported only on devices
	// running Android 9 and above.
	ManagementMode string `json:"managementMode,omitempty"`
	// Name: Output only. The name of the migration token, which is generated by
	// the server during creation, in the form
	// enterprises/{enterprise}/migrationTokens/{migration_token}.
	Name string `json:"name,omitempty"`
	// Policy: Required. Immutable. The name of the policy initially applied to the
	// enrolled device, in the form enterprises/{enterprise}/policies/{policy}.
	Policy string `json:"policy,omitempty"`
	// Ttl: Input only. The time that this migration token is valid for. This is
	// input-only, and for returning a migration token the server will populate the
	// expireTime field. This can be at most seven days. The default is seven days.
	Ttl string `json:"ttl,omitempty"`
	// UserId: Required. Immutable. The user id of the Managed Google Play account
	// on the device, as in the Play EMM API. This corresponds to the userId
	// parameter in Play EMM API's Devices.get
	// (https://developers.google.com/android/work/play/emm-api/v1/devices/get#parameters)
	// call.
	UserId string `json:"userId,omitempty"`
	// Value: Output only. The value of the migration token.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdditionalData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MigrationToken) MarshalJSON() ([]byte, error) {
	type NoMethod MigrationToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyPolicyApplicationsRequest: Request to update or create
// ApplicationPolicy objects in the given Policy.
type ModifyPolicyApplicationsRequest struct {
	// Changes: Required. The changes to be made to the ApplicationPolicy objects.
	// There must be at least one ApplicationPolicyChange.
	Changes []*ApplicationPolicyChange `json:"changes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Changes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Changes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyPolicyApplicationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyPolicyApplicationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyPolicyApplicationsResponse: Response to a request to update or create
// ApplicationPolicy objects in the given policy.
type ModifyPolicyApplicationsResponse struct {
	// Policy: The updated policy.
	Policy *Policy `json:"policy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyPolicyApplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyPolicyApplicationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkInfo: Device network info.
type NetworkInfo struct {
	// Imei: IMEI number of the GSM device. For example, A1000031212.
	Imei string `json:"imei,omitempty"`
	// Meid: MEID number of the CDMA device. For example, A00000292788E1.
	Meid string `json:"meid,omitempty"`
	// NetworkOperatorName: Alphabetic name of current registered operator. For
	// example, Vodafone.
	NetworkOperatorName string `json:"networkOperatorName,omitempty"`
	// TelephonyInfos: Provides telephony information associated with each SIM card
	// on the device. Only supported on fully managed devices starting from Android
	// API level 23.
	TelephonyInfos []*TelephonyInfo `json:"telephonyInfos,omitempty"`
	// WifiMacAddress: Wi-Fi MAC address of the device. For example,
	// 7c:11:11:11:11:11.
	WifiMacAddress string `json:"wifiMacAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Imei") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Imei") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NonComplianceDetail: Provides detail about non-compliance with a policy
// setting.
type NonComplianceDetail struct {
	// CurrentValue: If the policy setting could not be applied, the current value
	// of the setting on the device.
	CurrentValue interface{} `json:"currentValue,omitempty"`
	// FieldPath: For settings with nested fields, if a particular nested field is
	// out of compliance, this specifies the full path to the offending field. The
	// path is formatted in the same way the policy JSON field would be referenced
	// in JavaScript, that is: 1) For object-typed fields, the field name is
	// followed by a dot then by a subfield name. 2) For array-typed fields, the
	// field name is followed by the array index enclosed in brackets. For example,
	// to indicate a problem with the url field in the externalData field in the
	// 3rd application, the path would be applications[2].externalData.url
	FieldPath string `json:"fieldPath,omitempty"`
	// InstallationFailureReason: If package_name is set and the non-compliance
	// reason is APP_NOT_INSTALLED or APP_NOT_UPDATED, the detailed reason the app
	// can't be installed or updated.
	//
	// Possible values:
	//   "INSTALLATION_FAILURE_REASON_UNSPECIFIED" - This value is disallowed.
	//   "INSTALLATION_FAILURE_REASON_UNKNOWN" - An unknown condition is preventing
	// the app from being installed. Some potential reasons are that the device
	// doesn't have enough storage, the device network connection is unreliable, or
	// the installation is taking longer than expected. The installation will be
	// retried automatically.
	//   "IN_PROGRESS" - The installation is still in progress.
	//   "NOT_FOUND" - The app was not found in Play.
	//   "NOT_COMPATIBLE_WITH_DEVICE" - The app is incompatible with the device.
	//   "NOT_APPROVED" - The app has not been approved by the admin.
	//   "PERMISSIONS_NOT_ACCEPTED" - The app has new permissions that have not
	// been accepted by the admin.
	//   "NOT_AVAILABLE_IN_COUNTRY" - The app is not available in the user's
	// country.
	//   "NO_LICENSES_REMAINING" - There are no licenses available to assign to the
	// user.
	//   "NOT_ENROLLED" - The enterprise is no longer enrolled with Managed Google
	// Play or the admin has not accepted the latest Managed Google Play Terms of
	// Service.
	//   "USER_INVALID" - The user is no longer valid. The user may have been
	// deleted or disabled.
	//   "NETWORK_ERROR_UNRELIABLE_CONNECTION" - A network error on the user's
	// device has prevented the install from succeeding. This usually happens when
	// the device's internet connectivity is degraded, unavailable or there's a
	// network configuration issue. Please ensure the device has access to full
	// internet connectivity on a network that meets Android Enterprise Network
	// Requirements (https://support.google.com/work/android/answer/10513641). App
	// install or update will automatically resume once this is the case.
	//   "INSUFFICIENT_STORAGE" - The user's device does not have sufficient
	// storage space to install the app. This can be resolved by clearing up
	// storage space on the device. App install or update will automatically resume
	// once the device has sufficient storage.
	InstallationFailureReason string `json:"installationFailureReason,omitempty"`
	// NonComplianceReason: The reason the device is not in compliance with the
	// setting.
	//
	// Possible values:
	//   "NON_COMPLIANCE_REASON_UNSPECIFIED" - This value is not used.
	//   "API_LEVEL" - The setting is not supported in the API level of the Android
	// version running on the device.
	//   "MANAGEMENT_MODE" - The management mode (such as fully managed or work
	// profile) doesn't support the setting.
	//   "USER_ACTION" - The user has not taken required action to comply with the
	// setting.
	//   "INVALID_VALUE" - The setting has an invalid value.
	//   "APP_NOT_INSTALLED" - The app required to implement the policy is not
	// installed.
	//   "UNSUPPORTED" - The policy is not supported by the version of Android
	// Device Policy on the device.
	//   "APP_INSTALLED" - A blocked app is installed.
	//   "PENDING" - The setting hasn't been applied at the time of the report, but
	// is expected to be applied shortly.
	//   "APP_INCOMPATIBLE" - The setting can't be applied to the app because the
	// app doesn't support it, for example because its target SDK version is not
	// high enough.
	//   "APP_NOT_UPDATED" - The app is installed, but it hasn't been updated to
	// the minimum version code specified by policy.
	//   "DEVICE_INCOMPATIBLE" - The device is incompatible with the policy
	// requirements.
	//   "APP_SIGNING_CERT_MISMATCH" - The app's signing certificate does not match
	// the setting value.
	//   "PROJECT_NOT_PERMITTED" - The Google Cloud Platform project used to manage
	// the device is not permitted to use this policy.
	NonComplianceReason string `json:"nonComplianceReason,omitempty"`
	// PackageName: The package name indicating which app is out of compliance, if
	// applicable.
	PackageName string `json:"packageName,omitempty"`
	// SettingName: The name of the policy setting. This is the JSON field name of
	// a top-level Policy field.
	SettingName string `json:"settingName,omitempty"`
	// SpecificNonComplianceContext: Additional context for
	// specific_non_compliance_reason.
	SpecificNonComplianceContext *SpecificNonComplianceContext `json:"specificNonComplianceContext,omitempty"`
	// SpecificNonComplianceReason: The policy-specific reason the device is not in
	// compliance with the setting.
	//
	// Possible values:
	//   "SPECIFIC_NON_COMPLIANCE_REASON_UNSPECIFIED" - Specific non-compliance
	// reason is not specified. Fields in specific_non_compliance_context are not
	// set.
	//   "PASSWORD_POLICIES_USER_CREDENTIALS_CONFIRMATION_REQUIRED" - User needs to
	// confirm credentials by entering the screen lock. Fields in
	// specific_non_compliance_context are not set. nonComplianceReason is set to
	// USER_ACTION.
	//   "PASSWORD_POLICIES_PASSWORD_EXPIRED" - The device or profile password has
	// expired. passwordPoliciesContext is set. nonComplianceReason is set to
	// USER_ACTION.
	//   "PASSWORD_POLICIES_PASSWORD_NOT_SUFFICIENT" - The device password does not
	// satisfy password requirements. passwordPoliciesContext is set.
	// nonComplianceReason is set to USER_ACTION.
	//   "ONC_WIFI_INVALID_VALUE" - There is an incorrect value in ONC Wi-Fi
	// configuration. fieldPath specifies which field value is incorrect.
	// oncWifiContext is set. nonComplianceReason is set to INVALID_VALUE.
	//   "ONC_WIFI_API_LEVEL" - The ONC Wi-Fi setting is not supported in the API
	// level of the Android version running on the device. fieldPath specifies
	// which field value is not supported. oncWifiContext is set.
	// nonComplianceReason is set to API_LEVEL.
	//   "ONC_WIFI_INVALID_ENTERPRISE_CONFIG" - The enterprise Wi-Fi network is
	// missing either the root CA or domain name. nonComplianceReason is set to
	// INVALID_VALUE.
	//   "ONC_WIFI_USER_SHOULD_REMOVE_NETWORK" - User needs to remove the
	// configured Wi-Fi network manually. This is applicable only on work profiles
	// on personally-owned devices. nonComplianceReason is set to USER_ACTION.
	//   "ONC_WIFI_KEY_PAIR_ALIAS_NOT_CORRESPONDING_TO_EXISTING_KEY" - Key pair
	// alias specified via ClientCertKeyPairAlias
	// (https://chromium.googlesource.com/chromium/src/+/main/components/onc/docs/onc_spec.md#eap-type)
	// field in openNetworkConfiguration does not correspond to an existing key
	// installed on the device. nonComplianceReason is set to INVALID_VALUE.
	//   "PERMISSIBLE_USAGE_RESTRICTION" - This policy setting is restricted and
	// cannot be set for this Google Cloud Platform project. More details
	// (including how to enable usage of this policy setting) are available in the
	// Permissible Usage policy
	// (https://developers.google.com/android/management/permissible-usage).
	// nonComplianceReason is set to PROJECT_NOT_PERMITTED.
	//   "REQUIRED_ACCOUNT_NOT_IN_ENTERPRISE" - Work account required by the
	// workAccountSetupConfig policy setting is not part of the enterprise anymore.
	// nonComplianceReason is set to USER_ACTION.
	//   "NEW_ACCOUNT_NOT_IN_ENTERPRISE" - Work account added by the user is not
	// part of the enterprise. nonComplianceReason is set to USER_ACTION.
	//   "DEFAULT_APPLICATION_SETTING_UNSUPPORTED_SCOPES" - The default application
	// setting is applied to the scopes that are not supported by the management
	// mode, even if the management mode itself is supported for the app type
	// (e.g., a policy with DEFAULT_BROWSER app type and SCOPE_PERSONAL_PROFILE
	// list sent to a fully managed device results in the scopes being inapplicable
	// for the management mode). If the management mode is not supported for the
	// app type, a NonComplianceDetail with MANAGEMENT_MODE is reported, without a
	// specificNonComplianceReason.nonComplianceReason is set to MANAGEMENT_MODE.
	//   "DEFAULT_APPLICATION_SETTING_FAILED_FOR_SCOPE" - The default application
	// setting failed to apply for a specific scope. defaultApplicationContext is
	// set. nonComplianceReason is set to INVALID_VALUE or APP_NOT_INSTALLED.
	//   "PRIVATE_DNS_HOST_NOT_SERVING" - The specified host for private DNS is a
	// valid hostname but was found to not be a private DNS server.
	// nonComplianceReason is set to INVALID_VALUE.
	SpecificNonComplianceReason string `json:"specificNonComplianceReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NonComplianceDetail) MarshalJSON() ([]byte, error) {
	type NoMethod NonComplianceDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NonComplianceDetailCondition: A compliance rule condition which is satisfied
// if there exists any matching NonComplianceDetail for the device. A
// NonComplianceDetail matches a NonComplianceDetailCondition if all the fields
// which are set within the NonComplianceDetailCondition match the
// corresponding NonComplianceDetail fields.
type NonComplianceDetailCondition struct {
	// NonComplianceReason: The reason the device is not in compliance with the
	// setting. If not set, then this condition matches any reason.
	//
	// Possible values:
	//   "NON_COMPLIANCE_REASON_UNSPECIFIED" - This value is not used.
	//   "API_LEVEL" - The setting is not supported in the API level of the Android
	// version running on the device.
	//   "MANAGEMENT_MODE" - The management mode (such as fully managed or work
	// profile) doesn't support the setting.
	//   "USER_ACTION" - The user has not taken required action to comply with the
	// setting.
	//   "INVALID_VALUE" - The setting has an invalid value.
	//   "APP_NOT_INSTALLED" - The app required to implement the policy is not
	// installed.
	//   "UNSUPPORTED" - The policy is not supported by the version of Android
	// Device Policy on the device.
	//   "APP_INSTALLED" - A blocked app is installed.
	//   "PENDING" - The setting hasn't been applied at the time of the report, but
	// is expected to be applied shortly.
	//   "APP_INCOMPATIBLE" - The setting can't be applied to the app because the
	// app doesn't support it, for example because its target SDK version is not
	// high enough.
	//   "APP_NOT_UPDATED" - The app is installed, but it hasn't been updated to
	// the minimum version code specified by policy.
	//   "DEVICE_INCOMPATIBLE" - The device is incompatible with the policy
	// requirements.
	//   "APP_SIGNING_CERT_MISMATCH" - The app's signing certificate does not match
	// the setting value.
	//   "PROJECT_NOT_PERMITTED" - The Google Cloud Platform project used to manage
	// the device is not permitted to use this policy.
	NonComplianceReason string `json:"nonComplianceReason,omitempty"`
	// PackageName: The package name of the app that's out of compliance. If not
	// set, then this condition matches any package name.
	PackageName string `json:"packageName,omitempty"`
	// SettingName: The name of the policy setting. This is the JSON field name of
	// a top-level Policy field. If not set, then this condition matches any
	// setting name.
	SettingName string `json:"settingName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NonComplianceReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NonComplianceReason") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NonComplianceDetailCondition) MarshalJSON() ([]byte, error) {
	type NoMethod NonComplianceDetailCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OncCertificateProvider: This feature is not generally available.
type OncCertificateProvider struct {
	// CertificateReferences: This feature is not generally available.
	CertificateReferences []string `json:"certificateReferences,omitempty"`
	// ContentProviderEndpoint: This feature is not generally available.
	ContentProviderEndpoint *ContentProviderEndpoint `json:"contentProviderEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateReferences") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OncCertificateProvider) MarshalJSON() ([]byte, error) {
	type NoMethod OncCertificateProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OncWifiContext: Additional context for non-compliance related to Wi-Fi
// configuration.
type OncWifiContext struct {
	// WifiGuid: The GUID of non-compliant Wi-Fi configuration.
	WifiGuid string `json:"wifiGuid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WifiGuid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WifiGuid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OncWifiContext) MarshalJSON() ([]byte, error) {
	type NoMethod OncWifiContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is false, it means the operation is still in progress. If
	// true, the operation is completed, and either error or response is available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the name
	// should be a resource name ending with operations/{unique_id}.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as Delete, the response is
	// google.protobuf.Empty. If the original method is standard Get/Create/Update,
	// the response should be the resource. For other methods, the response should
	// have the type XxxResponse, where Xxx is the original method name. For
	// example, if the original method name is TakeSnapshot(), the inferred
	// response type is TakeSnapshotResponse.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OsShutdownEvent: Device was shutdown. Intentionally empty.
type OsShutdownEvent struct {
}

// OsStartupEvent: Device was started.
type OsStartupEvent struct {
	// VerifiedBootState: Verified Boot state.
	//
	// Possible values:
	//   "VERIFIED_BOOT_STATE_UNSPECIFIED" - Unknown value.
	//   "GREEN" - Indicates that there is a full chain of trust extending from the
	// bootloader to verified partitions including the bootloader, boot partition,
	// and all verified partitions.
	//   "YELLOW" - Indicates that the boot partition has been verified using the
	// embedded certificate and the signature is valid.
	//   "ORANGE" - Indicates that the device may be freely modified. Device
	// integrity is left to the user to verify out-of-band.
	VerifiedBootState string `json:"verifiedBootState,omitempty"`
	// VerityMode: dm-verity mode.
	//
	// Possible values:
	//   "DM_VERITY_MODE_UNSPECIFIED" - Unknown value.
	//   "ENFORCING" - Indicates that the device will be restarted when corruption
	// is detected.
	//   "IO_ERROR" - Indicates that an I/O error will be returned for an attempt
	// to read corrupted data blocks (also known as eio boot state).
	//   "DISABLED" - Indicates that dm-verity is disabled on device.
	VerityMode string `json:"verityMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VerifiedBootState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VerifiedBootState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OsStartupEvent) MarshalJSON() ([]byte, error) {
	type NoMethod OsStartupEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PackageNameList: A list of package names.
type PackageNameList struct {
	// PackageNames: A list of package names.
	PackageNames []string `json:"packageNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PackageNameList) MarshalJSON() ([]byte, error) {
	type NoMethod PackageNameList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PasswordPoliciesContext: Additional context for non-compliance related to
// password policies.
type PasswordPoliciesContext struct {
	// PasswordPolicyScope: The scope of non-compliant password.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - The scope is unspecified. The password requirements
	// are applied to the work profile for work profile devices and the whole
	// device for fully managed or dedicated devices.
	//   "SCOPE_DEVICE" - The password requirements are only applied to the device.
	//   "SCOPE_PROFILE" - The password requirements are only applied to the work
	// profile.
	PasswordPolicyScope string `json:"passwordPolicyScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PasswordPolicyScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PasswordPolicyScope") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PasswordPoliciesContext) MarshalJSON() ([]byte, error) {
	type NoMethod PasswordPoliciesContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PasswordRequirements: Requirements for the password used to unlock a device.
type PasswordRequirements struct {
	// MaximumFailedPasswordsForWipe: Number of incorrect device-unlock passwords
	// that can be entered before a device is wiped. A value of 0 means there is no
	// restriction.
	MaximumFailedPasswordsForWipe int64 `json:"maximumFailedPasswordsForWipe,omitempty"`
	// PasswordExpirationTimeout: Password expiration timeout.
	PasswordExpirationTimeout string `json:"passwordExpirationTimeout,omitempty"`
	// PasswordHistoryLength: The length of the password history. After setting
	// this field, the user won't be able to enter a new password that is the same
	// as any password in the history. A value of 0 means there is no restriction.
	PasswordHistoryLength int64 `json:"passwordHistoryLength,omitempty"`
	// PasswordMinimumLength: The minimum allowed password length. A value of 0
	// means there is no restriction. Only enforced when password_quality is
	// NUMERIC, NUMERIC_COMPLEX, ALPHABETIC, ALPHANUMERIC, or COMPLEX.
	PasswordMinimumLength int64 `json:"passwordMinimumLength,omitempty"`
	// PasswordMinimumLetters: Minimum number of letters required in the password.
	// Only enforced when password_quality is COMPLEX.
	PasswordMinimumLetters int64 `json:"passwordMinimumLetters,omitempty"`
	// PasswordMinimumLowerCase: Minimum number of lower case letters required in
	// the password. Only enforced when password_quality is COMPLEX.
	PasswordMinimumLowerCase int64 `json:"passwordMinimumLowerCase,omitempty"`
	// PasswordMinimumNonLetter: Minimum number of non-letter characters (numerical
	// digits or symbols) required in the password. Only enforced when
	// password_quality is COMPLEX.
	PasswordMinimumNonLetter int64 `json:"passwordMinimumNonLetter,omitempty"`
	// PasswordMinimumNumeric: Minimum number of numerical digits required in the
	// password. Only enforced when password_quality is COMPLEX.
	PasswordMinimumNumeric int64 `json:"passwordMinimumNumeric,omitempty"`
	// PasswordMinimumSymbols: Minimum number of symbols required in the password.
	// Only enforced when password_quality is COMPLEX.
	PasswordMinimumSymbols int64 `json:"passwordMinimumSymbols,omitempty"`
	// PasswordMinimumUpperCase: Minimum number of upper case letters required in
	// the password. Only enforced when password_quality is COMPLEX.
	PasswordMinimumUpperCase int64 `json:"passwordMinimumUpperCase,omitempty"`
	// PasswordQuality: The required password quality.
	//
	// Possible values:
	//   "PASSWORD_QUALITY_UNSPECIFIED" - There are no password requirements.
	//   "BIOMETRIC_WEAK" - The device must be secured with a low-security
	// biometric recognition technology, at minimum. This includes technologies
	// that can recognize the identity of an individual that are roughly equivalent
	// to a 3-digit PIN (false detection is less than 1 in 1,000).This, when
	// applied on personally owned work profile devices on Android 12
	// device-scoped, will be treated as COMPLEXITY_LOW for application. See
	// PasswordQuality for details.
	//   "SOMETHING" - A password is required, but there are no restrictions on
	// what the password must contain.This, when applied on personally owned work
	// profile devices on Android 12 device-scoped, will be treated as
	// COMPLEXITY_LOW for application. See PasswordQuality for details.
	//   "NUMERIC" - The password must contain numeric characters.This, when
	// applied on personally owned work profile devices on Android 12
	// device-scoped, will be treated as COMPLEXITY_MEDIUM for application. See
	// PasswordQuality for details.
	//   "NUMERIC_COMPLEX" - The password must contain numeric characters with no
	// repeating (4444) or ordered (1234, 4321, 2468) sequences.This, when applied
	// on personally owned work profile devices on Android 12 device-scoped, will
	// be treated as COMPLEXITY_MEDIUM for application. See PasswordQuality for
	// details.
	//   "ALPHABETIC" - The password must contain alphabetic (or symbol)
	// characters.This, when applied on personally owned work profile devices on
	// Android 12 device-scoped, will be treated as COMPLEXITY_HIGH for
	// application. See PasswordQuality for details.
	//   "ALPHANUMERIC" - The password must contain both numeric and alphabetic (or
	// symbol) characters.This, when applied on personally owned work profile
	// devices on Android 12 device-scoped, will be treated as COMPLEXITY_HIGH for
	// application. See PasswordQuality for details.
	//   "COMPLEX" - The password must meet the minimum requirements specified in
	// passwordMinimumLength, passwordMinimumLetters, passwordMinimumSymbols, etc.
	// For example, if passwordMinimumSymbols is 2, the password must contain at
	// least two symbols.This, when applied on personally owned work profile
	// devices on Android 12 device-scoped, will be treated as COMPLEXITY_HIGH for
	// application. In this case, the requirements in passwordMinimumLength,
	// passwordMinimumLetters, passwordMinimumSymbols, etc are not applied. See
	// PasswordQuality for details.
	//   "COMPLEXITY_LOW" - Define the low password complexity band as: pattern PIN
	// with repeating (4444) or ordered (1234, 4321, 2468) sequencesThis sets the
	// minimum complexity band which the password must meet.Enforcement varies
	// among different Android versions, management modes and password scopes. See
	// PasswordQuality for details.
	//   "COMPLEXITY_MEDIUM" - Define the medium password complexity band as: PIN
	// with no repeating (4444) or ordered (1234, 4321, 2468) sequences, length at
	// least 4 alphabetic, length at least 4 alphanumeric, length at least 4This
	// sets the minimum complexity band which the password must meet.Enforcement
	// varies among different Android versions, management modes and password
	// scopes. See PasswordQuality for details.
	//   "COMPLEXITY_HIGH" - Define the high password complexity band as:On Android
	// 12 and above: PIN with no repeating (4444) or ordered (1234, 4321, 2468)
	// sequences, length at least 8 alphabetic, length at least 6 alphanumeric,
	// length at least 6This sets the minimum complexity band which the password
	// must meet.Enforcement varies among different Android versions, management
	// modes and password scopes. See PasswordQuality for details.
	PasswordQuality string `json:"passwordQuality,omitempty"`
	// PasswordScope: The scope that the password requirement applies to.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - The scope is unspecified. The password requirements
	// are applied to the work profile for work profile devices and the whole
	// device for fully managed or dedicated devices.
	//   "SCOPE_DEVICE" - The password requirements are only applied to the device.
	//   "SCOPE_PROFILE" - The password requirements are only applied to the work
	// profile.
	PasswordScope string `json:"passwordScope,omitempty"`
	// RequirePasswordUnlock: The length of time after a device or work profile is
	// unlocked using a strong form of authentication (password, PIN, pattern) that
	// it can be unlocked using any other authentication method (e.g. fingerprint,
	// trust agents, face). After the specified time period elapses, only strong
	// forms of authentication can be used to unlock the device or work profile.
	//
	// Possible values:
	//   "REQUIRE_PASSWORD_UNLOCK_UNSPECIFIED" - Unspecified. Defaults to
	// USE_DEFAULT_DEVICE_TIMEOUT.
	//   "USE_DEFAULT_DEVICE_TIMEOUT" - The timeout period is set to the device’s
	// default.
	//   "REQUIRE_EVERY_DAY" - The timeout period is set to 24 hours.
	RequirePasswordUnlock string `json:"requirePasswordUnlock,omitempty"`
	// UnifiedLockSettings: Controls whether a unified lock is allowed for the
	// device and the work profile, on devices running Android 9 and above with a
	// work profile. This can be set only if password_scope is set to
	// SCOPE_PROFILE, the policy will be rejected otherwise. If user has not set a
	// separate work lock and this field is set to REQUIRE_SEPARATE_WORK_LOCK, a
	// NonComplianceDetail is reported with nonComplianceReason set to USER_ACTION.
	//
	// Possible values:
	//   "UNIFIED_LOCK_SETTINGS_UNSPECIFIED" - Unspecified. Defaults to
	// ALLOW_UNIFIED_WORK_AND_PERSONAL_LOCK.
	//   "ALLOW_UNIFIED_WORK_AND_PERSONAL_LOCK" - A common lock for the device and
	// the work profile is allowed.
	//   "REQUIRE_SEPARATE_WORK_LOCK" - A separate lock for the work profile is
	// required.
	UnifiedLockSettings string `json:"unifiedLockSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "MaximumFailedPasswordsForWipe") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaximumFailedPasswordsForWipe")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PasswordRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod PasswordRequirements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerAppResult: The result of an attempt to clear the data of a single app.
type PerAppResult struct {
	// ClearingResult: The result of an attempt to clear the data of a single app.
	//
	// Possible values:
	//   "CLEARING_RESULT_UNSPECIFIED" - Unspecified result.
	//   "SUCCESS" - This app’s data was successfully cleared.
	//   "APP_NOT_FOUND" - This app’s data could not be cleared because the app
	// was not found.
	//   "APP_PROTECTED" - This app’s data could not be cleared because the app
	// is protected. For example, this may apply to apps critical to the
	// functioning of the device, such as Google Play Store.
	//   "API_LEVEL" - This app’s data could not be cleared because the device
	// API level does not support this command.
	ClearingResult string `json:"clearingResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClearingResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClearingResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerAppResult) MarshalJSON() ([]byte, error) {
	type NoMethod PerAppResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PermissionGrant: Configuration for an Android permission and its grant
// state.
type PermissionGrant struct {
	// Permission: The Android permission or group, e.g.
	// android.permission.READ_CALENDAR or android.permission_group.CALENDAR.
	Permission string `json:"permission,omitempty"`
	// Policy: The policy for granting the permission.
	//
	// Possible values:
	//   "PERMISSION_POLICY_UNSPECIFIED" - Policy not specified. If no policy is
	// specified for a permission at any level, then the PROMPT behavior is used by
	// default.
	//   "PROMPT" - Prompt the user to grant a permission.
	//   "GRANT" - Automatically grant a permission.On Android 12 and above,
	// READ_SMS
	// (https://developer.android.com/reference/android/Manifest.permission#READ_SMS)
	// and following sensor-related permissions can only be granted on fully
	// managed devices: ACCESS_FINE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION)
	// ACCESS_BACKGROUND_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_BACKGROUND_LOCATION)
	// ACCESS_COARSE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_COARSE_LOCATION)
	// CAMERA
	// (https://developer.android.com/reference/android/Manifest.permission#CAMERA)
	// RECORD_AUDIO
	// (https://developer.android.com/reference/android/Manifest.permission#RECORD_AUDIO)
	// ACTIVITY_RECOGNITION
	// (https://developer.android.com/reference/android/Manifest.permission#ACTIVITY_RECOGNITION)
	// BODY_SENSORS
	// (https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS)
	//   "DENY" - Automatically deny a permission.
	Policy string `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permission") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permission") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PermissionGrant) MarshalJSON() ([]byte, error) {
	type NoMethod PermissionGrant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PersistentPreferredActivity: A default activity for handling intents that
// match a particular intent filter. Note: To set up a kiosk, use InstallType
// to KIOSK rather than use persistent preferred activities.
type PersistentPreferredActivity struct {
	// Actions: The intent actions to match in the filter. If any actions are
	// included in the filter, then an intent's action must be one of those values
	// for it to match. If no actions are included, the intent action is ignored.
	Actions []string `json:"actions,omitempty"`
	// Categories: The intent categories to match in the filter. An intent includes
	// the categories that it requires, all of which must be included in the filter
	// in order to match. In other words, adding a category to the filter has no
	// impact on matching unless that category is specified in the intent.
	Categories []string `json:"categories,omitempty"`
	// ReceiverActivity: The activity that should be the default intent handler.
	// This should be an Android component name, e.g.
	// com.android.enterprise.app/.MainActivity. Alternatively, the value may be
	// the package name of an app, which causes Android Device Policy to choose an
	// appropriate activity from the app to handle the intent.
	ReceiverActivity string `json:"receiverActivity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PersistentPreferredActivity) MarshalJSON() ([]byte, error) {
	type NoMethod PersistentPreferredActivity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PersonalApplicationPolicy: Policies for apps in the personal profile of a
// company-owned device with a work profile.
type PersonalApplicationPolicy struct {
	// InstallType: The type of installation to perform.
	//
	// Possible values:
	//   "INSTALL_TYPE_UNSPECIFIED" - Unspecified. Defaults to AVAILABLE.
	//   "BLOCKED" - The app is blocked and can't be installed in the personal
	// profile. If the app was previously installed in the device, it will be
	// uninstalled.
	//   "AVAILABLE" - The app is available to install in the personal profile.
	InstallType string `json:"installType,omitempty"`
	// PackageName: The package name of the application.
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstallType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstallType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PersonalApplicationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod PersonalApplicationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PersonalUsagePolicies: Policies controlling personal usage on a
// company-owned device with a work profile.
type PersonalUsagePolicies struct {
	// AccountTypesWithManagementDisabled: Account types that can't be managed by
	// the user.
	AccountTypesWithManagementDisabled []string `json:"accountTypesWithManagementDisabled,omitempty"`
	// BluetoothSharing: Optional. Whether bluetooth sharing is allowed.
	//
	// Possible values:
	//   "BLUETOOTH_SHARING_UNSPECIFIED" - Unspecified. Defaults to
	// BLUETOOTH_SHARING_ALLOWED.
	//   "BLUETOOTH_SHARING_ALLOWED" - Bluetooth sharing is allowed on personal
	// profile.Supported on Android 8 and above. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported if this is set for a personal device.
	//   "BLUETOOTH_SHARING_DISALLOWED" - Bluetooth sharing is disallowed on
	// personal profile.Supported on Android 8 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 8. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported if this is set for a
	// personal device.
	BluetoothSharing string `json:"bluetoothSharing,omitempty"`
	// CameraDisabled: If true, the camera is disabled on the personal profile.
	CameraDisabled bool `json:"cameraDisabled,omitempty"`
	// MaxDaysWithWorkOff: Controls how long the work profile can stay off. The
	// minimum duration must be at least 3 days. Other details are as follows: - If
	// the duration is set to 0, the feature is turned off. - If the duration is
	// set to a value smaller than the minimum duration, the feature returns an
	// error. *Note:* If you want to avoid personal profiles being suspended during
	// long periods of off-time, you can temporarily set a large value for this
	// parameter.
	MaxDaysWithWorkOff int64 `json:"maxDaysWithWorkOff,omitempty"`
	// PersonalApplications: Policy applied to applications in the personal
	// profile.
	PersonalApplications []*PersonalApplicationPolicy `json:"personalApplications,omitempty"`
	// PersonalPlayStoreMode: Used together with personalApplications to control
	// how apps in the personal profile are allowed or blocked.
	//
	// Possible values:
	//   "PLAY_STORE_MODE_UNSPECIFIED" - Unspecified. Defaults to BLOCKLIST.
	//   "BLACKLIST" - All Play Store apps are available for installation in the
	// personal profile, except those whose installType is BLOCKED in
	// personalApplications.
	//   "BLOCKLIST" - All Play Store apps are available for installation in the
	// personal profile, except those whose installType is BLOCKED in
	// personalApplications.
	//   "ALLOWLIST" - Only apps explicitly specified in personalApplications with
	// installType set to AVAILABLE are allowed to be installed in the personal
	// profile.
	PersonalPlayStoreMode string `json:"personalPlayStoreMode,omitempty"`
	// PrivateSpacePolicy: Optional. Controls whether a private space is allowed on
	// the device.
	//
	// Possible values:
	//   "PRIVATE_SPACE_POLICY_UNSPECIFIED" - Unspecified. Defaults to
	// PRIVATE_SPACE_ALLOWED.
	//   "PRIVATE_SPACE_ALLOWED" - Users can create a private space profile.
	//   "PRIVATE_SPACE_DISALLOWED" - Users cannot create a private space profile.
	// Supported only for company-owned devices with a work profile. Caution: Any
	// existing private space will be removed.
	PrivateSpacePolicy string `json:"privateSpacePolicy,omitempty"`
	// ScreenCaptureDisabled: If true, screen capture is disabled for all users.
	ScreenCaptureDisabled bool `json:"screenCaptureDisabled,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AccountTypesWithManagementDisabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AccountTypesWithManagementDisabled") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s PersonalUsagePolicies) MarshalJSON() ([]byte, error) {
	type NoMethod PersonalUsagePolicies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: A policy resource represents a group of settings that govern the
// behavior of a managed device and the apps installed on it.
type Policy struct {
	// AccountTypesWithManagementDisabled: Account types that can't be managed by
	// the user.
	AccountTypesWithManagementDisabled []string `json:"accountTypesWithManagementDisabled,omitempty"`
	// AddUserDisabled: Whether adding new users and profiles is disabled. For
	// devices where managementMode is DEVICE_OWNER this field is ignored and the
	// user is never allowed to add or remove users.
	AddUserDisabled bool `json:"addUserDisabled,omitempty"`
	// AdjustVolumeDisabled: Whether adjusting the master volume is disabled. Also
	// mutes the device. The setting has effect only on fully managed devices.
	AdjustVolumeDisabled bool `json:"adjustVolumeDisabled,omitempty"`
	// AdvancedSecurityOverrides: Advanced security settings. In most cases,
	// setting these is not needed.
	AdvancedSecurityOverrides *AdvancedSecurityOverrides `json:"advancedSecurityOverrides,omitempty"`
	// AlwaysOnVpnPackage: Configuration for an always-on VPN connection. Use with
	// vpn_config_disabled to prevent modification of this setting.
	AlwaysOnVpnPackage *AlwaysOnVpnPackage `json:"alwaysOnVpnPackage,omitempty"`
	// AndroidDevicePolicyTracks: This setting is not supported. Any value is
	// ignored.
	//
	// Possible values:
	//   "APP_TRACK_UNSPECIFIED" - This value is ignored.
	//   "PRODUCTION" - The production track, which provides the latest stable
	// release.
	//   "BETA" - The beta track, which provides the latest beta release.
	AndroidDevicePolicyTracks []string `json:"androidDevicePolicyTracks,omitempty"`
	// AppAutoUpdatePolicy: Recommended alternative: autoUpdateMode which is set
	// per app, provides greater flexibility around update frequency.When
	// autoUpdateMode is set to AUTO_UPDATE_POSTPONED or AUTO_UPDATE_HIGH_PRIORITY,
	// this field has no effect.The app auto update policy, which controls when
	// automatic app updates can be applied.
	//
	// Possible values:
	//   "APP_AUTO_UPDATE_POLICY_UNSPECIFIED" - The auto-update policy is not set.
	// Equivalent to CHOICE_TO_THE_USER.
	//   "CHOICE_TO_THE_USER" - The user can control auto-updates.
	//   "NEVER" - Apps are never auto-updated.
	//   "WIFI_ONLY" - Apps are auto-updated over Wi-Fi only.
	//   "ALWAYS" - Apps are auto-updated at any time. Data charges may apply.
	AppAutoUpdatePolicy string `json:"appAutoUpdatePolicy,omitempty"`
	// AppFunctions: Optional. Controls whether apps on the device for fully
	// managed devices or in the work profile for devices with work profiles are
	// allowed to expose app functions.
	//
	// Possible values:
	//   "APP_FUNCTIONS_UNSPECIFIED" - Unspecified. Defaults to
	// APP_FUNCTIONS_ALLOWED.
	//   "APP_FUNCTIONS_DISALLOWED" - Apps on the device for fully managed devices
	// or in the work profile for devices with work profiles are not allowed to
	// expose app functions. If this is set, crossProfileAppFunctions must not be
	// set to CROSS_PROFILE_APP_FUNCTIONS_ALLOWED, otherwise the policy will be
	// rejected.
	//   "APP_FUNCTIONS_ALLOWED" - Apps on the device for fully managed devices or
	// in the work profile for devices with work profiles are allowed to expose app
	// functions.
	AppFunctions string `json:"appFunctions,omitempty"`
	// Applications: Policy applied to apps. This can have at most 3,000 elements.
	Applications []*ApplicationPolicy `json:"applications,omitempty"`
	// AssistContentPolicy: Optional. Controls whether AssistContent
	// (https://developer.android.com/reference/android/app/assist/AssistContent)
	// is allowed to be sent to a privileged app such as an assistant app.
	// AssistContent includes screenshots and information about an app, such as
	// package name. This is supported on Android 15 and above.
	//
	// Possible values:
	//   "ASSIST_CONTENT_POLICY_UNSPECIFIED" - Unspecified. Defaults to
	// ASSIST_CONTENT_ALLOWED.
	//   "ASSIST_CONTENT_DISALLOWED" - Assist content is blocked from being sent to
	// a privileged app.Supported on Android 15 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 15.
	//   "ASSIST_CONTENT_ALLOWED" - Assist content is allowed to be sent to a
	// privileged app.Supported on Android 15 and above.
	AssistContentPolicy string `json:"assistContentPolicy,omitempty"`
	// AutoDateAndTimeZone: Whether auto date, time, and time zone are enabled on a
	// company-owned device. If this is set, then autoTimeRequired is ignored.
	//
	// Possible values:
	//   "AUTO_DATE_AND_TIME_ZONE_UNSPECIFIED" - Unspecified. Defaults to
	// AUTO_DATE_AND_TIME_ZONE_USER_CHOICE.
	//   "AUTO_DATE_AND_TIME_ZONE_USER_CHOICE" - Auto date, time, and time zone are
	// left to user's choice.
	//   "AUTO_DATE_AND_TIME_ZONE_ENFORCED" - Enforce auto date, time, and time
	// zone on the device.
	AutoDateAndTimeZone string `json:"autoDateAndTimeZone,omitempty"`
	// AutoTimeRequired: Whether auto time is required, which prevents the user
	// from manually setting the date and time. If autoDateAndTimeZone is set, this
	// field is ignored.
	AutoTimeRequired bool `json:"autoTimeRequired,omitempty"`
	// BlockApplicationsEnabled: Whether applications other than the ones
	// configured in applications are blocked from being installed. When set,
	// applications that were installed under a previous policy but no longer
	// appear in the policy are automatically uninstalled.
	BlockApplicationsEnabled bool `json:"blockApplicationsEnabled,omitempty"`
	// BluetoothConfigDisabled: Whether configuring bluetooth is disabled.
	BluetoothConfigDisabled bool `json:"bluetoothConfigDisabled,omitempty"`
	// BluetoothContactSharingDisabled: Whether bluetooth contact sharing is
	// disabled.
	BluetoothContactSharingDisabled bool `json:"bluetoothContactSharingDisabled,omitempty"`
	// BluetoothDisabled: Whether bluetooth is disabled. Prefer this setting over
	// bluetooth_config_disabled because bluetooth_config_disabled can be bypassed
	// by the user.
	BluetoothDisabled bool `json:"bluetoothDisabled,omitempty"`
	// CameraAccess: Controls the use of the camera and whether the user has access
	// to the camera access toggle.
	//
	// Possible values:
	//   "CAMERA_ACCESS_UNSPECIFIED" - If camera_disabled is true, this is
	// equivalent to CAMERA_ACCESS_DISABLED. Otherwise, this is equivalent to
	// CAMERA_ACCESS_USER_CHOICE.
	//   "CAMERA_ACCESS_USER_CHOICE" - The field camera_disabled is ignored. This
	// is the default device behaviour: all cameras on the device are available. On
	// Android 12 and above, the user can use the camera access toggle.
	//   "CAMERA_ACCESS_DISABLED" - The field camera_disabled is ignored. All
	// cameras on the device are disabled (for fully managed devices, this applies
	// device-wide and for work profiles this applies only to the work
	// profile).There are no explicit restrictions placed on the camera access
	// toggle on Android 12 and above: on fully managed devices, the camera access
	// toggle has no effect as all cameras are disabled. On devices with a work
	// profile, this toggle has no effect on apps in the work profile, but it
	// affects apps outside the work profile.
	//   "CAMERA_ACCESS_ENFORCED" - The field camera_disabled is ignored. All
	// cameras on the device are available. On fully managed devices running
	// Android 12 and above, the user is unable to use the camera access toggle. On
	// devices which are not fully managed or which run Android 11 or below, this
	// is equivalent to CAMERA_ACCESS_USER_CHOICE.
	CameraAccess string `json:"cameraAccess,omitempty"`
	// CameraDisabled: If camera_access is set to any value other than
	// CAMERA_ACCESS_UNSPECIFIED, this has no effect. Otherwise this field controls
	// whether cameras are disabled: If true, all cameras are disabled, otherwise
	// they are available. For fully managed devices this field applies for all
	// apps on the device. For work profiles, this field applies only to apps in
	// the work profile, and the camera access of apps outside the work profile is
	// unaffected.
	CameraDisabled bool `json:"cameraDisabled,omitempty"`
	// CellBroadcastsConfigDisabled: Whether configuring cell broadcast is
	// disabled.
	CellBroadcastsConfigDisabled bool `json:"cellBroadcastsConfigDisabled,omitempty"`
	// ChoosePrivateKeyRules: Rules for determining apps' access to private keys.
	// See ChoosePrivateKeyRule for details. This must be empty if any application
	// has CERT_SELECTION delegation scope.
	ChoosePrivateKeyRules []*ChoosePrivateKeyRule `json:"choosePrivateKeyRules,omitempty"`
	// ComplianceRules: Rules declaring which mitigating actions to take when a
	// device is not compliant with its policy. When the conditions for multiple
	// rules are satisfied, all of the mitigating actions for the rules are taken.
	// There is a maximum limit of 100 rules. Use policy enforcement rules instead.
	ComplianceRules []*ComplianceRule `json:"complianceRules,omitempty"`
	// CreateWindowsDisabled: Whether creating windows besides app windows is
	// disabled.
	CreateWindowsDisabled bool `json:"createWindowsDisabled,omitempty"`
	// CredentialProviderPolicyDefault: Controls which apps are allowed to act as
	// credential providers on Android 14 and above. These apps store credentials,
	// see this (https://developer.android.com/training/sign-in/passkeys) and this
	// (https://developer.android.com/reference/androidx/credentials/CredentialManager)
	// for details. See also credentialProviderPolicy.
	//
	// Possible values:
	//   "CREDENTIAL_PROVIDER_POLICY_DEFAULT_UNSPECIFIED" - Unspecified. Defaults
	// to CREDENTIAL_PROVIDER_DEFAULT_DISALLOWED.
	//   "CREDENTIAL_PROVIDER_DEFAULT_DISALLOWED" - Apps with
	// credentialProviderPolicy unspecified are not allowed to act as a credential
	// provider.
	//   "CREDENTIAL_PROVIDER_DEFAULT_DISALLOWED_EXCEPT_SYSTEM" - Apps with
	// credentialProviderPolicy unspecified are not allowed to act as a credential
	// provider except for the OEM default credential providers. OEM default
	// credential providers are always allowed to act as credential providers.
	CredentialProviderPolicyDefault string `json:"credentialProviderPolicyDefault,omitempty"`
	// CredentialsConfigDisabled: Whether configuring user credentials is disabled.
	CredentialsConfigDisabled bool `json:"credentialsConfigDisabled,omitempty"`
	// CrossProfilePolicies: Cross-profile policies applied on the device.
	CrossProfilePolicies *CrossProfilePolicies `json:"crossProfilePolicies,omitempty"`
	// DataRoamingDisabled: Whether roaming data services are disabled.
	DataRoamingDisabled bool `json:"dataRoamingDisabled,omitempty"`
	// DebuggingFeaturesAllowed: Whether the user is allowed to enable debugging
	// features.
	DebuggingFeaturesAllowed bool `json:"debuggingFeaturesAllowed,omitempty"`
	// DefaultApplicationSettings: Optional. The default application setting for
	// supported types. If the default application is successfully set for at least
	// one app type on a profile, users are prevented from changing any default
	// applications on that profile.Only one DefaultApplicationSetting is allowed
	// for each DefaultApplicationType.See Default application settings
	// (https://developers.google.com/android/management/default-application-settings)
	// guide for more details.
	DefaultApplicationSettings []*DefaultApplicationSetting `json:"defaultApplicationSettings,omitempty"`
	// DefaultPermissionPolicy: The default permission policy for runtime
	// permission requests.
	//
	// Possible values:
	//   "PERMISSION_POLICY_UNSPECIFIED" - Policy not specified. If no policy is
	// specified for a permission at any level, then the PROMPT behavior is used by
	// default.
	//   "PROMPT" - Prompt the user to grant a permission.
	//   "GRANT" - Automatically grant a permission.On Android 12 and above,
	// READ_SMS
	// (https://developer.android.com/reference/android/Manifest.permission#READ_SMS)
	// and following sensor-related permissions can only be granted on fully
	// managed devices: ACCESS_FINE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION)
	// ACCESS_BACKGROUND_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_BACKGROUND_LOCATION)
	// ACCESS_COARSE_LOCATION
	// (https://developer.android.com/reference/android/Manifest.permission#ACCESS_COARSE_LOCATION)
	// CAMERA
	// (https://developer.android.com/reference/android/Manifest.permission#CAMERA)
	// RECORD_AUDIO
	// (https://developer.android.com/reference/android/Manifest.permission#RECORD_AUDIO)
	// ACTIVITY_RECOGNITION
	// (https://developer.android.com/reference/android/Manifest.permission#ACTIVITY_RECOGNITION)
	// BODY_SENSORS
	// (https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS)
	//   "DENY" - Automatically deny a permission.
	DefaultPermissionPolicy string `json:"defaultPermissionPolicy,omitempty"`
	// DeviceConnectivityManagement: Covers controls for device connectivity such
	// as Wi-Fi, USB data access, keyboard/mouse connections, and more.
	DeviceConnectivityManagement *DeviceConnectivityManagement `json:"deviceConnectivityManagement,omitempty"`
	// DeviceOwnerLockScreenInfo: The device owner information to be shown on the
	// lock screen.
	DeviceOwnerLockScreenInfo *UserFacingMessage `json:"deviceOwnerLockScreenInfo,omitempty"`
	// DeviceRadioState: Covers controls for radio state such as Wi-Fi, bluetooth,
	// and more.
	DeviceRadioState *DeviceRadioState `json:"deviceRadioState,omitempty"`
	// DisplaySettings: Optional. Controls for the display settings.
	DisplaySettings *DisplaySettings `json:"displaySettings,omitempty"`
	// EncryptionPolicy: Whether encryption is enabled
	//
	// Possible values:
	//   "ENCRYPTION_POLICY_UNSPECIFIED" - This value is ignored, i.e. no
	// encryption required
	//   "ENABLED_WITHOUT_PASSWORD" - Encryption required but no password required
	// to boot
	//   "ENABLED_WITH_PASSWORD" - Encryption required with password required to
	// boot
	EncryptionPolicy string `json:"encryptionPolicy,omitempty"`
	// EnsureVerifyAppsEnabled: Whether app verification is force-enabled.
	EnsureVerifyAppsEnabled bool `json:"ensureVerifyAppsEnabled,omitempty"`
	// EnterpriseDisplayNameVisibility: Optional. Controls whether the
	// enterpriseDisplayName is visible on the device (e.g. lock screen message on
	// company-owned devices).
	//
	// Possible values:
	//   "ENTERPRISE_DISPLAY_NAME_VISIBILITY_UNSPECIFIED" - Unspecified. Defaults
	// to displaying the enterprise name that's set at the time of device setup. In
	// future, this will default to ENTERPRISE_DISPLAY_NAME_VISIBLE.
	//   "ENTERPRISE_DISPLAY_NAME_VISIBLE" - The enterprise display name is visible
	// on the device. Supported on work profiles on Android 7 and above. Supported
	// on fully managed devices on Android 8 and above. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 7. A
	// NonComplianceDetail with MANAGEMENT_MODE is reported on fully managed
	// devices on Android 7.
	//   "ENTERPRISE_DISPLAY_NAME_HIDDEN" - The enterprise display name is hidden
	// on the device.
	EnterpriseDisplayNameVisibility string `json:"enterpriseDisplayNameVisibility,omitempty"`
	// FactoryResetDisabled: Whether factory resetting from settings is disabled.
	FactoryResetDisabled bool `json:"factoryResetDisabled,omitempty"`
	// FrpAdminEmails: Email addresses of device administrators for factory reset
	// protection. When the device is factory reset, it will require one of these
	// admins to log in with the Google account email and password to unlock the
	// device. If no admins are specified, the device won't provide factory reset
	// protection.
	FrpAdminEmails []string `json:"frpAdminEmails,omitempty"`
	// FunDisabled: Whether the user is allowed to have fun. Controls whether the
	// Easter egg game in Settings is disabled.
	FunDisabled bool `json:"funDisabled,omitempty"`
	// InstallAppsDisabled: Whether user installation of apps is disabled.
	InstallAppsDisabled bool `json:"installAppsDisabled,omitempty"`
	// InstallUnknownSourcesAllowed: This field has no effect.
	InstallUnknownSourcesAllowed bool `json:"installUnknownSourcesAllowed,omitempty"`
	// KeyguardDisabled: If true, this disables the Lock Screen
	// (https://source.android.com/docs/core/display/multi_display/lock-screen) for
	// primary and/or secondary displays. This policy is supported only in
	// dedicated device management mode.
	KeyguardDisabled bool `json:"keyguardDisabled,omitempty"`
	// KeyguardDisabledFeatures: Disabled keyguard customizations, such as widgets.
	//
	// Possible values:
	//   "KEYGUARD_DISABLED_FEATURE_UNSPECIFIED" - This value is ignored.
	//   "CAMERA" - Disable the camera on secure keyguard screens (e.g. PIN).
	//   "NOTIFICATIONS" - Disable showing all notifications on secure keyguard
	// screens.
	//   "UNREDACTED_NOTIFICATIONS" - Disable unredacted notifications on secure
	// keyguard screens.
	//   "TRUST_AGENTS" - Ignore trust agent state on secure keyguard screens.
	//   "DISABLE_FINGERPRINT" - Disable fingerprint sensor on secure keyguard
	// screens.
	//   "DISABLE_REMOTE_INPUT" - On devices running Android 6 and below, disables
	// text entry into notifications on secure keyguard screens. Has no effect on
	// Android 7 and above.
	//   "FACE" - Disable face authentication on secure keyguard screens.
	//   "IRIS" - Disable iris authentication on secure keyguard screens.
	//   "BIOMETRICS" - Disable all biometric authentication on secure keyguard
	// screens.
	//   "SHORTCUTS" - Disable all shortcuts on secure keyguard screen on Android
	// 14 and above.
	//   "ALL_FEATURES" - Disable all current and future keyguard customizations.
	KeyguardDisabledFeatures []string `json:"keyguardDisabledFeatures,omitempty"`
	// KioskCustomLauncherEnabled: Whether the kiosk custom launcher is enabled.
	// This replaces the home screen with a launcher that locks down the device to
	// the apps installed via the applications setting. Apps appear on a single
	// page in alphabetical order. Use kioskCustomization to further configure the
	// kiosk device behavior.
	KioskCustomLauncherEnabled bool `json:"kioskCustomLauncherEnabled,omitempty"`
	// KioskCustomization: Settings controlling the behavior of a device in kiosk
	// mode. To enable kiosk mode, set kioskCustomLauncherEnabled to true or
	// specify an app in the policy with installType KIOSK.
	KioskCustomization *KioskCustomization `json:"kioskCustomization,omitempty"`
	// LocationMode: The degree of location detection enabled.
	//
	// Possible values:
	//   "LOCATION_MODE_UNSPECIFIED" - Defaults to LOCATION_USER_CHOICE.
	//   "HIGH_ACCURACY" - On Android 8 and below, all location detection methods
	// are enabled, including GPS, networks, and other sensors. On Android 9 and
	// above, this is equivalent to LOCATION_ENFORCED.
	//   "SENSORS_ONLY" - On Android 8 and below, only GPS and other sensors are
	// enabled. On Android 9 and above, this is equivalent to LOCATION_ENFORCED.
	//   "BATTERY_SAVING" - On Android 8 and below, only the network location
	// provider is enabled. On Android 9 and above, this is equivalent to
	// LOCATION_ENFORCED.
	//   "OFF" - On Android 8 and below, location setting and accuracy are
	// disabled. On Android 9 and above, this is equivalent to LOCATION_DISABLED.
	//   "LOCATION_USER_CHOICE" - Location setting is not restricted on the device.
	// No specific behavior is set or enforced.
	//   "LOCATION_ENFORCED" - Enable location setting on the device. Important: On
	// Android 11 and above, work profiles on company-owned devices cannot directly
	// enforce enabling of location services. When LOCATION_ENFORCED is set, then a
	// NonComplianceDetail with USER_ACTION is reported. Compliance can only be
	// restored once the user manually turns on location services through the
	// device's Settings application.
	//   "LOCATION_DISABLED" - Disable location setting on the device. Important:
	// On Android 11 and above, work profiles on company-owned devices cannot
	// directly enforce disabling of location services. When LOCATION_DISABLED is
	// set, then a nonComplianceDetail with USER_ACTION is reported. Compliance can
	// only be restored once the user manually turns off location services through
	// the device's Settings application.
	LocationMode string `json:"locationMode,omitempty"`
	// LongSupportMessage: A message displayed to the user in the device
	// administators settings screen.
	LongSupportMessage *UserFacingMessage `json:"longSupportMessage,omitempty"`
	// MaximumTimeToLock: Maximum time in milliseconds for user activity until the
	// device locks. A value of 0 means there is no restriction.
	MaximumTimeToLock int64 `json:"maximumTimeToLock,omitempty,string"`
	// MicrophoneAccess: Controls the use of the microphone and whether the user
	// has access to the microphone access toggle. This applies only on fully
	// managed devices.
	//
	// Possible values:
	//   "MICROPHONE_ACCESS_UNSPECIFIED" - If unmute_microphone_disabled is true,
	// this is equivalent to MICROPHONE_ACCESS_DISABLED. Otherwise, this is
	// equivalent to MICROPHONE_ACCESS_USER_CHOICE.
	//   "MICROPHONE_ACCESS_USER_CHOICE" - The field unmute_microphone_disabled is
	// ignored. This is the default device behaviour: the microphone on the device
	// is available. On Android 12 and above, the user can use the microphone
	// access toggle.
	//   "MICROPHONE_ACCESS_DISABLED" - The field unmute_microphone_disabled is
	// ignored. The microphone on the device is disabled (for fully managed
	// devices, this applies device-wide).The microphone access toggle has no
	// effect as the microphone is disabled.
	//   "MICROPHONE_ACCESS_ENFORCED" - The field unmute_microphone_disabled is
	// ignored. The microphone on the device is available. On devices running
	// Android 12 and above, the user is unable to use the microphone access
	// toggle. On devices which run Android 11 or below, this is equivalent to
	// MICROPHONE_ACCESS_USER_CHOICE.
	MicrophoneAccess string `json:"microphoneAccess,omitempty"`
	// MinimumApiLevel: The minimum allowed Android API level.
	MinimumApiLevel int64 `json:"minimumApiLevel,omitempty"`
	// MobileNetworksConfigDisabled: Whether configuring mobile networks is
	// disabled.
	MobileNetworksConfigDisabled bool `json:"mobileNetworksConfigDisabled,omitempty"`
	// ModifyAccountsDisabled: Whether adding or removing accounts is disabled.
	ModifyAccountsDisabled bool `json:"modifyAccountsDisabled,omitempty"`
	// MountPhysicalMediaDisabled: Whether the user mounting physical external
	// media is disabled.
	MountPhysicalMediaDisabled bool `json:"mountPhysicalMediaDisabled,omitempty"`
	// Name: The name of the policy in the form
	// enterprises/{enterpriseId}/policies/{policyId}.
	Name string `json:"name,omitempty"`
	// NetworkEscapeHatchEnabled: Whether the network escape hatch is enabled. If a
	// network connection can't be made at boot time, the escape hatch prompts the
	// user to temporarily connect to a network in order to refresh the device
	// policy. After applying policy, the temporary network will be forgotten and
	// the device will continue booting. This prevents being unable to connect to a
	// network if there is no suitable network in the last policy and the device
	// boots into an app in lock task mode, or the user is otherwise unable to
	// reach device settings.Note: Setting wifiConfigDisabled to true will override
	// this setting under specific circumstances. Please see wifiConfigDisabled for
	// further details. Setting configureWifi to DISALLOW_CONFIGURING_WIFI will
	// override this setting under specific circumstances. Please see
	// DISALLOW_CONFIGURING_WIFI for further details.
	NetworkEscapeHatchEnabled bool `json:"networkEscapeHatchEnabled,omitempty"`
	// NetworkResetDisabled: Whether resetting network settings is disabled.
	NetworkResetDisabled bool `json:"networkResetDisabled,omitempty"`
	// OncCertificateProviders: This feature is not generally available.
	OncCertificateProviders []*OncCertificateProvider `json:"oncCertificateProviders,omitempty"`
	// OpenNetworkConfiguration: Network configuration for the device. See
	// configure networks for more information.
	OpenNetworkConfiguration googleapi.RawMessage `json:"openNetworkConfiguration,omitempty"`
	// OutgoingBeamDisabled: Whether using NFC to beam data from apps is disabled.
	OutgoingBeamDisabled bool `json:"outgoingBeamDisabled,omitempty"`
	// OutgoingCallsDisabled: Whether outgoing calls are disabled.
	OutgoingCallsDisabled bool `json:"outgoingCallsDisabled,omitempty"`
	// PasswordPolicies: Password requirement policies. Different policies can be
	// set for work profile or fully managed devices by setting the password_scope
	// field in the policy.
	PasswordPolicies []*PasswordRequirements `json:"passwordPolicies,omitempty"`
	// PasswordRequirements: Password requirements. The field
	// password_requirements.require_password_unlock must not be set. DEPRECATED -
	// Use passwordPolicies.Note:Complexity-based values of PasswordQuality, that
	// is, COMPLEXITY_LOW, COMPLEXITY_MEDIUM, and COMPLEXITY_HIGH, cannot be used
	// here. unified_lock_settings cannot be used here.
	PasswordRequirements *PasswordRequirements `json:"passwordRequirements,omitempty"`
	// PermissionGrants: Explicit permission or group grants or denials for all
	// apps. These values override the default_permission_policy.
	PermissionGrants []*PermissionGrant `json:"permissionGrants,omitempty"`
	// PermittedAccessibilityServices: Specifies permitted accessibility services.
	// If the field is not set, any accessibility service can be used. If the field
	// is set, only the accessibility services in this list and the system's
	// built-in accessibility service can be used. In particular, if the field is
	// set to empty, only the system's built-in accessibility servicess can be
	// used. This can be set on fully managed devices and on work profiles. When
	// applied to a work profile, this affects both the personal profile and the
	// work profile.
	PermittedAccessibilityServices *PackageNameList `json:"permittedAccessibilityServices,omitempty"`
	// PermittedInputMethods: If present, only the input methods provided by
	// packages in this list are permitted. If this field is present, but the list
	// is empty, then only system input methods are permitted.
	PermittedInputMethods *PackageNameList `json:"permittedInputMethods,omitempty"`
	// PersistentPreferredActivities: Default intent handler activities.
	PersistentPreferredActivities []*PersistentPreferredActivity `json:"persistentPreferredActivities,omitempty"`
	// PersonalUsagePolicies: Policies managing personal usage on a company-owned
	// device.
	PersonalUsagePolicies *PersonalUsagePolicies `json:"personalUsagePolicies,omitempty"`
	// PlayStoreMode: This mode controls which apps are available to the user in
	// the Play Store and the behavior on the device when apps are removed from the
	// policy.
	//
	// Possible values:
	//   "PLAY_STORE_MODE_UNSPECIFIED" - Unspecified. Defaults to WHITELIST.
	//   "WHITELIST" - Only apps that are in the policy are available and any app
	// not in the policy will be automatically uninstalled from the device.
	//   "BLACKLIST" - All apps are available and any app that should not be on the
	// device should be explicitly marked as 'BLOCKED' in the applications policy.
	PlayStoreMode string `json:"playStoreMode,omitempty"`
	// PolicyEnforcementRules: Rules that define the behavior when a particular
	// policy can not be applied on device
	PolicyEnforcementRules []*PolicyEnforcementRule `json:"policyEnforcementRules,omitempty"`
	// PreferentialNetworkService: Controls whether preferential network service is
	// enabled on the work profile or on fully managed devices. For example, an
	// organization may have an agreement with a carrier that all of the work data
	// from its employees' devices will be sent via a network service dedicated for
	// enterprise use. An example of a supported preferential network service is
	// the enterprise slice on 5G networks. This policy has no effect if
	// preferentialNetworkServiceSettings or
	// ApplicationPolicy.preferentialNetworkId is set on devices running Android 13
	// or above.
	//
	// Possible values:
	//   "PREFERENTIAL_NETWORK_SERVICE_UNSPECIFIED" - Unspecified. Defaults to
	// PREFERENTIAL_NETWORK_SERVICES_DISABLED.
	//   "PREFERENTIAL_NETWORK_SERVICE_DISABLED" - Preferential network service is
	// disabled on the work profile.
	//   "PREFERENTIAL_NETWORK_SERVICE_ENABLED" - Preferential network service is
	// enabled on the work profile. This setting is only supported on work profiles
	// on devices running Android 12 or above. Starting with Android 13, fully
	// managed devices are also supported.
	PreferentialNetworkService string `json:"preferentialNetworkService,omitempty"`
	// PrintingPolicy: Optional. Controls whether printing is allowed. This is
	// supported on devices running Android 9 and above. .
	//
	// Possible values:
	//   "PRINTING_POLICY_UNSPECIFIED" - Unspecified. Defaults to PRINTING_ALLOWED.
	//   "PRINTING_DISALLOWED" - Printing is disallowed. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 9.
	//   "PRINTING_ALLOWED" - Printing is allowed.
	PrintingPolicy string `json:"printingPolicy,omitempty"`
	// PrivateKeySelectionEnabled: Allows showing UI on a device for a user to
	// choose a private key alias if there are no matching rules in
	// ChoosePrivateKeyRules. For devices below Android P, setting this may leave
	// enterprise keys vulnerable. This value will have no effect if any
	// application has CERT_SELECTION delegation scope.
	PrivateKeySelectionEnabled bool `json:"privateKeySelectionEnabled,omitempty"`
	// RecommendedGlobalProxy: The network-independent global HTTP proxy. Typically
	// proxies should be configured per-network in open_network_configuration.
	// However for unusual configurations like general internal filtering a global
	// HTTP proxy may be useful. If the proxy is not accessible, network access may
	// break. The global proxy is only a recommendation and some apps may ignore
	// it.
	RecommendedGlobalProxy *ProxyInfo `json:"recommendedGlobalProxy,omitempty"`
	// RemoveUserDisabled: Whether removing other users is disabled.
	RemoveUserDisabled bool `json:"removeUserDisabled,omitempty"`
	// SafeBootDisabled: Whether rebooting the device into safe boot is disabled.
	SafeBootDisabled bool `json:"safeBootDisabled,omitempty"`
	// ScreenCaptureDisabled: Whether screen capture is disabled.
	ScreenCaptureDisabled bool `json:"screenCaptureDisabled,omitempty"`
	// SetUserIconDisabled: Whether changing the user icon is disabled. This
	// applies only on devices running Android 7 and above.
	SetUserIconDisabled bool `json:"setUserIconDisabled,omitempty"`
	// SetWallpaperDisabled: Whether changing the wallpaper is disabled.
	SetWallpaperDisabled bool `json:"setWallpaperDisabled,omitempty"`
	// SetupActions: Action to take during the setup process. At most one action
	// may be specified.
	SetupActions []*SetupAction `json:"setupActions,omitempty"`
	// ShareLocationDisabled: Whether location sharing is disabled.
	ShareLocationDisabled bool `json:"shareLocationDisabled,omitempty"`
	// ShortSupportMessage: A message displayed to the user in the settings screen
	// wherever functionality has been disabled by the admin. If the message is
	// longer than 200 characters it may be truncated.
	ShortSupportMessage *UserFacingMessage `json:"shortSupportMessage,omitempty"`
	// SkipFirstUseHintsEnabled: Flag to skip hints on the first use. Enterprise
	// admin can enable the system recommendation for apps to skip their user
	// tutorial and other introductory hints on first start-up.
	SkipFirstUseHintsEnabled bool `json:"skipFirstUseHintsEnabled,omitempty"`
	// SmsDisabled: Whether sending and receiving SMS messages is disabled.
	SmsDisabled bool `json:"smsDisabled,omitempty"`
	// StatusBarDisabled: Whether the status bar is disabled. This disables
	// notifications, quick settings, and other screen overlays that allow escape
	// from full-screen mode. DEPRECATED. To disable the status bar on a kiosk
	// device, use InstallType KIOSK or kioskCustomLauncherEnabled.
	StatusBarDisabled bool `json:"statusBarDisabled,omitempty"`
	// StatusReportingSettings: Status reporting settings
	StatusReportingSettings *StatusReportingSettings `json:"statusReportingSettings,omitempty"`
	// StayOnPluggedModes: The battery plugged in modes for which the device stays
	// on. When using this setting, it is recommended to clear maximum_time_to_lock
	// so that the device doesn't lock itself while it stays on.
	//
	// Possible values:
	//   "BATTERY_PLUGGED_MODE_UNSPECIFIED" - This value is ignored.
	//   "AC" - Power source is an AC charger.
	//   "USB" - Power source is a USB port.
	//   "WIRELESS" - Power source is wireless.
	StayOnPluggedModes []string `json:"stayOnPluggedModes,omitempty"`
	// SystemUpdate: The system update policy, which controls how OS updates are
	// applied. If the update type is WINDOWED, the update window will
	// automatically apply to Play app updates as well.Note: Google Play system
	// updates (https://source.android.com/docs/core/ota/modular-system) (also
	// called Mainline updates) are automatically downloaded and require a device
	// reboot to be installed. Refer to the mainline section in Manage system
	// updates (https://developer.android.com/work/dpc/system-updates#mainline) for
	// further details.
	SystemUpdate *SystemUpdate `json:"systemUpdate,omitempty"`
	// TetheringConfigDisabled: Whether configuring tethering and portable hotspots
	// is disabled. If tetheringSettings is set to anything other than
	// TETHERING_SETTINGS_UNSPECIFIED, this setting is ignored.
	TetheringConfigDisabled bool `json:"tetheringConfigDisabled,omitempty"`
	// UninstallAppsDisabled: Whether user uninstallation of applications is
	// disabled. This prevents apps from being uninstalled, even those removed
	// using applications
	UninstallAppsDisabled bool `json:"uninstallAppsDisabled,omitempty"`
	// UnmuteMicrophoneDisabled: If microphone_access is set to any value other
	// than MICROPHONE_ACCESS_UNSPECIFIED, this has no effect. Otherwise this field
	// controls whether microphones are disabled: If true, all microphones are
	// disabled, otherwise they are available. This is available only on fully
	// managed devices.
	UnmuteMicrophoneDisabled bool `json:"unmuteMicrophoneDisabled,omitempty"`
	// UsageLog: Configuration of device activity logging.
	UsageLog *UsageLog `json:"usageLog,omitempty"`
	// UsbFileTransferDisabled: Whether transferring files over USB is disabled.
	// This is supported only on company-owned devices.
	UsbFileTransferDisabled bool `json:"usbFileTransferDisabled,omitempty"`
	// UsbMassStorageEnabled: Whether USB storage is enabled. Deprecated.
	UsbMassStorageEnabled bool `json:"usbMassStorageEnabled,omitempty"`
	// Version: The version of the policy. This is a read-only field. The version
	// is incremented each time the policy is updated.
	Version int64 `json:"version,omitempty,string"`
	// VpnConfigDisabled: Whether configuring VPN is disabled.
	VpnConfigDisabled bool `json:"vpnConfigDisabled,omitempty"`
	// WifiConfigDisabled: Whether configuring Wi-Fi networks is disabled.
	// Supported on fully managed devices and work profiles on company-owned
	// devices. For fully managed devices, setting this to true removes all
	// configured networks and retains only the networks configured using
	// openNetworkConfiguration. For work profiles on company-owned devices,
	// existing configured networks are not affected and the user is not allowed to
	// add, remove, or modify Wi-Fi networks. If configureWifi is set to anything
	// other than CONFIGURE_WIFI_UNSPECIFIED, this setting is ignored. Note: If a
	// network connection can't be made at boot time and configuring Wi-Fi is
	// disabled then network escape hatch will be shown in order to refresh the
	// device policy (see networkEscapeHatchEnabled).
	WifiConfigDisabled bool `json:"wifiConfigDisabled,omitempty"`
	// WifiConfigsLockdownEnabled: This is deprecated.
	WifiConfigsLockdownEnabled bool `json:"wifiConfigsLockdownEnabled,omitempty"`
	// WipeDataFlags: Optional. Wipe flags to indicate what data is wiped when a
	// device or profile wipe is triggered due to any reason (for example,
	// non-compliance). This does not apply to the enterprises.devices.delete
	// method. . This list must not have duplicates.
	//
	// Possible values:
	//   "WIPE_DATA_FLAG_UNSPECIFIED" - This value must not be used.
	//   "WIPE_ESIMS" - For company-owned devices, setting this in wipeDataFlags
	// will remove all eSIMs on the device when wipe is triggered due to any
	// reason. On personally-owned devices, this will remove only managed eSIMs on
	// the device. (eSIMs which are added via the ADD_ESIM command). This is
	// supported on devices running Android 15 and above. A NonComplianceDetail
	// with API_LEVEL is reported if the Android version is less than 15.
	WipeDataFlags []string `json:"wipeDataFlags,omitempty"`
	// WorkAccountSetupConfig: Optional. Controls the work account setup
	// configuration, such as details of whether a Google authenticated account is
	// required.
	WorkAccountSetupConfig *WorkAccountSetupConfig `json:"workAccountSetupConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AccountTypesWithManagementDisabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AccountTypesWithManagementDisabled") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PolicyEnforcementRule: A rule that defines the actions to take if a device
// or work profile is not compliant with the policy specified in settingName.
// In the case of multiple matching or multiple triggered enforcement rules, a
// merge will occur with the most severe action being taken. However, all
// triggered rules are still kept track of: this includes initial trigger time
// and all associated non-compliance details. In the situation where the most
// severe enforcement rule is satisfied, the next most appropriate action is
// applied.
type PolicyEnforcementRule struct {
	// BlockAction: An action to block access to apps and data on a company owned
	// device or in a work profile. This action also triggers a user-facing
	// notification with information (where possible) on how to correct the
	// compliance issue. Note: wipeAction must also be specified.
	BlockAction *BlockAction `json:"blockAction,omitempty"`
	// SettingName: The top-level policy to enforce. For example, applications or
	// passwordPolicies.
	SettingName string `json:"settingName,omitempty"`
	// WipeAction: An action to reset a company owned device or delete a work
	// profile. Note: blockAction must also be specified.
	WipeAction *WipeAction `json:"wipeAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PolicyEnforcementRule) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyEnforcementRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostureDetail: Additional details regarding the security posture of the
// device.
type PostureDetail struct {
	// Advice: Corresponding admin-facing advice to mitigate this security risk and
	// improve the security posture of the device.
	Advice []*UserFacingMessage `json:"advice,omitempty"`
	// SecurityRisk: A specific security risk that negatively affects the security
	// posture of the device.
	//
	// Possible values:
	//   "SECURITY_RISK_UNSPECIFIED" - Unspecified.
	//   "UNKNOWN_OS" - Play Integrity API detects that the device is running an
	// unknown OS (basicIntegrity check succeeds but ctsProfileMatch fails).
	//   "COMPROMISED_OS" - Play Integrity API detects that the device is running a
	// compromised OS (basicIntegrity check fails).
	//   "HARDWARE_BACKED_EVALUATION_FAILED" - Play Integrity API detects that the
	// device does not have a strong guarantee of system integrity, if the
	// MEETS_STRONG_INTEGRITY label doesn't show in the device integrity field
	// (https://developer.android.com/google/play/integrity/verdicts#device-integrity-field).
	SecurityRisk string `json:"securityRisk,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Advice") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Advice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostureDetail) MarshalJSON() ([]byte, error) {
	type NoMethod PostureDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PowerManagementEvent: A power management event.
type PowerManagementEvent struct {
	// BatteryLevel: For BATTERY_LEVEL_COLLECTED events, the battery level as a
	// percentage.
	BatteryLevel float64 `json:"batteryLevel,omitempty"`
	// CreateTime: The creation time of the event.
	CreateTime string `json:"createTime,omitempty"`
	// EventType: Event type.
	//
	// Possible values:
	//   "POWER_MANAGEMENT_EVENT_TYPE_UNSPECIFIED" - Unspecified. No events have
	// this type.
	//   "BATTERY_LEVEL_COLLECTED" - Battery level was measured.
	//   "POWER_CONNECTED" - The device started charging.
	//   "POWER_DISCONNECTED" - The device stopped charging.
	//   "BATTERY_LOW" - The device entered low-power mode.
	//   "BATTERY_OKAY" - The device exited low-power mode.
	//   "BOOT_COMPLETED" - The device booted.
	//   "SHUTDOWN" - The device shut down.
	EventType string `json:"eventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatteryLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatteryLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PowerManagementEvent) MarshalJSON() ([]byte, error) {
	type NoMethod PowerManagementEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PowerManagementEvent) UnmarshalJSON(data []byte) error {
	type NoMethod PowerManagementEvent
	var s1 struct {
		BatteryLevel gensupport.JSONFloat64 `json:"batteryLevel"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BatteryLevel = float64(s1.BatteryLevel)
	return nil
}

// PreferentialNetworkServiceConfig: Individual preferential network service
// configuration.
type PreferentialNetworkServiceConfig struct {
	// FallbackToDefaultConnection: Optional. Whether fallback to the device-wide
	// default network is allowed. If this is set to
	// FALLBACK_TO_DEFAULT_CONNECTION_ALLOWED, then nonMatchingNetworks must not be
	// set to NON_MATCHING_NETWORKS_DISALLOWED, the policy will be rejected
	// otherwise. Note: If this is set to
	// FALLBACK_TO_DEFAULT_CONNECTION_DISALLOWED, applications are not able to
	// access the internet if the 5G slice is not available.
	//
	// Possible values:
	//   "FALLBACK_TO_DEFAULT_CONNECTION_UNSPECIFIED" - Unspecified. Defaults to
	// FALLBACK_TO_DEFAULT_CONNECTION_ALLOWED.
	//   "FALLBACK_TO_DEFAULT_CONNECTION_ALLOWED" - Fallback to default connection
	// is allowed. If this is set, nonMatchingNetworks must not be set to
	// NON_MATCHING_NETWORKS_DISALLOWED, the policy will be rejected otherwise.
	//   "FALLBACK_TO_DEFAULT_CONNECTION_DISALLOWED" - Fallback to default
	// connection is not allowed.
	FallbackToDefaultConnection string `json:"fallbackToDefaultConnection,omitempty"`
	// NonMatchingNetworks: Optional. Whether apps this configuration applies to
	// are blocked from using networks other than the preferential service. If this
	// is set to NON_MATCHING_NETWORKS_DISALLOWED, then fallbackToDefaultConnection
	// must be set to FALLBACK_TO_DEFAULT_CONNECTION_DISALLOWED.
	//
	// Possible values:
	//   "NON_MATCHING_NETWORKS_UNSPECIFIED" - Unspecified. Defaults to
	// NON_MATCHING_NETWORKS_ALLOWED.
	//   "NON_MATCHING_NETWORKS_ALLOWED" - Apps this configuration applies to are
	// allowed to use networks other than the preferential service.
	//   "NON_MATCHING_NETWORKS_DISALLOWED" - Apps this configuration applies to
	// are disallowed from using other networks than the preferential service. This
	// can be set on Android 14 and above. A NonComplianceDetail with API_LEVEL is
	// reported if the Android version is less than 14. If this is set,
	// fallbackToDefaultConnection must be set to
	// FALLBACK_TO_DEFAULT_CONNECTION_DISALLOWED, the policy will be rejected
	// otherwise.
	NonMatchingNetworks string `json:"nonMatchingNetworks,omitempty"`
	// PreferentialNetworkId: Required. Preferential network identifier. This must
	// not be set to NO_PREFERENTIAL_NETWORK or
	// PREFERENTIAL_NETWORK_ID_UNSPECIFIED, the policy will be rejected otherwise.
	//
	// Possible values:
	//   "PREFERENTIAL_NETWORK_ID_UNSPECIFIED" - Whether this value is valid and
	// what it means depends on where it is used, and this is documented on the
	// relevant fields.
	//   "NO_PREFERENTIAL_NETWORK" - Application does not use any preferential
	// network.
	//   "PREFERENTIAL_NETWORK_ID_ONE" - Preferential network identifier 1.
	//   "PREFERENTIAL_NETWORK_ID_TWO" - Preferential network identifier 2.
	//   "PREFERENTIAL_NETWORK_ID_THREE" - Preferential network identifier 3.
	//   "PREFERENTIAL_NETWORK_ID_FOUR" - Preferential network identifier 4.
	//   "PREFERENTIAL_NETWORK_ID_FIVE" - Preferential network identifier 5.
	PreferentialNetworkId string `json:"preferentialNetworkId,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FallbackToDefaultConnection") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FallbackToDefaultConnection") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PreferentialNetworkServiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PreferentialNetworkServiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PreferentialNetworkServiceSettings: Preferential network service settings.
type PreferentialNetworkServiceSettings struct {
	// DefaultPreferentialNetworkId: Required. Default preferential network ID for
	// the applications that are not in applications or if
	// ApplicationPolicy.preferentialNetworkId is set to
	// PREFERENTIAL_NETWORK_ID_UNSPECIFIED. There must be a configuration for the
	// specified network ID in preferentialNetworkServiceConfigs, unless this is
	// set to NO_PREFERENTIAL_NETWORK. If set to
	// PREFERENTIAL_NETWORK_ID_UNSPECIFIED or unset, this defaults to
	// NO_PREFERENTIAL_NETWORK. Note: If the default preferential network is
	// misconfigured, applications with no ApplicationPolicy.preferentialNetworkId
	// set are not able to access the internet. This setting does not apply to the
	// following critical apps: com.google.android.apps.work.clouddpc
	// com.google.android.gmsApplicationPolicy.preferentialNetworkId can still be
	// used to configure the preferential network for them.
	//
	// Possible values:
	//   "PREFERENTIAL_NETWORK_ID_UNSPECIFIED" - Whether this value is valid and
	// what it means depends on where it is used, and this is documented on the
	// relevant fields.
	//   "NO_PREFERENTIAL_NETWORK" - Application does not use any preferential
	// network.
	//   "PREFERENTIAL_NETWORK_ID_ONE" - Preferential network identifier 1.
	//   "PREFERENTIAL_NETWORK_ID_TWO" - Preferential network identifier 2.
	//   "PREFERENTIAL_NETWORK_ID_THREE" - Preferential network identifier 3.
	//   "PREFERENTIAL_NETWORK_ID_FOUR" - Preferential network identifier 4.
	//   "PREFERENTIAL_NETWORK_ID_FIVE" - Preferential network identifier 5.
	DefaultPreferentialNetworkId string `json:"defaultPreferentialNetworkId,omitempty"`
	// PreferentialNetworkServiceConfigs: Required. Preferential network service
	// configurations which enables having multiple enterprise slices. There must
	// not be multiple configurations with the same preferentialNetworkId. If a
	// configuration is not referenced by any application by setting
	// ApplicationPolicy.preferentialNetworkId or by setting
	// defaultPreferentialNetworkId, it will be ignored. For devices on 4G
	// networks, enterprise APN needs to be configured additionally to set up data
	// call for preferential network service. These APNs can be added using
	// apnPolicy.
	PreferentialNetworkServiceConfigs []*PreferentialNetworkServiceConfig `json:"preferentialNetworkServiceConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DefaultPreferentialNetworkId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultPreferentialNetworkId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PreferentialNetworkServiceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod PreferentialNetworkServiceSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProvisioningInfo: Information about a device that is available during setup.
type ProvisioningInfo struct {
	// ApiLevel: The API level of the Android platform version running on the
	// device.
	ApiLevel int64 `json:"apiLevel,omitempty"`
	// AuthenticatedUserEmail: The email address of the authenticated user (only
	// present for Google Account provisioning method).
	AuthenticatedUserEmail string `json:"authenticatedUserEmail,omitempty"`
	// Brand: The brand of the device. For example, Google.
	Brand string `json:"brand,omitempty"`
	// Enterprise: The name of the enterprise in the form enterprises/{enterprise}.
	Enterprise string `json:"enterprise,omitempty"`
	// Imei: For corporate-owned devices, IMEI number of the GSM device. For
	// example, A1000031212.
	Imei string `json:"imei,omitempty"`
	// ManagementMode: The management mode of the device or profile.
	//
	// Possible values:
	//   "MANAGEMENT_MODE_UNSPECIFIED" - This value is disallowed.
	//   "DEVICE_OWNER" - Device owner. Android Device Policy has full control over
	// the device.
	//   "PROFILE_OWNER" - Profile owner. Android Device Policy has control over a
	// managed profile on the device.
	ManagementMode string `json:"managementMode,omitempty"`
	// Meid: For corporate-owned devices, MEID number of the CDMA device. For
	// example, A00000292788E1.
	Meid string `json:"meid,omitempty"`
	// Model: The model of the device. For example, Asus Nexus 7.
	Model string `json:"model,omitempty"`
	// Name: The name of this resource in the form
	// provisioningInfo/{provisioning_info}.
	Name string `json:"name,omitempty"`
	// Ownership: Ownership of the managed device.
	//
	// Possible values:
	//   "OWNERSHIP_UNSPECIFIED" - Ownership is unspecified.
	//   "COMPANY_OWNED" - Device is company-owned.
	//   "PERSONALLY_OWNED" - Device is personally-owned.
	Ownership string `json:"ownership,omitempty"`
	// SerialNumber: For corporate-owned devices, The device serial number.
	SerialNumber string `json:"serialNumber,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProvisioningInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ProvisioningInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProxyInfo: Configuration info for an HTTP proxy. For a direct proxy, set the
// host, port, and excluded_hosts fields. For a PAC script proxy, set the
// pac_uri field.
type ProxyInfo struct {
	// ExcludedHosts: For a direct proxy, the hosts for which the proxy is
	// bypassed. The host names may contain wildcards such as *.example.com.
	ExcludedHosts []string `json:"excludedHosts,omitempty"`
	// Host: The host of the direct proxy.
	Host string `json:"host,omitempty"`
	// PacUri: The URI of the PAC script used to configure the proxy.
	PacUri string `json:"pacUri,omitempty"`
	// Port: The port of the direct proxy.
	Port int64 `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedHosts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedHosts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProxyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ProxyInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoteLockEvent: The device or profile has been remotely locked via the LOCK
// command.
type RemoteLockEvent struct {
	// AdminPackageName: Package name of the admin app requesting the change.
	AdminPackageName string `json:"adminPackageName,omitempty"`
	// AdminUserId: User ID of the admin app from the which the change was
	// requested.
	AdminUserId int64 `json:"adminUserId,omitempty"`
	// TargetUserId: User ID in which the change was requested in.
	TargetUserId int64 `json:"targetUserId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdminPackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminPackageName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoteLockEvent) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteLockEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveEsimParams: Parameters associated with the REMOVE_ESIM command to
// remove an eSIM profile from the device.
type RemoveEsimParams struct {
	// IccId: Required. ICC ID of the eSIM profile to be deleted.
	IccId string `json:"iccId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IccId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IccId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveEsimParams) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveEsimParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemovePolicyApplicationsRequest: Request to remove ApplicationPolicy objects
// in the given policy.
type RemovePolicyApplicationsRequest struct {
	// PackageNames: Required. Package names to be removed. Entries that are not
	// found are ignored. There must be at least one entry in package_names.
	PackageNames []string `json:"packageNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemovePolicyApplicationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemovePolicyApplicationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemovePolicyApplicationsResponse: Response to a request to remove
// ApplicationPolicy objects in the given policy.
type RemovePolicyApplicationsResponse struct {
	// Policy: The updated policy after ApplicationPolicy objects have been
	// removed.
	Policy *Policy `json:"policy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemovePolicyApplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RemovePolicyApplicationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestDeviceInfoParams: Parameters associated with the REQUEST_DEVICE_INFO
// command to get device related information.
type RequestDeviceInfoParams struct {
	// DeviceInfo: Required. Type of device information to be requested.
	//
	// Possible values:
	//   "DEVICE_INFO_UNSPECIFIED" - This value is disallowed.
	//   "EID" - Request the identifier for eSIM. The user will be asked to approve
	// the disclosure of the information before the result can be returned. If the
	// user doesn't approve the disclosure, USER_DECLINED will be returned. This is
	// supported only for personally owned devices with work profiles and Android
	// versions 13 and above.
	DeviceInfo string `json:"deviceInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestDeviceInfoParams) MarshalJSON() ([]byte, error) {
	type NoMethod RequestDeviceInfoParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestDeviceInfoStatus: Status of the REQUEST_DEVICE_INFO command.
type RequestDeviceInfoStatus struct {
	// EidInfo: Information related to the EIDs of the device.
	EidInfo *EidInfo `json:"eidInfo,omitempty"`
	// Status: Output only. Status of a REQUEST_DEVICE_INFO command.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified. This value is not used.
	//   "SUCCEEDED" - Device information has been successfully delivered.
	//   "PENDING_USER_ACTION" - The user has not completed the actions required to
	// share device information.
	//   "USER_DECLINED" - The user declined sharing device information.
	//   "UNSUPPORTED" - The requested device info is not supported on this device,
	// e.g. eSIM is not supported on the device.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EidInfo") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EidInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestDeviceInfoStatus) MarshalJSON() ([]byte, error) {
	type NoMethod RequestDeviceInfoStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Role: Role an app can have.
type Role struct {
	// RoleType: Required. The type of the role an app can have.
	//
	// Possible values:
	//   "ROLE_TYPE_UNSPECIFIED" - The role type is unspecified. This value must
	// not be used.
	//   "COMPANION_APP" - The role type for companion apps. This role enables the
	// app as a companion app with the capability of interacting with Android
	// Device Policy offline. This is the recommended way to configure an app as a
	// companion app. For legacy way, see extensionConfig.On Android 14 and above,
	// the app with this role is exempted from power and background execution
	// restrictions, suspension and hibernation. On Android 11 and above, the user
	// control is disallowed for the app with this role. userControlSettings cannot
	// be set to USER_CONTROL_ALLOWED for the app with this role.Android Device
	// Policy notifies the companion app of any local command status updates if the
	// app has a service with . See Integrate with the AMAPI SDK
	// (https://developers.google.com/android/management/sdk-integration) guide for
	// more details on the requirements for the service.
	//   "KIOSK" - The role type for kiosk apps. An app can have this role only if
	// it has installType set to REQUIRED_FOR_SETUP or CUSTOM. Before adding this
	// role to an app with CUSTOM install type, the app must already be installed
	// on the device.The app having this role type is set as the preferred home
	// intent and allowlisted for lock task mode. When there is an app with this
	// role type, status bar will be automatically disabled.This is preferable to
	// setting installType to KIOSK.On Android 11 and above, the user control is
	// disallowed but userControlSettings can be set to USER_CONTROL_ALLOWED to
	// allow user control for the app with this role.
	//   "MOBILE_THREAT_DEFENSE_ENDPOINT_DETECTION_RESPONSE" - The role type for
	// Mobile Threat Defense (MTD) / Endpoint Detection & Response (EDR) apps.On
	// Android 14 and above, the app with this role is exempted from power and
	// background execution restrictions, suspension and hibernation. On Android 11
	// and above, the user control is disallowed and userControlSettings cannot be
	// set to USER_CONTROL_ALLOWED for the app with this role.
	//   "SYSTEM_HEALTH_MONITORING" - The role type for system health monitoring
	// apps.On Android 14 and above, the app with this role is exempted from power
	// and background execution restrictions, suspension and hibernation. On
	// Android 11 and above, the user control is disallowed and userControlSettings
	// cannot be set to USER_CONTROL_ALLOWED for the app with this role.
	RoleType string `json:"roleType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RoleType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RoleType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Role) MarshalJSON() ([]byte, error) {
	type NoMethod Role
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScreenBrightnessSettings: Controls for the screen brightness settings.
type ScreenBrightnessSettings struct {
	// ScreenBrightness: Optional. The screen brightness between 1 and 255 where 1
	// is the lowest and 255 is the highest brightness. A value of 0 (default)
	// means no screen brightness set. Any other value is rejected.
	// screenBrightnessMode must be either BRIGHTNESS_AUTOMATIC or BRIGHTNESS_FIXED
	// to set this. Supported on Android 9 and above on fully managed devices. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 9. Supported on work profiles on company-owned devices on Android
	// 15 and above.
	ScreenBrightness int64 `json:"screenBrightness,omitempty"`
	// ScreenBrightnessMode: Optional. Controls the screen brightness mode.
	//
	// Possible values:
	//   "SCREEN_BRIGHTNESS_MODE_UNSPECIFIED" - Unspecified. Defaults to
	// BRIGHTNESS_USER_CHOICE.
	//   "BRIGHTNESS_USER_CHOICE" - The user is allowed to configure the screen
	// brightness. screenBrightness must not be set.
	//   "BRIGHTNESS_AUTOMATIC" - The screen brightness mode is automatic in which
	// the brightness is automatically adjusted and the user is not allowed to
	// configure the screen brightness. screenBrightness can still be set and it is
	// taken into account while the brightness is automatically adjusted. Supported
	// on Android 9 and above on fully managed devices. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 9. Supported on
	// work profiles on company-owned devices on Android 15 and above.
	//   "BRIGHTNESS_FIXED" - The screen brightness mode is fixed in which the
	// brightness is set to screenBrightness and the user is not allowed to
	// configure the screen brightness. screenBrightness must be set. Supported on
	// Android 9 and above on fully managed devices. A NonComplianceDetail with
	// API_LEVEL is reported if the Android version is less than 9. Supported on
	// work profiles on company-owned devices on Android 15 and above.
	ScreenBrightnessMode string `json:"screenBrightnessMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScreenBrightness") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScreenBrightness") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScreenBrightnessSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ScreenBrightnessSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScreenTimeoutSettings: Controls the screen timeout settings.
type ScreenTimeoutSettings struct {
	// ScreenTimeout: Optional. Controls the screen timeout duration. The screen
	// timeout duration must be greater than 0, otherwise it is rejected.
	// Additionally, it should not be greater than maximumTimeToLock, otherwise the
	// screen timeout is set to maximumTimeToLock and a NonComplianceDetail with
	// INVALID_VALUE reason and SCREEN_TIMEOUT_GREATER_THAN_MAXIMUM_TIME_TO_LOCK
	// specific reason is reported. If the screen timeout is less than a certain
	// lower bound, it is set to the lower bound. The lower bound may vary across
	// devices. If this is set, screenTimeoutMode must be SCREEN_TIMEOUT_ENFORCED.
	// Supported on Android 9 and above on fully managed devices. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 9. Supported on work profiles on company-owned devices on Android
	// 15 and above.
	ScreenTimeout string `json:"screenTimeout,omitempty"`
	// ScreenTimeoutMode: Optional. Controls whether the user is allowed to
	// configure the screen timeout.
	//
	// Possible values:
	//   "SCREEN_TIMEOUT_MODE_UNSPECIFIED" - Unspecified. Defaults to
	// SCREEN_TIMEOUT_USER_CHOICE.
	//   "SCREEN_TIMEOUT_USER_CHOICE" - The user is allowed to configure the screen
	// timeout. screenTimeout must not be set.
	//   "SCREEN_TIMEOUT_ENFORCED" - The screen timeout is set to screenTimeout and
	// the user is not allowed to configure the timeout. screenTimeout must be set.
	// Supported on Android 9 and above on fully managed devices. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 9. Supported on work profiles on company-owned devices on Android
	// 15 and above.
	ScreenTimeoutMode string `json:"screenTimeoutMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScreenTimeout") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScreenTimeout") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScreenTimeoutSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ScreenTimeoutSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityPosture: The security posture of the device, as determined by the
// current device state and the policies applied.
type SecurityPosture struct {
	// DevicePosture: Device's security posture value.
	//
	// Possible values:
	//   "POSTURE_UNSPECIFIED" - Unspecified. There is no posture detail for this
	// posture value.
	//   "SECURE" - This device is secure.
	//   "AT_RISK" - This device may be more vulnerable to malicious actors than is
	// recommended for use with corporate data.
	//   "POTENTIALLY_COMPROMISED" - This device may be compromised and corporate
	// data may be accessible to unauthorized actors.
	DevicePosture string `json:"devicePosture,omitempty"`
	// PostureDetails: Additional details regarding the security posture of the
	// device.
	PostureDetails []*PostureDetail `json:"postureDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DevicePosture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DevicePosture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityPosture) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityPosture
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetupAction: An action executed during setup.
type SetupAction struct {
	// Description: Description of this action.
	Description *UserFacingMessage `json:"description,omitempty"`
	// LaunchApp: An action to launch an app. The app will be launched with an
	// intent containing an extra with key
	// com.google.android.apps.work.clouddpc.EXTRA_LAUNCHED_AS_SETUP_ACTION set to
	// the boolean value true to indicate that this is a setup action flow. If
	// SetupAction references an app, the corresponding installType in the
	// application policy must be set as REQUIRED_FOR_SETUP or said setup will
	// fail.
	LaunchApp *LaunchAppAction `json:"launchApp,omitempty"`
	// Title: Title of this action.
	Title *UserFacingMessage `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetupAction) MarshalJSON() ([]byte, error) {
	type NoMethod SetupAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SigninDetail: A resource containing sign in details for an enterprise. Use
// enterprises to manage SigninDetails for a given enterprise.For an
// enterprise, we can have any number of SigninDetails that is uniquely
// identified by combination of the following three fields (signin_url,
// allow_personal_usage, token_tag). One cannot create two SigninDetails with
// the same (signin_url, allow_personal_usage, token_tag). (token_tag is an
// optional field).Patch: The operation updates the current list of
// SigninDetails with the new list of SigninDetails. If the stored SigninDetail
// configuration is passed, it returns the same signin_enrollment_token and
// qr_code. If we pass multiple identical SigninDetail configurations that are
// not stored, it will store the first one amongst those SigninDetail
// configurations. if the configuration already exists we cannot request it
// more than once in a particular patch API call, otherwise it will give a
// duplicate key error and the whole operation will fail. If we remove certain
// SigninDetail configuration from the request then it will get removed from
// the storage. We can then request another signin_enrollment_token and qr_code
// for the same SigninDetail configuration.
type SigninDetail struct {
	// AllowPersonalUsage: Controls whether personal usage is allowed on a device
	// provisioned with this enrollment token.For company-owned devices: Enabling
	// personal usage allows the user to set up a work profile on the device.
	// Disabling personal usage requires the user provision the device as a fully
	// managed device.For personally-owned devices: Enabling personal usage allows
	// the user to set up a work profile on the device. Disabling personal usage
	// will prevent the device from provisioning. Personal usage cannot be disabled
	// on personally-owned device.
	//
	// Possible values:
	//   "ALLOW_PERSONAL_USAGE_UNSPECIFIED" - Personal usage restriction is not
	// specified
	//   "PERSONAL_USAGE_ALLOWED" - Personal usage is allowed
	//   "PERSONAL_USAGE_DISALLOWED" - Personal usage is disallowed
	//   "PERSONAL_USAGE_DISALLOWED_USERLESS" - Device is not associated with a
	// single user, and thus both personal usage and corporate identity
	// authentication are not expected. Important: This setting is mandatory for
	// dedicated device enrollment and it is a breaking change. This change needs
	// to be implemented before January 2025.For additional details see the
	// dedicated device provisioning guide
	// (https://developers.google.com/android/management/provision-device#company-owned_devices_for_work_use_only).
	AllowPersonalUsage string `json:"allowPersonalUsage,omitempty"`
	// DefaultStatus: Optional. Whether the sign-in URL should be used by default
	// for the enterprise. The SigninDetail with defaultStatus set to
	// SIGNIN_DETAIL_IS_DEFAULT is used for Google account enrollment method. Only
	// one of an enterprise's signinDetails can have defaultStatus set to
	// SIGNIN_DETAIL_IS_DEFAULT. If an Enterprise has at least one signinDetails
	// and none of them have defaultStatus set to SIGNIN_DETAIL_IS_DEFAULT then the
	// first one from the list is selected and has set defaultStatus to
	// SIGNIN_DETAIL_IS_DEFAULT. If no signinDetails specified for the Enterprise
	// then the Google Account device enrollment will fail.
	//
	// Possible values:
	//   "SIGNIN_DETAIL_DEFAULT_STATUS_UNSPECIFIED" - Equivalent to
	// SIGNIN_DETAIL_IS_NOT_DEFAULT.
	//   "SIGNIN_DETAIL_IS_DEFAULT" - The sign-in URL will be used by default for
	// the enterprise.
	//   "SIGNIN_DETAIL_IS_NOT_DEFAULT" - The sign-in URL will not be used by
	// default for the enterprise.
	DefaultStatus string `json:"defaultStatus,omitempty"`
	// QrCode: A JSON string whose UTF-8 representation can be used to generate a
	// QR code to enroll a device with this enrollment token. To enroll a device
	// using NFC, the NFC record must contain a serialized java.util.Properties
	// representation of the properties in the JSON. This is a read-only field
	// generated by the server.
	QrCode string `json:"qrCode,omitempty"`
	// SigninEnrollmentToken: An enterprise wide enrollment token used to trigger
	// custom sign-in flow. This is a read-only field generated by the server.
	SigninEnrollmentToken string `json:"signinEnrollmentToken,omitempty"`
	// SigninUrl: Sign-in URL for authentication when device is provisioned with a
	// sign-in enrollment token. The sign-in endpoint should finish authentication
	// flow with a URL in the form of
	// https://enterprise.google.com/android/enroll?et= for a successful login, or
	// https://enterprise.google.com/android/enroll/invalid for a failed login.
	SigninUrl string `json:"signinUrl,omitempty"`
	// TokenTag: An EMM-specified metadata to distinguish between instances of
	// SigninDetail.
	TokenTag string `json:"tokenTag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPersonalUsage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPersonalUsage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SigninDetail) MarshalJSON() ([]byte, error) {
	type NoMethod SigninDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SignupUrl: An enterprise signup URL.
type SignupUrl struct {
	// Name: The name of the resource. Use this value in the signupUrl field when
	// calling enterprises.create to complete the enterprise signup flow.
	Name string `json:"name,omitempty"`
	// Url: A URL where an enterprise admin can register their enterprise. The page
	// can't be rendered in an iframe.
	Url string `json:"url,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SignupUrl) MarshalJSON() ([]byte, error) {
	type NoMethod SignupUrl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SoftwareInfo: Information about device software.
type SoftwareInfo struct {
	// AndroidBuildNumber: Android build ID string meant for displaying to the
	// user. For example, shamu-userdebug 6.0.1 MOB30I 2756745 dev-keys.
	AndroidBuildNumber string `json:"androidBuildNumber,omitempty"`
	// AndroidBuildTime: Build time.
	AndroidBuildTime string `json:"androidBuildTime,omitempty"`
	// AndroidDevicePolicyVersionCode: The Android Device Policy app version code.
	AndroidDevicePolicyVersionCode int64 `json:"androidDevicePolicyVersionCode,omitempty"`
	// AndroidDevicePolicyVersionName: The Android Device Policy app version as
	// displayed to the user.
	AndroidDevicePolicyVersionName string `json:"androidDevicePolicyVersionName,omitempty"`
	// AndroidVersion: The user-visible Android version string. For example, 6.0.1.
	AndroidVersion string `json:"androidVersion,omitempty"`
	// BootloaderVersion: The system bootloader version number, e.g. 0.6.7.
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`
	// DeviceBuildSignature: SHA-256 hash of android.content.pm.Signature
	// (https://developer.android.com/reference/android/content/pm/Signature.html)
	// associated with the system package, which can be used to verify that the
	// system build hasn't been modified.
	DeviceBuildSignature string `json:"deviceBuildSignature,omitempty"`
	// DeviceKernelVersion: Kernel version, for example, 2.6.32.9-g103d848.
	DeviceKernelVersion string `json:"deviceKernelVersion,omitempty"`
	// PrimaryLanguageCode: An IETF BCP 47 language code for the primary locale on
	// the device.
	PrimaryLanguageCode string `json:"primaryLanguageCode,omitempty"`
	// SecurityPatchLevel: Security patch level, e.g. 2016-05-01.
	SecurityPatchLevel string `json:"securityPatchLevel,omitempty"`
	// SystemUpdateInfo: Information about a potential pending system update.
	SystemUpdateInfo *SystemUpdateInfo `json:"systemUpdateInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AndroidBuildNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidBuildNumber") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SoftwareInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SoftwareInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SpecificNonComplianceContext: Additional context for
// SpecificNonComplianceReason.
type SpecificNonComplianceContext struct {
	// DefaultApplicationContext: Output only. Additional context for
	// non-compliance related to default application settings. See
	// DEFAULT_APPLICATION_SETTING_FAILED_FOR_SCOPE.
	DefaultApplicationContext *DefaultApplicationContext `json:"defaultApplicationContext,omitempty"`
	// OncWifiContext: Additional context for non-compliance related to Wi-Fi
	// configuration. See ONC_WIFI_INVALID_VALUE and ONC_WIFI_API_LEVEL
	OncWifiContext *OncWifiContext `json:"oncWifiContext,omitempty"`
	// PasswordPoliciesContext: Additional context for non-compliance related to
	// password policies. See PASSWORD_POLICIES_PASSWORD_EXPIRED and
	// PASSWORD_POLICIES_PASSWORD_NOT_SUFFICIENT.
	PasswordPoliciesContext *PasswordPoliciesContext `json:"passwordPoliciesContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultApplicationContext")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultApplicationContext") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SpecificNonComplianceContext) MarshalJSON() ([]byte, error) {
	type NoMethod SpecificNonComplianceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartLostModeParams: Parameters associated with the START_LOST_MODE command
// to put the device into lost mode. At least one of the parameters, not
// including the organization name, must be provided in order for the device to
// be put into lost mode.
type StartLostModeParams struct {
	// LostEmailAddress: The email address displayed to the user when the device is
	// in lost mode.
	LostEmailAddress string `json:"lostEmailAddress,omitempty"`
	// LostMessage: The message displayed to the user when the device is in lost
	// mode.
	LostMessage *UserFacingMessage `json:"lostMessage,omitempty"`
	// LostOrganization: The organization name displayed to the user when the
	// device is in lost mode.
	LostOrganization *UserFacingMessage `json:"lostOrganization,omitempty"`
	// LostPhoneNumber: The phone number that will be called when the device is in
	// lost mode and the call owner button is tapped.
	LostPhoneNumber *UserFacingMessage `json:"lostPhoneNumber,omitempty"`
	// LostStreetAddress: The street address displayed to the user when the device
	// is in lost mode.
	LostStreetAddress *UserFacingMessage `json:"lostStreetAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LostEmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LostEmailAddress") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartLostModeParams) MarshalJSON() ([]byte, error) {
	type NoMethod StartLostModeParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartLostModeStatus: Status of the START_LOST_MODE command to put the device
// into lost mode.
type StartLostModeStatus struct {
	// Status: The status. See StartLostModeStatus.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified. This value is not used.
	//   "SUCCESS" - The device was put into lost mode.
	//   "RESET_PASSWORD_RECENTLY" - The device could not be put into lost mode
	// because the admin reset the device's password recently.
	//   "USER_EXIT_LOST_MODE_RECENTLY" - The device could not be put into lost
	// mode because the user exited lost mode recently.
	//   "ALREADY_IN_LOST_MODE" - The device is already in lost mode.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartLostModeStatus) MarshalJSON() ([]byte, error) {
	type NoMethod StartLostModeStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The Status type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each Status message contains three
// pieces of data: error code, error message, and error details.You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatusReportingSettings: Settings controlling the behavior of status
// reports.
type StatusReportingSettings struct {
	// ApplicationReportingSettings: Application reporting settings. Only
	// applicable if application_reports_enabled is true.
	ApplicationReportingSettings *ApplicationReportingSettings `json:"applicationReportingSettings,omitempty"`
	// ApplicationReportsEnabled: Whether app reports are enabled.
	ApplicationReportsEnabled bool `json:"applicationReportsEnabled,omitempty"`
	// CommonCriteriaModeEnabled: Whether Common Criteria Mode reporting is
	// enabled. This is supported only on company-owned devices.
	CommonCriteriaModeEnabled bool `json:"commonCriteriaModeEnabled,omitempty"`
	// DefaultApplicationInfoReportingEnabled: Optional. Whether
	// defaultApplicationInfo reporting is enabled.
	DefaultApplicationInfoReportingEnabled bool `json:"defaultApplicationInfoReportingEnabled,omitempty"`
	// DeviceSettingsEnabled: Whether device settings reporting is enabled.
	DeviceSettingsEnabled bool `json:"deviceSettingsEnabled,omitempty"`
	// DisplayInfoEnabled: Whether displays reporting is enabled. Report data is
	// not available for personally owned devices with work profiles.
	DisplayInfoEnabled bool `json:"displayInfoEnabled,omitempty"`
	// HardwareStatusEnabled: Whether hardware status reporting is enabled. Report
	// data is not available for personally owned devices with work profiles.
	HardwareStatusEnabled bool `json:"hardwareStatusEnabled,omitempty"`
	// MemoryInfoEnabled: Whether memory event reporting is enabled.
	MemoryInfoEnabled bool `json:"memoryInfoEnabled,omitempty"`
	// NetworkInfoEnabled: Whether network info reporting is enabled.
	NetworkInfoEnabled bool `json:"networkInfoEnabled,omitempty"`
	// PowerManagementEventsEnabled: Whether power management event reporting is
	// enabled. Report data is not available for personally owned devices with work
	// profiles.
	PowerManagementEventsEnabled bool `json:"powerManagementEventsEnabled,omitempty"`
	// SoftwareInfoEnabled: Whether software info reporting is enabled.
	SoftwareInfoEnabled bool `json:"softwareInfoEnabled,omitempty"`
	// SystemPropertiesEnabled: Whether system properties reporting is enabled.
	SystemPropertiesEnabled bool `json:"systemPropertiesEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ApplicationReportingSettings") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationReportingSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatusReportingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod StatusReportingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopLostModeParams: Parameters associated with the STOP_LOST_MODE command to
// take the device out of lost mode.
type StopLostModeParams struct {
}

// StopLostModeStatus: Status of the STOP_LOST_MODE command to take the device
// out of lost mode.
type StopLostModeStatus struct {
	// Status: The status. See StopLostModeStatus.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified. This value is not used.
	//   "SUCCESS" - The device was taken out of lost mode.
	//   "NOT_IN_LOST_MODE" - The device is not in lost mode.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StopLostModeStatus) MarshalJSON() ([]byte, error) {
	type NoMethod StopLostModeStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopLostModeUserAttemptEvent: A lost mode event indicating the user has
// attempted to stop lost mode.
type StopLostModeUserAttemptEvent struct {
	// Status: The status of the attempt to stop lost mode.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - This value is not used.
	//   "ATTEMPT_SUCCEEDED" - Indicates that the user successfully stopped lost
	// mode.
	//   "ATTEMPT_FAILED" - Indicates that the user's attempt to stop lost mode
	// failed.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StopLostModeUserAttemptEvent) MarshalJSON() ([]byte, error) {
	type NoMethod StopLostModeUserAttemptEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SystemUpdate: Configuration for managing system updatesNote: Google Play
// system updates (https://source.android.com/docs/core/ota/modular-system)
// (also called Mainline updates) are automatically downloaded but require a
// device reboot to be installed. Refer to the mainline section in Manage
// system updates
// (https://developer.android.com/work/dpc/system-updates#mainline) for further
// details.
type SystemUpdate struct {
	// EndMinutes: If the type is WINDOWED, the end of the maintenance window,
	// measured as the number of minutes after midnight in device's local time.
	// This value must be between 0 and 1439, inclusive. If this value is less than
	// start_minutes, then the maintenance window spans midnight. If the
	// maintenance window specified is smaller than 30 minutes, the actual window
	// is extended to 30 minutes beyond the start time.
	EndMinutes int64 `json:"endMinutes,omitempty"`
	// FreezePeriods: An annually repeating time period in which over-the-air (OTA)
	// system updates are postponed to freeze the OS version running on a device.
	// To prevent freezing the device indefinitely, each freeze period must be
	// separated by at least 60 days.
	FreezePeriods []*FreezePeriod `json:"freezePeriods,omitempty"`
	// StartMinutes: If the type is WINDOWED, the start of the maintenance window,
	// measured as the number of minutes after midnight in the device's local time.
	// This value must be between 0 and 1439, inclusive.
	StartMinutes int64 `json:"startMinutes,omitempty"`
	// Type: The type of system update to configure.
	//
	// Possible values:
	//   "SYSTEM_UPDATE_TYPE_UNSPECIFIED" - Follow the default update behavior for
	// the device, which typically requires the user to accept system updates.
	//   "AUTOMATIC" - Install automatically as soon as an update is available.
	//   "WINDOWED" - Install automatically within a daily maintenance window. This
	// also configures Play apps to be updated within the window. This is strongly
	// recommended for kiosk devices because this is the only way apps persistently
	// pinned to the foreground can be updated by Play.If autoUpdateMode is set to
	// AUTO_UPDATE_HIGH_PRIORITY for an app, then the maintenance window is ignored
	// for that app and it is updated as soon as possible even outside of the
	// maintenance window.
	//   "POSTPONE" - Postpone automatic install up to a maximum of 30 days. This
	// policy does not affect security updates (e.g. monthly security patches).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndMinutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndMinutes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SystemUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod SystemUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SystemUpdateInfo: Information about a potential pending system update.
type SystemUpdateInfo struct {
	// UpdateReceivedTime: The time when the update was first available. A zero
	// value indicates that this field is not set. This field is set only if an
	// update is available (that is, updateStatus is neither UPDATE_STATUS_UNKNOWN
	// nor UP_TO_DATE).
	UpdateReceivedTime string `json:"updateReceivedTime,omitempty"`
	// UpdateStatus: The status of an update: whether an update exists and what
	// type it is.
	//
	// Possible values:
	//   "UPDATE_STATUS_UNKNOWN" - It is unknown whether there is a pending system
	// update. This happens when, for example, the device API level is less than
	// 26, or if the version of Android Device Policy is outdated.
	//   "UP_TO_DATE" - There is no pending system update available on the device.
	//   "UNKNOWN_UPDATE_AVAILABLE" - There is a pending system update available,
	// but its type is not known.
	//   "SECURITY_UPDATE_AVAILABLE" - There is a pending security update
	// available.
	//   "OS_UPDATE_AVAILABLE" - There is a pending OS update available.
	UpdateStatus string `json:"updateStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateReceivedTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateReceivedTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SystemUpdateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SystemUpdateInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TelephonyInfo: Telephony information associated with a given SIM card on the
// device. Only supported on fully managed devices starting from Android API
// level 23.
type TelephonyInfo struct {
	// ActivationState: Output only. Activation state of the SIM card on the
	// device. This is applicable for eSIMs only. This is supported on all devices
	// for API level 35 and above. This is always ACTIVATION_STATE_UNSPECIFIED for
	// physical SIMs and for devices below API level 35.
	//
	// Possible values:
	//   "ACTIVATION_STATE_UNSPECIFIED" - Activation state is not specified.
	//   "ACTIVATED" - The SIM card is activated.
	//   "NOT_ACTIVATED" - The SIM card is not activated.
	ActivationState string `json:"activationState,omitempty"`
	// CarrierName: The carrier name associated with this SIM card.
	CarrierName string `json:"carrierName,omitempty"`
	// ConfigMode: Output only. The configuration mode of the SIM card on the
	// device. This is applicable for eSIMs only. This is supported on all devices
	// for API level 35 and above. This is always CONFIG_MODE_UNSPECIFIED for
	// physical SIMs and for devices below API level 35.
	//
	// Possible values:
	//   "CONFIG_MODE_UNSPECIFIED" - The configuration mode is unspecified.
	//   "ADMIN_CONFIGURED" - The admin has configured this SIM.
	//   "USER_CONFIGURED" - The user has configured this SIM.
	ConfigMode string `json:"configMode,omitempty"`
	// IccId: Output only. The ICCID associated with this SIM card.
	IccId string `json:"iccId,omitempty"`
	// PhoneNumber: The phone number associated with this SIM card.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TelephonyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TelephonyInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TermsAndConditions: A terms and conditions page to be accepted during
// provisioning.
type TermsAndConditions struct {
	// Content: A well-formatted HTML string. It will be parsed on the client with
	// android.text.Html#fromHtml.
	Content *UserFacingMessage `json:"content,omitempty"`
	// Header: A short header which appears above the HTML content.
	Header *UserFacingMessage `json:"header,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TermsAndConditions) MarshalJSON() ([]byte, error) {
	type NoMethod TermsAndConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageLog: Controls types of device activity logs collected from the device
// and reported via Pub/Sub notification
// (https://developers.google.com/android/management/notifications).
type UsageLog struct {
	// EnabledLogTypes: Specifies which log types are enabled. Note that users will
	// receive on-device messaging when usage logging is enabled.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - This value is not used.
	//   "SECURITY_LOGS" - Enable logging of on-device security events, like when
	// the device password is incorrectly entered or removable storage is mounted.
	// See UsageLogEvent for a complete description of the logged security events.
	// Supported for fully managed devices on Android 7 and above. Supported for
	// company-owned devices with a work profile on Android 12 and above, on which
	// only security events from the work profile are logged. Can be overridden by
	// the application delegated scope SECURITY_LOGS
	//   "NETWORK_ACTIVITY_LOGS" - Enable logging of on-device network events, like
	// DNS lookups and TCP connections. See UsageLogEvent for a complete
	// description of the logged network events. Supported for fully managed
	// devices on Android 8 and above. Supported for company-owned devices with a
	// work profile on Android 12 and above, on which only network events from the
	// work profile are logged. Can be overridden by the application delegated
	// scope NETWORK_ACTIVITY_LOGS
	EnabledLogTypes []string `json:"enabledLogTypes,omitempty"`
	// UploadOnCellularAllowed: Specifies which of the enabled log types can be
	// uploaded over mobile data. By default logs are queued for upload when the
	// device connects to WiFi.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - This value is not used.
	//   "SECURITY_LOGS" - Enable logging of on-device security events, like when
	// the device password is incorrectly entered or removable storage is mounted.
	// See UsageLogEvent for a complete description of the logged security events.
	// Supported for fully managed devices on Android 7 and above. Supported for
	// company-owned devices with a work profile on Android 12 and above, on which
	// only security events from the work profile are logged. Can be overridden by
	// the application delegated scope SECURITY_LOGS
	//   "NETWORK_ACTIVITY_LOGS" - Enable logging of on-device network events, like
	// DNS lookups and TCP connections. See UsageLogEvent for a complete
	// description of the logged network events. Supported for fully managed
	// devices on Android 8 and above. Supported for company-owned devices with a
	// work profile on Android 12 and above, on which only network events from the
	// work profile are logged. Can be overridden by the application delegated
	// scope NETWORK_ACTIVITY_LOGS
	UploadOnCellularAllowed []string `json:"uploadOnCellularAllowed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnabledLogTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnabledLogTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageLog) MarshalJSON() ([]byte, error) {
	type NoMethod UsageLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageLogEvent: An event logged on the device.
type UsageLogEvent struct {
	// AdbShellCommandEvent: A shell command was issued over ADB via “adb shell
	// command”. Part of SECURITY_LOGS.
	AdbShellCommandEvent *AdbShellCommandEvent `json:"adbShellCommandEvent,omitempty"`
	// AdbShellInteractiveEvent: An ADB interactive shell was opened via “adb
	// shell”. Part of SECURITY_LOGS.
	AdbShellInteractiveEvent *AdbShellInteractiveEvent `json:"adbShellInteractiveEvent,omitempty"`
	// AppProcessStartEvent: An app process was started. Part of SECURITY_LOGS.
	AppProcessStartEvent *AppProcessStartEvent `json:"appProcessStartEvent,omitempty"`
	// BackupServiceToggledEvent: An admin has enabled or disabled backup service.
	// Part of SECURITY_LOGS.
	BackupServiceToggledEvent *BackupServiceToggledEvent `json:"backupServiceToggledEvent,omitempty"`
	// CertAuthorityInstalledEvent: A new root certificate was installed into the
	// system's trusted credential storage. Part of SECURITY_LOGS.
	CertAuthorityInstalledEvent *CertAuthorityInstalledEvent `json:"certAuthorityInstalledEvent,omitempty"`
	// CertAuthorityRemovedEvent: A root certificate was removed from the system's
	// trusted credential storage. Part of SECURITY_LOGS.
	CertAuthorityRemovedEvent *CertAuthorityRemovedEvent `json:"certAuthorityRemovedEvent,omitempty"`
	// CertValidationFailureEvent: An X.509v3 certificate failed to validate,
	// currently this validation is performed on the Wi-FI access point and failure
	// may be due to a mismatch upon server certificate validation. However it may
	// in the future include other validation events of an X.509v3 certificate.
	// Part of SECURITY_LOGS.
	CertValidationFailureEvent *CertValidationFailureEvent `json:"certValidationFailureEvent,omitempty"`
	// ConnectEvent: A TCP connect event was initiated through the standard network
	// stack. Part of NETWORK_ACTIVITY_LOGS.
	ConnectEvent *ConnectEvent `json:"connectEvent,omitempty"`
	// CryptoSelfTestCompletedEvent: Validates whether Android’s built-in
	// cryptographic library (BoringSSL) is valid. Should always succeed on device
	// boot, if it fails, the device should be considered untrusted. Part of
	// SECURITY_LOGS.
	CryptoSelfTestCompletedEvent *CryptoSelfTestCompletedEvent `json:"cryptoSelfTestCompletedEvent,omitempty"`
	// DnsEvent: A DNS lookup event was initiated through the standard network
	// stack. Part of NETWORK_ACTIVITY_LOGS.
	DnsEvent *DnsEvent `json:"dnsEvent,omitempty"`
	// EnrollmentCompleteEvent: Device has completed enrollment. Part of
	// AMAPI_LOGS.
	EnrollmentCompleteEvent *EnrollmentCompleteEvent `json:"enrollmentCompleteEvent,omitempty"`
	// EventId: Unique id of the event.
	EventId int64 `json:"eventId,omitempty,string"`
	// EventTime: Device timestamp when the event was logged.
	EventTime string `json:"eventTime,omitempty"`
	// EventType: The particular usage log event type that was reported on the
	// device. Use this to determine which event field to access.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - This value is not used
	//   "ADB_SHELL_COMMAND" - Indicates adb_shell_command_event has been set.
	//   "ADB_SHELL_INTERACTIVE" - Indicates adb_shell_interactive_event has been
	// set.
	//   "APP_PROCESS_START" - Indicates app_process_start_event has been set.
	//   "KEYGUARD_DISMISSED" - Indicates keyguard_dismissed_event has been set.
	//   "KEYGUARD_DISMISS_AUTH_ATTEMPT" - Indicates
	// keyguard_dismiss_auth_attempt_event has been set.
	//   "KEYGUARD_SECURED" - Indicates keyguard_secured_event has been set.
	//   "FILE_PULLED" - Indicates file_pulled_event has been set.
	//   "FILE_PUSHED" - Indicates file_pushed_event has been set.
	//   "CERT_AUTHORITY_INSTALLED" - Indicates cert_authority_installed_event has
	// been set.
	//   "CERT_AUTHORITY_REMOVED" - Indicates cert_authority_removed_event has been
	// set.
	//   "CERT_VALIDATION_FAILURE" - Indicates cert_validation_failure_event has
	// been set.
	//   "CRYPTO_SELF_TEST_COMPLETED" - Indicates crypto_self_test_completed_event
	// has been set.
	//   "KEY_DESTRUCTION" - Indicates key_destruction_event has been set.
	//   "KEY_GENERATED" - Indicates key_generated_event has been set.
	//   "KEY_IMPORT" - Indicates key_import_event has been set.
	//   "KEY_INTEGRITY_VIOLATION" - Indicates key_integrity_violation_event has
	// been set.
	//   "LOGGING_STARTED" - Indicates logging_started_event has been set.
	//   "LOGGING_STOPPED" - Indicates logging_stopped_event has been set.
	//   "LOG_BUFFER_SIZE_CRITICAL" - Indicates log_buffer_size_critical_event has
	// been set.
	//   "MEDIA_MOUNT" - Indicates media_mount_event has been set.
	//   "MEDIA_UNMOUNT" - Indicates media_unmount_event has been set.
	//   "OS_SHUTDOWN" - Indicates os_shutdown_event has been set.
	//   "OS_STARTUP" - Indicates os_startup_event has been set.
	//   "REMOTE_LOCK" - Indicates remote_lock_event has been set.
	//   "WIPE_FAILURE" - Indicates wipe_failure_event has been set.
	//   "CONNECT" - Indicates connect_event has been set.
	//   "DNS" - Indicates dns_event has been set.
	//   "STOP_LOST_MODE_USER_ATTEMPT" - Indicates stopLostModeUserAttemptEvent has
	// been set.
	//   "LOST_MODE_OUTGOING_PHONE_CALL" - Indicates lostModeOutgoingPhoneCallEvent
	// has been set.
	//   "LOST_MODE_LOCATION" - Indicates lostModeLocationEvent has been set.
	//   "ENROLLMENT_COMPLETE" - Indicates enrollment_complete_event has been set.
	//   "BACKUP_SERVICE_TOGGLED" - Indicates backupServiceToggledEvent has been
	// set.
	EventType string `json:"eventType,omitempty"`
	// FilePulledEvent: A file was downloaded from the device. Part of
	// SECURITY_LOGS.
	FilePulledEvent *FilePulledEvent `json:"filePulledEvent,omitempty"`
	// FilePushedEvent: A file was uploaded onto the device. Part of SECURITY_LOGS.
	FilePushedEvent *FilePushedEvent `json:"filePushedEvent,omitempty"`
	// KeyDestructionEvent: A cryptographic key including user installed, admin
	// installed and system maintained private key is removed from the device
	// either by the user or management. Part of SECURITY_LOGS.
	KeyDestructionEvent *KeyDestructionEvent `json:"keyDestructionEvent,omitempty"`
	// KeyGeneratedEvent: A cryptographic key including user installed, admin
	// installed and system maintained private key is installed on the device
	// either by the user or management. Part of SECURITY_LOGS.
	KeyGeneratedEvent *KeyGeneratedEvent `json:"keyGeneratedEvent,omitempty"`
	// KeyImportEvent: A cryptographic key including user installed, admin
	// installed and system maintained private key is imported on the device either
	// by the user or management. Part of SECURITY_LOGS.
	KeyImportEvent *KeyImportEvent `json:"keyImportEvent,omitempty"`
	// KeyIntegrityViolationEvent: A cryptographic key including user installed,
	// admin installed and system maintained private key is determined to be
	// corrupted due to storage corruption, hardware failure or some OS issue. Part
	// of SECURITY_LOGS.
	KeyIntegrityViolationEvent *KeyIntegrityViolationEvent `json:"keyIntegrityViolationEvent,omitempty"`
	// KeyguardDismissAuthAttemptEvent: An attempt was made to unlock the device.
	// Part of SECURITY_LOGS.
	KeyguardDismissAuthAttemptEvent *KeyguardDismissAuthAttemptEvent `json:"keyguardDismissAuthAttemptEvent,omitempty"`
	// KeyguardDismissedEvent: The keyguard was dismissed. Part of SECURITY_LOGS.
	KeyguardDismissedEvent *KeyguardDismissedEvent `json:"keyguardDismissedEvent,omitempty"`
	// KeyguardSecuredEvent: The device was locked either by user or timeout. Part
	// of SECURITY_LOGS.
	KeyguardSecuredEvent *KeyguardSecuredEvent `json:"keyguardSecuredEvent,omitempty"`
	// LogBufferSizeCriticalEvent: The audit log buffer has reached 90% of its
	// capacity, therefore older events may be dropped. Part of SECURITY_LOGS.
	LogBufferSizeCriticalEvent *LogBufferSizeCriticalEvent `json:"logBufferSizeCriticalEvent,omitempty"`
	// LoggingStartedEvent: usageLog policy has been enabled. Part of
	// SECURITY_LOGS.
	LoggingStartedEvent *LoggingStartedEvent `json:"loggingStartedEvent,omitempty"`
	// LoggingStoppedEvent: usageLog policy has been disabled. Part of
	// SECURITY_LOGS.
	LoggingStoppedEvent *LoggingStoppedEvent `json:"loggingStoppedEvent,omitempty"`
	// LostModeLocationEvent: A lost mode location update when a device in lost
	// mode.
	LostModeLocationEvent *LostModeLocationEvent `json:"lostModeLocationEvent,omitempty"`
	// LostModeOutgoingPhoneCallEvent: An outgoing phone call has been made when a
	// device in lost mode.
	LostModeOutgoingPhoneCallEvent *LostModeOutgoingPhoneCallEvent `json:"lostModeOutgoingPhoneCallEvent,omitempty"`
	// MediaMountEvent: Removable media was mounted. Part of SECURITY_LOGS.
	MediaMountEvent *MediaMountEvent `json:"mediaMountEvent,omitempty"`
	// MediaUnmountEvent: Removable media was unmounted. Part of SECURITY_LOGS.
	MediaUnmountEvent *MediaUnmountEvent `json:"mediaUnmountEvent,omitempty"`
	// OsShutdownEvent: Device was shutdown. Part of SECURITY_LOGS.
	OsShutdownEvent *OsShutdownEvent `json:"osShutdownEvent,omitempty"`
	// OsStartupEvent: Device was started. Part of SECURITY_LOGS.
	OsStartupEvent *OsStartupEvent `json:"osStartupEvent,omitempty"`
	// RemoteLockEvent: The device or profile has been remotely locked via the LOCK
	// command. Part of SECURITY_LOGS.
	RemoteLockEvent *RemoteLockEvent `json:"remoteLockEvent,omitempty"`
	// StopLostModeUserAttemptEvent: An attempt to take a device out of lost mode.
	StopLostModeUserAttemptEvent *StopLostModeUserAttemptEvent `json:"stopLostModeUserAttemptEvent,omitempty"`
	// WipeFailureEvent: The work profile or company-owned device failed to wipe
	// when requested. This could be user initiated or admin initiated e.g. delete
	// was received. Part of SECURITY_LOGS.
	WipeFailureEvent *WipeFailureEvent `json:"wipeFailureEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdbShellCommandEvent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdbShellCommandEvent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageLogEvent) MarshalJSON() ([]byte, error) {
	type NoMethod UsageLogEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// User: A user belonging to an enterprise.
type User struct {
	// AccountIdentifier: A unique identifier you create for this user, such as
	// user342 or asset#44418. This field must be set when the user is created and
	// can't be updated. This field must not contain personally identifiable
	// information (PII). This identifier must be 1024 characters or less;
	// otherwise, the update policy request will fail.
	AccountIdentifier string `json:"accountIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountIdentifier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountIdentifier") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s User) MarshalJSON() ([]byte, error) {
	type NoMethod User
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserFacingMessage: Provides a user-facing message with locale info. The
// maximum message length is 4096 characters.
type UserFacingMessage struct {
	// DefaultMessage: The default message displayed if no localized message is
	// specified or the user's locale doesn't match with any of the localized
	// messages. A default message must be provided if any localized messages are
	// provided.
	DefaultMessage string `json:"defaultMessage,omitempty"`
	// LocalizedMessages: A map containing pairs, where locale is a well-formed BCP
	// 47 language (https://www.w3.org/International/articles/language-tags/) code,
	// such as en-US, es-ES, or fr.
	LocalizedMessages map[string]string `json:"localizedMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultMessage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserFacingMessage) MarshalJSON() ([]byte, error) {
	type NoMethod UserFacingMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebApp: A web app.
type WebApp struct {
	// DisplayMode: The display mode of the web app.
	//
	// Possible values:
	//   "DISPLAY_MODE_UNSPECIFIED" - Not used.
	//   "MINIMAL_UI" - Opens the web app with a minimal set of browser UI elements
	// for controlling navigation and viewing the page URL.
	//   "STANDALONE" - Opens the web app to look and feel like a standalone native
	// application. The browser UI elements and page URL are not visible, however
	// the system status bar and back button are visible.
	//   "FULL_SCREEN" - Opens the web app in full screen without any visible
	// controls. The browser UI elements, page URL, system status bar and back
	// button are not visible, and the web app takes up the entirety of the
	// available display area.
	DisplayMode string `json:"displayMode,omitempty"`
	// Icons: A list of icons for the web app. Must have at least one element.
	Icons []*WebAppIcon `json:"icons,omitempty"`
	// Name: The name of the web app, which is generated by the server during
	// creation in the form enterprises/{enterpriseId}/webApps/{packageName}.
	Name string `json:"name,omitempty"`
	// StartUrl: The start URL, i.e. the URL that should load when the user opens
	// the application.
	StartUrl string `json:"startUrl,omitempty"`
	// Title: The title of the web app as displayed to the user (e.g., amongst a
	// list of other applications, or as a label for an icon).
	Title string `json:"title,omitempty"`
	// VersionCode: The current version of the app.Note that the version can
	// automatically increase during the lifetime of the web app, while Google does
	// internal housekeeping to keep the web app up-to-date.
	VersionCode int64 `json:"versionCode,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebApp) MarshalJSON() ([]byte, error) {
	type NoMethod WebApp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebAppIcon: An icon for a web app. Supported formats are: png, jpg and webp.
type WebAppIcon struct {
	// ImageData: The actual bytes of the image in a base64url encoded string (c.f.
	// RFC4648, section 5 "Base 64 Encoding with URL and Filename Safe Alphabet").
	// - The image type can be png or jpg. - The image should ideally be square. -
	// The image should ideally have a size of 512x512.
	ImageData string `json:"imageData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebAppIcon) MarshalJSON() ([]byte, error) {
	type NoMethod WebAppIcon
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebToken: A web token used to access the managed Google Play iframe.
type WebToken struct {
	// EnabledFeatures: The features to enable. Use this if you want to control
	// exactly which feature(s) will be activated; leave empty to allow all
	// features.Restrictions / things to note: - If no features are listed here,
	// all features are enabled — this is the default behavior where you give
	// access to all features to your admins. - This must not contain any
	// FEATURE_UNSPECIFIED values. - Repeated values are ignored
	//
	// Possible values:
	//   "FEATURE_UNSPECIFIED" - Unspecified feature.
	//   "PLAY_SEARCH" - The Managed Play search apps page
	// (https://developers.google.com/android/management/apps#search-apps).
	//   "PRIVATE_APPS" - The private apps page
	// (https://developers.google.com/android/management/apps#private-apps).
	//   "WEB_APPS" - The Web Apps page
	// (https://developers.google.com/android/management/apps#web-apps).
	//   "STORE_BUILDER" - The organize apps page
	// (https://developers.google.com/android/management/apps#organize-apps).
	//   "MANAGED_CONFIGURATIONS" - The managed configurations page
	// (https://developers.google.com/android/management/managed-configurations-iframe).
	//   "ZERO_TOUCH_CUSTOMER_MANAGEMENT" - The zero-touch iframe
	// (https://developers.google.com/android/management/zero-touch-iframe).
	EnabledFeatures []string `json:"enabledFeatures,omitempty"`
	// Name: The name of the web token, which is generated by the server during
	// creation in the form enterprises/{enterpriseId}/webTokens/{webTokenId}.
	Name string `json:"name,omitempty"`
	// ParentFrameUrl: The URL of the parent frame hosting the iframe with the
	// embedded UI. To prevent XSS, the iframe may not be hosted at other URLs. The
	// URL must use the https scheme.
	ParentFrameUrl string `json:"parentFrameUrl,omitempty"`
	// Permissions: Permissions available to an admin in the embedded UI. An admin
	// must have all of these permissions in order to view the UI. This field is
	// deprecated.
	//
	// Possible values:
	//   "WEB_TOKEN_PERMISSION_UNSPECIFIED" - This value is ignored.
	//   "APPROVE_APPS" - The permission to approve apps for the enterprise.
	Permissions []string `json:"permissions,omitempty"`
	// Value: The token value which is used in the hosting page to generate the
	// iframe with the embedded UI. This is a read-only field generated by the
	// server.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnabledFeatures") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnabledFeatures") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebToken) MarshalJSON() ([]byte, error) {
	type NoMethod WebToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WifiRoamingPolicy: Wi-Fi roaming policy.
type WifiRoamingPolicy struct {
	// WifiRoamingSettings: Optional. Wi-Fi roaming settings. SSIDs provided in
	// this list must be unique, the policy will be rejected otherwise.
	WifiRoamingSettings []*WifiRoamingSetting `json:"wifiRoamingSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WifiRoamingSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WifiRoamingSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WifiRoamingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod WifiRoamingPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WifiRoamingSetting: Wi-Fi roaming setting.
type WifiRoamingSetting struct {
	// WifiRoamingMode: Required. Wi-Fi roaming mode for the specified SSID.
	//
	// Possible values:
	//   "WIFI_ROAMING_MODE_UNSPECIFIED" - Unspecified. Defaults to
	// WIFI_ROAMING_DEFAULT.
	//   "WIFI_ROAMING_DISABLED" - Wi-Fi roaming is disabled. Supported on Android
	// 15 and above on fully managed devices and work profiles on company-owned
	// devices. A NonComplianceDetail with MANAGEMENT_MODE is reported for other
	// management modes. A NonComplianceDetail with API_LEVEL is reported if the
	// Android version is less than 15.
	//   "WIFI_ROAMING_DEFAULT" - Default Wi-Fi roaming mode of the device.
	//   "WIFI_ROAMING_AGGRESSIVE" - Aggressive roaming mode which allows quicker
	// Wi-Fi roaming. Supported on Android 15 and above on fully managed devices
	// and work profiles on company-owned devices. A NonComplianceDetail with
	// MANAGEMENT_MODE is reported for other management modes. A
	// NonComplianceDetail with API_LEVEL is reported if the Android version is
	// less than 15. A NonComplianceDetail with DEVICE_INCOMPATIBLE is reported if
	// the device does not support aggressive roaming mode.
	WifiRoamingMode string `json:"wifiRoamingMode,omitempty"`
	// WifiSsid: Required. SSID of the Wi-Fi network.
	WifiSsid string `json:"wifiSsid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WifiRoamingMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WifiRoamingMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WifiRoamingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod WifiRoamingSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WifiSsid: Represents a Wi-Fi SSID.
type WifiSsid struct {
	// WifiSsid: Required. Wi-Fi SSID represented as a string.
	WifiSsid string `json:"wifiSsid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WifiSsid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WifiSsid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WifiSsid) MarshalJSON() ([]byte, error) {
	type NoMethod WifiSsid
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WifiSsidPolicy: Restrictions on which Wi-Fi SSIDs the device can connect to.
// Note that this does not affect which networks can be configured on the
// device. Supported on company-owned devices running Android 13 and above.
type WifiSsidPolicy struct {
	// WifiSsidPolicyType: Type of the Wi-Fi SSID policy to be applied.
	//
	// Possible values:
	//   "WIFI_SSID_POLICY_TYPE_UNSPECIFIED" - Defaults to WIFI_SSID_DENYLIST.
	// wifiSsids must not be set. There are no restrictions on which SSID the
	// device can connect to.
	//   "WIFI_SSID_DENYLIST" - The device cannot connect to any Wi-Fi network
	// whose SSID is in wifiSsids, but can connect to other networks.
	//   "WIFI_SSID_ALLOWLIST" - The device can make Wi-Fi connections only to the
	// SSIDs in wifiSsids. wifiSsids must not be empty. The device will not be able
	// to connect to any other Wi-Fi network.
	WifiSsidPolicyType string `json:"wifiSsidPolicyType,omitempty"`
	// WifiSsids: Optional. List of Wi-Fi SSIDs that should be applied in the
	// policy. This field must be non-empty when WifiSsidPolicyType is set to
	// WIFI_SSID_ALLOWLIST. If this is set to a non-empty list, then a
	// NonComplianceDetail detail with API_LEVEL is reported if the Android version
	// is less than 13 and a NonComplianceDetail with MANAGEMENT_MODE is reported
	// for non-company-owned devices.
	WifiSsids []*WifiSsid `json:"wifiSsids,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WifiSsidPolicyType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WifiSsidPolicyType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WifiSsidPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod WifiSsidPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeAction: An action to reset a company owned device or delete a work
// profile. Note: blockAction must also be specified.
type WipeAction struct {
	// PreserveFrp: Whether the factory-reset protection data is preserved on the
	// device. This setting doesn’t apply to work profiles.
	PreserveFrp bool `json:"preserveFrp,omitempty"`
	// WipeAfterDays: Number of days the policy is non-compliant before the device
	// or work profile is wiped. wipeAfterDays must be greater than blockAfterDays.
	WipeAfterDays int64 `json:"wipeAfterDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PreserveFrp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PreserveFrp") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeAction) MarshalJSON() ([]byte, error) {
	type NoMethod WipeAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WipeFailureEvent: The work profile or company-owned device failed to wipe
// when requested. This could be user initiated or admin initiated e.g. delete
// was received. Intentionally empty.
type WipeFailureEvent struct {
}

// WipeParams: Parameters associated with the WIPE command to wipe the device.
type WipeParams struct {
	// WipeDataFlags: Optional. Flags to determine what data to wipe.
	//
	// Possible values:
	//   "WIPE_DATA_FLAG_UNSPECIFIED" - This value is ignored.
	//   "PRESERVE_RESET_PROTECTION_DATA" - Preserve the factory reset protection
	// data on the device.
	//   "WIPE_EXTERNAL_STORAGE" - Additionally wipe the device's external storage
	// (such as SD cards).
	//   "WIPE_ESIMS" - For company-owned devices, this removes all eSIMs from the
	// device when the device is wiped. In personally-owned devices, this will
	// remove managed eSIMs (eSIMs which are added via the ADD_ESIM command) on the
	// devices and no personally owned eSIMs will be removed.
	WipeDataFlags []string `json:"wipeDataFlags,omitempty"`
	// WipeReason: Optional. A short message displayed to the user before wiping
	// the work profile on personal devices. This has no effect on company owned
	// devices. The maximum message length is 200 characters.
	WipeReason *UserFacingMessage `json:"wipeReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WipeDataFlags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WipeDataFlags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WipeParams) MarshalJSON() ([]byte, error) {
	type NoMethod WipeParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkAccountSetupConfig: Controls the work account setup configuration, such
// as details of whether a Google authenticated account is required.
type WorkAccountSetupConfig struct {
	// AuthenticationType: Optional. The authentication type of the user on the
	// device.
	//
	// Possible values:
	//   "AUTHENTICATION_TYPE_UNSPECIFIED" - Unspecified. Defaults to
	// AUTHENTICATION_TYPE_NOT_ENFORCED.
	//   "AUTHENTICATION_TYPE_NOT_ENFORCED" - Authentication status of user on
	// device is not enforced.
	//   "GOOGLE_AUTHENTICATED" - Requires device to be managed with a Google
	// authenticated account.
	AuthenticationType string `json:"authenticationType,omitempty"`
	// RequiredAccountEmail: Optional. The specific google work account email
	// address to be added. This field is only relevant if authenticationType is
	// GOOGLE_AUTHENTICATED. This must be an enterprise account and not a consumer
	// account. Once set and a Google authenticated account is added to the device,
	// changing this field will have no effect, and thus recommended to be set only
	// once.
	RequiredAccountEmail string `json:"requiredAccountEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthenticationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthenticationType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkAccountSetupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkAccountSetupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EnterprisesCreateCall struct {
	s          *Service
	enterprise *Enterprise
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an enterprise. This is the last step in the enterprise
// signup flow. See also: SigninDetail
func (r *EnterprisesService) Create(enterprise *Enterprise) *EnterprisesCreateCall {
	c := &EnterprisesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.enterprise = enterprise
	return c
}

// AgreementAccepted sets the optional parameter "agreementAccepted": Whether
// the enterprise admin has seen and agreed to the managed Google Play
// Agreement (https://www.android.com/enterprise/terms/). Do not set this field
// for any customer-managed enterprise
// (https://developers.google.com/android/management/create-enterprise#customer-managed_enterprises).
// Set this to field to true for all EMM-managed enterprises
// (https://developers.google.com/android/management/create-enterprise#emm-managed_enterprises).
func (c *EnterprisesCreateCall) AgreementAccepted(agreementAccepted bool) *EnterprisesCreateCall {
	c.urlParams_.Set("agreementAccepted", fmt.Sprint(agreementAccepted))
	return c
}

// EnterpriseToken sets the optional parameter "enterpriseToken": The
// enterprise token appended to the callback URL. Set this when creating a
// customer-managed enterprise
// (https://developers.google.com/android/management/create-enterprise#customer-managed_enterprises)
// and not when creating a deprecated EMM-managed enterprise
// (https://developers.google.com/android/management/create-enterprise#emm-managed_enterprises).
func (c *EnterprisesCreateCall) EnterpriseToken(enterpriseToken string) *EnterprisesCreateCall {
	c.urlParams_.Set("enterpriseToken", enterpriseToken)
	return c
}

// ProjectId sets the optional parameter "projectId": The ID of the Google
// Cloud Platform project which will own the enterprise.
func (c *EnterprisesCreateCall) ProjectId(projectId string) *EnterprisesCreateCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// SignupUrlName sets the optional parameter "signupUrlName": The name of the
// SignupUrl used to sign up for the enterprise. Set this when creating a
// customer-managed enterprise
// (https://developers.google.com/android/management/create-enterprise#customer-managed_enterprises)
// and not when creating a deprecated EMM-managed enterprise
// (https://developers.google.com/android/management/create-enterprise#emm-managed_enterprises).
func (c *EnterprisesCreateCall) SignupUrlName(signupUrlName string) *EnterprisesCreateCall {
	c.urlParams_.Set("signupUrlName", signupUrlName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesCreateCall) Fields(s ...googleapi.Field) *EnterprisesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesCreateCall) Context(ctx context.Context) *EnterprisesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.enterprise)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/enterprises")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Enterprise.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesCreateCall) Do(opts ...googleapi.CallOption) (*Enterprise, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Enterprise{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Permanently deletes an enterprise and all accounts and data
// associated with it. Warning: this will result in a cascaded deletion of all
// AM API devices associated with the deleted enterprise. Only available for
// EMM-managed enterprises.
//
// - name: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesService) Delete(name string) *EnterprisesDeleteCall {
	c := &EnterprisesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDeleteCall) Fields(s ...googleapi.Field) *EnterprisesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDeleteCall) Context(ctx context.Context) *EnterprisesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesGenerateEnterpriseUpgradeUrlCall struct {
	s                                   *Service
	name                                string
	generateenterpriseupgradeurlrequest *GenerateEnterpriseUpgradeUrlRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// GenerateEnterpriseUpgradeUrl: Generates an enterprise upgrade URL to upgrade
// an existing managed Google Play Accounts enterprise to a managed Google
// domain. See the guide
// (https://developers.google.com/android/management/upgrade-an-enterprise) for
// more details.
//
//   - name: The name of the enterprise to be upgraded in the form
//     enterprises/{enterpriseId}.
func (r *EnterprisesService) GenerateEnterpriseUpgradeUrl(name string, generateenterpriseupgradeurlrequest *GenerateEnterpriseUpgradeUrlRequest) *EnterprisesGenerateEnterpriseUpgradeUrlCall {
	c := &EnterprisesGenerateEnterpriseUpgradeUrlCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.generateenterpriseupgradeurlrequest = generateenterpriseupgradeurlrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesGenerateEnterpriseUpgradeUrlCall) Fields(s ...googleapi.Field) *EnterprisesGenerateEnterpriseUpgradeUrlCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesGenerateEnterpriseUpgradeUrlCall) Context(ctx context.Context) *EnterprisesGenerateEnterpriseUpgradeUrlCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesGenerateEnterpriseUpgradeUrlCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesGenerateEnterpriseUpgradeUrlCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generateenterpriseupgradeurlrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:generateEnterpriseUpgradeUrl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.generateEnterpriseUpgradeUrl", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.generateEnterpriseUpgradeUrl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateEnterpriseUpgradeUrlResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesGenerateEnterpriseUpgradeUrlCall) Do(opts ...googleapi.CallOption) (*GenerateEnterpriseUpgradeUrlResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateEnterpriseUpgradeUrlResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.generateEnterpriseUpgradeUrl", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an enterprise.
//
// - name: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesService) Get(name string) *EnterprisesGetCall {
	c := &EnterprisesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesGetCall) Fields(s ...googleapi.Field) *EnterprisesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesGetCall) IfNoneMatch(entityTag string) *EnterprisesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesGetCall) Context(ctx context.Context) *EnterprisesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Enterprise.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesGetCall) Do(opts ...googleapi.CallOption) (*Enterprise, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Enterprise{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists EMM-managed enterprises. Only BASIC fields are returned.
func (r *EnterprisesService) List() *EnterprisesListCall {
	c := &EnterprisesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page size.
// The actual page size may be fixed to a min or max value.
func (c *EnterprisesListCall) PageSize(pageSize int64) *EnterprisesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results returned by the server.
func (c *EnterprisesListCall) PageToken(pageToken string) *EnterprisesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ProjectId sets the optional parameter "projectId": Required. The Cloud
// project ID of the EMM managing the enterprises.
func (c *EnterprisesListCall) ProjectId(projectId string) *EnterprisesListCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// View sets the optional parameter "view": Specifies which Enterprise fields
// to return. This method only supports BASIC.
//
// Possible values:
//
//	"ENTERPRISE_VIEW_UNSPECIFIED" - The API will default to the BASIC view for
//
// the List method.
//
//	"BASIC" - Includes name and enterprise_display_name fields.
func (c *EnterprisesListCall) View(view string) *EnterprisesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesListCall) Fields(s ...googleapi.Field) *EnterprisesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesListCall) IfNoneMatch(entityTag string) *EnterprisesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesListCall) Context(ctx context.Context) *EnterprisesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/enterprises")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEnterprisesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesListCall) Do(opts ...googleapi.CallOption) (*ListEnterprisesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEnterprisesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesListCall) Pages(ctx context.Context, f func(*ListEnterprisesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesPatchCall struct {
	s          *Service
	name       string
	enterprise *Enterprise
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an enterprise. See also: SigninDetail
//
// - name: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesService) Patch(name string, enterprise *Enterprise) *EnterprisesPatchCall {
	c := &EnterprisesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.enterprise = enterprise
	return c
}

// UpdateMask sets the optional parameter "updateMask": The field mask
// indicating the fields to update. If not set, all modifiable fields will be
// modified.
func (c *EnterprisesPatchCall) UpdateMask(updateMask string) *EnterprisesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPatchCall) Fields(s ...googleapi.Field) *EnterprisesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPatchCall) Context(ctx context.Context) *EnterprisesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.enterprise)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Enterprise.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesPatchCall) Do(opts ...googleapi.CallOption) (*Enterprise, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Enterprise{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesApplicationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets info about an application.
//
//   - name: The name of the application in the form
//     enterprises/{enterpriseId}/applications/{package_name}.
func (r *EnterprisesApplicationsService) Get(name string) *EnterprisesApplicationsGetCall {
	c := &EnterprisesApplicationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode": The preferred
// language for localized application info, as a BCP47 tag (e.g. "en-US",
// "de"). If not specified the default language of the application will be
// used.
func (c *EnterprisesApplicationsGetCall) LanguageCode(languageCode string) *EnterprisesApplicationsGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesApplicationsGetCall) Fields(s ...googleapi.Field) *EnterprisesApplicationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesApplicationsGetCall) IfNoneMatch(entityTag string) *EnterprisesApplicationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesApplicationsGetCall) Context(ctx context.Context) *EnterprisesApplicationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesApplicationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesApplicationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.applications.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.applications.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Application.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesApplicationsGetCall) Do(opts ...googleapi.CallOption) (*Application, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Application{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.applications.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a device. This operation attempts to wipe the device but
// this is not guaranteed to succeed if the device is offline for an extended
// period. Deleted devices do not show up in enterprises.devices.list calls and
// a 404 is returned from enterprises.devices.get.
//
//   - name: The name of the device in the form
//     enterprises/{enterpriseId}/devices/{deviceId}.
func (r *EnterprisesDevicesService) Delete(name string) *EnterprisesDevicesDeleteCall {
	c := &EnterprisesDevicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// WipeDataFlags sets the optional parameter "wipeDataFlags": Optional flags
// that control the device wiping behavior.
//
// Possible values:
//
//	"WIPE_DATA_FLAG_UNSPECIFIED" - This value is ignored.
//	"PRESERVE_RESET_PROTECTION_DATA" - Preserve the factory reset protection
//
// data on the device.
//
//	"WIPE_EXTERNAL_STORAGE" - Additionally wipe the device's external storage
//
// (such as SD cards).
//
//	"WIPE_ESIMS" - For company-owned devices, this removes all eSIMs from the
//
// device when the device is wiped. In personally-owned devices, this will
// remove managed eSIMs (eSIMs which are added via the ADD_ESIM command) on the
// devices and no personally owned eSIMs will be removed.
func (c *EnterprisesDevicesDeleteCall) WipeDataFlags(wipeDataFlags ...string) *EnterprisesDevicesDeleteCall {
	c.urlParams_.SetMulti("wipeDataFlags", append([]string{}, wipeDataFlags...))
	return c
}

// WipeReasonMessage sets the optional parameter "wipeReasonMessage": A short
// message displayed to the user before wiping the work profile on personal
// devices. This has no effect on company owned devices. The maximum message
// length is 200 characters.
func (c *EnterprisesDevicesDeleteCall) WipeReasonMessage(wipeReasonMessage string) *EnterprisesDevicesDeleteCall {
	c.urlParams_.Set("wipeReasonMessage", wipeReasonMessage)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesDeleteCall) Fields(s ...googleapi.Field) *EnterprisesDevicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesDeleteCall) Context(ctx context.Context) *EnterprisesDevicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a device. Deleted devices will respond with a 404 error.
//
//   - name: The name of the device in the form
//     enterprises/{enterpriseId}/devices/{deviceId}.
func (r *EnterprisesDevicesService) Get(name string) *EnterprisesDevicesGetCall {
	c := &EnterprisesDevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesGetCall) Fields(s ...googleapi.Field) *EnterprisesDevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesDevicesGetCall) IfNoneMatch(entityTag string) *EnterprisesDevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesGetCall) Context(ctx context.Context) *EnterprisesDevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Device.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesGetCall) Do(opts ...googleapi.CallOption) (*Device, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Device{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesIssueCommandCall struct {
	s          *Service
	name       string
	command    *Command
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// IssueCommand: Issues a command to a device. The Operation resource returned
// contains a Command in its metadata field. Use the get operation method to
// get the status of the command.
//
//   - name: The name of the device in the form
//     enterprises/{enterpriseId}/devices/{deviceId}.
func (r *EnterprisesDevicesService) IssueCommand(name string, command *Command) *EnterprisesDevicesIssueCommandCall {
	c := &EnterprisesDevicesIssueCommandCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.command = command
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesIssueCommandCall) Fields(s ...googleapi.Field) *EnterprisesDevicesIssueCommandCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesIssueCommandCall) Context(ctx context.Context) *EnterprisesDevicesIssueCommandCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesIssueCommandCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesIssueCommandCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.command)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:issueCommand")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.issueCommand", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.issueCommand" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesIssueCommandCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.issueCommand", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists devices for a given enterprise. Deleted devices are not returned
// in the response.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesDevicesService) List(parent string) *EnterprisesDevicesListCall {
	c := &EnterprisesDevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page size. If
// unspecified, at most 10 devices will be returned. The maximum value is 100;
// values above 100 will be coerced to 100. The limits can change over time.
func (c *EnterprisesDevicesListCall) PageSize(pageSize int64) *EnterprisesDevicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results returned by the server.
func (c *EnterprisesDevicesListCall) PageToken(pageToken string) *EnterprisesDevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesListCall) Fields(s ...googleapi.Field) *EnterprisesDevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesDevicesListCall) IfNoneMatch(entityTag string) *EnterprisesDevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesListCall) Context(ctx context.Context) *EnterprisesDevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDevicesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesDevicesListCall) Do(opts ...googleapi.CallOption) (*ListDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesDevicesListCall) Pages(ctx context.Context, f func(*ListDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesDevicesPatchCall struct {
	s          *Service
	name       string
	device     *Device
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a device.
//
//   - name: The name of the device in the form
//     enterprises/{enterpriseId}/devices/{deviceId}.
func (r *EnterprisesDevicesService) Patch(name string, device *Device) *EnterprisesDevicesPatchCall {
	c := &EnterprisesDevicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.device = device
	return c
}

// UpdateMask sets the optional parameter "updateMask": The field mask
// indicating the fields to update. If not set, all modifiable fields will be
// modified.
func (c *EnterprisesDevicesPatchCall) UpdateMask(updateMask string) *EnterprisesDevicesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesPatchCall) Fields(s ...googleapi.Field) *EnterprisesDevicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesPatchCall) Context(ctx context.Context) *EnterprisesDevicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.device)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Device.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesPatchCall) Do(opts ...googleapi.CallOption) (*Device, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Device{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// Code.CANCELLED.
//
// - name: The name of the operation resource to be cancelled.
func (r *EnterprisesDevicesOperationsService) Cancel(name string) *EnterprisesDevicesOperationsCancelCall {
	c := &EnterprisesDevicesOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesOperationsCancelCall) Fields(s ...googleapi.Field) *EnterprisesDevicesOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesOperationsCancelCall) Context(ctx context.Context) *EnterprisesDevicesOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *EnterprisesDevicesOperationsService) Get(name string) *EnterprisesDevicesOperationsGetCall {
	c := &EnterprisesDevicesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesOperationsGetCall) Fields(s ...googleapi.Field) *EnterprisesDevicesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesDevicesOperationsGetCall) IfNoneMatch(entityTag string) *EnterprisesDevicesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesOperationsGetCall) Context(ctx context.Context) *EnterprisesDevicesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesDevicesOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesDevicesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns UNIMPLEMENTED.
//
// - name: The name of the operation's parent resource.
func (r *EnterprisesDevicesOperationsService) List(name string) *EnterprisesDevicesOperationsListCall {
	c := &EnterprisesDevicesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *EnterprisesDevicesOperationsListCall) Filter(filter string) *EnterprisesDevicesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *EnterprisesDevicesOperationsListCall) PageSize(pageSize int64) *EnterprisesDevicesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *EnterprisesDevicesOperationsListCall) PageToken(pageToken string) *EnterprisesDevicesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to true, operations that are reachable are returned as normal, and
// those that are unreachable are returned in the
// ListOperationsResponse.unreachable field.This can only be true when reading
// across collections. For example, when parent is set to
// "projects/example/locations/-".This field is not supported by default and
// will result in an UNIMPLEMENTED error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *EnterprisesDevicesOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *EnterprisesDevicesOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesDevicesOperationsListCall) Fields(s ...googleapi.Field) *EnterprisesDevicesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesDevicesOperationsListCall) IfNoneMatch(entityTag string) *EnterprisesDevicesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesDevicesOperationsListCall) Context(ctx context.Context) *EnterprisesDevicesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesDevicesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesDevicesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.devices.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesDevicesOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.devices.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesDevicesOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesEnrollmentTokensCreateCall struct {
	s               *Service
	parent          string
	enrollmenttoken *EnrollmentToken
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates an enrollment token for a given enterprise. It's up to the
// caller's responsibility to manage the lifecycle of newly created tokens and
// deleting them when they're not intended to be used anymore.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesEnrollmentTokensService) Create(parent string, enrollmenttoken *EnrollmentToken) *EnterprisesEnrollmentTokensCreateCall {
	c := &EnterprisesEnrollmentTokensCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollmenttoken = enrollmenttoken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesEnrollmentTokensCreateCall) Fields(s ...googleapi.Field) *EnterprisesEnrollmentTokensCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesEnrollmentTokensCreateCall) Context(ctx context.Context) *EnterprisesEnrollmentTokensCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesEnrollmentTokensCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesEnrollmentTokensCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.enrollmenttoken)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/enrollmentTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.enrollmentTokens.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *EnrollmentToken.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesEnrollmentTokensCreateCall) Do(opts ...googleapi.CallOption) (*EnrollmentToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EnrollmentToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesEnrollmentTokensDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an enrollment token. This operation invalidates the token,
// preventing its future use.
//
//   - name: The name of the enrollment token in the form
//     enterprises/{enterpriseId}/enrollmentTokens/{enrollmentTokenId}.
func (r *EnterprisesEnrollmentTokensService) Delete(name string) *EnterprisesEnrollmentTokensDeleteCall {
	c := &EnterprisesEnrollmentTokensDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesEnrollmentTokensDeleteCall) Fields(s ...googleapi.Field) *EnterprisesEnrollmentTokensDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesEnrollmentTokensDeleteCall) Context(ctx context.Context) *EnterprisesEnrollmentTokensDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesEnrollmentTokensDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesEnrollmentTokensDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.enrollmentTokens.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesEnrollmentTokensDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesEnrollmentTokensGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an active, unexpired enrollment token. A partial view of the
// enrollment token is returned. Only the following fields are populated: name,
// expirationTimestamp, allowPersonalUsage, value, qrCode. This method is meant
// to help manage active enrollment tokens lifecycle. For security reasons,
// it's recommended to delete active enrollment tokens as soon as they're not
// intended to be used anymore.
//
//   - name: The name of the enrollment token in the form
//     enterprises/{enterpriseId}/enrollmentTokens/{enrollmentTokenId}.
func (r *EnterprisesEnrollmentTokensService) Get(name string) *EnterprisesEnrollmentTokensGetCall {
	c := &EnterprisesEnrollmentTokensGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesEnrollmentTokensGetCall) Fields(s ...googleapi.Field) *EnterprisesEnrollmentTokensGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesEnrollmentTokensGetCall) IfNoneMatch(entityTag string) *EnterprisesEnrollmentTokensGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesEnrollmentTokensGetCall) Context(ctx context.Context) *EnterprisesEnrollmentTokensGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesEnrollmentTokensGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesEnrollmentTokensGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.enrollmentTokens.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *EnrollmentToken.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesEnrollmentTokensGetCall) Do(opts ...googleapi.CallOption) (*EnrollmentToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EnrollmentToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesEnrollmentTokensListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists active, unexpired enrollment tokens for a given enterprise. The
// list items contain only a partial view of EnrollmentToken object. Only the
// following fields are populated: name, expirationTimestamp,
// allowPersonalUsage, value, qrCode. This method is meant to help manage
// active enrollment tokens lifecycle. For security reasons, it's recommended
// to delete active enrollment tokens as soon as they're not intended to be
// used anymore.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesEnrollmentTokensService) List(parent string) *EnterprisesEnrollmentTokensListCall {
	c := &EnterprisesEnrollmentTokensListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page size.
// The service may return fewer than this value. If unspecified, at most 10
// items will be returned. The maximum value is 100; values above 100 will be
// coerced to 100.
func (c *EnterprisesEnrollmentTokensListCall) PageSize(pageSize int64) *EnterprisesEnrollmentTokensListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results returned by the server.
func (c *EnterprisesEnrollmentTokensListCall) PageToken(pageToken string) *EnterprisesEnrollmentTokensListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesEnrollmentTokensListCall) Fields(s ...googleapi.Field) *EnterprisesEnrollmentTokensListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesEnrollmentTokensListCall) IfNoneMatch(entityTag string) *EnterprisesEnrollmentTokensListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesEnrollmentTokensListCall) Context(ctx context.Context) *EnterprisesEnrollmentTokensListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesEnrollmentTokensListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesEnrollmentTokensListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/enrollmentTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.enrollmentTokens.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEnrollmentTokensResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesEnrollmentTokensListCall) Do(opts ...googleapi.CallOption) (*ListEnrollmentTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEnrollmentTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.enrollmentTokens.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesEnrollmentTokensListCall) Pages(ctx context.Context, f func(*ListEnrollmentTokensResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesMigrationTokensCreateCall struct {
	s              *Service
	parent         string
	migrationtoken *MigrationToken
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a migration token, to migrate an existing device from being
// managed by the EMM's Device Policy Controller (DPC) to being managed by the
// Android Management API. See the guide
// (https://developers.google.com/android/management/dpc-migration) for more
// details.
//
//   - parent: The enterprise in which this migration token is created. This must
//     be the same enterprise which already manages the device in the Play EMM
//     API. Format: enterprises/{enterprise}.
func (r *EnterprisesMigrationTokensService) Create(parent string, migrationtoken *MigrationToken) *EnterprisesMigrationTokensCreateCall {
	c := &EnterprisesMigrationTokensCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.migrationtoken = migrationtoken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesMigrationTokensCreateCall) Fields(s ...googleapi.Field) *EnterprisesMigrationTokensCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesMigrationTokensCreateCall) Context(ctx context.Context) *EnterprisesMigrationTokensCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesMigrationTokensCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesMigrationTokensCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.migrationtoken)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/migrationTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.migrationTokens.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *MigrationToken.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesMigrationTokensCreateCall) Do(opts ...googleapi.CallOption) (*MigrationToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MigrationToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesMigrationTokensGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a migration token.
//
//   - name: The name of the migration token to retrieve. Format:
//     enterprises/{enterprise}/migrationTokens/{migration_token}.
func (r *EnterprisesMigrationTokensService) Get(name string) *EnterprisesMigrationTokensGetCall {
	c := &EnterprisesMigrationTokensGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesMigrationTokensGetCall) Fields(s ...googleapi.Field) *EnterprisesMigrationTokensGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesMigrationTokensGetCall) IfNoneMatch(entityTag string) *EnterprisesMigrationTokensGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesMigrationTokensGetCall) Context(ctx context.Context) *EnterprisesMigrationTokensGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesMigrationTokensGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesMigrationTokensGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.migrationTokens.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MigrationToken.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesMigrationTokensGetCall) Do(opts ...googleapi.CallOption) (*MigrationToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MigrationToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesMigrationTokensListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists migration tokens.
//
//   - parent: The enterprise which the migration tokens belong to. Format:
//     enterprises/{enterprise}.
func (r *EnterprisesMigrationTokensService) List(parent string) *EnterprisesMigrationTokensListCall {
	c := &EnterprisesMigrationTokensListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// migration tokens to return. Fewer migration tokens may be returned. If
// unspecified, at most 100 migration tokens will be returned. The maximum
// value is 100; values above 100 will be coerced to 100.
func (c *EnterprisesMigrationTokensListCall) PageSize(pageSize int64) *EnterprisesMigrationTokensListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous ListMigrationTokens call. Provide this to retrieve the
// subsequent page.When paginating, all other parameters provided to
// ListMigrationTokens must match the call that provided the page token.
func (c *EnterprisesMigrationTokensListCall) PageToken(pageToken string) *EnterprisesMigrationTokensListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesMigrationTokensListCall) Fields(s ...googleapi.Field) *EnterprisesMigrationTokensListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesMigrationTokensListCall) IfNoneMatch(entityTag string) *EnterprisesMigrationTokensListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesMigrationTokensListCall) Context(ctx context.Context) *EnterprisesMigrationTokensListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesMigrationTokensListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesMigrationTokensListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/migrationTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.migrationTokens.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMigrationTokensResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesMigrationTokensListCall) Do(opts ...googleapi.CallOption) (*ListMigrationTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMigrationTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.migrationTokens.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesMigrationTokensListCall) Pages(ctx context.Context, f func(*ListMigrationTokensResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a policy. This operation is only permitted if no devices are
// currently referencing the policy.
//
//   - name: The name of the policy in the form
//     enterprises/{enterpriseId}/policies/{policyId}.
func (r *EnterprisesPoliciesService) Delete(name string) *EnterprisesPoliciesDeleteCall {
	c := &EnterprisesPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesDeleteCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesDeleteCall) Context(ctx context.Context) *EnterprisesPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a policy.
//
//   - name: The name of the policy in the form
//     enterprises/{enterpriseId}/policies/{policyId}.
func (r *EnterprisesPoliciesService) Get(name string) *EnterprisesPoliciesGetCall {
	c := &EnterprisesPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesGetCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesPoliciesGetCall) IfNoneMatch(entityTag string) *EnterprisesPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesGetCall) Context(ctx context.Context) *EnterprisesPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesPoliciesGetCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists policies for a given enterprise.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesPoliciesService) List(parent string) *EnterprisesPoliciesListCall {
	c := &EnterprisesPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page size.
// The actual page size may be fixed to a min or max value.
func (c *EnterprisesPoliciesListCall) PageSize(pageSize int64) *EnterprisesPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results returned by the server.
func (c *EnterprisesPoliciesListCall) PageToken(pageToken string) *EnterprisesPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesListCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesPoliciesListCall) IfNoneMatch(entityTag string) *EnterprisesPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesListCall) Context(ctx context.Context) *EnterprisesPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPoliciesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesPoliciesListCall) Pages(ctx context.Context, f func(*ListPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesPoliciesModifyPolicyApplicationsCall struct {
	s                               *Service
	name                            string
	modifypolicyapplicationsrequest *ModifyPolicyApplicationsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// ModifyPolicyApplications: Updates or creates applications in a policy.
//
//   - name: The name of the Policy containing the ApplicationPolicy objects to
//     be updated, in the form enterprises/{enterpriseId}/policies/{policyId}.
func (r *EnterprisesPoliciesService) ModifyPolicyApplications(name string, modifypolicyapplicationsrequest *ModifyPolicyApplicationsRequest) *EnterprisesPoliciesModifyPolicyApplicationsCall {
	c := &EnterprisesPoliciesModifyPolicyApplicationsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.modifypolicyapplicationsrequest = modifypolicyapplicationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesModifyPolicyApplicationsCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesModifyPolicyApplicationsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesModifyPolicyApplicationsCall) Context(ctx context.Context) *EnterprisesPoliciesModifyPolicyApplicationsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesModifyPolicyApplicationsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesModifyPolicyApplicationsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.modifypolicyapplicationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:modifyPolicyApplications")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.modifyPolicyApplications", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.modifyPolicyApplications" call.
// Any non-2xx status code is an error. Response headers are in either
// *ModifyPolicyApplicationsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesPoliciesModifyPolicyApplicationsCall) Do(opts ...googleapi.CallOption) (*ModifyPolicyApplicationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ModifyPolicyApplicationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.modifyPolicyApplications", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesPoliciesPatchCall struct {
	s          *Service
	name       string
	policy     *Policy
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates or creates a policy.
//
//   - name: The name of the policy in the form
//     enterprises/{enterpriseId}/policies/{policyId}.
func (r *EnterprisesPoliciesService) Patch(name string, policy *Policy) *EnterprisesPoliciesPatchCall {
	c := &EnterprisesPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.policy = policy
	return c
}

// UpdateMask sets the optional parameter "updateMask": The field mask
// indicating the fields to update. If not set, all modifiable fields will be
// modified.
func (c *EnterprisesPoliciesPatchCall) UpdateMask(updateMask string) *EnterprisesPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesPatchCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesPatchCall) Context(ctx context.Context) *EnterprisesPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesPoliciesRemovePolicyApplicationsCall struct {
	s                               *Service
	name                            string
	removepolicyapplicationsrequest *RemovePolicyApplicationsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// RemovePolicyApplications: Removes applications in a policy.
//
//   - name: The name of the policy containing the ApplicationPolicy objects to
//     be removed, in the form enterprises/{enterpriseId}/policies/{policyId}.
func (r *EnterprisesPoliciesService) RemovePolicyApplications(name string, removepolicyapplicationsrequest *RemovePolicyApplicationsRequest) *EnterprisesPoliciesRemovePolicyApplicationsCall {
	c := &EnterprisesPoliciesRemovePolicyApplicationsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.removepolicyapplicationsrequest = removepolicyapplicationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesPoliciesRemovePolicyApplicationsCall) Fields(s ...googleapi.Field) *EnterprisesPoliciesRemovePolicyApplicationsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesPoliciesRemovePolicyApplicationsCall) Context(ctx context.Context) *EnterprisesPoliciesRemovePolicyApplicationsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesPoliciesRemovePolicyApplicationsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesPoliciesRemovePolicyApplicationsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removepolicyapplicationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:removePolicyApplications")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.removePolicyApplications", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.policies.removePolicyApplications" call.
// Any non-2xx status code is an error. Response headers are in either
// *RemovePolicyApplicationsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EnterprisesPoliciesRemovePolicyApplicationsCall) Do(opts ...googleapi.CallOption) (*RemovePolicyApplicationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RemovePolicyApplicationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.policies.removePolicyApplications", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesWebAppsCreateCall struct {
	s          *Service
	parent     string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a web app.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesWebAppsService) Create(parent string, webapp *WebApp) *EnterprisesWebAppsCreateCall {
	c := &EnterprisesWebAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.webapp = webapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebAppsCreateCall) Fields(s ...googleapi.Field) *EnterprisesWebAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebAppsCreateCall) Context(ctx context.Context) *EnterprisesWebAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.webapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webApps.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesWebAppsCreateCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesWebAppsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a web app.
//
//   - name: The name of the web app in the form
//     enterprises/{enterpriseId}/webApps/{packageName}.
func (r *EnterprisesWebAppsService) Delete(name string) *EnterprisesWebAppsDeleteCall {
	c := &EnterprisesWebAppsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebAppsDeleteCall) Fields(s ...googleapi.Field) *EnterprisesWebAppsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebAppsDeleteCall) Context(ctx context.Context) *EnterprisesWebAppsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebAppsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebAppsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webApps.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesWebAppsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesWebAppsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a web app.
//
//   - name: The name of the web app in the form
//     enterprises/{enterpriseId}/webApps/{packageName}.
func (r *EnterprisesWebAppsService) Get(name string) *EnterprisesWebAppsGetCall {
	c := &EnterprisesWebAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebAppsGetCall) Fields(s ...googleapi.Field) *EnterprisesWebAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesWebAppsGetCall) IfNoneMatch(entityTag string) *EnterprisesWebAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebAppsGetCall) Context(ctx context.Context) *EnterprisesWebAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webApps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesWebAppsGetCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesWebAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists web apps for a given enterprise.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesWebAppsService) List(parent string) *EnterprisesWebAppsListCall {
	c := &EnterprisesWebAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page size.
// This is a hint and the actual page size in the response may be different.
func (c *EnterprisesWebAppsListCall) PageSize(pageSize int64) *EnterprisesWebAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results returned by the server.
func (c *EnterprisesWebAppsListCall) PageToken(pageToken string) *EnterprisesWebAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebAppsListCall) Fields(s ...googleapi.Field) *EnterprisesWebAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EnterprisesWebAppsListCall) IfNoneMatch(entityTag string) *EnterprisesWebAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebAppsListCall) Context(ctx context.Context) *EnterprisesWebAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webApps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWebAppsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EnterprisesWebAppsListCall) Do(opts ...googleapi.CallOption) (*ListWebAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWebAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EnterprisesWebAppsListCall) Pages(ctx context.Context, f func(*ListWebAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EnterprisesWebAppsPatchCall struct {
	s          *Service
	name       string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a web app.
//
//   - name: The name of the web app in the form
//     enterprises/{enterpriseId}/webApps/{packageName}.
func (r *EnterprisesWebAppsService) Patch(name string, webapp *WebApp) *EnterprisesWebAppsPatchCall {
	c := &EnterprisesWebAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.webapp = webapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": The field mask
// indicating the fields to update. If not set, all modifiable fields will be
// modified.
func (c *EnterprisesWebAppsPatchCall) UpdateMask(updateMask string) *EnterprisesWebAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebAppsPatchCall) Fields(s ...googleapi.Field) *EnterprisesWebAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebAppsPatchCall) Context(ctx context.Context) *EnterprisesWebAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.webapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webApps.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesWebAppsPatchCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webApps.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EnterprisesWebTokensCreateCall struct {
	s          *Service
	parent     string
	webtoken   *WebToken
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a web token to access an embeddable managed Google Play web
// UI for a given enterprise.
//
// - parent: The name of the enterprise in the form enterprises/{enterpriseId}.
func (r *EnterprisesWebTokensService) Create(parent string, webtoken *WebToken) *EnterprisesWebTokensCreateCall {
	c := &EnterprisesWebTokensCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.webtoken = webtoken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EnterprisesWebTokensCreateCall) Fields(s ...googleapi.Field) *EnterprisesWebTokensCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EnterprisesWebTokensCreateCall) Context(ctx context.Context) *EnterprisesWebTokensCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EnterprisesWebTokensCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EnterprisesWebTokensCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.webtoken)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/webTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webTokens.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.enterprises.webTokens.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebToken.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EnterprisesWebTokensCreateCall) Do(opts ...googleapi.CallOption) (*WebToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.enterprises.webTokens.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProvisioningInfoGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get the device provisioning information by the identifier provided in
// the sign-in url.
//
//   - name: The identifier that Android Device Policy passes to the 3P sign-in
//     page in the form of provisioningInfo/{provisioning_info}.
func (r *ProvisioningInfoService) Get(nameid string) *ProvisioningInfoGetCall {
	c := &ProvisioningInfoGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProvisioningInfoGetCall) Fields(s ...googleapi.Field) *ProvisioningInfoGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProvisioningInfoGetCall) IfNoneMatch(entityTag string) *ProvisioningInfoGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProvisioningInfoGetCall) Context(ctx context.Context) *ProvisioningInfoGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProvisioningInfoGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProvisioningInfoGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.provisioningInfo.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.provisioningInfo.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProvisioningInfo.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProvisioningInfoGetCall) Do(opts ...googleapi.CallOption) (*ProvisioningInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProvisioningInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.provisioningInfo.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SignupUrlsCreateCall struct {
	s          *Service
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an enterprise signup URL.
func (r *SignupUrlsService) Create() *SignupUrlsCreateCall {
	c := &SignupUrlsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// AdminEmail sets the optional parameter "adminEmail": Email address used to
// prefill the admin field of the enterprise signup form. This value is a hint
// only and can be altered by the user. If allowedDomains is non-empty then
// this must belong to one of the allowedDomains.
func (c *SignupUrlsCreateCall) AdminEmail(adminEmail string) *SignupUrlsCreateCall {
	c.urlParams_.Set("adminEmail", adminEmail)
	return c
}

// AllowedDomains sets the optional parameter "allowedDomains": A list of
// domains that are permitted for the admin email. The IT admin cannot enter an
// email address with a domain name that is not in this list. Subdomains of
// domains in this list are not allowed but can be allowed by adding a second
// entry which has *. prefixed to the domain name (e.g. *.example.com). If the
// field is not present or is an empty list then the IT admin is free to use
// any valid domain name. Personal email domains are always allowed, but will
// result in the creation of a managed Google Play Accounts enterprise.
func (c *SignupUrlsCreateCall) AllowedDomains(allowedDomains ...string) *SignupUrlsCreateCall {
	c.urlParams_.SetMulti("allowedDomains", append([]string{}, allowedDomains...))
	return c
}

// CallbackUrl sets the optional parameter "callbackUrl": The callback URL that
// the admin will be redirected to after successfully creating an enterprise.
// Before redirecting there the system will add a query parameter to this URL
// named enterpriseToken which will contain an opaque token to be used for the
// create enterprise request. The URL will be parsed then reformatted in order
// to add the enterpriseToken parameter, so there may be some minor formatting
// changes.
func (c *SignupUrlsCreateCall) CallbackUrl(callbackUrl string) *SignupUrlsCreateCall {
	c.urlParams_.Set("callbackUrl", callbackUrl)
	return c
}

// ProjectId sets the optional parameter "projectId": The ID of the Google
// Cloud Platform project which will own the enterprise.
func (c *SignupUrlsCreateCall) ProjectId(projectId string) *SignupUrlsCreateCall {
	c.urlParams_.Set("projectId", projectId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SignupUrlsCreateCall) Fields(s ...googleapi.Field) *SignupUrlsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SignupUrlsCreateCall) Context(ctx context.Context) *SignupUrlsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SignupUrlsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SignupUrlsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/signupUrls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "androidmanagement.signupUrls.create", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidmanagement.signupUrls.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *SignupUrl.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SignupUrlsCreateCall) Do(opts ...googleapi.CallOption) (*SignupUrl, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SignupUrl{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "androidmanagement.signupUrls.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
