// Package webaudio provides the Chrome DevTools Protocol
// commands, types, and events for the WebAudio domain.
//
// This domain allows inspection of Web Audio API.
// https://webaudio.github.io/web-audio-api/.
//
// Generated by the cdproto-gen command.
package webaudio

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams enables the WebAudio domain and starts sending context
// lifetime events.
type EnableParams struct{}

// Enable enables the WebAudio domain and starts sending context lifetime
// events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#method-enable
func Enable() *EnableParams {
	return &EnableParams{}
}

// Do executes WebAudio.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, nil, nil)
}

// DisableParams disables the WebAudio domain.
type DisableParams struct{}

// Disable disables the WebAudio domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes WebAudio.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// GetRealtimeDataParams fetch the realtime data from the registered
// contexts.
type GetRealtimeDataParams struct {
	ContextID GraphObjectID `json:"contextId"`
}

// GetRealtimeData fetch the realtime data from the registered contexts.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#method-getRealtimeData
//
// parameters:
//   contextID
func GetRealtimeData(contextID GraphObjectID) *GetRealtimeDataParams {
	return &GetRealtimeDataParams{
		ContextID: contextID,
	}
}

// GetRealtimeDataReturns return values.
type GetRealtimeDataReturns struct {
	RealtimeData *ContextRealtimeData `json:"realtimeData,omitempty"`
}

// Do executes WebAudio.getRealtimeData against the provided context.
//
// returns:
//   realtimeData
func (p *GetRealtimeDataParams) Do(ctx context.Context) (realtimeData *ContextRealtimeData, err error) {
	// execute
	var res GetRealtimeDataReturns
	err = cdp.Execute(ctx, CommandGetRealtimeData, p, &res)
	if err != nil {
		return nil, err
	}

	return res.RealtimeData, nil
}

// Command names.
const (
	CommandEnable          = "WebAudio.enable"
	CommandDisable         = "WebAudio.disable"
	CommandGetRealtimeData = "WebAudio.getRealtimeData"
)
