// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestUnretrievableAttributes(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.UnretrievableAttributesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.UnretrievableAttributes([]string{}...),
		},
		{
			opts:     []interface{}{opt.UnretrievableAttributes("value1")},
			expected: opt.UnretrievableAttributes("value1"),
		},
		{
			opts:     []interface{}{opt.UnretrievableAttributes("value1", "value2", "value3")},
			expected: opt.UnretrievableAttributes("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractUnretrievableAttributes(c.opts...)
			out opt.UnretrievableAttributesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestUnretrievableAttributes_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.UnretrievableAttributesOption
	}{
		{
			payload:  `""`,
			expected: opt.UnretrievableAttributes([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.UnretrievableAttributes("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.UnretrievableAttributes("value1", "value2", "value3"),
		},
	} {
		var got opt.UnretrievableAttributesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
