// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/visionai/v1/streaming_service.proto

package visionai

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The lease type.
type LeaseType int32

const (
	// Lease type unspecified.
	LeaseType_LEASE_TYPE_UNSPECIFIED LeaseType = 0
	// Lease for stream reader.
	LeaseType_LEASE_TYPE_READER LeaseType = 1
	// Lease for stream writer.
	LeaseType_LEASE_TYPE_WRITER LeaseType = 2
)

// Enum value maps for LeaseType.
var (
	LeaseType_name = map[int32]string{
		0: "LEASE_TYPE_UNSPECIFIED",
		1: "LEASE_TYPE_READER",
		2: "LEASE_TYPE_WRITER",
	}
	LeaseType_value = map[string]int32{
		"LEASE_TYPE_UNSPECIFIED": 0,
		"LEASE_TYPE_READER":      1,
		"LEASE_TYPE_WRITER":      2,
	}
)

func (x LeaseType) Enum() *LeaseType {
	p := new(LeaseType)
	*p = x
	return p
}

func (x LeaseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LeaseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_streaming_service_proto_enumTypes[0].Descriptor()
}

func (LeaseType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_streaming_service_proto_enumTypes[0]
}

func (x LeaseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LeaseType.Descriptor instead.
func (LeaseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{0}
}

// Request message for ReceiveEvents.
type ReceiveEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//
	//	*ReceiveEventsRequest_SetupRequest_
	//	*ReceiveEventsRequest_CommitRequest
	Request isReceiveEventsRequest_Request `protobuf_oneof:"request"`
}

func (x *ReceiveEventsRequest) Reset() {
	*x = ReceiveEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveEventsRequest) ProtoMessage() {}

func (x *ReceiveEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveEventsRequest.ProtoReflect.Descriptor instead.
func (*ReceiveEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{0}
}

func (m *ReceiveEventsRequest) GetRequest() isReceiveEventsRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *ReceiveEventsRequest) GetSetupRequest() *ReceiveEventsRequest_SetupRequest {
	if x, ok := x.GetRequest().(*ReceiveEventsRequest_SetupRequest_); ok {
		return x.SetupRequest
	}
	return nil
}

func (x *ReceiveEventsRequest) GetCommitRequest() *CommitRequest {
	if x, ok := x.GetRequest().(*ReceiveEventsRequest_CommitRequest); ok {
		return x.CommitRequest
	}
	return nil
}

type isReceiveEventsRequest_Request interface {
	isReceiveEventsRequest_Request()
}

type ReceiveEventsRequest_SetupRequest_ struct {
	// The setup request to setup the RPC connection.
	SetupRequest *ReceiveEventsRequest_SetupRequest `protobuf:"bytes,1,opt,name=setup_request,json=setupRequest,proto3,oneof"`
}

type ReceiveEventsRequest_CommitRequest struct {
	// This request checkpoints the consumer's read progress.
	CommitRequest *CommitRequest `protobuf:"bytes,2,opt,name=commit_request,json=commitRequest,proto3,oneof"`
}

func (*ReceiveEventsRequest_SetupRequest_) isReceiveEventsRequest_Request() {}

func (*ReceiveEventsRequest_CommitRequest) isReceiveEventsRequest_Request() {}

// The event update message.
type EventUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the stream that the event is attached to.
	Stream string `protobuf:"bytes,1,opt,name=stream,proto3" json:"stream,omitempty"`
	// The name of the event.
	Event string `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// The name of the series.
	Series string `protobuf:"bytes,3,opt,name=series,proto3" json:"series,omitempty"`
	// The timestamp when the Event update happens.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The offset of the message that will be used to acknowledge of the message
	// receiving.
	Offset int64 `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *EventUpdate) Reset() {
	*x = EventUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventUpdate) ProtoMessage() {}

func (x *EventUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventUpdate.ProtoReflect.Descriptor instead.
func (*EventUpdate) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{1}
}

func (x *EventUpdate) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

func (x *EventUpdate) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *EventUpdate) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *EventUpdate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EventUpdate) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Control message for a ReceiveEventsResponse.
type ReceiveEventsControlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible control messages.
	//
	// Types that are assignable to Control:
	//
	//	*ReceiveEventsControlResponse_Heartbeat
	//	*ReceiveEventsControlResponse_WritesDoneRequest
	Control isReceiveEventsControlResponse_Control `protobuf_oneof:"control"`
}

func (x *ReceiveEventsControlResponse) Reset() {
	*x = ReceiveEventsControlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveEventsControlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveEventsControlResponse) ProtoMessage() {}

func (x *ReceiveEventsControlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveEventsControlResponse.ProtoReflect.Descriptor instead.
func (*ReceiveEventsControlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{2}
}

func (m *ReceiveEventsControlResponse) GetControl() isReceiveEventsControlResponse_Control {
	if m != nil {
		return m.Control
	}
	return nil
}

func (x *ReceiveEventsControlResponse) GetHeartbeat() bool {
	if x, ok := x.GetControl().(*ReceiveEventsControlResponse_Heartbeat); ok {
		return x.Heartbeat
	}
	return false
}

func (x *ReceiveEventsControlResponse) GetWritesDoneRequest() bool {
	if x, ok := x.GetControl().(*ReceiveEventsControlResponse_WritesDoneRequest); ok {
		return x.WritesDoneRequest
	}
	return false
}

type isReceiveEventsControlResponse_Control interface {
	isReceiveEventsControlResponse_Control()
}

type ReceiveEventsControlResponse_Heartbeat struct {
	// A server heartbeat.
	Heartbeat bool `protobuf:"varint,1,opt,name=heartbeat,proto3,oneof"`
}

type ReceiveEventsControlResponse_WritesDoneRequest struct {
	// A request to the receiver to complete any final writes followed by a
	// `WritesDone`; e.g. issue any final `CommitRequest`s.
	//
	// May be ignored if `WritesDone` has already been issued at any point
	// prior to receiving this message.
	//
	// If `WritesDone` does not get issued, then the server will forcefully
	// cancel the connection, and the receiver will likely receive an
	// uninformative after `Read` returns `false` and `Finish` is called.
	WritesDoneRequest bool `protobuf:"varint,2,opt,name=writes_done_request,json=writesDoneRequest,proto3,oneof"`
}

func (*ReceiveEventsControlResponse_Heartbeat) isReceiveEventsControlResponse_Control() {}

func (*ReceiveEventsControlResponse_WritesDoneRequest) isReceiveEventsControlResponse_Control() {}

// Response message for the ReceiveEvents.
type ReceiveEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible response types.
	//
	// Types that are assignable to Response:
	//
	//	*ReceiveEventsResponse_EventUpdate
	//	*ReceiveEventsResponse_Control
	Response isReceiveEventsResponse_Response `protobuf_oneof:"response"`
}

func (x *ReceiveEventsResponse) Reset() {
	*x = ReceiveEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveEventsResponse) ProtoMessage() {}

func (x *ReceiveEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveEventsResponse.ProtoReflect.Descriptor instead.
func (*ReceiveEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{3}
}

func (m *ReceiveEventsResponse) GetResponse() isReceiveEventsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ReceiveEventsResponse) GetEventUpdate() *EventUpdate {
	if x, ok := x.GetResponse().(*ReceiveEventsResponse_EventUpdate); ok {
		return x.EventUpdate
	}
	return nil
}

func (x *ReceiveEventsResponse) GetControl() *ReceiveEventsControlResponse {
	if x, ok := x.GetResponse().(*ReceiveEventsResponse_Control); ok {
		return x.Control
	}
	return nil
}

type isReceiveEventsResponse_Response interface {
	isReceiveEventsResponse_Response()
}

type ReceiveEventsResponse_EventUpdate struct {
	// The event update message.
	EventUpdate *EventUpdate `protobuf:"bytes,1,opt,name=event_update,json=eventUpdate,proto3,oneof"`
}

type ReceiveEventsResponse_Control struct {
	// A control message from the server.
	Control *ReceiveEventsControlResponse `protobuf:"bytes,2,opt,name=control,proto3,oneof"`
}

func (*ReceiveEventsResponse_EventUpdate) isReceiveEventsResponse_Response() {}

func (*ReceiveEventsResponse_Control) isReceiveEventsResponse_Response() {}

// The lease message.
type Lease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The lease id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The series name.
	Series string `protobuf:"bytes,2,opt,name=series,proto3" json:"series,omitempty"`
	// The owner name.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// The lease expire time.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The lease type.
	LeaseType LeaseType `protobuf:"varint,5,opt,name=lease_type,json=leaseType,proto3,enum=google.cloud.visionai.v1.LeaseType" json:"lease_type,omitempty"`
}

func (x *Lease) Reset() {
	*x = Lease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lease) ProtoMessage() {}

func (x *Lease) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lease.ProtoReflect.Descriptor instead.
func (*Lease) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{4}
}

func (x *Lease) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Lease) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *Lease) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *Lease) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Lease) GetLeaseType() LeaseType {
	if x != nil {
		return x.LeaseType
	}
	return LeaseType_LEASE_TYPE_UNSPECIFIED
}

// Request message for acquiring a lease.
type AcquireLeaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The series name.
	Series string `protobuf:"bytes,1,opt,name=series,proto3" json:"series,omitempty"`
	// The owner name.
	Owner string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// The lease term.
	Term *durationpb.Duration `protobuf:"bytes,3,opt,name=term,proto3" json:"term,omitempty"`
	// The lease type.
	LeaseType LeaseType `protobuf:"varint,4,opt,name=lease_type,json=leaseType,proto3,enum=google.cloud.visionai.v1.LeaseType" json:"lease_type,omitempty"`
}

func (x *AcquireLeaseRequest) Reset() {
	*x = AcquireLeaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcquireLeaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcquireLeaseRequest) ProtoMessage() {}

func (x *AcquireLeaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcquireLeaseRequest.ProtoReflect.Descriptor instead.
func (*AcquireLeaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{5}
}

func (x *AcquireLeaseRequest) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *AcquireLeaseRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *AcquireLeaseRequest) GetTerm() *durationpb.Duration {
	if x != nil {
		return x.Term
	}
	return nil
}

func (x *AcquireLeaseRequest) GetLeaseType() LeaseType {
	if x != nil {
		return x.LeaseType
	}
	return LeaseType_LEASE_TYPE_UNSPECIFIED
}

// Request message for renewing a lease.
type RenewLeaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lease id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Series name.
	Series string `protobuf:"bytes,2,opt,name=series,proto3" json:"series,omitempty"`
	// Lease owner.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// Lease term.
	Term *durationpb.Duration `protobuf:"bytes,4,opt,name=term,proto3" json:"term,omitempty"`
}

func (x *RenewLeaseRequest) Reset() {
	*x = RenewLeaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenewLeaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewLeaseRequest) ProtoMessage() {}

func (x *RenewLeaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewLeaseRequest.ProtoReflect.Descriptor instead.
func (*RenewLeaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{6}
}

func (x *RenewLeaseRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RenewLeaseRequest) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *RenewLeaseRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *RenewLeaseRequest) GetTerm() *durationpb.Duration {
	if x != nil {
		return x.Term
	}
	return nil
}

// Request message for releasing lease.
type ReleaseLeaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lease id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Series name.
	Series string `protobuf:"bytes,2,opt,name=series,proto3" json:"series,omitempty"`
	// Lease owner.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
}

func (x *ReleaseLeaseRequest) Reset() {
	*x = ReleaseLeaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseLeaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseLeaseRequest) ProtoMessage() {}

func (x *ReleaseLeaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseLeaseRequest.ProtoReflect.Descriptor instead.
func (*ReleaseLeaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{7}
}

func (x *ReleaseLeaseRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ReleaseLeaseRequest) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *ReleaseLeaseRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

// Response message for release lease.
type ReleaseLeaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReleaseLeaseResponse) Reset() {
	*x = ReleaseLeaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseLeaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseLeaseResponse) ProtoMessage() {}

func (x *ReleaseLeaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseLeaseResponse.ProtoReflect.Descriptor instead.
func (*ReleaseLeaseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{8}
}

// RequestMetadata is the metadata message for the request.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stream name.
	Stream string `protobuf:"bytes,1,opt,name=stream,proto3" json:"stream,omitempty"`
	// Evevt name.
	Event string `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// Series name.
	Series string `protobuf:"bytes,3,opt,name=series,proto3" json:"series,omitempty"`
	// Lease id.
	LeaseId string `protobuf:"bytes,4,opt,name=lease_id,json=leaseId,proto3" json:"lease_id,omitempty"`
	// Owner name.
	Owner string `protobuf:"bytes,5,opt,name=owner,proto3" json:"owner,omitempty"`
	// Lease term specifies how long the client wants the session to be maintained
	// by the server after the client leaves. If the lease term is not set, the
	// server will release the session immediately and the client cannot reconnect
	// to the same session later.
	LeaseTerm *durationpb.Duration `protobuf:"bytes,6,opt,name=lease_term,json=leaseTerm,proto3" json:"lease_term,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{9}
}

func (x *RequestMetadata) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

func (x *RequestMetadata) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *RequestMetadata) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *RequestMetadata) GetLeaseId() string {
	if x != nil {
		return x.LeaseId
	}
	return ""
}

func (x *RequestMetadata) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *RequestMetadata) GetLeaseTerm() *durationpb.Duration {
	if x != nil {
		return x.LeaseTerm
	}
	return nil
}

// Request message for sending packets.
type SendPacketsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//
	//	*SendPacketsRequest_Packet
	//	*SendPacketsRequest_Metadata
	Request isSendPacketsRequest_Request `protobuf_oneof:"request"`
}

func (x *SendPacketsRequest) Reset() {
	*x = SendPacketsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendPacketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendPacketsRequest) ProtoMessage() {}

func (x *SendPacketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendPacketsRequest.ProtoReflect.Descriptor instead.
func (*SendPacketsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{10}
}

func (m *SendPacketsRequest) GetRequest() isSendPacketsRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *SendPacketsRequest) GetPacket() *Packet {
	if x, ok := x.GetRequest().(*SendPacketsRequest_Packet); ok {
		return x.Packet
	}
	return nil
}

func (x *SendPacketsRequest) GetMetadata() *RequestMetadata {
	if x, ok := x.GetRequest().(*SendPacketsRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

type isSendPacketsRequest_Request interface {
	isSendPacketsRequest_Request()
}

type SendPacketsRequest_Packet struct {
	// Packets sent over the streaming rpc.
	Packet *Packet `protobuf:"bytes,1,opt,name=packet,proto3,oneof"`
}

type SendPacketsRequest_Metadata struct {
	// The first message of the streaming rpc including the request metadata.
	Metadata *RequestMetadata `protobuf:"bytes,2,opt,name=metadata,proto3,oneof"`
}

func (*SendPacketsRequest_Packet) isSendPacketsRequest_Request() {}

func (*SendPacketsRequest_Metadata) isSendPacketsRequest_Request() {}

// Response message for sending packets.
type SendPacketsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SendPacketsResponse) Reset() {
	*x = SendPacketsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendPacketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendPacketsResponse) ProtoMessage() {}

func (x *SendPacketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendPacketsResponse.ProtoReflect.Descriptor instead.
func (*SendPacketsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{11}
}

// Request message for receiving packets.
type ReceivePacketsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible request types from the client.
	//
	// Types that are assignable to Request:
	//
	//	*ReceivePacketsRequest_SetupRequest_
	//	*ReceivePacketsRequest_CommitRequest
	Request isReceivePacketsRequest_Request `protobuf_oneof:"request"`
}

func (x *ReceivePacketsRequest) Reset() {
	*x = ReceivePacketsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceivePacketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceivePacketsRequest) ProtoMessage() {}

func (x *ReceivePacketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceivePacketsRequest.ProtoReflect.Descriptor instead.
func (*ReceivePacketsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{12}
}

func (m *ReceivePacketsRequest) GetRequest() isReceivePacketsRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *ReceivePacketsRequest) GetSetupRequest() *ReceivePacketsRequest_SetupRequest {
	if x, ok := x.GetRequest().(*ReceivePacketsRequest_SetupRequest_); ok {
		return x.SetupRequest
	}
	return nil
}

func (x *ReceivePacketsRequest) GetCommitRequest() *CommitRequest {
	if x, ok := x.GetRequest().(*ReceivePacketsRequest_CommitRequest); ok {
		return x.CommitRequest
	}
	return nil
}

type isReceivePacketsRequest_Request interface {
	isReceivePacketsRequest_Request()
}

type ReceivePacketsRequest_SetupRequest_ struct {
	// The request to setup the initial state of session.
	//
	// The client must send and only send this as the first message.
	SetupRequest *ReceivePacketsRequest_SetupRequest `protobuf:"bytes,6,opt,name=setup_request,json=setupRequest,proto3,oneof"`
}

type ReceivePacketsRequest_CommitRequest struct {
	// This request checkpoints the consumer's read progress.
	CommitRequest *CommitRequest `protobuf:"bytes,7,opt,name=commit_request,json=commitRequest,proto3,oneof"`
}

func (*ReceivePacketsRequest_SetupRequest_) isReceivePacketsRequest_Request() {}

func (*ReceivePacketsRequest_CommitRequest) isReceivePacketsRequest_Request() {}

// Control message for a ReceivePacketsResponse.
type ReceivePacketsControlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible control messages.
	//
	// Types that are assignable to Control:
	//
	//	*ReceivePacketsControlResponse_Heartbeat
	//	*ReceivePacketsControlResponse_WritesDoneRequest
	Control isReceivePacketsControlResponse_Control `protobuf_oneof:"control"`
}

func (x *ReceivePacketsControlResponse) Reset() {
	*x = ReceivePacketsControlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceivePacketsControlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceivePacketsControlResponse) ProtoMessage() {}

func (x *ReceivePacketsControlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceivePacketsControlResponse.ProtoReflect.Descriptor instead.
func (*ReceivePacketsControlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{13}
}

func (m *ReceivePacketsControlResponse) GetControl() isReceivePacketsControlResponse_Control {
	if m != nil {
		return m.Control
	}
	return nil
}

func (x *ReceivePacketsControlResponse) GetHeartbeat() bool {
	if x, ok := x.GetControl().(*ReceivePacketsControlResponse_Heartbeat); ok {
		return x.Heartbeat
	}
	return false
}

func (x *ReceivePacketsControlResponse) GetWritesDoneRequest() bool {
	if x, ok := x.GetControl().(*ReceivePacketsControlResponse_WritesDoneRequest); ok {
		return x.WritesDoneRequest
	}
	return false
}

type isReceivePacketsControlResponse_Control interface {
	isReceivePacketsControlResponse_Control()
}

type ReceivePacketsControlResponse_Heartbeat struct {
	// A server heartbeat.
	Heartbeat bool `protobuf:"varint,1,opt,name=heartbeat,proto3,oneof"`
}

type ReceivePacketsControlResponse_WritesDoneRequest struct {
	// A request to the receiver to complete any final writes followed by a
	// `WritesDone`; e.g. issue any final `CommitRequest`s.
	//
	// May be ignored if `WritesDone` has already been issued at any point
	// prior to receiving this message.
	//
	// If `WritesDone` does not get issued, then the server will forcefully
	// cancel the connection, and the receiver will likely receive an
	// uninformative after `Read` returns `false` and `Finish` is called.
	WritesDoneRequest bool `protobuf:"varint,2,opt,name=writes_done_request,json=writesDoneRequest,proto3,oneof"`
}

func (*ReceivePacketsControlResponse_Heartbeat) isReceivePacketsControlResponse_Control() {}

func (*ReceivePacketsControlResponse_WritesDoneRequest) isReceivePacketsControlResponse_Control() {}

// Response message from ReceivePackets.
type ReceivePacketsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible response types.
	//
	// Types that are assignable to Response:
	//
	//	*ReceivePacketsResponse_Packet
	//	*ReceivePacketsResponse_Control
	Response isReceivePacketsResponse_Response `protobuf_oneof:"response"`
}

func (x *ReceivePacketsResponse) Reset() {
	*x = ReceivePacketsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceivePacketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceivePacketsResponse) ProtoMessage() {}

func (x *ReceivePacketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceivePacketsResponse.ProtoReflect.Descriptor instead.
func (*ReceivePacketsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{14}
}

func (m *ReceivePacketsResponse) GetResponse() isReceivePacketsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ReceivePacketsResponse) GetPacket() *Packet {
	if x, ok := x.GetResponse().(*ReceivePacketsResponse_Packet); ok {
		return x.Packet
	}
	return nil
}

func (x *ReceivePacketsResponse) GetControl() *ReceivePacketsControlResponse {
	if x, ok := x.GetResponse().(*ReceivePacketsResponse_Control); ok {
		return x.Control
	}
	return nil
}

type isReceivePacketsResponse_Response interface {
	isReceivePacketsResponse_Response()
}

type ReceivePacketsResponse_Packet struct {
	// A genuine data payload originating from the sender.
	Packet *Packet `protobuf:"bytes,1,opt,name=packet,proto3,oneof"`
}

type ReceivePacketsResponse_Control struct {
	// A control message from the server.
	Control *ReceivePacketsControlResponse `protobuf:"bytes,3,opt,name=control,proto3,oneof"`
}

func (*ReceivePacketsResponse_Packet) isReceivePacketsResponse_Response() {}

func (*ReceivePacketsResponse_Control) isReceivePacketsResponse_Response() {}

// The options for receiver under the eager mode.
type EagerMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EagerMode) Reset() {
	*x = EagerMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EagerMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EagerMode) ProtoMessage() {}

func (x *EagerMode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EagerMode.ProtoReflect.Descriptor instead.
func (*EagerMode) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{15}
}

// The options for receiver under the controlled mode.
type ControlledMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the offset from which to start receiveing.
	//
	// Types that are assignable to StartingOffset:
	//
	//	*ControlledMode_StartingLogicalOffset
	StartingOffset isControlledMode_StartingOffset `protobuf_oneof:"starting_offset"`
	// This is the logical starting point to fallback upon should the
	// specified starting offset be unavailable.
	//
	// This can be one of the following values:
	//
	// "begin": This will read from the earliest available message.
	//
	// "end": This will read only future messages.
	FallbackStartingOffset string `protobuf:"bytes,2,opt,name=fallback_starting_offset,json=fallbackStartingOffset,proto3" json:"fallback_starting_offset,omitempty"`
}

func (x *ControlledMode) Reset() {
	*x = ControlledMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ControlledMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControlledMode) ProtoMessage() {}

func (x *ControlledMode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControlledMode.ProtoReflect.Descriptor instead.
func (*ControlledMode) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{16}
}

func (m *ControlledMode) GetStartingOffset() isControlledMode_StartingOffset {
	if m != nil {
		return m.StartingOffset
	}
	return nil
}

func (x *ControlledMode) GetStartingLogicalOffset() string {
	if x, ok := x.GetStartingOffset().(*ControlledMode_StartingLogicalOffset); ok {
		return x.StartingLogicalOffset
	}
	return ""
}

func (x *ControlledMode) GetFallbackStartingOffset() string {
	if x != nil {
		return x.FallbackStartingOffset
	}
	return ""
}

type isControlledMode_StartingOffset interface {
	isControlledMode_StartingOffset()
}

type ControlledMode_StartingLogicalOffset struct {
	// This can be set to the following logical starting points:
	//
	// "begin": This will read from the earliest available message.
	//
	// "most-recent": This will read from the latest available message.
	//
	// "end": This will read only future messages.
	//
	// "stored": This will resume reads one past the last committed offset.
	//
	//	It is the only option that resumes progress; all others
	//	jump unilaterally.
	StartingLogicalOffset string `protobuf:"bytes,1,opt,name=starting_logical_offset,json=startingLogicalOffset,proto3,oneof"`
}

func (*ControlledMode_StartingLogicalOffset) isControlledMode_StartingOffset() {}

// The message for explicitly committing the read progress.
//
// This may only be used when `ReceivePacketsControlledMode` is set in the
// initial setup request.
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The offset to commit.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{17}
}

func (x *CommitRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// SetupRequest is the first message sent to the service to setup the RPC
// connection.
type ReceiveEventsRequest_SetupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster name.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The stream name. The service will return the events for the given stream.
	Stream string `protobuf:"bytes,2,opt,name=stream,proto3" json:"stream,omitempty"`
	// A name for the receiver to self-identify.
	//
	// This is used to keep track of a receiver's read progress.
	Receiver string `protobuf:"bytes,3,opt,name=receiver,proto3" json:"receiver,omitempty"`
	// Controller mode configuration for receiving events from the server.
	ControlledMode *ControlledMode `protobuf:"bytes,4,opt,name=controlled_mode,json=controlledMode,proto3" json:"controlled_mode,omitempty"`
	// The maximum duration of server silence before the client determines the
	// server unreachable.
	//
	// The client must either receive an `Event` update or a heart beat message
	// before this duration expires; otherwise, the client will automatically
	// cancel the current connection and retry.
	HeartbeatInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=heartbeat_interval,json=heartbeatInterval,proto3" json:"heartbeat_interval,omitempty"`
	// The grace period after which a `writes_done_request` is issued, that a
	// `WritesDone` is expected from the client.
	//
	// The server is free to cancel the RPC should this expire.
	//
	// A system default will be chosen if unset.
	WritesDoneGracePeriod *durationpb.Duration `protobuf:"bytes,6,opt,name=writes_done_grace_period,json=writesDoneGracePeriod,proto3" json:"writes_done_grace_period,omitempty"`
}

func (x *ReceiveEventsRequest_SetupRequest) Reset() {
	*x = ReceiveEventsRequest_SetupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveEventsRequest_SetupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveEventsRequest_SetupRequest) ProtoMessage() {}

func (x *ReceiveEventsRequest_SetupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveEventsRequest_SetupRequest.ProtoReflect.Descriptor instead.
func (*ReceiveEventsRequest_SetupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReceiveEventsRequest_SetupRequest) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *ReceiveEventsRequest_SetupRequest) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

func (x *ReceiveEventsRequest_SetupRequest) GetReceiver() string {
	if x != nil {
		return x.Receiver
	}
	return ""
}

func (x *ReceiveEventsRequest_SetupRequest) GetControlledMode() *ControlledMode {
	if x != nil {
		return x.ControlledMode
	}
	return nil
}

func (x *ReceiveEventsRequest_SetupRequest) GetHeartbeatInterval() *durationpb.Duration {
	if x != nil {
		return x.HeartbeatInterval
	}
	return nil
}

func (x *ReceiveEventsRequest_SetupRequest) GetWritesDoneGracePeriod() *durationpb.Duration {
	if x != nil {
		return x.WritesDoneGracePeriod
	}
	return nil
}

// The message specifying the initial settings for the ReceivePackets session.
type ReceivePacketsRequest_SetupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mode in which the consumer reads messages.
	//
	// Types that are assignable to ConsumerMode:
	//
	//	*ReceivePacketsRequest_SetupRequest_EagerReceiveMode
	//	*ReceivePacketsRequest_SetupRequest_ControlledReceiveMode
	ConsumerMode isReceivePacketsRequest_SetupRequest_ConsumerMode `protobuf_oneof:"consumer_mode"`
	// The configurations that specify where packets are retrieved.
	Metadata *RequestMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A name for the receiver to self-identify.
	//
	// This is used to keep track of a receiver's read progress.
	Receiver string `protobuf:"bytes,2,opt,name=receiver,proto3" json:"receiver,omitempty"`
	// The maximum duration of server silence before the client determines the
	// server unreachable.
	//
	// The client must either receive a `Packet` or a heart beat message before
	// this duration expires; otherwise, the client will automatically cancel
	// the current connection and retry.
	HeartbeatInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=heartbeat_interval,json=heartbeatInterval,proto3" json:"heartbeat_interval,omitempty"`
	// The grace period after which a `writes_done_request` is issued, that a
	// `WritesDone` is expected from the client.
	//
	// The server is free to cancel the RPC should this expire.
	//
	// A system default will be chosen if unset.
	WritesDoneGracePeriod *durationpb.Duration `protobuf:"bytes,6,opt,name=writes_done_grace_period,json=writesDoneGracePeriod,proto3" json:"writes_done_grace_period,omitempty"`
}

func (x *ReceivePacketsRequest_SetupRequest) Reset() {
	*x = ReceivePacketsRequest_SetupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceivePacketsRequest_SetupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceivePacketsRequest_SetupRequest) ProtoMessage() {}

func (x *ReceivePacketsRequest_SetupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceivePacketsRequest_SetupRequest.ProtoReflect.Descriptor instead.
func (*ReceivePacketsRequest_SetupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP(), []int{12, 0}
}

func (m *ReceivePacketsRequest_SetupRequest) GetConsumerMode() isReceivePacketsRequest_SetupRequest_ConsumerMode {
	if m != nil {
		return m.ConsumerMode
	}
	return nil
}

func (x *ReceivePacketsRequest_SetupRequest) GetEagerReceiveMode() *EagerMode {
	if x, ok := x.GetConsumerMode().(*ReceivePacketsRequest_SetupRequest_EagerReceiveMode); ok {
		return x.EagerReceiveMode
	}
	return nil
}

func (x *ReceivePacketsRequest_SetupRequest) GetControlledReceiveMode() *ControlledMode {
	if x, ok := x.GetConsumerMode().(*ReceivePacketsRequest_SetupRequest_ControlledReceiveMode); ok {
		return x.ControlledReceiveMode
	}
	return nil
}

func (x *ReceivePacketsRequest_SetupRequest) GetMetadata() *RequestMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ReceivePacketsRequest_SetupRequest) GetReceiver() string {
	if x != nil {
		return x.Receiver
	}
	return ""
}

func (x *ReceivePacketsRequest_SetupRequest) GetHeartbeatInterval() *durationpb.Duration {
	if x != nil {
		return x.HeartbeatInterval
	}
	return nil
}

func (x *ReceivePacketsRequest_SetupRequest) GetWritesDoneGracePeriod() *durationpb.Duration {
	if x != nil {
		return x.WritesDoneGracePeriod
	}
	return nil
}

type isReceivePacketsRequest_SetupRequest_ConsumerMode interface {
	isReceivePacketsRequest_SetupRequest_ConsumerMode()
}

type ReceivePacketsRequest_SetupRequest_EagerReceiveMode struct {
	// Options for configuring eager mode.
	EagerReceiveMode *EagerMode `protobuf:"bytes,3,opt,name=eager_receive_mode,json=eagerReceiveMode,proto3,oneof"`
}

type ReceivePacketsRequest_SetupRequest_ControlledReceiveMode struct {
	// Options for configuring controlled mode.
	ControlledReceiveMode *ControlledMode `protobuf:"bytes,4,opt,name=controlled_receive_mode,json=controlledReceiveMode,proto3,oneof"`
}

func (*ReceivePacketsRequest_SetupRequest_EagerReceiveMode) isReceivePacketsRequest_SetupRequest_ConsumerMode() {
}

func (*ReceivePacketsRequest_SetupRequest_ControlledReceiveMode) isReceivePacketsRequest_SetupRequest_ConsumerMode() {
}

var File_google_cloud_visionai_v1_streaming_service_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1_streaming_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7, 0x04, 0x0a, 0x14, 0x52, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x62, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0xcd, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x68, 0x65, 0x61,
	0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x12, 0x52, 0x0a, 0x18, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f,
	0x6e, 0x65, 0x5f, 0x67, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x15, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x44, 0x6f, 0x6e, 0x65, 0x47, 0x72, 0x61, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0xa8, 0x01, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x7b, 0x0a,
	0x1c, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a,
	0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x30, 0x0a,
	0x13, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x11, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x73, 0x44, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0xc3, 0x01, 0x0a, 0x15, 0x52,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x12, 0x52, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xc6, 0x01, 0x0a, 0x05, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x41, 0x63,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x2d, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x12, 0x42,
	0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x74, 0x65, 0x72, 0x6d, 0x22, 0x53, 0x0a, 0x13, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x22, 0x16, 0x0a, 0x14, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x38, 0x0a,
	0x0a, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x54, 0x65, 0x72, 0x6d, 0x22, 0xa4, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x6e, 0x64,
	0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x47, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x15,
	0x0a, 0x13, 0x53, 0x65, 0x6e, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb5, 0x05, 0x0a, 0x15, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x63, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0xd9, 0x03, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x12, 0x65, 0x61, 0x67, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x61, 0x67, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x10, 0x65, 0x61, 0x67, 0x65,
	0x72, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x62, 0x0a, 0x17,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x45, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x12, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x68, 0x65, 0x61, 0x72,
	0x74, 0x62, 0x65, 0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x52, 0x0a,
	0x18, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x6e, 0x65, 0x5f, 0x67, 0x72, 0x61,
	0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x73, 0x44, 0x6f, 0x6e, 0x65, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x7c, 0x0a,
	0x1d, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e,
	0x0a, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x30,
	0x0a, 0x13, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x11, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x73, 0x44, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0xb5, 0x01, 0x0a, 0x16,
	0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x53, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x0b, 0x0a, 0x09, 0x45, 0x61, 0x67, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x22, 0x97, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x15, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x38, 0x0a,
	0x18, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x27, 0x0a, 0x0d, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x2a, 0x55, 0x0a, 0x09, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11,
	0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x45,
	0x52, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x52, 0x10, 0x02, 0x32, 0xe3, 0x07, 0x0a, 0x10, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x70, 0x0a, 0x0b, 0x53, 0x65, 0x6e, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x12, 0x79, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x76, 0x0a, 0x0d,
	0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x12, 0xaf, 0x01, 0x0a, 0x0c, 0x41, 0x63, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x63, 0x71, 0x75, 0x69, 0x72, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x44, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x71, 0x75, 0x69, 0x72, 0x65, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xa9, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x6e, 0x65, 0x77,
	0x4c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x3a,
	0x01, 0x2a, 0x12, 0xbe, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4c, 0x65, 0x61, 0x73, 0x65,
	0x3a, 0x01, 0x2a, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xcd, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x42, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0xaa, 0x02, 0x18, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1_streaming_service_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1_streaming_service_proto_rawDescData = file_google_cloud_visionai_v1_streaming_service_proto_rawDesc
)

func file_google_cloud_visionai_v1_streaming_service_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1_streaming_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1_streaming_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1_streaming_service_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1_streaming_service_proto_rawDescData
}

var file_google_cloud_visionai_v1_streaming_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_visionai_v1_streaming_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_visionai_v1_streaming_service_proto_goTypes = []interface{}{
	(LeaseType)(0),                             // 0: google.cloud.visionai.v1.LeaseType
	(*ReceiveEventsRequest)(nil),               // 1: google.cloud.visionai.v1.ReceiveEventsRequest
	(*EventUpdate)(nil),                        // 2: google.cloud.visionai.v1.EventUpdate
	(*ReceiveEventsControlResponse)(nil),       // 3: google.cloud.visionai.v1.ReceiveEventsControlResponse
	(*ReceiveEventsResponse)(nil),              // 4: google.cloud.visionai.v1.ReceiveEventsResponse
	(*Lease)(nil),                              // 5: google.cloud.visionai.v1.Lease
	(*AcquireLeaseRequest)(nil),                // 6: google.cloud.visionai.v1.AcquireLeaseRequest
	(*RenewLeaseRequest)(nil),                  // 7: google.cloud.visionai.v1.RenewLeaseRequest
	(*ReleaseLeaseRequest)(nil),                // 8: google.cloud.visionai.v1.ReleaseLeaseRequest
	(*ReleaseLeaseResponse)(nil),               // 9: google.cloud.visionai.v1.ReleaseLeaseResponse
	(*RequestMetadata)(nil),                    // 10: google.cloud.visionai.v1.RequestMetadata
	(*SendPacketsRequest)(nil),                 // 11: google.cloud.visionai.v1.SendPacketsRequest
	(*SendPacketsResponse)(nil),                // 12: google.cloud.visionai.v1.SendPacketsResponse
	(*ReceivePacketsRequest)(nil),              // 13: google.cloud.visionai.v1.ReceivePacketsRequest
	(*ReceivePacketsControlResponse)(nil),      // 14: google.cloud.visionai.v1.ReceivePacketsControlResponse
	(*ReceivePacketsResponse)(nil),             // 15: google.cloud.visionai.v1.ReceivePacketsResponse
	(*EagerMode)(nil),                          // 16: google.cloud.visionai.v1.EagerMode
	(*ControlledMode)(nil),                     // 17: google.cloud.visionai.v1.ControlledMode
	(*CommitRequest)(nil),                      // 18: google.cloud.visionai.v1.CommitRequest
	(*ReceiveEventsRequest_SetupRequest)(nil),  // 19: google.cloud.visionai.v1.ReceiveEventsRequest.SetupRequest
	(*ReceivePacketsRequest_SetupRequest)(nil), // 20: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest
	(*timestamppb.Timestamp)(nil),              // 21: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                // 22: google.protobuf.Duration
	(*Packet)(nil),                             // 23: google.cloud.visionai.v1.Packet
}
var file_google_cloud_visionai_v1_streaming_service_proto_depIdxs = []int32{
	19, // 0: google.cloud.visionai.v1.ReceiveEventsRequest.setup_request:type_name -> google.cloud.visionai.v1.ReceiveEventsRequest.SetupRequest
	18, // 1: google.cloud.visionai.v1.ReceiveEventsRequest.commit_request:type_name -> google.cloud.visionai.v1.CommitRequest
	21, // 2: google.cloud.visionai.v1.EventUpdate.update_time:type_name -> google.protobuf.Timestamp
	2,  // 3: google.cloud.visionai.v1.ReceiveEventsResponse.event_update:type_name -> google.cloud.visionai.v1.EventUpdate
	3,  // 4: google.cloud.visionai.v1.ReceiveEventsResponse.control:type_name -> google.cloud.visionai.v1.ReceiveEventsControlResponse
	21, // 5: google.cloud.visionai.v1.Lease.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 6: google.cloud.visionai.v1.Lease.lease_type:type_name -> google.cloud.visionai.v1.LeaseType
	22, // 7: google.cloud.visionai.v1.AcquireLeaseRequest.term:type_name -> google.protobuf.Duration
	0,  // 8: google.cloud.visionai.v1.AcquireLeaseRequest.lease_type:type_name -> google.cloud.visionai.v1.LeaseType
	22, // 9: google.cloud.visionai.v1.RenewLeaseRequest.term:type_name -> google.protobuf.Duration
	22, // 10: google.cloud.visionai.v1.RequestMetadata.lease_term:type_name -> google.protobuf.Duration
	23, // 11: google.cloud.visionai.v1.SendPacketsRequest.packet:type_name -> google.cloud.visionai.v1.Packet
	10, // 12: google.cloud.visionai.v1.SendPacketsRequest.metadata:type_name -> google.cloud.visionai.v1.RequestMetadata
	20, // 13: google.cloud.visionai.v1.ReceivePacketsRequest.setup_request:type_name -> google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest
	18, // 14: google.cloud.visionai.v1.ReceivePacketsRequest.commit_request:type_name -> google.cloud.visionai.v1.CommitRequest
	23, // 15: google.cloud.visionai.v1.ReceivePacketsResponse.packet:type_name -> google.cloud.visionai.v1.Packet
	14, // 16: google.cloud.visionai.v1.ReceivePacketsResponse.control:type_name -> google.cloud.visionai.v1.ReceivePacketsControlResponse
	17, // 17: google.cloud.visionai.v1.ReceiveEventsRequest.SetupRequest.controlled_mode:type_name -> google.cloud.visionai.v1.ControlledMode
	22, // 18: google.cloud.visionai.v1.ReceiveEventsRequest.SetupRequest.heartbeat_interval:type_name -> google.protobuf.Duration
	22, // 19: google.cloud.visionai.v1.ReceiveEventsRequest.SetupRequest.writes_done_grace_period:type_name -> google.protobuf.Duration
	16, // 20: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest.eager_receive_mode:type_name -> google.cloud.visionai.v1.EagerMode
	17, // 21: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest.controlled_receive_mode:type_name -> google.cloud.visionai.v1.ControlledMode
	10, // 22: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest.metadata:type_name -> google.cloud.visionai.v1.RequestMetadata
	22, // 23: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest.heartbeat_interval:type_name -> google.protobuf.Duration
	22, // 24: google.cloud.visionai.v1.ReceivePacketsRequest.SetupRequest.writes_done_grace_period:type_name -> google.protobuf.Duration
	11, // 25: google.cloud.visionai.v1.StreamingService.SendPackets:input_type -> google.cloud.visionai.v1.SendPacketsRequest
	13, // 26: google.cloud.visionai.v1.StreamingService.ReceivePackets:input_type -> google.cloud.visionai.v1.ReceivePacketsRequest
	1,  // 27: google.cloud.visionai.v1.StreamingService.ReceiveEvents:input_type -> google.cloud.visionai.v1.ReceiveEventsRequest
	6,  // 28: google.cloud.visionai.v1.StreamingService.AcquireLease:input_type -> google.cloud.visionai.v1.AcquireLeaseRequest
	7,  // 29: google.cloud.visionai.v1.StreamingService.RenewLease:input_type -> google.cloud.visionai.v1.RenewLeaseRequest
	8,  // 30: google.cloud.visionai.v1.StreamingService.ReleaseLease:input_type -> google.cloud.visionai.v1.ReleaseLeaseRequest
	12, // 31: google.cloud.visionai.v1.StreamingService.SendPackets:output_type -> google.cloud.visionai.v1.SendPacketsResponse
	15, // 32: google.cloud.visionai.v1.StreamingService.ReceivePackets:output_type -> google.cloud.visionai.v1.ReceivePacketsResponse
	4,  // 33: google.cloud.visionai.v1.StreamingService.ReceiveEvents:output_type -> google.cloud.visionai.v1.ReceiveEventsResponse
	5,  // 34: google.cloud.visionai.v1.StreamingService.AcquireLease:output_type -> google.cloud.visionai.v1.Lease
	5,  // 35: google.cloud.visionai.v1.StreamingService.RenewLease:output_type -> google.cloud.visionai.v1.Lease
	9,  // 36: google.cloud.visionai.v1.StreamingService.ReleaseLease:output_type -> google.cloud.visionai.v1.ReleaseLeaseResponse
	31, // [31:37] is the sub-list for method output_type
	25, // [25:31] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1_streaming_service_proto_init() }
func file_google_cloud_visionai_v1_streaming_service_proto_init() {
	if File_google_cloud_visionai_v1_streaming_service_proto != nil {
		return
	}
	file_google_cloud_visionai_v1_streaming_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveEventsControlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcquireLeaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenewLeaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseLeaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseLeaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendPacketsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendPacketsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceivePacketsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceivePacketsControlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceivePacketsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EagerMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ControlledMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveEventsRequest_SetupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceivePacketsRequest_SetupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ReceiveEventsRequest_SetupRequest_)(nil),
		(*ReceiveEventsRequest_CommitRequest)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ReceiveEventsControlResponse_Heartbeat)(nil),
		(*ReceiveEventsControlResponse_WritesDoneRequest)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ReceiveEventsResponse_EventUpdate)(nil),
		(*ReceiveEventsResponse_Control)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*SendPacketsRequest_Packet)(nil),
		(*SendPacketsRequest_Metadata)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ReceivePacketsRequest_SetupRequest_)(nil),
		(*ReceivePacketsRequest_CommitRequest)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ReceivePacketsControlResponse_Heartbeat)(nil),
		(*ReceivePacketsControlResponse_WritesDoneRequest)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*ReceivePacketsResponse_Packet)(nil),
		(*ReceivePacketsResponse_Control)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*ControlledMode_StartingLogicalOffset)(nil),
	}
	file_google_cloud_visionai_v1_streaming_service_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*ReceivePacketsRequest_SetupRequest_EagerReceiveMode)(nil),
		(*ReceivePacketsRequest_SetupRequest_ControlledReceiveMode)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1_streaming_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visionai_v1_streaming_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1_streaming_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1_streaming_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1_streaming_service_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1_streaming_service_proto = out.File
	file_google_cloud_visionai_v1_streaming_service_proto_rawDesc = nil
	file_google_cloud_visionai_v1_streaming_service_proto_goTypes = nil
	file_google_cloud_visionai_v1_streaming_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StreamingServiceClient is the client API for StreamingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingServiceClient interface {
	// Send packets to the series.
	SendPackets(ctx context.Context, opts ...grpc.CallOption) (StreamingService_SendPacketsClient, error)
	// Receive packets from the series.
	ReceivePackets(ctx context.Context, opts ...grpc.CallOption) (StreamingService_ReceivePacketsClient, error)
	// Receive events given the stream name.
	ReceiveEvents(ctx context.Context, opts ...grpc.CallOption) (StreamingService_ReceiveEventsClient, error)
	// AcquireLease acquires a lease.
	AcquireLease(ctx context.Context, in *AcquireLeaseRequest, opts ...grpc.CallOption) (*Lease, error)
	// RenewLease renews a lease.
	RenewLease(ctx context.Context, in *RenewLeaseRequest, opts ...grpc.CallOption) (*Lease, error)
	// RleaseLease releases a lease.
	ReleaseLease(ctx context.Context, in *ReleaseLeaseRequest, opts ...grpc.CallOption) (*ReleaseLeaseResponse, error)
}

type streamingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreamingServiceClient(cc grpc.ClientConnInterface) StreamingServiceClient {
	return &streamingServiceClient{cc}
}

func (c *streamingServiceClient) SendPackets(ctx context.Context, opts ...grpc.CallOption) (StreamingService_SendPacketsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingService_serviceDesc.Streams[0], "/google.cloud.visionai.v1.StreamingService/SendPackets", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingServiceSendPacketsClient{stream}
	return x, nil
}

type StreamingService_SendPacketsClient interface {
	Send(*SendPacketsRequest) error
	Recv() (*SendPacketsResponse, error)
	grpc.ClientStream
}

type streamingServiceSendPacketsClient struct {
	grpc.ClientStream
}

func (x *streamingServiceSendPacketsClient) Send(m *SendPacketsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingServiceSendPacketsClient) Recv() (*SendPacketsResponse, error) {
	m := new(SendPacketsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *streamingServiceClient) ReceivePackets(ctx context.Context, opts ...grpc.CallOption) (StreamingService_ReceivePacketsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingService_serviceDesc.Streams[1], "/google.cloud.visionai.v1.StreamingService/ReceivePackets", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingServiceReceivePacketsClient{stream}
	return x, nil
}

type StreamingService_ReceivePacketsClient interface {
	Send(*ReceivePacketsRequest) error
	Recv() (*ReceivePacketsResponse, error)
	grpc.ClientStream
}

type streamingServiceReceivePacketsClient struct {
	grpc.ClientStream
}

func (x *streamingServiceReceivePacketsClient) Send(m *ReceivePacketsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingServiceReceivePacketsClient) Recv() (*ReceivePacketsResponse, error) {
	m := new(ReceivePacketsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *streamingServiceClient) ReceiveEvents(ctx context.Context, opts ...grpc.CallOption) (StreamingService_ReceiveEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingService_serviceDesc.Streams[2], "/google.cloud.visionai.v1.StreamingService/ReceiveEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingServiceReceiveEventsClient{stream}
	return x, nil
}

type StreamingService_ReceiveEventsClient interface {
	Send(*ReceiveEventsRequest) error
	Recv() (*ReceiveEventsResponse, error)
	grpc.ClientStream
}

type streamingServiceReceiveEventsClient struct {
	grpc.ClientStream
}

func (x *streamingServiceReceiveEventsClient) Send(m *ReceiveEventsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingServiceReceiveEventsClient) Recv() (*ReceiveEventsResponse, error) {
	m := new(ReceiveEventsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *streamingServiceClient) AcquireLease(ctx context.Context, in *AcquireLeaseRequest, opts ...grpc.CallOption) (*Lease, error) {
	out := new(Lease)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.StreamingService/AcquireLease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamingServiceClient) RenewLease(ctx context.Context, in *RenewLeaseRequest, opts ...grpc.CallOption) (*Lease, error) {
	out := new(Lease)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.StreamingService/RenewLease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamingServiceClient) ReleaseLease(ctx context.Context, in *ReleaseLeaseRequest, opts ...grpc.CallOption) (*ReleaseLeaseResponse, error) {
	out := new(ReleaseLeaseResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.StreamingService/ReleaseLease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StreamingServiceServer is the server API for StreamingService service.
type StreamingServiceServer interface {
	// Send packets to the series.
	SendPackets(StreamingService_SendPacketsServer) error
	// Receive packets from the series.
	ReceivePackets(StreamingService_ReceivePacketsServer) error
	// Receive events given the stream name.
	ReceiveEvents(StreamingService_ReceiveEventsServer) error
	// AcquireLease acquires a lease.
	AcquireLease(context.Context, *AcquireLeaseRequest) (*Lease, error)
	// RenewLease renews a lease.
	RenewLease(context.Context, *RenewLeaseRequest) (*Lease, error)
	// RleaseLease releases a lease.
	ReleaseLease(context.Context, *ReleaseLeaseRequest) (*ReleaseLeaseResponse, error)
}

// UnimplementedStreamingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingServiceServer struct {
}

func (*UnimplementedStreamingServiceServer) SendPackets(StreamingService_SendPacketsServer) error {
	return status.Errorf(codes.Unimplemented, "method SendPackets not implemented")
}
func (*UnimplementedStreamingServiceServer) ReceivePackets(StreamingService_ReceivePacketsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceivePackets not implemented")
}
func (*UnimplementedStreamingServiceServer) ReceiveEvents(StreamingService_ReceiveEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveEvents not implemented")
}
func (*UnimplementedStreamingServiceServer) AcquireLease(context.Context, *AcquireLeaseRequest) (*Lease, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcquireLease not implemented")
}
func (*UnimplementedStreamingServiceServer) RenewLease(context.Context, *RenewLeaseRequest) (*Lease, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewLease not implemented")
}
func (*UnimplementedStreamingServiceServer) ReleaseLease(context.Context, *ReleaseLeaseRequest) (*ReleaseLeaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReleaseLease not implemented")
}

func RegisterStreamingServiceServer(s *grpc.Server, srv StreamingServiceServer) {
	s.RegisterService(&_StreamingService_serviceDesc, srv)
}

func _StreamingService_SendPackets_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingServiceServer).SendPackets(&streamingServiceSendPacketsServer{stream})
}

type StreamingService_SendPacketsServer interface {
	Send(*SendPacketsResponse) error
	Recv() (*SendPacketsRequest, error)
	grpc.ServerStream
}

type streamingServiceSendPacketsServer struct {
	grpc.ServerStream
}

func (x *streamingServiceSendPacketsServer) Send(m *SendPacketsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingServiceSendPacketsServer) Recv() (*SendPacketsRequest, error) {
	m := new(SendPacketsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _StreamingService_ReceivePackets_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingServiceServer).ReceivePackets(&streamingServiceReceivePacketsServer{stream})
}

type StreamingService_ReceivePacketsServer interface {
	Send(*ReceivePacketsResponse) error
	Recv() (*ReceivePacketsRequest, error)
	grpc.ServerStream
}

type streamingServiceReceivePacketsServer struct {
	grpc.ServerStream
}

func (x *streamingServiceReceivePacketsServer) Send(m *ReceivePacketsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingServiceReceivePacketsServer) Recv() (*ReceivePacketsRequest, error) {
	m := new(ReceivePacketsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _StreamingService_ReceiveEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingServiceServer).ReceiveEvents(&streamingServiceReceiveEventsServer{stream})
}

type StreamingService_ReceiveEventsServer interface {
	Send(*ReceiveEventsResponse) error
	Recv() (*ReceiveEventsRequest, error)
	grpc.ServerStream
}

type streamingServiceReceiveEventsServer struct {
	grpc.ServerStream
}

func (x *streamingServiceReceiveEventsServer) Send(m *ReceiveEventsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingServiceReceiveEventsServer) Recv() (*ReceiveEventsRequest, error) {
	m := new(ReceiveEventsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _StreamingService_AcquireLease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcquireLeaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamingServiceServer).AcquireLease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.StreamingService/AcquireLease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamingServiceServer).AcquireLease(ctx, req.(*AcquireLeaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamingService_RenewLease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewLeaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamingServiceServer).RenewLease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.StreamingService/RenewLease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamingServiceServer).RenewLease(ctx, req.(*RenewLeaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamingService_ReleaseLease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReleaseLeaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamingServiceServer).ReleaseLease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.StreamingService/ReleaseLease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamingServiceServer).ReleaseLease(ctx, req.(*ReleaseLeaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StreamingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visionai.v1.StreamingService",
	HandlerType: (*StreamingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AcquireLease",
			Handler:    _StreamingService_AcquireLease_Handler,
		},
		{
			MethodName: "RenewLease",
			Handler:    _StreamingService_RenewLease_Handler,
		},
		{
			MethodName: "ReleaseLease",
			Handler:    _StreamingService_ReleaseLease_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SendPackets",
			Handler:       _StreamingService_SendPackets_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ReceivePackets",
			Handler:       _StreamingService_ReceivePackets_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ReceiveEvents",
			Handler:       _StreamingService_ReceiveEvents_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/visionai/v1/streaming_service.proto",
}
