// Code generated by smithy-go-codegen DO NOT EDIT.

package iam

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iam/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a human readable summary for a given entity. At this time, the only
// supported entity type is delegation-request
//
// This method uses a Large Language Model (LLM) to generate the summary.
//
// If a delegation request has no owner or owner account, GetHumanReadableSummary
// for that delegation request can be called by any account. If the owner account
// is assigned but there is no owner id, only identities within that owner account
// can call GetHumanReadableSummary for the delegation request to retrieve a
// summary of that request. Once the delegation request is fully owned, the owner
// of the request gets a default permission to get that delegation request. For
// more details, read default permissions granted to delegation requests. These rules are identical to [GetDelegationRequest] API behavior, such that a
// party who has permissions to call [GetDelegationRequest]for a given delegation request will always be
// able to retrieve the human readable summary for that request.
//
// [GetDelegationRequest]: https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetDelegationRequest.html
func (c *Client) GetHumanReadableSummary(ctx context.Context, params *GetHumanReadableSummaryInput, optFns ...func(*Options)) (*GetHumanReadableSummaryOutput, error) {
	if params == nil {
		params = &GetHumanReadableSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetHumanReadableSummary", params, optFns, c.addOperationGetHumanReadableSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetHumanReadableSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetHumanReadableSummaryInput struct {

	// Arn of the entity to be summarized. At this time, the only supported entity
	// type is delegation-request
	//
	// This member is required.
	EntityArn *string

	// A string representing the locale to use for the summary generation. The
	// supported locale strings are based on the Supported languages of the Amazon Web Services Management Console.
	Locale *string

	noSmithyDocumentSerde
}

type GetHumanReadableSummaryOutput struct {

	// The locale that this response was generated for. This maps to the input locale.
	Locale *string

	// Summary content in the specified locale. Summary content is non-empty only if
	// the SummaryState is AVAILABLE .
	SummaryContent *string

	// State of summary generation. This generation process is asynchronous and this
	// attribute indicates the state of the generation process.
	SummaryState types.SummaryStateType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetHumanReadableSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetHumanReadableSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetHumanReadableSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetHumanReadableSummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetHumanReadableSummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetHumanReadableSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetHumanReadableSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetHumanReadableSummary",
	}
}
