// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/documentai/v1/processor.proto

package documentaipb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible states of the processor version.
type ProcessorVersion_State int32

const (
	// The processor version is in an unspecified state.
	ProcessorVersion_STATE_UNSPECIFIED ProcessorVersion_State = 0
	// The processor version is deployed and can be used for processing.
	ProcessorVersion_DEPLOYED ProcessorVersion_State = 1
	// The processor version is being deployed.
	ProcessorVersion_DEPLOYING ProcessorVersion_State = 2
	// The processor version is not deployed and cannot be used for processing.
	ProcessorVersion_UNDEPLOYED ProcessorVersion_State = 3
	// The processor version is being undeployed.
	ProcessorVersion_UNDEPLOYING ProcessorVersion_State = 4
	// The processor version is being created.
	ProcessorVersion_CREATING ProcessorVersion_State = 5
	// The processor version is being deleted.
	ProcessorVersion_DELETING ProcessorVersion_State = 6
	// The processor version failed and is in an indeterminate state.
	ProcessorVersion_FAILED ProcessorVersion_State = 7
	// The processor version is being imported.
	ProcessorVersion_IMPORTING ProcessorVersion_State = 8
)

// Enum value maps for ProcessorVersion_State.
var (
	ProcessorVersion_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DEPLOYED",
		2: "DEPLOYING",
		3: "UNDEPLOYED",
		4: "UNDEPLOYING",
		5: "CREATING",
		6: "DELETING",
		7: "FAILED",
		8: "IMPORTING",
	}
	ProcessorVersion_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DEPLOYED":          1,
		"DEPLOYING":         2,
		"UNDEPLOYED":        3,
		"UNDEPLOYING":       4,
		"CREATING":          5,
		"DELETING":          6,
		"FAILED":            7,
		"IMPORTING":         8,
	}
)

func (x ProcessorVersion_State) Enum() *ProcessorVersion_State {
	p := new(ProcessorVersion_State)
	*p = x
	return p
}

func (x ProcessorVersion_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessorVersion_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_processor_proto_enumTypes[0].Descriptor()
}

func (ProcessorVersion_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_processor_proto_enumTypes[0]
}

func (x ProcessorVersion_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessorVersion_State.Descriptor instead.
func (ProcessorVersion_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 0}
}

// The possible model types of the processor version.
type ProcessorVersion_ModelType int32

const (
	// The processor version has unspecified model type.
	ProcessorVersion_MODEL_TYPE_UNSPECIFIED ProcessorVersion_ModelType = 0
	// The processor version has generative model type.
	ProcessorVersion_MODEL_TYPE_GENERATIVE ProcessorVersion_ModelType = 1
	// The processor version has custom model type.
	ProcessorVersion_MODEL_TYPE_CUSTOM ProcessorVersion_ModelType = 2
)

// Enum value maps for ProcessorVersion_ModelType.
var (
	ProcessorVersion_ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		1: "MODEL_TYPE_GENERATIVE",
		2: "MODEL_TYPE_CUSTOM",
	}
	ProcessorVersion_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED": 0,
		"MODEL_TYPE_GENERATIVE":  1,
		"MODEL_TYPE_CUSTOM":      2,
	}
)

func (x ProcessorVersion_ModelType) Enum() *ProcessorVersion_ModelType {
	p := new(ProcessorVersion_ModelType)
	*p = x
	return p
}

func (x ProcessorVersion_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessorVersion_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_processor_proto_enumTypes[1].Descriptor()
}

func (ProcessorVersion_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_processor_proto_enumTypes[1]
}

func (x ProcessorVersion_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessorVersion_ModelType.Descriptor instead.
func (ProcessorVersion_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 1}
}

// The type of custom model created by the user.
type ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType int32

const (
	// The model type is unspecified.
	ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CUSTOM_MODEL_TYPE_UNSPECIFIED ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType = 0
	// The model is a versioned foundation model.
	ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_VERSIONED_FOUNDATION ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType = 1
	// The model is a finetuned foundation model.
	ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_FINE_TUNED ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType = 2
)

// Enum value maps for ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType.
var (
	ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType_name = map[int32]string{
		0: "CUSTOM_MODEL_TYPE_UNSPECIFIED",
		1: "VERSIONED_FOUNDATION",
		2: "FINE_TUNED",
	}
	ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType_value = map[string]int32{
		"CUSTOM_MODEL_TYPE_UNSPECIFIED": 0,
		"VERSIONED_FOUNDATION":          1,
		"FINE_TUNED":                    2,
	}
)

func (x ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) Enum() *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType {
	p := new(ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType)
	*p = x
	return p
}

func (x ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_processor_proto_enumTypes[2].Descriptor()
}

func (ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_processor_proto_enumTypes[2]
}

func (x ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType.Descriptor instead.
func (ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 1, 1, 0}
}

// The possible states of the processor.
type Processor_State int32

const (
	// The processor is in an unspecified state.
	Processor_STATE_UNSPECIFIED Processor_State = 0
	// The processor is enabled, i.e., has an enabled version which can
	// currently serve processing requests and all the feature dependencies have
	// been successfully initialized.
	Processor_ENABLED Processor_State = 1
	// The processor is disabled.
	Processor_DISABLED Processor_State = 2
	// The processor is being enabled, will become `ENABLED` if successful.
	Processor_ENABLING Processor_State = 3
	// The processor is being disabled, will become `DISABLED` if successful.
	Processor_DISABLING Processor_State = 4
	// The processor is being created, will become either `ENABLED` (for
	// successful creation) or `FAILED` (for failed ones).
	// Once a processor is in this state, it can then be used for document
	// processing, but the feature dependencies of the processor might not be
	// fully created yet.
	Processor_CREATING Processor_State = 5
	// The processor failed during creation or initialization of feature
	// dependencies. The user should delete the processor and recreate one as
	// all the functionalities of the processor are disabled.
	Processor_FAILED Processor_State = 6
	// The processor is being deleted, will be removed if successful.
	Processor_DELETING Processor_State = 7
)

// Enum value maps for Processor_State.
var (
	Processor_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "ENABLING",
		4: "DISABLING",
		5: "CREATING",
		6: "FAILED",
		7: "DELETING",
	}
	Processor_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
		"ENABLING":          3,
		"DISABLING":         4,
		"CREATING":          5,
		"FAILED":            6,
		"DELETING":          7,
	}
)

func (x Processor_State) Enum() *Processor_State {
	p := new(Processor_State)
	*p = x
	return p
}

func (x Processor_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Processor_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_processor_proto_enumTypes[3].Descriptor()
}

func (Processor_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_processor_proto_enumTypes[3]
}

func (x Processor_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Processor_State.Descriptor instead.
func (Processor_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{2, 0}
}

// A processor version is an implementation of a processor. Each processor
// can have multiple versions, pretrained by Google internally or uptrained
// by the customer. A processor can only have one default version at a time.
// Its document-processing behavior is defined by that version.
type ProcessorVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the processor version.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the processor version.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The schema of the processor version. Describes the output.
	DocumentSchema *DocumentSchema `protobuf:"bytes,12,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
	// Output only. The state of the processor version.
	State ProcessorVersion_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.documentai.v1.ProcessorVersion_State" json:"state,omitempty"`
	// The time the processor version was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The most recently invoked evaluation for the processor version.
	LatestEvaluation *EvaluationReference `protobuf:"bytes,8,opt,name=latest_evaluation,json=latestEvaluation,proto3" json:"latest_evaluation,omitempty"`
	// The KMS key name used for encryption.
	KmsKeyName string `protobuf:"bytes,9,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// The KMS key version with which data is encrypted.
	KmsKeyVersionName string `protobuf:"bytes,10,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// Output only. Denotes that this `ProcessorVersion` is managed by Google.
	GoogleManaged bool `protobuf:"varint,11,opt,name=google_managed,json=googleManaged,proto3" json:"google_managed,omitempty"`
	// If set, information about the eventual deprecation of this version.
	DeprecationInfo *ProcessorVersion_DeprecationInfo `protobuf:"bytes,13,opt,name=deprecation_info,json=deprecationInfo,proto3" json:"deprecation_info,omitempty"`
	// Output only. The model type of this processor version.
	ModelType ProcessorVersion_ModelType `protobuf:"varint,15,opt,name=model_type,json=modelType,proto3,enum=google.cloud.documentai.v1.ProcessorVersion_ModelType" json:"model_type,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,16,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,17,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Output only. Information about Generative AI model-based processor
	// versions.
	GenAiModelInfo *ProcessorVersion_GenAiModelInfo `protobuf:"bytes,18,opt,name=gen_ai_model_info,json=genAiModelInfo,proto3" json:"gen_ai_model_info,omitempty"`
}

func (x *ProcessorVersion) Reset() {
	*x = ProcessorVersion{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersion) ProtoMessage() {}

func (x *ProcessorVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersion.ProtoReflect.Descriptor instead.
func (*ProcessorVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0}
}

func (x *ProcessorVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessorVersion) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ProcessorVersion) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

func (x *ProcessorVersion) GetState() ProcessorVersion_State {
	if x != nil {
		return x.State
	}
	return ProcessorVersion_STATE_UNSPECIFIED
}

func (x *ProcessorVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ProcessorVersion) GetLatestEvaluation() *EvaluationReference {
	if x != nil {
		return x.LatestEvaluation
	}
	return nil
}

func (x *ProcessorVersion) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *ProcessorVersion) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (x *ProcessorVersion) GetGoogleManaged() bool {
	if x != nil {
		return x.GoogleManaged
	}
	return false
}

func (x *ProcessorVersion) GetDeprecationInfo() *ProcessorVersion_DeprecationInfo {
	if x != nil {
		return x.DeprecationInfo
	}
	return nil
}

func (x *ProcessorVersion) GetModelType() ProcessorVersion_ModelType {
	if x != nil {
		return x.ModelType
	}
	return ProcessorVersion_MODEL_TYPE_UNSPECIFIED
}

func (x *ProcessorVersion) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *ProcessorVersion) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *ProcessorVersion) GetGenAiModelInfo() *ProcessorVersion_GenAiModelInfo {
	if x != nil {
		return x.GenAiModelInfo
	}
	return nil
}

// Contains the alias and the aliased resource name of processor version.
type ProcessorVersionAlias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The alias in the form of `processor_version` resource name.
	Alias string `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// The resource name of aliased processor version.
	ProcessorVersion string `protobuf:"bytes,2,opt,name=processor_version,json=processorVersion,proto3" json:"processor_version,omitempty"`
}

func (x *ProcessorVersionAlias) Reset() {
	*x = ProcessorVersionAlias{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersionAlias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersionAlias) ProtoMessage() {}

func (x *ProcessorVersionAlias) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersionAlias.ProtoReflect.Descriptor instead.
func (*ProcessorVersionAlias) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{1}
}

func (x *ProcessorVersionAlias) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *ProcessorVersionAlias) GetProcessorVersion() string {
	if x != nil {
		return x.ProcessorVersion
	}
	return ""
}

// The first-class citizen for Document AI. Each processor defines how to
// extract structural information from a document.
type Processor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The resource name of the processor.
	// Format: `projects/{project}/locations/{location}/processors/{processor}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
	// To get a list of processor types, see
	// [FetchProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.FetchProcessorTypes].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The display name of the processor.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The state of the processor.
	State Processor_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.documentai.v1.Processor_State" json:"state,omitempty"`
	// The default processor version.
	DefaultProcessorVersion string `protobuf:"bytes,9,opt,name=default_processor_version,json=defaultProcessorVersion,proto3" json:"default_processor_version,omitempty"`
	// Output only. The processor version aliases.
	ProcessorVersionAliases []*ProcessorVersionAlias `protobuf:"bytes,10,rep,name=processor_version_aliases,json=processorVersionAliases,proto3" json:"processor_version_aliases,omitempty"`
	// Output only. Immutable. The http endpoint that can be called to invoke
	// processing.
	ProcessEndpoint string `protobuf:"bytes,6,opt,name=process_endpoint,json=processEndpoint,proto3" json:"process_endpoint,omitempty"`
	// The time the processor was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The [KMS key](https://cloud.google.com/security-key-management) used for
	// encryption and decryption in CMEK scenarios.
	KmsKeyName string `protobuf:"bytes,8,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,12,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,13,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *Processor) Reset() {
	*x = Processor{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Processor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Processor) ProtoMessage() {}

func (x *Processor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Processor.ProtoReflect.Descriptor instead.
func (*Processor) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{2}
}

func (x *Processor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Processor) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Processor) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Processor) GetState() Processor_State {
	if x != nil {
		return x.State
	}
	return Processor_STATE_UNSPECIFIED
}

func (x *Processor) GetDefaultProcessorVersion() string {
	if x != nil {
		return x.DefaultProcessorVersion
	}
	return ""
}

func (x *Processor) GetProcessorVersionAliases() []*ProcessorVersionAlias {
	if x != nil {
		return x.ProcessorVersionAliases
	}
	return nil
}

func (x *Processor) GetProcessEndpoint() string {
	if x != nil {
		return x.ProcessEndpoint
	}
	return ""
}

func (x *Processor) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Processor) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Processor) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Processor) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

// Information about the upcoming deprecation of this processor version.
type ProcessorVersion_DeprecationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which this processor version will be deprecated.
	DeprecationTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=deprecation_time,json=deprecationTime,proto3" json:"deprecation_time,omitempty"`
	// If set, the processor version that will be used as a replacement.
	ReplacementProcessorVersion string `protobuf:"bytes,2,opt,name=replacement_processor_version,json=replacementProcessorVersion,proto3" json:"replacement_processor_version,omitempty"`
}

func (x *ProcessorVersion_DeprecationInfo) Reset() {
	*x = ProcessorVersion_DeprecationInfo{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersion_DeprecationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersion_DeprecationInfo) ProtoMessage() {}

func (x *ProcessorVersion_DeprecationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersion_DeprecationInfo.ProtoReflect.Descriptor instead.
func (*ProcessorVersion_DeprecationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ProcessorVersion_DeprecationInfo) GetDeprecationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeprecationTime
	}
	return nil
}

func (x *ProcessorVersion_DeprecationInfo) GetReplacementProcessorVersion() string {
	if x != nil {
		return x.ReplacementProcessorVersion
	}
	return ""
}

// Information about Generative AI model-based processor versions.
type ProcessorVersion_GenAiModelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processor version is either a pretrained Google-managed foundation
	// model or a custom Generative AI model created by the user.
	//
	// Types that are assignable to ModelInfo:
	//
	//	*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo_
	//	*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_
	ModelInfo isProcessorVersion_GenAiModelInfo_ModelInfo `protobuf_oneof:"model_info"`
}

func (x *ProcessorVersion_GenAiModelInfo) Reset() {
	*x = ProcessorVersion_GenAiModelInfo{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersion_GenAiModelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersion_GenAiModelInfo) ProtoMessage() {}

func (x *ProcessorVersion_GenAiModelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersion_GenAiModelInfo.ProtoReflect.Descriptor instead.
func (*ProcessorVersion_GenAiModelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 1}
}

func (m *ProcessorVersion_GenAiModelInfo) GetModelInfo() isProcessorVersion_GenAiModelInfo_ModelInfo {
	if m != nil {
		return m.ModelInfo
	}
	return nil
}

func (x *ProcessorVersion_GenAiModelInfo) GetFoundationGenAiModelInfo() *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo {
	if x, ok := x.GetModelInfo().(*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo_); ok {
		return x.FoundationGenAiModelInfo
	}
	return nil
}

func (x *ProcessorVersion_GenAiModelInfo) GetCustomGenAiModelInfo() *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo {
	if x, ok := x.GetModelInfo().(*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_); ok {
		return x.CustomGenAiModelInfo
	}
	return nil
}

type isProcessorVersion_GenAiModelInfo_ModelInfo interface {
	isProcessorVersion_GenAiModelInfo_ModelInfo()
}

type ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo_ struct {
	// Information for a pretrained Google-managed foundation model.
	FoundationGenAiModelInfo *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo `protobuf:"bytes,1,opt,name=foundation_gen_ai_model_info,json=foundationGenAiModelInfo,proto3,oneof"`
}

type ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_ struct {
	// Information for a custom Generative AI model created by the user.
	CustomGenAiModelInfo *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo `protobuf:"bytes,2,opt,name=custom_gen_ai_model_info,json=customGenAiModelInfo,proto3,oneof"`
}

func (*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo_) isProcessorVersion_GenAiModelInfo_ModelInfo() {
}

func (*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_) isProcessorVersion_GenAiModelInfo_ModelInfo() {
}

// Information for a pretrained Google-managed foundation model.
type ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether finetuning is allowed for this base processor version.
	FinetuningAllowed bool `protobuf:"varint,1,opt,name=finetuning_allowed,json=finetuningAllowed,proto3" json:"finetuning_allowed,omitempty"`
	// The minimum number of labeled documents in the training dataset
	// required for finetuning.
	MinTrainLabeledDocuments int32 `protobuf:"varint,2,opt,name=min_train_labeled_documents,json=minTrainLabeledDocuments,proto3" json:"min_train_labeled_documents,omitempty"`
}

func (x *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) Reset() {
	*x = ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) ProtoMessage() {}

func (x *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo.ProtoReflect.Descriptor instead.
func (*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) GetFinetuningAllowed() bool {
	if x != nil {
		return x.FinetuningAllowed
	}
	return false
}

func (x *ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo) GetMinTrainLabeledDocuments() int32 {
	if x != nil {
		return x.MinTrainLabeledDocuments
	}
	return 0
}

// Information for a custom Generative AI model created by the user. These
// are created with `Create New Version` in either the `Call foundation
// model` or `Fine tuning` tabs.
type ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of custom model created by the user.
	CustomModelType ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType `protobuf:"varint,1,opt,name=custom_model_type,json=customModelType,proto3,enum=google.cloud.documentai.v1.ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType" json:"custom_model_type,omitempty"`
	// The base processor version ID for the custom model.
	BaseProcessorVersionId string `protobuf:"bytes,2,opt,name=base_processor_version_id,json=baseProcessorVersionId,proto3" json:"base_processor_version_id,omitempty"`
}

func (x *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) Reset() {
	*x = ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo{}
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) ProtoMessage() {}

func (x *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_processor_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo.ProtoReflect.Descriptor instead.
func (*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_processor_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) GetCustomModelType() ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType {
	if x != nil {
		return x.CustomModelType
	}
	return ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CUSTOM_MODEL_TYPE_UNSPECIFIED
}

func (x *ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo) GetBaseProcessorVersionId() string {
	if x != nil {
		return x.BaseProcessorVersionId
	}
	return ""
}

var File_google_cloud_documentai_v1_processor_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1_processor_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f,
	0x76, 0x31, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x12, 0x0a, 0x10, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x12, 0x67, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5a, 0x0a, 0x0a,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50,
	0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x69, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12, 0x6b, 0x0a, 0x11,
	0x67, 0x65, 0x6e, 0x5f, 0x61, 0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x67, 0x65, 0x6e, 0x41, 0x69,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xcd, 0x01, 0x0a, 0x0f, 0x44, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a,
	0x10, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x73, 0x0a, 0x1d, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x92, 0x06, 0x0a, 0x0e, 0x47, 0x65,
	0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x96, 0x01, 0x0a,
	0x1c, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x65, 0x6e, 0x5f,
	0x61, 0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x6e, 0x41, 0x69,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x18, 0x66, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x8a, 0x01, 0x0a, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x67, 0x65, 0x6e, 0x5f, 0x61, 0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x47, 0x65, 0x6e, 0x41,
	0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x14, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x1a, 0x88, 0x01, 0x0a, 0x18, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x2d, 0x0a, 0x12, 0x66, 0x69, 0x6e, 0x65, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x66, 0x69, 0x6e,
	0x65, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x3d,
	0x0a, 0x1b, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x18, 0x6d, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xc0, 0x02,
	0x0a, 0x14, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x8c, 0x01, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x5e, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x45, 0x44, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x4e, 0x45, 0x5f, 0x54, 0x55, 0x4e, 0x45, 0x44, 0x10, 0x02,
	0x42, 0x0c, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x93,
	0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a,
	0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x08, 0x22, 0x59, 0x0a, 0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a,
	0x15, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45,
	0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x4f, 0x44, 0x45,
	0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x3a,
	0x96, 0x01, 0xea, 0x41, 0x92, 0x01, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x8b, 0x01, 0x0a, 0x15, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x5c, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd7, 0x06, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x6b, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x19,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x31, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x22, 0x7e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x23, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d,
	0x42, 0xd1, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x42, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x49, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1_processor_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1_processor_proto_rawDescData = file_google_cloud_documentai_v1_processor_proto_rawDesc
)

func file_google_cloud_documentai_v1_processor_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1_processor_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1_processor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1_processor_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1_processor_proto_rawDescData
}

var file_google_cloud_documentai_v1_processor_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_documentai_v1_processor_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_documentai_v1_processor_proto_goTypes = []any{
	(ProcessorVersion_State)(0),     // 0: google.cloud.documentai.v1.ProcessorVersion.State
	(ProcessorVersion_ModelType)(0), // 1: google.cloud.documentai.v1.ProcessorVersion.ModelType
	(ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_CustomModelType)(0), // 2: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.CustomGenAiModelInfo.CustomModelType
	(Processor_State)(0),                                             // 3: google.cloud.documentai.v1.Processor.State
	(*ProcessorVersion)(nil),                                         // 4: google.cloud.documentai.v1.ProcessorVersion
	(*ProcessorVersionAlias)(nil),                                    // 5: google.cloud.documentai.v1.ProcessorVersionAlias
	(*Processor)(nil),                                                // 6: google.cloud.documentai.v1.Processor
	(*ProcessorVersion_DeprecationInfo)(nil),                         // 7: google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
	(*ProcessorVersion_GenAiModelInfo)(nil),                          // 8: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo
	(*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo)(nil), // 9: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.FoundationGenAiModelInfo
	(*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo)(nil),     // 10: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.CustomGenAiModelInfo
	(*DocumentSchema)(nil),                                           // 11: google.cloud.documentai.v1.DocumentSchema
	(*timestamppb.Timestamp)(nil),                                    // 12: google.protobuf.Timestamp
	(*EvaluationReference)(nil),                                      // 13: google.cloud.documentai.v1.EvaluationReference
}
var file_google_cloud_documentai_v1_processor_proto_depIdxs = []int32{
	11, // 0: google.cloud.documentai.v1.ProcessorVersion.document_schema:type_name -> google.cloud.documentai.v1.DocumentSchema
	0,  // 1: google.cloud.documentai.v1.ProcessorVersion.state:type_name -> google.cloud.documentai.v1.ProcessorVersion.State
	12, // 2: google.cloud.documentai.v1.ProcessorVersion.create_time:type_name -> google.protobuf.Timestamp
	13, // 3: google.cloud.documentai.v1.ProcessorVersion.latest_evaluation:type_name -> google.cloud.documentai.v1.EvaluationReference
	7,  // 4: google.cloud.documentai.v1.ProcessorVersion.deprecation_info:type_name -> google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
	1,  // 5: google.cloud.documentai.v1.ProcessorVersion.model_type:type_name -> google.cloud.documentai.v1.ProcessorVersion.ModelType
	8,  // 6: google.cloud.documentai.v1.ProcessorVersion.gen_ai_model_info:type_name -> google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo
	3,  // 7: google.cloud.documentai.v1.Processor.state:type_name -> google.cloud.documentai.v1.Processor.State
	5,  // 8: google.cloud.documentai.v1.Processor.processor_version_aliases:type_name -> google.cloud.documentai.v1.ProcessorVersionAlias
	12, // 9: google.cloud.documentai.v1.Processor.create_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.deprecation_time:type_name -> google.protobuf.Timestamp
	9,  // 11: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.foundation_gen_ai_model_info:type_name -> google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.FoundationGenAiModelInfo
	10, // 12: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.custom_gen_ai_model_info:type_name -> google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.CustomGenAiModelInfo
	2,  // 13: google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.CustomGenAiModelInfo.custom_model_type:type_name -> google.cloud.documentai.v1.ProcessorVersion.GenAiModelInfo.CustomGenAiModelInfo.CustomModelType
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1_processor_proto_init() }
func file_google_cloud_documentai_v1_processor_proto_init() {
	if File_google_cloud_documentai_v1_processor_proto != nil {
		return
	}
	file_google_cloud_documentai_v1_document_schema_proto_init()
	file_google_cloud_documentai_v1_evaluation_proto_init()
	file_google_cloud_documentai_v1_processor_proto_msgTypes[4].OneofWrappers = []any{
		(*ProcessorVersion_GenAiModelInfo_FoundationGenAiModelInfo_)(nil),
		(*ProcessorVersion_GenAiModelInfo_CustomGenAiModelInfo_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1_processor_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_documentai_v1_processor_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1_processor_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1_processor_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1_processor_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1_processor_proto = out.File
	file_google_cloud_documentai_v1_processor_proto_rawDesc = nil
	file_google_cloud_documentai_v1_processor_proto_goTypes = nil
	file_google_cloud_documentai_v1_processor_proto_depIdxs = nil
}
