// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/metadata.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Identifies the cloud system that manages the data storage.
type StorageSystem int32

const (
	// Storage system unspecified.
	StorageSystem_STORAGE_SYSTEM_UNSPECIFIED StorageSystem = 0
	// The entity data is contained within a Cloud Storage bucket.
	StorageSystem_CLOUD_STORAGE StorageSystem = 1
	// The entity data is contained within a BigQuery dataset.
	StorageSystem_BIGQUERY StorageSystem = 2
)

// Enum value maps for StorageSystem.
var (
	StorageSystem_name = map[int32]string{
		0: "STORAGE_SYSTEM_UNSPECIFIED",
		1: "CLOUD_STORAGE",
		2: "BIGQUERY",
	}
	StorageSystem_value = map[string]int32{
		"STORAGE_SYSTEM_UNSPECIFIED": 0,
		"CLOUD_STORAGE":              1,
		"BIGQUERY":                   2,
	}
)

func (x StorageSystem) Enum() *StorageSystem {
	p := new(StorageSystem)
	*p = x
	return p
}

func (x StorageSystem) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageSystem) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[0].Descriptor()
}

func (StorageSystem) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[0]
}

func (x StorageSystem) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StorageSystem.Descriptor instead.
func (StorageSystem) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{0}
}

// Entity views.
type ListEntitiesRequest_EntityView int32

const (
	// The default unset value. Return both table and fileset entities
	// if unspecified.
	ListEntitiesRequest_ENTITY_VIEW_UNSPECIFIED ListEntitiesRequest_EntityView = 0
	// Only list table entities.
	ListEntitiesRequest_TABLES ListEntitiesRequest_EntityView = 1
	// Only list fileset entities.
	ListEntitiesRequest_FILESETS ListEntitiesRequest_EntityView = 2
)

// Enum value maps for ListEntitiesRequest_EntityView.
var (
	ListEntitiesRequest_EntityView_name = map[int32]string{
		0: "ENTITY_VIEW_UNSPECIFIED",
		1: "TABLES",
		2: "FILESETS",
	}
	ListEntitiesRequest_EntityView_value = map[string]int32{
		"ENTITY_VIEW_UNSPECIFIED": 0,
		"TABLES":                  1,
		"FILESETS":                2,
	}
)

func (x ListEntitiesRequest_EntityView) Enum() *ListEntitiesRequest_EntityView {
	p := new(ListEntitiesRequest_EntityView)
	*p = x
	return p
}

func (x ListEntitiesRequest_EntityView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListEntitiesRequest_EntityView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[1].Descriptor()
}

func (ListEntitiesRequest_EntityView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[1]
}

func (x ListEntitiesRequest_EntityView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListEntitiesRequest_EntityView.Descriptor instead.
func (ListEntitiesRequest_EntityView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{3, 0}
}

// Entity views for get entity partial result.
type GetEntityRequest_EntityView int32

const (
	// The API will default to the `BASIC` view.
	GetEntityRequest_ENTITY_VIEW_UNSPECIFIED GetEntityRequest_EntityView = 0
	// Minimal view that does not include the schema.
	GetEntityRequest_BASIC GetEntityRequest_EntityView = 1
	// Include basic information and schema.
	GetEntityRequest_SCHEMA GetEntityRequest_EntityView = 2
	// Include everything. Currently, this is the same as the SCHEMA view.
	GetEntityRequest_FULL GetEntityRequest_EntityView = 4
)

// Enum value maps for GetEntityRequest_EntityView.
var (
	GetEntityRequest_EntityView_name = map[int32]string{
		0: "ENTITY_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "SCHEMA",
		4: "FULL",
	}
	GetEntityRequest_EntityView_value = map[string]int32{
		"ENTITY_VIEW_UNSPECIFIED": 0,
		"BASIC":                   1,
		"SCHEMA":                  2,
		"FULL":                    4,
	}
)

func (x GetEntityRequest_EntityView) Enum() *GetEntityRequest_EntityView {
	p := new(GetEntityRequest_EntityView)
	*p = x
	return p
}

func (x GetEntityRequest_EntityView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetEntityRequest_EntityView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[2].Descriptor()
}

func (GetEntityRequest_EntityView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[2]
}

func (x GetEntityRequest_EntityView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetEntityRequest_EntityView.Descriptor instead.
func (GetEntityRequest_EntityView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{5, 0}
}

// The type of entity.
type Entity_Type int32

const (
	// Type unspecified.
	Entity_TYPE_UNSPECIFIED Entity_Type = 0
	// Structured and semi-structured data.
	Entity_TABLE Entity_Type = 1
	// Unstructured data.
	Entity_FILESET Entity_Type = 2
)

// Enum value maps for Entity_Type.
var (
	Entity_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TABLE",
		2: "FILESET",
	}
	Entity_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TABLE":            1,
		"FILESET":          2,
	}
)

func (x Entity_Type) Enum() *Entity_Type {
	p := new(Entity_Type)
	*p = x
	return p
}

func (x Entity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[3].Descriptor()
}

func (Entity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[3]
}

func (x Entity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entity_Type.Descriptor instead.
func (Entity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{11, 0}
}

// Type information for fields in schemas and partition schemas.
type Schema_Type int32

const (
	// SchemaType unspecified.
	Schema_TYPE_UNSPECIFIED Schema_Type = 0
	// Boolean field.
	Schema_BOOLEAN Schema_Type = 1
	// Single byte numeric field.
	Schema_BYTE Schema_Type = 2
	// 16-bit numeric field.
	Schema_INT16 Schema_Type = 3
	// 32-bit numeric field.
	Schema_INT32 Schema_Type = 4
	// 64-bit numeric field.
	Schema_INT64 Schema_Type = 5
	// Floating point numeric field.
	Schema_FLOAT Schema_Type = 6
	// Double precision numeric field.
	Schema_DOUBLE Schema_Type = 7
	// Real value numeric field.
	Schema_DECIMAL Schema_Type = 8
	// Sequence of characters field.
	Schema_STRING Schema_Type = 9
	// Sequence of bytes field.
	Schema_BINARY Schema_Type = 10
	// Date and time field.
	Schema_TIMESTAMP Schema_Type = 11
	// Date field.
	Schema_DATE Schema_Type = 12
	// Time field.
	Schema_TIME Schema_Type = 13
	// Structured field. Nested fields that define the structure of the map.
	// If all nested fields are nullable, this field represents a union.
	Schema_RECORD Schema_Type = 14
	// Null field that does not have values.
	Schema_NULL Schema_Type = 100
)

// Enum value maps for Schema_Type.
var (
	Schema_Type_name = map[int32]string{
		0:   "TYPE_UNSPECIFIED",
		1:   "BOOLEAN",
		2:   "BYTE",
		3:   "INT16",
		4:   "INT32",
		5:   "INT64",
		6:   "FLOAT",
		7:   "DOUBLE",
		8:   "DECIMAL",
		9:   "STRING",
		10:  "BINARY",
		11:  "TIMESTAMP",
		12:  "DATE",
		13:  "TIME",
		14:  "RECORD",
		100: "NULL",
	}
	Schema_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"BOOLEAN":          1,
		"BYTE":             2,
		"INT16":            3,
		"INT32":            4,
		"INT64":            5,
		"FLOAT":            6,
		"DOUBLE":           7,
		"DECIMAL":          8,
		"STRING":           9,
		"BINARY":           10,
		"TIMESTAMP":        11,
		"DATE":             12,
		"TIME":             13,
		"RECORD":           14,
		"NULL":             100,
	}
)

func (x Schema_Type) Enum() *Schema_Type {
	p := new(Schema_Type)
	*p = x
	return p
}

func (x Schema_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[4].Descriptor()
}

func (Schema_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[4]
}

func (x Schema_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_Type.Descriptor instead.
func (Schema_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13, 0}
}

// Additional qualifiers to define field semantics.
type Schema_Mode int32

const (
	// Mode unspecified.
	Schema_MODE_UNSPECIFIED Schema_Mode = 0
	// The field has required semantics.
	Schema_REQUIRED Schema_Mode = 1
	// The field has optional semantics, and may be null.
	Schema_NULLABLE Schema_Mode = 2
	// The field has repeated (0 or more) semantics, and is a list of values.
	Schema_REPEATED Schema_Mode = 3
)

// Enum value maps for Schema_Mode.
var (
	Schema_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "REQUIRED",
		2: "NULLABLE",
		3: "REPEATED",
	}
	Schema_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"REQUIRED":         1,
		"NULLABLE":         2,
		"REPEATED":         3,
	}
)

func (x Schema_Mode) Enum() *Schema_Mode {
	p := new(Schema_Mode)
	*p = x
	return p
}

func (x Schema_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[5].Descriptor()
}

func (Schema_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[5]
}

func (x Schema_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_Mode.Descriptor instead.
func (Schema_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13, 1}
}

// The structure of paths within the entity, which represent partitions.
type Schema_PartitionStyle int32

const (
	// PartitionStyle unspecified
	Schema_PARTITION_STYLE_UNSPECIFIED Schema_PartitionStyle = 0
	// Partitions are hive-compatible.
	// Examples: `gs://bucket/path/to/table/dt=2019-10-31/lang=en`,
	// `gs://bucket/path/to/table/dt=2019-10-31/lang=en/late`.
	Schema_HIVE_COMPATIBLE Schema_PartitionStyle = 1
)

// Enum value maps for Schema_PartitionStyle.
var (
	Schema_PartitionStyle_name = map[int32]string{
		0: "PARTITION_STYLE_UNSPECIFIED",
		1: "HIVE_COMPATIBLE",
	}
	Schema_PartitionStyle_value = map[string]int32{
		"PARTITION_STYLE_UNSPECIFIED": 0,
		"HIVE_COMPATIBLE":             1,
	}
)

func (x Schema_PartitionStyle) Enum() *Schema_PartitionStyle {
	p := new(Schema_PartitionStyle)
	*p = x
	return p
}

func (x Schema_PartitionStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_PartitionStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[6].Descriptor()
}

func (Schema_PartitionStyle) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[6]
}

func (x Schema_PartitionStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_PartitionStyle.Descriptor instead.
func (Schema_PartitionStyle) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13, 2}
}

// The specific file format of the data.
type StorageFormat_Format int32

const (
	// Format unspecified.
	StorageFormat_FORMAT_UNSPECIFIED StorageFormat_Format = 0
	// Parquet-formatted structured data.
	StorageFormat_PARQUET StorageFormat_Format = 1
	// Avro-formatted structured data.
	StorageFormat_AVRO StorageFormat_Format = 2
	// Orc-formatted structured data.
	StorageFormat_ORC StorageFormat_Format = 3
	// Csv-formatted semi-structured data.
	StorageFormat_CSV StorageFormat_Format = 100
	// Json-formatted semi-structured data.
	StorageFormat_JSON StorageFormat_Format = 101
	// Image data formats (such as jpg and png).
	StorageFormat_IMAGE StorageFormat_Format = 200
	// Audio data formats (such as mp3, and wav).
	StorageFormat_AUDIO StorageFormat_Format = 201
	// Video data formats (such as mp4 and mpg).
	StorageFormat_VIDEO StorageFormat_Format = 202
	// Textual data formats (such as txt and xml).
	StorageFormat_TEXT StorageFormat_Format = 203
	// TensorFlow record format.
	StorageFormat_TFRECORD StorageFormat_Format = 204
	// Data that doesn't match a specific format.
	StorageFormat_OTHER StorageFormat_Format = 1000
	// Data of an unknown format.
	StorageFormat_UNKNOWN StorageFormat_Format = 1001
)

// Enum value maps for StorageFormat_Format.
var (
	StorageFormat_Format_name = map[int32]string{
		0:    "FORMAT_UNSPECIFIED",
		1:    "PARQUET",
		2:    "AVRO",
		3:    "ORC",
		100:  "CSV",
		101:  "JSON",
		200:  "IMAGE",
		201:  "AUDIO",
		202:  "VIDEO",
		203:  "TEXT",
		204:  "TFRECORD",
		1000: "OTHER",
		1001: "UNKNOWN",
	}
	StorageFormat_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"PARQUET":            1,
		"AVRO":               2,
		"ORC":                3,
		"CSV":                100,
		"JSON":               101,
		"IMAGE":              200,
		"AUDIO":              201,
		"VIDEO":              202,
		"TEXT":               203,
		"TFRECORD":           204,
		"OTHER":              1000,
		"UNKNOWN":            1001,
	}
)

func (x StorageFormat_Format) Enum() *StorageFormat_Format {
	p := new(StorageFormat_Format)
	*p = x
	return p
}

func (x StorageFormat_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageFormat_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[7].Descriptor()
}

func (StorageFormat_Format) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[7]
}

func (x StorageFormat_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StorageFormat_Format.Descriptor instead.
func (StorageFormat_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14, 0}
}

// The specific compressed file format of the data.
type StorageFormat_CompressionFormat int32

const (
	// CompressionFormat unspecified. Implies uncompressed data.
	StorageFormat_COMPRESSION_FORMAT_UNSPECIFIED StorageFormat_CompressionFormat = 0
	// GZip compressed set of files.
	StorageFormat_GZIP StorageFormat_CompressionFormat = 2
	// BZip2 compressed set of files.
	StorageFormat_BZIP2 StorageFormat_CompressionFormat = 3
)

// Enum value maps for StorageFormat_CompressionFormat.
var (
	StorageFormat_CompressionFormat_name = map[int32]string{
		0: "COMPRESSION_FORMAT_UNSPECIFIED",
		2: "GZIP",
		3: "BZIP2",
	}
	StorageFormat_CompressionFormat_value = map[string]int32{
		"COMPRESSION_FORMAT_UNSPECIFIED": 0,
		"GZIP":                           2,
		"BZIP2":                          3,
	}
)

func (x StorageFormat_CompressionFormat) Enum() *StorageFormat_CompressionFormat {
	p := new(StorageFormat_CompressionFormat)
	*p = x
	return p
}

func (x StorageFormat_CompressionFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageFormat_CompressionFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[8].Descriptor()
}

func (StorageFormat_CompressionFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[8]
}

func (x StorageFormat_CompressionFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StorageFormat_CompressionFormat.Descriptor instead.
func (StorageFormat_CompressionFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14, 1}
}

// Access Mode determines how data stored within the Entity is read.
type StorageAccess_AccessMode int32

const (
	// Access mode unspecified.
	StorageAccess_ACCESS_MODE_UNSPECIFIED StorageAccess_AccessMode = 0
	// Default. Data is accessed directly using storage APIs.
	StorageAccess_DIRECT StorageAccess_AccessMode = 1
	// Data is accessed through a managed interface using BigQuery APIs.
	StorageAccess_MANAGED StorageAccess_AccessMode = 2
)

// Enum value maps for StorageAccess_AccessMode.
var (
	StorageAccess_AccessMode_name = map[int32]string{
		0: "ACCESS_MODE_UNSPECIFIED",
		1: "DIRECT",
		2: "MANAGED",
	}
	StorageAccess_AccessMode_value = map[string]int32{
		"ACCESS_MODE_UNSPECIFIED": 0,
		"DIRECT":                  1,
		"MANAGED":                 2,
	}
)

func (x StorageAccess_AccessMode) Enum() *StorageAccess_AccessMode {
	p := new(StorageAccess_AccessMode)
	*p = x
	return p
}

func (x StorageAccess_AccessMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageAccess_AccessMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_metadata_proto_enumTypes[9].Descriptor()
}

func (StorageAccess_AccessMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_metadata_proto_enumTypes[9]
}

func (x StorageAccess_AccessMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StorageAccess_AccessMode.Descriptor instead.
func (StorageAccess_AccessMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{15, 0}
}

// Create a metadata entity request.
type CreateEntityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent zone:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Entity resource.
	Entity *Entity `protobuf:"bytes,3,opt,name=entity,proto3" json:"entity,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEntityRequest) Reset() {
	*x = CreateEntityRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntityRequest) ProtoMessage() {}

func (x *CreateEntityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntityRequest.ProtoReflect.Descriptor instead.
func (*CreateEntityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *CreateEntityRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntityRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *CreateEntityRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update a metadata entity request.
// The exiting entity will be fully replaced by the entity in the request.
// The entity ID is mutable. To modify the ID, use the current entity ID in the
// request URL and specify the new ID in the request body.
type UpdateEntityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Update description.
	Entity *Entity `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEntityRequest) Reset() {
	*x = UpdateEntityRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntityRequest) ProtoMessage() {}

func (x *UpdateEntityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntityRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateEntityRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *UpdateEntityRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete a metadata entity request.
type DeleteEntityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entity:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The etag associated with the entity, which can be retrieved with
	// a [GetEntity][] request.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteEntityRequest) Reset() {
	*x = DeleteEntityRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntityRequest) ProtoMessage() {}

func (x *DeleteEntityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntityRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteEntityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntityRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List metadata entities request.
type ListEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent zone:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Specify the entity view to make a partial list request.
	View ListEntitiesRequest_EntityView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.ListEntitiesRequest_EntityView" json:"view,omitempty"`
	// Optional. Maximum number of entities to return. The service may return
	// fewer than this value. If unspecified, 100 entities will be returned by
	// default. The maximum value is 500; larger values will will be truncated to
	// 500.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntities` call. Provide
	// this to retrieve the subsequent page. When paginating, all other parameters
	// provided to `ListEntities` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The following filter parameters can be added to the URL to limit
	// the entities returned by the API:
	//
	// - Entity ID: ?filter="id=entityID"
	// - Asset ID: ?filter="asset=assetID"
	// - Data path ?filter="data_path=gs://my-bucket"
	// - Is HIVE compatible: ?filter="hive_compatible=true"
	// - Is BigQuery compatible: ?filter="bigquery_compatible=true"
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListEntitiesRequest) Reset() {
	*x = ListEntitiesRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitiesRequest) ProtoMessage() {}

func (x *ListEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitiesRequest.ProtoReflect.Descriptor instead.
func (*ListEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *ListEntitiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitiesRequest) GetView() ListEntitiesRequest_EntityView {
	if x != nil {
		return x.View
	}
	return ListEntitiesRequest_ENTITY_VIEW_UNSPECIFIED
}

func (x *ListEntitiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntitiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List metadata entities response.
type ListEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entities in the specified parent zone.
	Entities []*Entity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// remaining results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntitiesResponse) Reset() {
	*x = ListEntitiesResponse{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitiesResponse) ProtoMessage() {}

func (x *ListEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitiesResponse.ProtoReflect.Descriptor instead.
func (*ListEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *ListEntitiesResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *ListEntitiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Get metadata entity request.
type GetEntityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entity:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Used to select the subset of entity information to return.
	// Defaults to `BASIC`.
	View GetEntityRequest_EntityView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.GetEntityRequest_EntityView" json:"view,omitempty"`
}

func (x *GetEntityRequest) Reset() {
	*x = GetEntityRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntityRequest) ProtoMessage() {}

func (x *GetEntityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntityRequest.ProtoReflect.Descriptor instead.
func (*GetEntityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *GetEntityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntityRequest) GetView() GetEntityRequest_EntityView {
	if x != nil {
		return x.View
	}
	return GetEntityRequest_ENTITY_VIEW_UNSPECIFIED
}

// List metadata partitions request.
type ListPartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent entity:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of partitions to return. The service may return
	// fewer than this value. If unspecified, 100 partitions will be returned by
	// default. The maximum page size is 500; larger values will will be truncated
	// to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListPartitions` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListPartitions` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter the partitions returned to the caller using a key value
	// pair expression. Supported operators and syntax:
	//
	// - logic operators: AND, OR
	// - comparison operators: <, >, >=, <= ,=, !=
	// - LIKE operators:
	//   - The right hand of a LIKE operator supports "." and
	//     "*" for wildcard searches, for example "value1 LIKE ".*oo.*"
	//
	// - parenthetical grouping: ( )
	//
	// Sample filter expression: `?filter="key1 < value1 OR key2 > value2"
	//
	// **Notes:**
	//
	//   - Keys to the left of operators are case insensitive.
	//   - Partition results are sorted first by creation time, then by
	//     lexicographic order.
	//   - Up to 20 key value filter pairs are allowed, but due to performance
	//     considerations, only the first 10 will be used as a filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPartitionsRequest) Reset() {
	*x = ListPartitionsRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPartitionsRequest) ProtoMessage() {}

func (x *ListPartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPartitionsRequest.ProtoReflect.Descriptor instead.
func (*ListPartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{6}
}

func (x *ListPartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPartitionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPartitionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPartitionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Create metadata partition request.
type CreatePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent zone:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Partition resource.
	Partition *Partition `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreatePartitionRequest) Reset() {
	*x = CreatePartitionRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePartitionRequest) ProtoMessage() {}

func (x *CreatePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePartitionRequest.ProtoReflect.Descriptor instead.
func (*CreatePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{7}
}

func (x *CreatePartitionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePartitionRequest) GetPartition() *Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *CreatePartitionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete metadata partition request.
type DeletePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the partition.
	// format:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
	// The {partition_value_path} segment consists of an ordered sequence of
	// partition values separated by "/". All values must be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag associated with the partition.
	//
	// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/metadata.proto.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeletePartitionRequest) Reset() {
	*x = DeletePartitionRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePartitionRequest) ProtoMessage() {}

func (x *DeletePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePartitionRequest.ProtoReflect.Descriptor instead.
func (*DeletePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{8}
}

func (x *DeletePartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/metadata.proto.
func (x *DeletePartitionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List metadata partitions response.
type ListPartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partitions under the specified parent entity.
	Partitions []*Partition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// remaining results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPartitionsResponse) Reset() {
	*x = ListPartitionsResponse{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPartitionsResponse) ProtoMessage() {}

func (x *ListPartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPartitionsResponse.ProtoReflect.Descriptor instead.
func (*ListPartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{9}
}

func (x *ListPartitionsResponse) GetPartitions() []*Partition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *ListPartitionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Get metadata partition request.
type GetPartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the partition:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
	// The {partition_value_path} segment consists of an ordered sequence of
	// partition values separated by "/". All values must be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPartitionRequest) Reset() {
	*x = GetPartitionRequest{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionRequest) ProtoMessage() {}

func (x *GetPartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{10}
}

func (x *GetPartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents tables and fileset metadata contained within a zone.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the entity, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Display name must be shorter than or equal to 256 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User friendly longer description text. Must be shorter than or
	// equal to 1024 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time when the entity was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the entity was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. A user-provided entity ID. It is mutable, and will be used as the
	// published table name. Specifying a new ID in an update entity
	// request will override the existing value.
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), and
	// underscores, and consist of 256 or fewer characters.
	Id string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. The etag associated with the entity, which can be retrieved with
	// a [GetEntity][] request. Required for update and delete requests.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Immutable. The type of entity.
	Type Entity_Type `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Entity_Type" json:"type,omitempty"`
	// Required. Immutable. The ID of the asset associated with the storage
	// location containing the entity data. The entity must be with in the same
	// zone with the asset.
	Asset string `protobuf:"bytes,11,opt,name=asset,proto3" json:"asset,omitempty"`
	// Required. Immutable. The storage path of the entity data.
	// For Cloud Storage data, this is the fully-qualified path to the entity,
	// such as `gs://bucket/path/to/data`. For BigQuery data, this is the name of
	// the table resource, such as
	// `projects/project_id/datasets/dataset_id/tables/table_id`.
	DataPath string `protobuf:"bytes,12,opt,name=data_path,json=dataPath,proto3" json:"data_path,omitempty"`
	// Optional. The set of items within the data path constituting the data in
	// the entity, represented as a glob path. Example:
	// `gs://bucket/path/to/data/**/*.csv`.
	DataPathPattern string `protobuf:"bytes,13,opt,name=data_path_pattern,json=dataPathPattern,proto3" json:"data_path_pattern,omitempty"`
	// Output only. The name of the associated Data Catalog entry.
	CatalogEntry string `protobuf:"bytes,14,opt,name=catalog_entry,json=catalogEntry,proto3" json:"catalog_entry,omitempty"`
	// Required. Immutable. Identifies the storage system of the entity data.
	System StorageSystem `protobuf:"varint,15,opt,name=system,proto3,enum=google.cloud.dataplex.v1.StorageSystem" json:"system,omitempty"`
	// Required. Identifies the storage format of the entity data.
	// It does not apply to entities with data stored in BigQuery.
	Format *StorageFormat `protobuf:"bytes,16,opt,name=format,proto3" json:"format,omitempty"`
	// Output only. Metadata stores that the entity is compatible with.
	Compatibility *Entity_CompatibilityStatus `protobuf:"bytes,19,opt,name=compatibility,proto3" json:"compatibility,omitempty"`
	// Output only. Identifies the access mechanism to the entity. Not user
	// settable.
	Access *StorageAccess `protobuf:"bytes,21,opt,name=access,proto3" json:"access,omitempty"`
	// Output only. System generated unique ID for the Entity. This ID will be
	// different if the Entity is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,22,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The description of the data structure and layout.
	// The schema is not included in list responses. It is only included in
	// `SCHEMA` and `FULL` entity views of a `GetEntity` response.
	Schema *Schema `protobuf:"bytes,50,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{11}
}

func (x *Entity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entity) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Entity) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Entity) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Entity) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Entity) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Entity) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Entity) GetType() Entity_Type {
	if x != nil {
		return x.Type
	}
	return Entity_TYPE_UNSPECIFIED
}

func (x *Entity) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *Entity) GetDataPath() string {
	if x != nil {
		return x.DataPath
	}
	return ""
}

func (x *Entity) GetDataPathPattern() string {
	if x != nil {
		return x.DataPathPattern
	}
	return ""
}

func (x *Entity) GetCatalogEntry() string {
	if x != nil {
		return x.CatalogEntry
	}
	return ""
}

func (x *Entity) GetSystem() StorageSystem {
	if x != nil {
		return x.System
	}
	return StorageSystem_STORAGE_SYSTEM_UNSPECIFIED
}

func (x *Entity) GetFormat() *StorageFormat {
	if x != nil {
		return x.Format
	}
	return nil
}

func (x *Entity) GetCompatibility() *Entity_CompatibilityStatus {
	if x != nil {
		return x.Compatibility
	}
	return nil
}

func (x *Entity) GetAccess() *StorageAccess {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *Entity) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Entity) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

// Represents partition metadata contained within entity instances.
type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Partition values used in the HTTP URL must be
	// double encoded. For example, `url_encode(url_encode(value))` can be used
	// to encode "US:CA/CA#Sunnyvale so that the request URL ends
	// with "/partitions/US%253ACA/CA%2523Sunnyvale".
	// The name field in the response retains the encoded format.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The set of values representing the partition, which
	// correspond to the partition schema defined in the parent entity.
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Required. Immutable. The location of the entity data within the partition,
	// for example, `gs://bucket/path/to/entity/key1=value1/key2=value2`. Or
	// `projects/<project_id>/datasets/<dataset_id>/tables/<table_id>`
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Optional. The etag for this partition.
	//
	// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/metadata.proto.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{12}
}

func (x *Partition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Partition) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Partition) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/metadata.proto.
func (x *Partition) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Schema information describing the structure and layout of the data.
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Set to `true` if user-managed or `false` if managed by Dataplex
	// Universal Catalog. The default is `false` (managed by Dataplex Universal
	// Catalog).
	//
	// - Set to `false`to enable Dataplex Universal Catalog discovery to update
	// the schema.
	//
	//	including new data discovery, schema inference, and schema evolution.
	//	Users retain the ability to input and edit the schema. Dataplex Universal
	//	Catalog treats schema input by the user as though produced by a previous
	//	Dataplex Universal Catalog discovery operation, and it will evolve the
	//	schema and take action based on that treatment.
	//
	//   - Set to `true` to fully manage the entity
	//     schema. This setting guarantees that Dataplex Universal Catalog will not
	//     change schema fields.
	UserManaged bool `protobuf:"varint,1,opt,name=user_managed,json=userManaged,proto3" json:"user_managed,omitempty"`
	// Optional. The sequence of fields describing data in table entities.
	// **Note:** BigQuery SchemaFields are immutable.
	Fields []*Schema_SchemaField `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	// Optional. The sequence of fields describing the partition structure in
	// entities. If this field is empty, there are no partitions within the data.
	PartitionFields []*Schema_PartitionField `protobuf:"bytes,3,rep,name=partition_fields,json=partitionFields,proto3" json:"partition_fields,omitempty"`
	// Optional. The structure of paths containing partition data within the
	// entity.
	PartitionStyle Schema_PartitionStyle `protobuf:"varint,4,opt,name=partition_style,json=partitionStyle,proto3,enum=google.cloud.dataplex.v1.Schema_PartitionStyle" json:"partition_style,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13}
}

func (x *Schema) GetUserManaged() bool {
	if x != nil {
		return x.UserManaged
	}
	return false
}

func (x *Schema) GetFields() []*Schema_SchemaField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Schema) GetPartitionFields() []*Schema_PartitionField {
	if x != nil {
		return x.PartitionFields
	}
	return nil
}

func (x *Schema) GetPartitionStyle() Schema_PartitionStyle {
	if x != nil {
		return x.PartitionStyle
	}
	return Schema_PARTITION_STYLE_UNSPECIFIED
}

// Describes the format of the data within its storage location.
type StorageFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The data format associated with the stored data, which
	// represents content type values. The value is inferred from mime type.
	Format StorageFormat_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.dataplex.v1.StorageFormat_Format" json:"format,omitempty"`
	// Optional. The compression type associated with the stored data.
	// If unspecified, the data is uncompressed.
	CompressionFormat StorageFormat_CompressionFormat `protobuf:"varint,2,opt,name=compression_format,json=compressionFormat,proto3,enum=google.cloud.dataplex.v1.StorageFormat_CompressionFormat" json:"compression_format,omitempty"`
	// Required. The mime type descriptor for the data. Must match the pattern
	// {type}/{subtype}. Supported values:
	//
	// - application/x-parquet
	// - application/x-avro
	// - application/x-orc
	// - application/x-tfrecord
	// - application/x-parquet+iceberg
	// - application/x-avro+iceberg
	// - application/x-orc+iceberg
	// - application/json
	// - application/{subtypes}
	// - text/csv
	// - text/<subtypes>
	// - image/{image subtype}
	// - video/{video subtype}
	// - audio/{audio subtype}
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Additional format-specific options.
	//
	// Types that are assignable to Options:
	//
	//	*StorageFormat_Csv
	//	*StorageFormat_Json
	//	*StorageFormat_Iceberg
	Options isStorageFormat_Options `protobuf_oneof:"options"`
}

func (x *StorageFormat) Reset() {
	*x = StorageFormat{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageFormat) ProtoMessage() {}

func (x *StorageFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageFormat.ProtoReflect.Descriptor instead.
func (*StorageFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14}
}

func (x *StorageFormat) GetFormat() StorageFormat_Format {
	if x != nil {
		return x.Format
	}
	return StorageFormat_FORMAT_UNSPECIFIED
}

func (x *StorageFormat) GetCompressionFormat() StorageFormat_CompressionFormat {
	if x != nil {
		return x.CompressionFormat
	}
	return StorageFormat_COMPRESSION_FORMAT_UNSPECIFIED
}

func (x *StorageFormat) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (m *StorageFormat) GetOptions() isStorageFormat_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *StorageFormat) GetCsv() *StorageFormat_CsvOptions {
	if x, ok := x.GetOptions().(*StorageFormat_Csv); ok {
		return x.Csv
	}
	return nil
}

func (x *StorageFormat) GetJson() *StorageFormat_JsonOptions {
	if x, ok := x.GetOptions().(*StorageFormat_Json); ok {
		return x.Json
	}
	return nil
}

func (x *StorageFormat) GetIceberg() *StorageFormat_IcebergOptions {
	if x, ok := x.GetOptions().(*StorageFormat_Iceberg); ok {
		return x.Iceberg
	}
	return nil
}

type isStorageFormat_Options interface {
	isStorageFormat_Options()
}

type StorageFormat_Csv struct {
	// Optional. Additional information about CSV formatted data.
	Csv *StorageFormat_CsvOptions `protobuf:"bytes,10,opt,name=csv,proto3,oneof"`
}

type StorageFormat_Json struct {
	// Optional. Additional information about CSV formatted data.
	Json *StorageFormat_JsonOptions `protobuf:"bytes,11,opt,name=json,proto3,oneof"`
}

type StorageFormat_Iceberg struct {
	// Optional. Additional information about iceberg tables.
	Iceberg *StorageFormat_IcebergOptions `protobuf:"bytes,12,opt,name=iceberg,proto3,oneof"`
}

func (*StorageFormat_Csv) isStorageFormat_Options() {}

func (*StorageFormat_Json) isStorageFormat_Options() {}

func (*StorageFormat_Iceberg) isStorageFormat_Options() {}

// Describes the access mechanism of the data within its storage location.
type StorageAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Describes the read access mechanism of the data. Not user
	// settable.
	Read StorageAccess_AccessMode `protobuf:"varint,21,opt,name=read,proto3,enum=google.cloud.dataplex.v1.StorageAccess_AccessMode" json:"read,omitempty"`
}

func (x *StorageAccess) Reset() {
	*x = StorageAccess{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageAccess) ProtoMessage() {}

func (x *StorageAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageAccess.ProtoReflect.Descriptor instead.
func (*StorageAccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{15}
}

func (x *StorageAccess) GetRead() StorageAccess_AccessMode {
	if x != nil {
		return x.Read
	}
	return StorageAccess_ACCESS_MODE_UNSPECIFIED
}

// Provides compatibility information for various metadata stores.
type Entity_CompatibilityStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Whether this entity is compatible with Hive Metastore.
	HiveMetastore *Entity_CompatibilityStatus_Compatibility `protobuf:"bytes,1,opt,name=hive_metastore,json=hiveMetastore,proto3" json:"hive_metastore,omitempty"`
	// Output only. Whether this entity is compatible with BigQuery.
	Bigquery *Entity_CompatibilityStatus_Compatibility `protobuf:"bytes,2,opt,name=bigquery,proto3" json:"bigquery,omitempty"`
}

func (x *Entity_CompatibilityStatus) Reset() {
	*x = Entity_CompatibilityStatus{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entity_CompatibilityStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity_CompatibilityStatus) ProtoMessage() {}

func (x *Entity_CompatibilityStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity_CompatibilityStatus.ProtoReflect.Descriptor instead.
func (*Entity_CompatibilityStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Entity_CompatibilityStatus) GetHiveMetastore() *Entity_CompatibilityStatus_Compatibility {
	if x != nil {
		return x.HiveMetastore
	}
	return nil
}

func (x *Entity_CompatibilityStatus) GetBigquery() *Entity_CompatibilityStatus_Compatibility {
	if x != nil {
		return x.Bigquery
	}
	return nil
}

// Provides compatibility information for a specific metadata store.
type Entity_CompatibilityStatus_Compatibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Whether the entity is compatible and can be represented in
	// the metadata store.
	Compatible bool `protobuf:"varint,1,opt,name=compatible,proto3" json:"compatible,omitempty"`
	// Output only. Provides additional detail if the entity is incompatible
	// with the metadata store.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *Entity_CompatibilityStatus_Compatibility) Reset() {
	*x = Entity_CompatibilityStatus_Compatibility{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entity_CompatibilityStatus_Compatibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity_CompatibilityStatus_Compatibility) ProtoMessage() {}

func (x *Entity_CompatibilityStatus_Compatibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity_CompatibilityStatus_Compatibility.ProtoReflect.Descriptor instead.
func (*Entity_CompatibilityStatus_Compatibility) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{11, 0, 0}
}

func (x *Entity_CompatibilityStatus_Compatibility) GetCompatible() bool {
	if x != nil {
		return x.Compatible
	}
	return false
}

func (x *Entity_CompatibilityStatus_Compatibility) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Represents a column field within a table schema.
type Schema_SchemaField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the field. Must contain only letters, numbers and
	// underscores, with a maximum length of 767 characters,
	// and must begin with a letter or underscore.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly field description. Must be less than or equal to
	// 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The type of field.
	Type Schema_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Schema_Type" json:"type,omitempty"`
	// Required. Additional field semantics.
	Mode Schema_Mode `protobuf:"varint,4,opt,name=mode,proto3,enum=google.cloud.dataplex.v1.Schema_Mode" json:"mode,omitempty"`
	// Optional. Any nested field for complex types.
	Fields []*Schema_SchemaField `protobuf:"bytes,10,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Schema_SchemaField) Reset() {
	*x = Schema_SchemaField{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_SchemaField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_SchemaField) ProtoMessage() {}

func (x *Schema_SchemaField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_SchemaField.ProtoReflect.Descriptor instead.
func (*Schema_SchemaField) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13, 0}
}

func (x *Schema_SchemaField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema_SchemaField) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_SchemaField) GetType() Schema_Type {
	if x != nil {
		return x.Type
	}
	return Schema_TYPE_UNSPECIFIED
}

func (x *Schema_SchemaField) GetMode() Schema_Mode {
	if x != nil {
		return x.Mode
	}
	return Schema_MODE_UNSPECIFIED
}

func (x *Schema_SchemaField) GetFields() []*Schema_SchemaField {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Represents a key field within the entity's partition structure. You could
// have up to 20 partition fields, but only the first 10 partitions have the
// filtering ability due to performance consideration. **Note:**
// Partition fields are immutable.
type Schema_PartitionField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Partition field name must consist of letters, numbers, and
	// underscores only, with a maximum of length of 256 characters, and must
	// begin with a letter or underscore..
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The type of field.
	Type Schema_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Schema_Type" json:"type,omitempty"`
}

func (x *Schema_PartitionField) Reset() {
	*x = Schema_PartitionField{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_PartitionField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_PartitionField) ProtoMessage() {}

func (x *Schema_PartitionField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_PartitionField.ProtoReflect.Descriptor instead.
func (*Schema_PartitionField) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{13, 1}
}

func (x *Schema_PartitionField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema_PartitionField) GetType() Schema_Type {
	if x != nil {
		return x.Type
	}
	return Schema_TYPE_UNSPECIFIED
}

// Describes CSV and similar semi-structured data formats.
type StorageFormat_CsvOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The character encoding of the data. Accepts "US-ASCII",
	// "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
	Encoding string `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Optional. The number of rows to interpret as header rows that should be
	// skipped when reading data rows. Defaults to 0.
	HeaderRows int32 `protobuf:"varint,2,opt,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Optional. The delimiter used to separate values. Defaults to ','.
	Delimiter string `protobuf:"bytes,3,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Optional. The character used to quote column values. Accepts '"'
	// (double quotation mark) or ”' (single quotation mark). Defaults to
	// '"' (double quotation mark) if unspecified.
	Quote string `protobuf:"bytes,4,opt,name=quote,proto3" json:"quote,omitempty"`
}

func (x *StorageFormat_CsvOptions) Reset() {
	*x = StorageFormat_CsvOptions{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageFormat_CsvOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageFormat_CsvOptions) ProtoMessage() {}

func (x *StorageFormat_CsvOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageFormat_CsvOptions.ProtoReflect.Descriptor instead.
func (*StorageFormat_CsvOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14, 0}
}

func (x *StorageFormat_CsvOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *StorageFormat_CsvOptions) GetHeaderRows() int32 {
	if x != nil {
		return x.HeaderRows
	}
	return 0
}

func (x *StorageFormat_CsvOptions) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *StorageFormat_CsvOptions) GetQuote() string {
	if x != nil {
		return x.Quote
	}
	return ""
}

// Describes JSON data format.
type StorageFormat_JsonOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8"
	// and "ISO-8859-1". Defaults to UTF-8 if not specified.
	Encoding string `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *StorageFormat_JsonOptions) Reset() {
	*x = StorageFormat_JsonOptions{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageFormat_JsonOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageFormat_JsonOptions) ProtoMessage() {}

func (x *StorageFormat_JsonOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageFormat_JsonOptions.ProtoReflect.Descriptor instead.
func (*StorageFormat_JsonOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14, 1}
}

func (x *StorageFormat_JsonOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

// Describes Iceberg data format.
type StorageFormat_IcebergOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The location of where the iceberg metadata is present, must be
	// within the table path
	MetadataLocation string `protobuf:"bytes,1,opt,name=metadata_location,json=metadataLocation,proto3" json:"metadata_location,omitempty"`
}

func (x *StorageFormat_IcebergOptions) Reset() {
	*x = StorageFormat_IcebergOptions{}
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageFormat_IcebergOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageFormat_IcebergOptions) ProtoMessage() {}

func (x *StorageFormat_IcebergOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_metadata_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageFormat_IcebergOptions.ProtoReflect.Descriptor instead.
func (*StorageFormat_IcebergOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP(), []int{14, 2}
}

func (x *StorageFormat_IcebergOptions) GetMetadataLocation() string {
	if x != nil {
		return x.MetadataLocation
	}
	return ""
}

var File_google_cloud_dataplex_v1_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_metadata_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x5a, 0x6f,
	0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x7e, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x6a, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22,
	0xce, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a,
	0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x43, 0x0a, 0x0a, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x54,
	0x49, 0x54, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x53,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x45, 0x54, 0x53, 0x10, 0x02,
	0x22, 0x7c, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xea,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22,
	0x4a, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a,
	0x17, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41,
	0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10,
	0x02, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x04, 0x22, 0xba, 0x01, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xca, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x72, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41,
	0x01, 0x18, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x85, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x54, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x0b, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x41, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1c, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x12, 0x23, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2f, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61, 0x74, 0x68, 0x50,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x47, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x05, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x44, 0x0a, 0x06, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x5f, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x44, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x3d, 0x0a,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0xbd, 0x02, 0x0a,
	0x13, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x6e, 0x0a, 0x0e, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x68, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x63, 0x0a, 0x08, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a, 0x51, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12,
	0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x34, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x45, 0x54,
	0x10, 0x02, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x7d, 0x22, 0xbf, 0x02, 0x0a,
	0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x05, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01,
	0x18, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x93, 0x01, 0xea, 0x41, 0x8f, 0x01, 0x0a,
	0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65,
	0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b,
	0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xa0,
	0x08, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x26, 0x0a, 0x0c, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x12, 0x49, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x5f, 0x0a, 0x10,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x5d, 0x0a,
	0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x1a, 0x98, 0x02, 0x0a,
	0x0b, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3e, 0x0a, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x49, 0x0a, 0x06,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x6c, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x41, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x59, 0x54, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x49,
	0x4e, 0x54, 0x31, 0x36, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x33, 0x32, 0x10,
	0x04, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05,
	0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c,
	0x45, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x08,
	0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06,
	0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45,
	0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x0b, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x0c, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x0d, 0x12, 0x0a, 0x0a, 0x06, 0x52,
	0x45, 0x43, 0x4f, 0x52, 0x44, 0x10, 0x0e, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x55, 0x4c, 0x4c, 0x10,
	0x64, 0x22, 0x46, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x4e, 0x55, 0x4c, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52,
	0x45, 0x50, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x46, 0x0a, 0x0e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50,
	0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f,
	0x48, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10,
	0x01, 0x22, 0xf2, 0x07, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x6d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x4b, 0x0a, 0x03, 0x63, 0x73, 0x76, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x43, 0x73, 0x76, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x63, 0x73, 0x76, 0x12, 0x4e,
	0x0a, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x12, 0x57,
	0x0a, 0x07, 0x69, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x49, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07,
	0x69, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x1a, 0x91, 0x01, 0x0a, 0x0a, 0x43, 0x73, 0x76, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x21, 0x0a,
	0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x1a, 0x2e, 0x0a, 0x0b, 0x4a,
	0x73, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x42, 0x0a, 0x0e, 0x49,
	0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a,
	0x11, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xab, 0x01, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f,
	0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52, 0x51, 0x55, 0x45, 0x54, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x41, 0x56, 0x52, 0x4f, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x52, 0x43,
	0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10, 0x64, 0x12, 0x08, 0x0a, 0x04, 0x4a,
	0x53, 0x4f, 0x4e, 0x10, 0x65, 0x12, 0x0a, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0xc8,
	0x01, 0x12, 0x0a, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0xc9, 0x01, 0x12, 0x0a, 0x0a,
	0x05, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x10, 0xca, 0x01, 0x12, 0x09, 0x0a, 0x04, 0x54, 0x45, 0x58,
	0x54, 0x10, 0xcb, 0x01, 0x12, 0x0d, 0x0a, 0x08, 0x54, 0x46, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44,
	0x10, 0xcc, 0x01, 0x12, 0x0a, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0xe8, 0x07, 0x12,
	0x0c, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0xe9, 0x07, 0x22, 0x4c, 0x0a,
	0x11, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x5a, 0x49, 0x50, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x42, 0x5a, 0x49, 0x50, 0x32, 0x10, 0x03, 0x42, 0x09, 0x0a, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x4b, 0x0a, 0x04, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x72, 0x65, 0x61, 0x64, 0x22, 0x42, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x50, 0x0a, 0x0d, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x54,
	0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c,
	0x4f, 0x55, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x32, 0x89, 0x0e, 0x0a, 0x0f,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xbd, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x22, 0x5c, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0xb4, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x1a, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa6, 0x01, 0x0a, 0x09,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbc, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0xd9, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f,
	0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0xb6, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x59, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x2a, 0x4a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xbd, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12,
	0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x69, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_metadata_proto_rawDescData = file_google_cloud_dataplex_v1_metadata_proto_rawDesc
)

func file_google_cloud_dataplex_v1_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_metadata_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_metadata_proto_rawDescData
}

var file_google_cloud_dataplex_v1_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_cloud_dataplex_v1_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_dataplex_v1_metadata_proto_goTypes = []any{
	(StorageSystem)(0),                               // 0: google.cloud.dataplex.v1.StorageSystem
	(ListEntitiesRequest_EntityView)(0),              // 1: google.cloud.dataplex.v1.ListEntitiesRequest.EntityView
	(GetEntityRequest_EntityView)(0),                 // 2: google.cloud.dataplex.v1.GetEntityRequest.EntityView
	(Entity_Type)(0),                                 // 3: google.cloud.dataplex.v1.Entity.Type
	(Schema_Type)(0),                                 // 4: google.cloud.dataplex.v1.Schema.Type
	(Schema_Mode)(0),                                 // 5: google.cloud.dataplex.v1.Schema.Mode
	(Schema_PartitionStyle)(0),                       // 6: google.cloud.dataplex.v1.Schema.PartitionStyle
	(StorageFormat_Format)(0),                        // 7: google.cloud.dataplex.v1.StorageFormat.Format
	(StorageFormat_CompressionFormat)(0),             // 8: google.cloud.dataplex.v1.StorageFormat.CompressionFormat
	(StorageAccess_AccessMode)(0),                    // 9: google.cloud.dataplex.v1.StorageAccess.AccessMode
	(*CreateEntityRequest)(nil),                      // 10: google.cloud.dataplex.v1.CreateEntityRequest
	(*UpdateEntityRequest)(nil),                      // 11: google.cloud.dataplex.v1.UpdateEntityRequest
	(*DeleteEntityRequest)(nil),                      // 12: google.cloud.dataplex.v1.DeleteEntityRequest
	(*ListEntitiesRequest)(nil),                      // 13: google.cloud.dataplex.v1.ListEntitiesRequest
	(*ListEntitiesResponse)(nil),                     // 14: google.cloud.dataplex.v1.ListEntitiesResponse
	(*GetEntityRequest)(nil),                         // 15: google.cloud.dataplex.v1.GetEntityRequest
	(*ListPartitionsRequest)(nil),                    // 16: google.cloud.dataplex.v1.ListPartitionsRequest
	(*CreatePartitionRequest)(nil),                   // 17: google.cloud.dataplex.v1.CreatePartitionRequest
	(*DeletePartitionRequest)(nil),                   // 18: google.cloud.dataplex.v1.DeletePartitionRequest
	(*ListPartitionsResponse)(nil),                   // 19: google.cloud.dataplex.v1.ListPartitionsResponse
	(*GetPartitionRequest)(nil),                      // 20: google.cloud.dataplex.v1.GetPartitionRequest
	(*Entity)(nil),                                   // 21: google.cloud.dataplex.v1.Entity
	(*Partition)(nil),                                // 22: google.cloud.dataplex.v1.Partition
	(*Schema)(nil),                                   // 23: google.cloud.dataplex.v1.Schema
	(*StorageFormat)(nil),                            // 24: google.cloud.dataplex.v1.StorageFormat
	(*StorageAccess)(nil),                            // 25: google.cloud.dataplex.v1.StorageAccess
	(*Entity_CompatibilityStatus)(nil),               // 26: google.cloud.dataplex.v1.Entity.CompatibilityStatus
	(*Entity_CompatibilityStatus_Compatibility)(nil), // 27: google.cloud.dataplex.v1.Entity.CompatibilityStatus.Compatibility
	(*Schema_SchemaField)(nil),                       // 28: google.cloud.dataplex.v1.Schema.SchemaField
	(*Schema_PartitionField)(nil),                    // 29: google.cloud.dataplex.v1.Schema.PartitionField
	(*StorageFormat_CsvOptions)(nil),                 // 30: google.cloud.dataplex.v1.StorageFormat.CsvOptions
	(*StorageFormat_JsonOptions)(nil),                // 31: google.cloud.dataplex.v1.StorageFormat.JsonOptions
	(*StorageFormat_IcebergOptions)(nil),             // 32: google.cloud.dataplex.v1.StorageFormat.IcebergOptions
	(*timestamppb.Timestamp)(nil),                    // 33: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                            // 34: google.protobuf.Empty
}
var file_google_cloud_dataplex_v1_metadata_proto_depIdxs = []int32{
	21, // 0: google.cloud.dataplex.v1.CreateEntityRequest.entity:type_name -> google.cloud.dataplex.v1.Entity
	21, // 1: google.cloud.dataplex.v1.UpdateEntityRequest.entity:type_name -> google.cloud.dataplex.v1.Entity
	1,  // 2: google.cloud.dataplex.v1.ListEntitiesRequest.view:type_name -> google.cloud.dataplex.v1.ListEntitiesRequest.EntityView
	21, // 3: google.cloud.dataplex.v1.ListEntitiesResponse.entities:type_name -> google.cloud.dataplex.v1.Entity
	2,  // 4: google.cloud.dataplex.v1.GetEntityRequest.view:type_name -> google.cloud.dataplex.v1.GetEntityRequest.EntityView
	22, // 5: google.cloud.dataplex.v1.CreatePartitionRequest.partition:type_name -> google.cloud.dataplex.v1.Partition
	22, // 6: google.cloud.dataplex.v1.ListPartitionsResponse.partitions:type_name -> google.cloud.dataplex.v1.Partition
	33, // 7: google.cloud.dataplex.v1.Entity.create_time:type_name -> google.protobuf.Timestamp
	33, // 8: google.cloud.dataplex.v1.Entity.update_time:type_name -> google.protobuf.Timestamp
	3,  // 9: google.cloud.dataplex.v1.Entity.type:type_name -> google.cloud.dataplex.v1.Entity.Type
	0,  // 10: google.cloud.dataplex.v1.Entity.system:type_name -> google.cloud.dataplex.v1.StorageSystem
	24, // 11: google.cloud.dataplex.v1.Entity.format:type_name -> google.cloud.dataplex.v1.StorageFormat
	26, // 12: google.cloud.dataplex.v1.Entity.compatibility:type_name -> google.cloud.dataplex.v1.Entity.CompatibilityStatus
	25, // 13: google.cloud.dataplex.v1.Entity.access:type_name -> google.cloud.dataplex.v1.StorageAccess
	23, // 14: google.cloud.dataplex.v1.Entity.schema:type_name -> google.cloud.dataplex.v1.Schema
	28, // 15: google.cloud.dataplex.v1.Schema.fields:type_name -> google.cloud.dataplex.v1.Schema.SchemaField
	29, // 16: google.cloud.dataplex.v1.Schema.partition_fields:type_name -> google.cloud.dataplex.v1.Schema.PartitionField
	6,  // 17: google.cloud.dataplex.v1.Schema.partition_style:type_name -> google.cloud.dataplex.v1.Schema.PartitionStyle
	7,  // 18: google.cloud.dataplex.v1.StorageFormat.format:type_name -> google.cloud.dataplex.v1.StorageFormat.Format
	8,  // 19: google.cloud.dataplex.v1.StorageFormat.compression_format:type_name -> google.cloud.dataplex.v1.StorageFormat.CompressionFormat
	30, // 20: google.cloud.dataplex.v1.StorageFormat.csv:type_name -> google.cloud.dataplex.v1.StorageFormat.CsvOptions
	31, // 21: google.cloud.dataplex.v1.StorageFormat.json:type_name -> google.cloud.dataplex.v1.StorageFormat.JsonOptions
	32, // 22: google.cloud.dataplex.v1.StorageFormat.iceberg:type_name -> google.cloud.dataplex.v1.StorageFormat.IcebergOptions
	9,  // 23: google.cloud.dataplex.v1.StorageAccess.read:type_name -> google.cloud.dataplex.v1.StorageAccess.AccessMode
	27, // 24: google.cloud.dataplex.v1.Entity.CompatibilityStatus.hive_metastore:type_name -> google.cloud.dataplex.v1.Entity.CompatibilityStatus.Compatibility
	27, // 25: google.cloud.dataplex.v1.Entity.CompatibilityStatus.bigquery:type_name -> google.cloud.dataplex.v1.Entity.CompatibilityStatus.Compatibility
	4,  // 26: google.cloud.dataplex.v1.Schema.SchemaField.type:type_name -> google.cloud.dataplex.v1.Schema.Type
	5,  // 27: google.cloud.dataplex.v1.Schema.SchemaField.mode:type_name -> google.cloud.dataplex.v1.Schema.Mode
	28, // 28: google.cloud.dataplex.v1.Schema.SchemaField.fields:type_name -> google.cloud.dataplex.v1.Schema.SchemaField
	4,  // 29: google.cloud.dataplex.v1.Schema.PartitionField.type:type_name -> google.cloud.dataplex.v1.Schema.Type
	10, // 30: google.cloud.dataplex.v1.MetadataService.CreateEntity:input_type -> google.cloud.dataplex.v1.CreateEntityRequest
	11, // 31: google.cloud.dataplex.v1.MetadataService.UpdateEntity:input_type -> google.cloud.dataplex.v1.UpdateEntityRequest
	12, // 32: google.cloud.dataplex.v1.MetadataService.DeleteEntity:input_type -> google.cloud.dataplex.v1.DeleteEntityRequest
	15, // 33: google.cloud.dataplex.v1.MetadataService.GetEntity:input_type -> google.cloud.dataplex.v1.GetEntityRequest
	13, // 34: google.cloud.dataplex.v1.MetadataService.ListEntities:input_type -> google.cloud.dataplex.v1.ListEntitiesRequest
	17, // 35: google.cloud.dataplex.v1.MetadataService.CreatePartition:input_type -> google.cloud.dataplex.v1.CreatePartitionRequest
	18, // 36: google.cloud.dataplex.v1.MetadataService.DeletePartition:input_type -> google.cloud.dataplex.v1.DeletePartitionRequest
	20, // 37: google.cloud.dataplex.v1.MetadataService.GetPartition:input_type -> google.cloud.dataplex.v1.GetPartitionRequest
	16, // 38: google.cloud.dataplex.v1.MetadataService.ListPartitions:input_type -> google.cloud.dataplex.v1.ListPartitionsRequest
	21, // 39: google.cloud.dataplex.v1.MetadataService.CreateEntity:output_type -> google.cloud.dataplex.v1.Entity
	21, // 40: google.cloud.dataplex.v1.MetadataService.UpdateEntity:output_type -> google.cloud.dataplex.v1.Entity
	34, // 41: google.cloud.dataplex.v1.MetadataService.DeleteEntity:output_type -> google.protobuf.Empty
	21, // 42: google.cloud.dataplex.v1.MetadataService.GetEntity:output_type -> google.cloud.dataplex.v1.Entity
	14, // 43: google.cloud.dataplex.v1.MetadataService.ListEntities:output_type -> google.cloud.dataplex.v1.ListEntitiesResponse
	22, // 44: google.cloud.dataplex.v1.MetadataService.CreatePartition:output_type -> google.cloud.dataplex.v1.Partition
	34, // 45: google.cloud.dataplex.v1.MetadataService.DeletePartition:output_type -> google.protobuf.Empty
	22, // 46: google.cloud.dataplex.v1.MetadataService.GetPartition:output_type -> google.cloud.dataplex.v1.Partition
	19, // 47: google.cloud.dataplex.v1.MetadataService.ListPartitions:output_type -> google.cloud.dataplex.v1.ListPartitionsResponse
	39, // [39:48] is the sub-list for method output_type
	30, // [30:39] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_metadata_proto_init() }
func file_google_cloud_dataplex_v1_metadata_proto_init() {
	if File_google_cloud_dataplex_v1_metadata_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_metadata_proto_msgTypes[14].OneofWrappers = []any{
		(*StorageFormat_Csv)(nil),
		(*StorageFormat_Json)(nil),
		(*StorageFormat_Iceberg)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_metadata_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataplex_v1_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_metadata_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_metadata_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_metadata_proto = out.File
	file_google_cloud_dataplex_v1_metadata_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_metadata_proto_goTypes = nil
	file_google_cloud_dataplex_v1_metadata_proto_depIdxs = nil
}
