// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/datascans.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of data scan.
type DataScanType int32

const (
	// The data scan type is unspecified.
	DataScanType_DATA_SCAN_TYPE_UNSPECIFIED DataScanType = 0
	// Data quality scan.
	DataScanType_DATA_QUALITY DataScanType = 1
	// Data profile scan.
	DataScanType_DATA_PROFILE DataScanType = 2
	// Data discovery scan.
	DataScanType_DATA_DISCOVERY DataScanType = 3
	// Data documentation scan.
	DataScanType_DATA_DOCUMENTATION DataScanType = 4
)

// Enum value maps for DataScanType.
var (
	DataScanType_name = map[int32]string{
		0: "DATA_SCAN_TYPE_UNSPECIFIED",
		1: "DATA_QUALITY",
		2: "DATA_PROFILE",
		3: "DATA_DISCOVERY",
		4: "DATA_DOCUMENTATION",
	}
	DataScanType_value = map[string]int32{
		"DATA_SCAN_TYPE_UNSPECIFIED": 0,
		"DATA_QUALITY":               1,
		"DATA_PROFILE":               2,
		"DATA_DISCOVERY":             3,
		"DATA_DOCUMENTATION":         4,
	}
)

func (x DataScanType) Enum() *DataScanType {
	p := new(DataScanType)
	*p = x
	return p
}

func (x DataScanType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[0].Descriptor()
}

func (DataScanType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[0]
}

func (x DataScanType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanType.Descriptor instead.
func (DataScanType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{0}
}

// DataScan view options.
type GetDataScanRequest_DataScanView int32

const (
	// The API will default to the `BASIC` view.
	GetDataScanRequest_DATA_SCAN_VIEW_UNSPECIFIED GetDataScanRequest_DataScanView = 0
	// Basic view that does not include *spec* and *result*.
	GetDataScanRequest_BASIC GetDataScanRequest_DataScanView = 1
	// Include everything.
	GetDataScanRequest_FULL GetDataScanRequest_DataScanView = 10
)

// Enum value maps for GetDataScanRequest_DataScanView.
var (
	GetDataScanRequest_DataScanView_name = map[int32]string{
		0:  "DATA_SCAN_VIEW_UNSPECIFIED",
		1:  "BASIC",
		10: "FULL",
	}
	GetDataScanRequest_DataScanView_value = map[string]int32{
		"DATA_SCAN_VIEW_UNSPECIFIED": 0,
		"BASIC":                      1,
		"FULL":                       10,
	}
)

func (x GetDataScanRequest_DataScanView) Enum() *GetDataScanRequest_DataScanView {
	p := new(GetDataScanRequest_DataScanView)
	*p = x
	return p
}

func (x GetDataScanRequest_DataScanView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetDataScanRequest_DataScanView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[1].Descriptor()
}

func (GetDataScanRequest_DataScanView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[1]
}

func (x GetDataScanRequest_DataScanView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetDataScanRequest_DataScanView.Descriptor instead.
func (GetDataScanRequest_DataScanView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{3, 0}
}

// DataScanJob view options.
type GetDataScanJobRequest_DataScanJobView int32

const (
	// The API will default to the `BASIC` view.
	GetDataScanJobRequest_DATA_SCAN_JOB_VIEW_UNSPECIFIED GetDataScanJobRequest_DataScanJobView = 0
	// Basic view that does not include *spec* and *result*.
	GetDataScanJobRequest_BASIC GetDataScanJobRequest_DataScanJobView = 1
	// Include everything.
	GetDataScanJobRequest_FULL GetDataScanJobRequest_DataScanJobView = 10
)

// Enum value maps for GetDataScanJobRequest_DataScanJobView.
var (
	GetDataScanJobRequest_DataScanJobView_name = map[int32]string{
		0:  "DATA_SCAN_JOB_VIEW_UNSPECIFIED",
		1:  "BASIC",
		10: "FULL",
	}
	GetDataScanJobRequest_DataScanJobView_value = map[string]int32{
		"DATA_SCAN_JOB_VIEW_UNSPECIFIED": 0,
		"BASIC":                          1,
		"FULL":                           10,
	}
)

func (x GetDataScanJobRequest_DataScanJobView) Enum() *GetDataScanJobRequest_DataScanJobView {
	p := new(GetDataScanJobRequest_DataScanJobView)
	*p = x
	return p
}

func (x GetDataScanJobRequest_DataScanJobView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetDataScanJobRequest_DataScanJobView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[2].Descriptor()
}

func (GetDataScanJobRequest_DataScanJobView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[2]
}

func (x GetDataScanJobRequest_DataScanJobView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetDataScanJobRequest_DataScanJobView.Descriptor instead.
func (GetDataScanJobRequest_DataScanJobView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{8, 0}
}

// Execution state for the DataScanJob.
type DataScanJob_State int32

const (
	// The DataScanJob state is unspecified.
	DataScanJob_STATE_UNSPECIFIED DataScanJob_State = 0
	// The DataScanJob is running.
	DataScanJob_RUNNING DataScanJob_State = 1
	// The DataScanJob is canceling.
	DataScanJob_CANCELING DataScanJob_State = 2
	// The DataScanJob cancellation was successful.
	DataScanJob_CANCELLED DataScanJob_State = 3
	// The DataScanJob completed successfully.
	DataScanJob_SUCCEEDED DataScanJob_State = 4
	// The DataScanJob is no longer running due to an error.
	DataScanJob_FAILED DataScanJob_State = 5
	// The DataScanJob has been created but not started to run yet.
	DataScanJob_PENDING DataScanJob_State = 7
)

// Enum value maps for DataScanJob_State.
var (
	DataScanJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "CANCELING",
		3: "CANCELLED",
		4: "SUCCEEDED",
		5: "FAILED",
		7: "PENDING",
	}
	DataScanJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"CANCELING":         2,
		"CANCELLED":         3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"PENDING":           7,
	}
)

func (x DataScanJob_State) Enum() *DataScanJob_State {
	p := new(DataScanJob_State)
	*p = x
	return p
}

func (x DataScanJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[3].Descriptor()
}

func (DataScanJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[3]
}

func (x DataScanJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanJob_State.Descriptor instead.
func (DataScanJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{14, 0}
}

// Create dataScan request.
type CreateDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location:
	// `projects/{project}/locations/{location_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. DataScan resource.
	DataScan *DataScan `protobuf:"bytes,2,opt,name=data_scan,json=dataScan,proto3" json:"data_scan,omitempty"`
	// Required. DataScan identifier.
	//
	// * Must contain only lowercase letters, numbers and hyphens.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	// * Must be between 1-63 characters.
	// * Must be unique within the customer project / location.
	DataScanId string `protobuf:"bytes,3,opt,name=data_scan_id,json=dataScanId,proto3" json:"data_scan_id,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is `false`.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateDataScanRequest) Reset() {
	*x = CreateDataScanRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataScanRequest) ProtoMessage() {}

func (x *CreateDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataScanRequest.ProtoReflect.Descriptor instead.
func (*CreateDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDataScanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataScanRequest) GetDataScan() *DataScan {
	if x != nil {
		return x.DataScan
	}
	return nil
}

func (x *CreateDataScanRequest) GetDataScanId() string {
	if x != nil {
		return x.DataScanId
	}
	return ""
}

func (x *CreateDataScanRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update dataScan request.
type UpdateDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. DataScan resource to be updated.
	//
	// Only fields specified in `update_mask` are updated.
	DataScan *DataScan `protobuf:"bytes,1,opt,name=data_scan,json=dataScan,proto3" json:"data_scan,omitempty"`
	// Optional. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is `false`.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateDataScanRequest) Reset() {
	*x = UpdateDataScanRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataScanRequest) ProtoMessage() {}

func (x *UpdateDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataScanRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateDataScanRequest) GetDataScan() *DataScan {
	if x != nil {
		return x.DataScan
	}
	return nil
}

func (x *UpdateDataScanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataScanRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete dataScan request.
type DeleteDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any child resources of this data scan will also
	// be deleted. (Otherwise, the request will only work if the data scan has no
	// child resources.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteDataScanRequest) Reset() {
	*x = DeleteDataScanRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataScanRequest) ProtoMessage() {}

func (x *DeleteDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataScanRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDataScanRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Get dataScan request.
type GetDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Select the DataScan view to return. Defaults to `BASIC`.
	View GetDataScanRequest_DataScanView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.GetDataScanRequest_DataScanView" json:"view,omitempty"`
}

func (x *GetDataScanRequest) Reset() {
	*x = GetDataScanRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataScanRequest) ProtoMessage() {}

func (x *GetDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataScanRequest.ProtoReflect.Descriptor instead.
func (*GetDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{3}
}

func (x *GetDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDataScanRequest) GetView() GetDataScanRequest_DataScanView {
	if x != nil {
		return x.View
	}
	return GetDataScanRequest_DATA_SCAN_VIEW_UNSPECIFIED
}

// List dataScans request.
type ListDataScansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location:
	// `projects/{project}/locations/{location_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of dataScans to return. The service may return
	// fewer than this value. If unspecified, at most 500 scans will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListDataScans` call. Provide
	// this to retrieve the subsequent page. When paginating, all other parameters
	// provided to `ListDataScans` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields (`name` or `create_time`) for the result.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDataScansRequest) Reset() {
	*x = ListDataScansRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataScansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScansRequest) ProtoMessage() {}

func (x *ListDataScansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScansRequest.ProtoReflect.Descriptor instead.
func (*ListDataScansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{4}
}

func (x *ListDataScansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataScansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataScansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataScansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDataScansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List dataScans response.
type ListDataScansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScans (`BASIC` view only) under the given parent location.
	DataScans []*DataScan `protobuf:"bytes,1,rep,name=data_scans,json=dataScans,proto3" json:"data_scans,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDataScansResponse) Reset() {
	*x = ListDataScansResponse{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataScansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScansResponse) ProtoMessage() {}

func (x *ListDataScansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScansResponse.ProtoReflect.Descriptor instead.
func (*ListDataScansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{5}
}

func (x *ListDataScansResponse) GetDataScans() []*DataScan {
	if x != nil {
		return x.DataScans
	}
	return nil
}

func (x *ListDataScansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDataScansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Run DataScan Request
type RunDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`.
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	//
	// Only **OnDemand** data scans are allowed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RunDataScanRequest) Reset() {
	*x = RunDataScanRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDataScanRequest) ProtoMessage() {}

func (x *RunDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDataScanRequest.ProtoReflect.Descriptor instead.
func (*RunDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{6}
}

func (x *RunDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Run DataScan Response.
type RunDataScanResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScanJob created by RunDataScan request.
	Job *DataScanJob `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *RunDataScanResponse) Reset() {
	*x = RunDataScanResponse{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunDataScanResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDataScanResponse) ProtoMessage() {}

func (x *RunDataScanResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDataScanResponse.ProtoReflect.Descriptor instead.
func (*RunDataScanResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{7}
}

func (x *RunDataScanResponse) GetJob() *DataScanJob {
	if x != nil {
		return x.Job
	}
	return nil
}

// Get DataScanJob request.
type GetDataScanJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataScanJob:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Select the DataScanJob view to return. Defaults to `BASIC`.
	View GetDataScanJobRequest_DataScanJobView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.GetDataScanJobRequest_DataScanJobView" json:"view,omitempty"`
}

func (x *GetDataScanJobRequest) Reset() {
	*x = GetDataScanJobRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataScanJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataScanJobRequest) ProtoMessage() {}

func (x *GetDataScanJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataScanJobRequest.ProtoReflect.Descriptor instead.
func (*GetDataScanJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{8}
}

func (x *GetDataScanJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDataScanJobRequest) GetView() GetDataScanJobRequest_DataScanJobView {
	if x != nil {
		return x.View
	}
	return GetDataScanJobRequest_DATA_SCAN_JOB_VIEW_UNSPECIFIED
}

// List DataScanJobs request.
type ListDataScanJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent environment:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of DataScanJobs to return. The service may return
	// fewer than this value. If unspecified, at most 10 DataScanJobs will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListDataScanJobs` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListDataScanJobs` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the ListDataScanJobs
	// request.
	//
	// If unspecified, all datascan jobs will be returned. Multiple filters can be
	// applied (with `AND`, `OR` logical operators). Filters are case-sensitive.
	//
	// Allowed fields are:
	//
	// - `start_time`
	// - `end_time`
	//
	// `start_time` and `end_time` expect RFC-3339 formatted strings (e.g.
	// 2018-10-08T18:30:00-07:00).
	//
	// For instance, 'start_time > 2018-10-08T00:00:00.123456789Z AND end_time <
	// 2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between
	// specified start and end times.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListDataScanJobsRequest) Reset() {
	*x = ListDataScanJobsRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataScanJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScanJobsRequest) ProtoMessage() {}

func (x *ListDataScanJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScanJobsRequest.ProtoReflect.Descriptor instead.
func (*ListDataScanJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{9}
}

func (x *ListDataScanJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataScanJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataScanJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataScanJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List DataScanJobs response.
type ListDataScanJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScanJobs (`BASIC` view only) under a given dataScan.
	DataScanJobs []*DataScanJob `protobuf:"bytes,1,rep,name=data_scan_jobs,json=dataScanJobs,proto3" json:"data_scan_jobs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataScanJobsResponse) Reset() {
	*x = ListDataScanJobsResponse{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataScanJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScanJobsResponse) ProtoMessage() {}

func (x *ListDataScanJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScanJobsResponse.ProtoReflect.Descriptor instead.
func (*ListDataScanJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{10}
}

func (x *ListDataScanJobsResponse) GetDataScanJobs() []*DataScanJob {
	if x != nil {
		return x.DataScanJobs
	}
	return nil
}

func (x *ListDataScanJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request details for generating data quality rule recommendations.
type GenerateDataQualityRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name must be one of the following:
	//
	// * The name of a data scan with at least one successful, completed data
	// profiling job
	// * The name of a successful, completed data profiling job (a data scan job
	// where the job type is data profiling)
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GenerateDataQualityRulesRequest) Reset() {
	*x = GenerateDataQualityRulesRequest{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateDataQualityRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDataQualityRulesRequest) ProtoMessage() {}

func (x *GenerateDataQualityRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDataQualityRulesRequest.ProtoReflect.Descriptor instead.
func (*GenerateDataQualityRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateDataQualityRulesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response details for data quality rule recommendations.
type GenerateDataQualityRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data quality rules that Dataplex Universal Catalog generates based on
	// the results of a data profiling scan.
	Rule []*DataQualityRule `protobuf:"bytes,1,rep,name=rule,proto3" json:"rule,omitempty"`
}

func (x *GenerateDataQualityRulesResponse) Reset() {
	*x = GenerateDataQualityRulesResponse{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateDataQualityRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDataQualityRulesResponse) ProtoMessage() {}

func (x *GenerateDataQualityRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDataQualityRulesResponse.ProtoReflect.Descriptor instead.
func (*GenerateDataQualityRulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{12}
}

func (x *GenerateDataQualityRulesResponse) GetRule() []*DataQualityRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

// Represents a user-visible job which provides the insights for the related
// data source.
//
// For example:
//
//   - Data quality: generates queries based on the rules and runs against the
//     data to get data quality check results. For more information, see [Auto
//     data quality
//     overview](https://cloud.google.com/dataplex/docs/auto-data-quality-overview).
//   - Data profile: analyzes the data in tables and generates insights about
//     the structure, content and relationships (such as null percent,
//     cardinality, min/max/mean, etc). For more information, see [About data
//     profiling](https://cloud.google.com/dataplex/docs/data-profiling-overview).
//   - Data discovery: scans data in Cloud Storage buckets to extract and then
//     catalog metadata. For more information, see [Discover and catalog Cloud
//     Storage data](https://cloud.google.com/bigquery/docs/automatic-discovery).
//   - Data documentation: analyzes the table details and generates insights
//
// including descriptions and sample SQL queries for the table. For more
// information, see [Generate data insights in
// BigQuery](https://cloud.google.com/bigquery/docs/data-insights).
type DataScan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The relative resource name of the scan, of the
	// form: `projects/{project}/locations/{location_id}/dataScans/{datascan_id}`,
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the scan. This ID will
	// be different if the scan is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the scan.
	//
	// * Must be between 1-1024 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	//
	// * Must be between 1-256 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the scan.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Current state of the DataScan.
	State State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Output only. The time when the scan was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the scan was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The data source for DataScan.
	Data *DataSource `protobuf:"bytes,9,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. DataScan execution settings.
	//
	// If not specified, the fields in it will use their default values.
	ExecutionSpec *DataScan_ExecutionSpec `protobuf:"bytes,10,opt,name=execution_spec,json=executionSpec,proto3" json:"execution_spec,omitempty"`
	// Output only. Status of the data scan execution.
	ExecutionStatus *DataScan_ExecutionStatus `protobuf:"bytes,11,opt,name=execution_status,json=executionStatus,proto3" json:"execution_status,omitempty"`
	// Output only. The type of DataScan.
	Type DataScanType `protobuf:"varint,12,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DataScanType" json:"type,omitempty"`
	// Data scan related setting.
	// The settings are required and immutable. After you configure the settings
	// for one type of data scan, you can't change the data scan to a different
	// type of data scan.
	//
	// Types that are assignable to Spec:
	//
	//	*DataScan_DataQualitySpec
	//	*DataScan_DataProfileSpec
	//	*DataScan_DataDiscoverySpec
	//	*DataScan_DataDocumentationSpec
	Spec isDataScan_Spec `protobuf_oneof:"spec"`
	// The result of the data scan.
	//
	// Types that are assignable to Result:
	//
	//	*DataScan_DataQualityResult
	//	*DataScan_DataProfileResult
	//	*DataScan_DataDiscoveryResult
	//	*DataScan_DataDocumentationResult
	Result isDataScan_Result `protobuf_oneof:"result"`
}

func (x *DataScan) Reset() {
	*x = DataScan{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataScan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan) ProtoMessage() {}

func (x *DataScan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan.ProtoReflect.Descriptor instead.
func (*DataScan) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{13}
}

func (x *DataScan) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataScan) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DataScan) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataScan) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataScan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DataScan) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *DataScan) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataScan) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DataScan) GetData() *DataSource {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DataScan) GetExecutionSpec() *DataScan_ExecutionSpec {
	if x != nil {
		return x.ExecutionSpec
	}
	return nil
}

func (x *DataScan) GetExecutionStatus() *DataScan_ExecutionStatus {
	if x != nil {
		return x.ExecutionStatus
	}
	return nil
}

func (x *DataScan) GetType() DataScanType {
	if x != nil {
		return x.Type
	}
	return DataScanType_DATA_SCAN_TYPE_UNSPECIFIED
}

func (m *DataScan) GetSpec() isDataScan_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *DataScan) GetDataQualitySpec() *DataQualitySpec {
	if x, ok := x.GetSpec().(*DataScan_DataQualitySpec); ok {
		return x.DataQualitySpec
	}
	return nil
}

func (x *DataScan) GetDataProfileSpec() *DataProfileSpec {
	if x, ok := x.GetSpec().(*DataScan_DataProfileSpec); ok {
		return x.DataProfileSpec
	}
	return nil
}

func (x *DataScan) GetDataDiscoverySpec() *DataDiscoverySpec {
	if x, ok := x.GetSpec().(*DataScan_DataDiscoverySpec); ok {
		return x.DataDiscoverySpec
	}
	return nil
}

func (x *DataScan) GetDataDocumentationSpec() *DataDocumentationSpec {
	if x, ok := x.GetSpec().(*DataScan_DataDocumentationSpec); ok {
		return x.DataDocumentationSpec
	}
	return nil
}

func (m *DataScan) GetResult() isDataScan_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataScan) GetDataQualityResult() *DataQualityResult {
	if x, ok := x.GetResult().(*DataScan_DataQualityResult); ok {
		return x.DataQualityResult
	}
	return nil
}

func (x *DataScan) GetDataProfileResult() *DataProfileResult {
	if x, ok := x.GetResult().(*DataScan_DataProfileResult); ok {
		return x.DataProfileResult
	}
	return nil
}

func (x *DataScan) GetDataDiscoveryResult() *DataDiscoveryResult {
	if x, ok := x.GetResult().(*DataScan_DataDiscoveryResult); ok {
		return x.DataDiscoveryResult
	}
	return nil
}

func (x *DataScan) GetDataDocumentationResult() *DataDocumentationResult {
	if x, ok := x.GetResult().(*DataScan_DataDocumentationResult); ok {
		return x.DataDocumentationResult
	}
	return nil
}

type isDataScan_Spec interface {
	isDataScan_Spec()
}

type DataScan_DataQualitySpec struct {
	// Settings for a data quality scan.
	DataQualitySpec *DataQualitySpec `protobuf:"bytes,100,opt,name=data_quality_spec,json=dataQualitySpec,proto3,oneof"`
}

type DataScan_DataProfileSpec struct {
	// Settings for a data profile scan.
	DataProfileSpec *DataProfileSpec `protobuf:"bytes,101,opt,name=data_profile_spec,json=dataProfileSpec,proto3,oneof"`
}

type DataScan_DataDiscoverySpec struct {
	// Settings for a data discovery scan.
	DataDiscoverySpec *DataDiscoverySpec `protobuf:"bytes,102,opt,name=data_discovery_spec,json=dataDiscoverySpec,proto3,oneof"`
}

type DataScan_DataDocumentationSpec struct {
	// Settings for a data documentation scan.
	DataDocumentationSpec *DataDocumentationSpec `protobuf:"bytes,103,opt,name=data_documentation_spec,json=dataDocumentationSpec,proto3,oneof"`
}

func (*DataScan_DataQualitySpec) isDataScan_Spec() {}

func (*DataScan_DataProfileSpec) isDataScan_Spec() {}

func (*DataScan_DataDiscoverySpec) isDataScan_Spec() {}

func (*DataScan_DataDocumentationSpec) isDataScan_Spec() {}

type isDataScan_Result interface {
	isDataScan_Result()
}

type DataScan_DataQualityResult struct {
	// Output only. The result of a data quality scan.
	DataQualityResult *DataQualityResult `protobuf:"bytes,200,opt,name=data_quality_result,json=dataQualityResult,proto3,oneof"`
}

type DataScan_DataProfileResult struct {
	// Output only. The result of a data profile scan.
	DataProfileResult *DataProfileResult `protobuf:"bytes,201,opt,name=data_profile_result,json=dataProfileResult,proto3,oneof"`
}

type DataScan_DataDiscoveryResult struct {
	// Output only. The result of a data discovery scan.
	DataDiscoveryResult *DataDiscoveryResult `protobuf:"bytes,202,opt,name=data_discovery_result,json=dataDiscoveryResult,proto3,oneof"`
}

type DataScan_DataDocumentationResult struct {
	// Output only. The result of a data documentation scan.
	DataDocumentationResult *DataDocumentationResult `protobuf:"bytes,203,opt,name=data_documentation_result,json=dataDocumentationResult,proto3,oneof"`
}

func (*DataScan_DataQualityResult) isDataScan_Result() {}

func (*DataScan_DataProfileResult) isDataScan_Result() {}

func (*DataScan_DataDiscoveryResult) isDataScan_Result() {}

func (*DataScan_DataDocumentationResult) isDataScan_Result() {}

// A DataScanJob represents an instance of DataScan execution.
type DataScanJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The relative resource name of the DataScanJob, of
	// the form:
	// `projects/{project}/locations/{location_id}/dataScans/{datascan_id}/jobs/{job_id}`,
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a Google Cloud region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the DataScanJob.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the DataScanJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the DataScanJob was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the DataScanJob ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Execution state for the DataScanJob.
	State DataScanJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataScanJob_State" json:"state,omitempty"`
	// Output only. Additional information about the current state.
	Message string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. The type of the parent DataScan.
	Type DataScanType `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DataScanType" json:"type,omitempty"`
	// Data scan related setting.
	//
	// Types that are assignable to Spec:
	//
	//	*DataScanJob_DataQualitySpec
	//	*DataScanJob_DataProfileSpec
	//	*DataScanJob_DataDiscoverySpec
	//	*DataScanJob_DataDocumentationSpec
	Spec isDataScanJob_Spec `protobuf_oneof:"spec"`
	// The result of the data scan.
	//
	// Types that are assignable to Result:
	//
	//	*DataScanJob_DataQualityResult
	//	*DataScanJob_DataProfileResult
	//	*DataScanJob_DataDiscoveryResult
	//	*DataScanJob_DataDocumentationResult
	Result isDataScanJob_Result `protobuf_oneof:"result"`
}

func (x *DataScanJob) Reset() {
	*x = DataScanJob{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataScanJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanJob) ProtoMessage() {}

func (x *DataScanJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanJob.ProtoReflect.Descriptor instead.
func (*DataScanJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{14}
}

func (x *DataScanJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataScanJob) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DataScanJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataScanJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DataScanJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DataScanJob) GetState() DataScanJob_State {
	if x != nil {
		return x.State
	}
	return DataScanJob_STATE_UNSPECIFIED
}

func (x *DataScanJob) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DataScanJob) GetType() DataScanType {
	if x != nil {
		return x.Type
	}
	return DataScanType_DATA_SCAN_TYPE_UNSPECIFIED
}

func (m *DataScanJob) GetSpec() isDataScanJob_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *DataScanJob) GetDataQualitySpec() *DataQualitySpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataQualitySpec); ok {
		return x.DataQualitySpec
	}
	return nil
}

func (x *DataScanJob) GetDataProfileSpec() *DataProfileSpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataProfileSpec); ok {
		return x.DataProfileSpec
	}
	return nil
}

func (x *DataScanJob) GetDataDiscoverySpec() *DataDiscoverySpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataDiscoverySpec); ok {
		return x.DataDiscoverySpec
	}
	return nil
}

func (x *DataScanJob) GetDataDocumentationSpec() *DataDocumentationSpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataDocumentationSpec); ok {
		return x.DataDocumentationSpec
	}
	return nil
}

func (m *DataScanJob) GetResult() isDataScanJob_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataScanJob) GetDataQualityResult() *DataQualityResult {
	if x, ok := x.GetResult().(*DataScanJob_DataQualityResult); ok {
		return x.DataQualityResult
	}
	return nil
}

func (x *DataScanJob) GetDataProfileResult() *DataProfileResult {
	if x, ok := x.GetResult().(*DataScanJob_DataProfileResult); ok {
		return x.DataProfileResult
	}
	return nil
}

func (x *DataScanJob) GetDataDiscoveryResult() *DataDiscoveryResult {
	if x, ok := x.GetResult().(*DataScanJob_DataDiscoveryResult); ok {
		return x.DataDiscoveryResult
	}
	return nil
}

func (x *DataScanJob) GetDataDocumentationResult() *DataDocumentationResult {
	if x, ok := x.GetResult().(*DataScanJob_DataDocumentationResult); ok {
		return x.DataDocumentationResult
	}
	return nil
}

type isDataScanJob_Spec interface {
	isDataScanJob_Spec()
}

type DataScanJob_DataQualitySpec struct {
	// Output only. Settings for a data quality scan.
	DataQualitySpec *DataQualitySpec `protobuf:"bytes,100,opt,name=data_quality_spec,json=dataQualitySpec,proto3,oneof"`
}

type DataScanJob_DataProfileSpec struct {
	// Output only. Settings for a data profile scan.
	DataProfileSpec *DataProfileSpec `protobuf:"bytes,101,opt,name=data_profile_spec,json=dataProfileSpec,proto3,oneof"`
}

type DataScanJob_DataDiscoverySpec struct {
	// Output only. Settings for a data discovery scan.
	DataDiscoverySpec *DataDiscoverySpec `protobuf:"bytes,102,opt,name=data_discovery_spec,json=dataDiscoverySpec,proto3,oneof"`
}

type DataScanJob_DataDocumentationSpec struct {
	// Output only. Settings for a data documentation scan.
	DataDocumentationSpec *DataDocumentationSpec `protobuf:"bytes,103,opt,name=data_documentation_spec,json=dataDocumentationSpec,proto3,oneof"`
}

func (*DataScanJob_DataQualitySpec) isDataScanJob_Spec() {}

func (*DataScanJob_DataProfileSpec) isDataScanJob_Spec() {}

func (*DataScanJob_DataDiscoverySpec) isDataScanJob_Spec() {}

func (*DataScanJob_DataDocumentationSpec) isDataScanJob_Spec() {}

type isDataScanJob_Result interface {
	isDataScanJob_Result()
}

type DataScanJob_DataQualityResult struct {
	// Output only. The result of a data quality scan.
	DataQualityResult *DataQualityResult `protobuf:"bytes,200,opt,name=data_quality_result,json=dataQualityResult,proto3,oneof"`
}

type DataScanJob_DataProfileResult struct {
	// Output only. The result of a data profile scan.
	DataProfileResult *DataProfileResult `protobuf:"bytes,201,opt,name=data_profile_result,json=dataProfileResult,proto3,oneof"`
}

type DataScanJob_DataDiscoveryResult struct {
	// Output only. The result of a data discovery scan.
	DataDiscoveryResult *DataDiscoveryResult `protobuf:"bytes,202,opt,name=data_discovery_result,json=dataDiscoveryResult,proto3,oneof"`
}

type DataScanJob_DataDocumentationResult struct {
	// Output only. The result of a data documentation scan.
	DataDocumentationResult *DataDocumentationResult `protobuf:"bytes,203,opt,name=data_documentation_result,json=dataDocumentationResult,proto3,oneof"`
}

func (*DataScanJob_DataQualityResult) isDataScanJob_Result() {}

func (*DataScanJob_DataProfileResult) isDataScanJob_Result() {}

func (*DataScanJob_DataDiscoveryResult) isDataScanJob_Result() {}

func (*DataScanJob_DataDocumentationResult) isDataScanJob_Result() {}

// DataScan execution settings.
type DataScan_ExecutionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Spec related to how often and when a scan should be triggered.
	//
	// If not specified, the default is `OnDemand`, which means the scan will
	// not run until the user calls `RunDataScan` API.
	Trigger *Trigger `protobuf:"bytes,1,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// Spec related to incremental scan of the data
	//
	// When an option is selected for incremental scan, it cannot be unset or
	// changed. If not specified, a data scan will run for all data in the
	// table.
	//
	// Types that are assignable to Incremental:
	//
	//	*DataScan_ExecutionSpec_Field
	Incremental isDataScan_ExecutionSpec_Incremental `protobuf_oneof:"incremental"`
}

func (x *DataScan_ExecutionSpec) Reset() {
	*x = DataScan_ExecutionSpec{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataScan_ExecutionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan_ExecutionSpec) ProtoMessage() {}

func (x *DataScan_ExecutionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan_ExecutionSpec.ProtoReflect.Descriptor instead.
func (*DataScan_ExecutionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{13, 0}
}

func (x *DataScan_ExecutionSpec) GetTrigger() *Trigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

func (m *DataScan_ExecutionSpec) GetIncremental() isDataScan_ExecutionSpec_Incremental {
	if m != nil {
		return m.Incremental
	}
	return nil
}

func (x *DataScan_ExecutionSpec) GetField() string {
	if x, ok := x.GetIncremental().(*DataScan_ExecutionSpec_Field); ok {
		return x.Field
	}
	return ""
}

type isDataScan_ExecutionSpec_Incremental interface {
	isDataScan_ExecutionSpec_Incremental()
}

type DataScan_ExecutionSpec_Field struct {
	// Immutable. The unnested field (of type *Date* or *Timestamp*) that
	// contains values which monotonically increase over time.
	//
	// If not specified, a data scan will run for all data in the table.
	Field string `protobuf:"bytes,100,opt,name=field,proto3,oneof"`
}

func (*DataScan_ExecutionSpec_Field) isDataScan_ExecutionSpec_Incremental() {}

// Status of the data scan execution.
type DataScan_ExecutionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The time when the latest DataScanJob started.
	LatestJobStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=latest_job_start_time,json=latestJobStartTime,proto3" json:"latest_job_start_time,omitempty"`
	// Optional. The time when the latest DataScanJob ended.
	LatestJobEndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=latest_job_end_time,json=latestJobEndTime,proto3" json:"latest_job_end_time,omitempty"`
	// Optional. The time when the DataScanJob execution was created.
	LatestJobCreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=latest_job_create_time,json=latestJobCreateTime,proto3" json:"latest_job_create_time,omitempty"`
}

func (x *DataScan_ExecutionStatus) Reset() {
	*x = DataScan_ExecutionStatus{}
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataScan_ExecutionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan_ExecutionStatus) ProtoMessage() {}

func (x *DataScan_ExecutionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan_ExecutionStatus.ProtoReflect.Descriptor instead.
func (*DataScan_ExecutionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{13, 1}
}

func (x *DataScan_ExecutionStatus) GetLatestJobStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestJobStartTime
	}
	return nil
}

func (x *DataScan_ExecutionStatus) GetLatestJobEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestJobEndTime
	}
	return nil
}

func (x *DataScan_ExecutionStatus) GetLatestJobCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestJobCreateTime
	}
	return nil
}

var File_google_cloud_dataplex_v1_datascans_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_datascans_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x63, 0x61, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xf1, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x44, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63,
	0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0x70, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x22, 0xeb, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x56, 0x69,
	0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x43, 0x0a,
	0x0c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a,
	0x1a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x0a, 0x22, 0xdc, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x52, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x13,
	0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0xfe, 0x01, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a,
	0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x22, 0x4a, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x43, 0x41,
	0x4e, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49,
	0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x0a, 0x22, 0xbe, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8f,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x3a, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x20,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x22,
	0xca, 0x10, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x1a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x62, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x57,
	0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x66,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x69, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0xc9, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x69, 0x0a, 0x15, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x01, 0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x75, 0x0a, 0x19, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0xcb, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x17, 0x64, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x7d, 0x0a,
	0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40,
	0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x0d, 0x0a,
	0x0b, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x1a, 0x8b, 0x02, 0x0a,
	0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x52, 0x0a, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x13, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x45, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x16, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4a, 0x6f, 0x62,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x63, 0xea, 0x41, 0x60, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x3c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xe2, 0x0b, 0x0a,
	0x0b, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3f, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a,
	0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c, 0x0a, 0x11, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x62, 0x0a, 0x13, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a,
	0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x63, 0x0a,
	0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52,
	0x11, 0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x69, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x13, 0x64,
	0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x75, 0x0a, 0x19, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0xcb, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x17, 0x64, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x71, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x3a, 0x71, 0xea, 0x41,
	0x6e, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x42,
	0x06, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2a, 0x7e, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54,
	0x59, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x50, 0x52, 0x4f, 0x46,
	0x49, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x49,
	0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x04, 0x32, 0xb6, 0x0f, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2c, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3a, 0x3a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x22, 0x2d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x0e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82,
	0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x15, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x9d, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36,
	0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x12, 0xad, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f,
	0x62, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36,
	0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6a,
	0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0xc1, 0x02, 0x0a, 0x18, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xad, 0x01,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9f, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0x4b, 0xca,
	0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6a, 0x0a, 0x1c, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_datascans_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_datascans_proto_rawDescData = file_google_cloud_dataplex_v1_datascans_proto_rawDesc
)

func file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_datascans_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_datascans_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_datascans_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescData
}

var file_google_cloud_dataplex_v1_datascans_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dataplex_v1_datascans_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_dataplex_v1_datascans_proto_goTypes = []any{
	(DataScanType)(0),                          // 0: google.cloud.dataplex.v1.DataScanType
	(GetDataScanRequest_DataScanView)(0),       // 1: google.cloud.dataplex.v1.GetDataScanRequest.DataScanView
	(GetDataScanJobRequest_DataScanJobView)(0), // 2: google.cloud.dataplex.v1.GetDataScanJobRequest.DataScanJobView
	(DataScanJob_State)(0),                     // 3: google.cloud.dataplex.v1.DataScanJob.State
	(*CreateDataScanRequest)(nil),              // 4: google.cloud.dataplex.v1.CreateDataScanRequest
	(*UpdateDataScanRequest)(nil),              // 5: google.cloud.dataplex.v1.UpdateDataScanRequest
	(*DeleteDataScanRequest)(nil),              // 6: google.cloud.dataplex.v1.DeleteDataScanRequest
	(*GetDataScanRequest)(nil),                 // 7: google.cloud.dataplex.v1.GetDataScanRequest
	(*ListDataScansRequest)(nil),               // 8: google.cloud.dataplex.v1.ListDataScansRequest
	(*ListDataScansResponse)(nil),              // 9: google.cloud.dataplex.v1.ListDataScansResponse
	(*RunDataScanRequest)(nil),                 // 10: google.cloud.dataplex.v1.RunDataScanRequest
	(*RunDataScanResponse)(nil),                // 11: google.cloud.dataplex.v1.RunDataScanResponse
	(*GetDataScanJobRequest)(nil),              // 12: google.cloud.dataplex.v1.GetDataScanJobRequest
	(*ListDataScanJobsRequest)(nil),            // 13: google.cloud.dataplex.v1.ListDataScanJobsRequest
	(*ListDataScanJobsResponse)(nil),           // 14: google.cloud.dataplex.v1.ListDataScanJobsResponse
	(*GenerateDataQualityRulesRequest)(nil),    // 15: google.cloud.dataplex.v1.GenerateDataQualityRulesRequest
	(*GenerateDataQualityRulesResponse)(nil),   // 16: google.cloud.dataplex.v1.GenerateDataQualityRulesResponse
	(*DataScan)(nil),                           // 17: google.cloud.dataplex.v1.DataScan
	(*DataScanJob)(nil),                        // 18: google.cloud.dataplex.v1.DataScanJob
	(*DataScan_ExecutionSpec)(nil),             // 19: google.cloud.dataplex.v1.DataScan.ExecutionSpec
	(*DataScan_ExecutionStatus)(nil),           // 20: google.cloud.dataplex.v1.DataScan.ExecutionStatus
	nil,                                        // 21: google.cloud.dataplex.v1.DataScan.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),              // 22: google.protobuf.FieldMask
	(*DataQualityRule)(nil),                    // 23: google.cloud.dataplex.v1.DataQualityRule
	(State)(0),                                 // 24: google.cloud.dataplex.v1.State
	(*timestamppb.Timestamp)(nil),              // 25: google.protobuf.Timestamp
	(*DataSource)(nil),                         // 26: google.cloud.dataplex.v1.DataSource
	(*DataQualitySpec)(nil),                    // 27: google.cloud.dataplex.v1.DataQualitySpec
	(*DataProfileSpec)(nil),                    // 28: google.cloud.dataplex.v1.DataProfileSpec
	(*DataDiscoverySpec)(nil),                  // 29: google.cloud.dataplex.v1.DataDiscoverySpec
	(*DataDocumentationSpec)(nil),              // 30: google.cloud.dataplex.v1.DataDocumentationSpec
	(*DataQualityResult)(nil),                  // 31: google.cloud.dataplex.v1.DataQualityResult
	(*DataProfileResult)(nil),                  // 32: google.cloud.dataplex.v1.DataProfileResult
	(*DataDiscoveryResult)(nil),                // 33: google.cloud.dataplex.v1.DataDiscoveryResult
	(*DataDocumentationResult)(nil),            // 34: google.cloud.dataplex.v1.DataDocumentationResult
	(*Trigger)(nil),                            // 35: google.cloud.dataplex.v1.Trigger
	(*longrunningpb.Operation)(nil),            // 36: google.longrunning.Operation
}
var file_google_cloud_dataplex_v1_datascans_proto_depIdxs = []int32{
	17, // 0: google.cloud.dataplex.v1.CreateDataScanRequest.data_scan:type_name -> google.cloud.dataplex.v1.DataScan
	17, // 1: google.cloud.dataplex.v1.UpdateDataScanRequest.data_scan:type_name -> google.cloud.dataplex.v1.DataScan
	22, // 2: google.cloud.dataplex.v1.UpdateDataScanRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 3: google.cloud.dataplex.v1.GetDataScanRequest.view:type_name -> google.cloud.dataplex.v1.GetDataScanRequest.DataScanView
	17, // 4: google.cloud.dataplex.v1.ListDataScansResponse.data_scans:type_name -> google.cloud.dataplex.v1.DataScan
	18, // 5: google.cloud.dataplex.v1.RunDataScanResponse.job:type_name -> google.cloud.dataplex.v1.DataScanJob
	2,  // 6: google.cloud.dataplex.v1.GetDataScanJobRequest.view:type_name -> google.cloud.dataplex.v1.GetDataScanJobRequest.DataScanJobView
	18, // 7: google.cloud.dataplex.v1.ListDataScanJobsResponse.data_scan_jobs:type_name -> google.cloud.dataplex.v1.DataScanJob
	23, // 8: google.cloud.dataplex.v1.GenerateDataQualityRulesResponse.rule:type_name -> google.cloud.dataplex.v1.DataQualityRule
	21, // 9: google.cloud.dataplex.v1.DataScan.labels:type_name -> google.cloud.dataplex.v1.DataScan.LabelsEntry
	24, // 10: google.cloud.dataplex.v1.DataScan.state:type_name -> google.cloud.dataplex.v1.State
	25, // 11: google.cloud.dataplex.v1.DataScan.create_time:type_name -> google.protobuf.Timestamp
	25, // 12: google.cloud.dataplex.v1.DataScan.update_time:type_name -> google.protobuf.Timestamp
	26, // 13: google.cloud.dataplex.v1.DataScan.data:type_name -> google.cloud.dataplex.v1.DataSource
	19, // 14: google.cloud.dataplex.v1.DataScan.execution_spec:type_name -> google.cloud.dataplex.v1.DataScan.ExecutionSpec
	20, // 15: google.cloud.dataplex.v1.DataScan.execution_status:type_name -> google.cloud.dataplex.v1.DataScan.ExecutionStatus
	0,  // 16: google.cloud.dataplex.v1.DataScan.type:type_name -> google.cloud.dataplex.v1.DataScanType
	27, // 17: google.cloud.dataplex.v1.DataScan.data_quality_spec:type_name -> google.cloud.dataplex.v1.DataQualitySpec
	28, // 18: google.cloud.dataplex.v1.DataScan.data_profile_spec:type_name -> google.cloud.dataplex.v1.DataProfileSpec
	29, // 19: google.cloud.dataplex.v1.DataScan.data_discovery_spec:type_name -> google.cloud.dataplex.v1.DataDiscoverySpec
	30, // 20: google.cloud.dataplex.v1.DataScan.data_documentation_spec:type_name -> google.cloud.dataplex.v1.DataDocumentationSpec
	31, // 21: google.cloud.dataplex.v1.DataScan.data_quality_result:type_name -> google.cloud.dataplex.v1.DataQualityResult
	32, // 22: google.cloud.dataplex.v1.DataScan.data_profile_result:type_name -> google.cloud.dataplex.v1.DataProfileResult
	33, // 23: google.cloud.dataplex.v1.DataScan.data_discovery_result:type_name -> google.cloud.dataplex.v1.DataDiscoveryResult
	34, // 24: google.cloud.dataplex.v1.DataScan.data_documentation_result:type_name -> google.cloud.dataplex.v1.DataDocumentationResult
	25, // 25: google.cloud.dataplex.v1.DataScanJob.create_time:type_name -> google.protobuf.Timestamp
	25, // 26: google.cloud.dataplex.v1.DataScanJob.start_time:type_name -> google.protobuf.Timestamp
	25, // 27: google.cloud.dataplex.v1.DataScanJob.end_time:type_name -> google.protobuf.Timestamp
	3,  // 28: google.cloud.dataplex.v1.DataScanJob.state:type_name -> google.cloud.dataplex.v1.DataScanJob.State
	0,  // 29: google.cloud.dataplex.v1.DataScanJob.type:type_name -> google.cloud.dataplex.v1.DataScanType
	27, // 30: google.cloud.dataplex.v1.DataScanJob.data_quality_spec:type_name -> google.cloud.dataplex.v1.DataQualitySpec
	28, // 31: google.cloud.dataplex.v1.DataScanJob.data_profile_spec:type_name -> google.cloud.dataplex.v1.DataProfileSpec
	29, // 32: google.cloud.dataplex.v1.DataScanJob.data_discovery_spec:type_name -> google.cloud.dataplex.v1.DataDiscoverySpec
	30, // 33: google.cloud.dataplex.v1.DataScanJob.data_documentation_spec:type_name -> google.cloud.dataplex.v1.DataDocumentationSpec
	31, // 34: google.cloud.dataplex.v1.DataScanJob.data_quality_result:type_name -> google.cloud.dataplex.v1.DataQualityResult
	32, // 35: google.cloud.dataplex.v1.DataScanJob.data_profile_result:type_name -> google.cloud.dataplex.v1.DataProfileResult
	33, // 36: google.cloud.dataplex.v1.DataScanJob.data_discovery_result:type_name -> google.cloud.dataplex.v1.DataDiscoveryResult
	34, // 37: google.cloud.dataplex.v1.DataScanJob.data_documentation_result:type_name -> google.cloud.dataplex.v1.DataDocumentationResult
	35, // 38: google.cloud.dataplex.v1.DataScan.ExecutionSpec.trigger:type_name -> google.cloud.dataplex.v1.Trigger
	25, // 39: google.cloud.dataplex.v1.DataScan.ExecutionStatus.latest_job_start_time:type_name -> google.protobuf.Timestamp
	25, // 40: google.cloud.dataplex.v1.DataScan.ExecutionStatus.latest_job_end_time:type_name -> google.protobuf.Timestamp
	25, // 41: google.cloud.dataplex.v1.DataScan.ExecutionStatus.latest_job_create_time:type_name -> google.protobuf.Timestamp
	4,  // 42: google.cloud.dataplex.v1.DataScanService.CreateDataScan:input_type -> google.cloud.dataplex.v1.CreateDataScanRequest
	5,  // 43: google.cloud.dataplex.v1.DataScanService.UpdateDataScan:input_type -> google.cloud.dataplex.v1.UpdateDataScanRequest
	6,  // 44: google.cloud.dataplex.v1.DataScanService.DeleteDataScan:input_type -> google.cloud.dataplex.v1.DeleteDataScanRequest
	7,  // 45: google.cloud.dataplex.v1.DataScanService.GetDataScan:input_type -> google.cloud.dataplex.v1.GetDataScanRequest
	8,  // 46: google.cloud.dataplex.v1.DataScanService.ListDataScans:input_type -> google.cloud.dataplex.v1.ListDataScansRequest
	10, // 47: google.cloud.dataplex.v1.DataScanService.RunDataScan:input_type -> google.cloud.dataplex.v1.RunDataScanRequest
	12, // 48: google.cloud.dataplex.v1.DataScanService.GetDataScanJob:input_type -> google.cloud.dataplex.v1.GetDataScanJobRequest
	13, // 49: google.cloud.dataplex.v1.DataScanService.ListDataScanJobs:input_type -> google.cloud.dataplex.v1.ListDataScanJobsRequest
	15, // 50: google.cloud.dataplex.v1.DataScanService.GenerateDataQualityRules:input_type -> google.cloud.dataplex.v1.GenerateDataQualityRulesRequest
	36, // 51: google.cloud.dataplex.v1.DataScanService.CreateDataScan:output_type -> google.longrunning.Operation
	36, // 52: google.cloud.dataplex.v1.DataScanService.UpdateDataScan:output_type -> google.longrunning.Operation
	36, // 53: google.cloud.dataplex.v1.DataScanService.DeleteDataScan:output_type -> google.longrunning.Operation
	17, // 54: google.cloud.dataplex.v1.DataScanService.GetDataScan:output_type -> google.cloud.dataplex.v1.DataScan
	9,  // 55: google.cloud.dataplex.v1.DataScanService.ListDataScans:output_type -> google.cloud.dataplex.v1.ListDataScansResponse
	11, // 56: google.cloud.dataplex.v1.DataScanService.RunDataScan:output_type -> google.cloud.dataplex.v1.RunDataScanResponse
	18, // 57: google.cloud.dataplex.v1.DataScanService.GetDataScanJob:output_type -> google.cloud.dataplex.v1.DataScanJob
	14, // 58: google.cloud.dataplex.v1.DataScanService.ListDataScanJobs:output_type -> google.cloud.dataplex.v1.ListDataScanJobsResponse
	16, // 59: google.cloud.dataplex.v1.DataScanService.GenerateDataQualityRules:output_type -> google.cloud.dataplex.v1.GenerateDataQualityRulesResponse
	51, // [51:60] is the sub-list for method output_type
	42, // [42:51] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_datascans_proto_init() }
func file_google_cloud_dataplex_v1_datascans_proto_init() {
	if File_google_cloud_dataplex_v1_datascans_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_data_discovery_proto_init()
	file_google_cloud_dataplex_v1_data_documentation_proto_init()
	file_google_cloud_dataplex_v1_data_profile_proto_init()
	file_google_cloud_dataplex_v1_data_quality_proto_init()
	file_google_cloud_dataplex_v1_processing_proto_init()
	file_google_cloud_dataplex_v1_resources_proto_init()
	file_google_cloud_dataplex_v1_service_proto_init()
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13].OneofWrappers = []any{
		(*DataScan_DataQualitySpec)(nil),
		(*DataScan_DataProfileSpec)(nil),
		(*DataScan_DataDiscoverySpec)(nil),
		(*DataScan_DataDocumentationSpec)(nil),
		(*DataScan_DataQualityResult)(nil),
		(*DataScan_DataProfileResult)(nil),
		(*DataScan_DataDiscoveryResult)(nil),
		(*DataScan_DataDocumentationResult)(nil),
	}
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14].OneofWrappers = []any{
		(*DataScanJob_DataQualitySpec)(nil),
		(*DataScanJob_DataProfileSpec)(nil),
		(*DataScanJob_DataDiscoverySpec)(nil),
		(*DataScanJob_DataDocumentationSpec)(nil),
		(*DataScanJob_DataQualityResult)(nil),
		(*DataScanJob_DataProfileResult)(nil),
		(*DataScanJob_DataDiscoveryResult)(nil),
		(*DataScanJob_DataDocumentationResult)(nil),
	}
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[15].OneofWrappers = []any{
		(*DataScan_ExecutionSpec_Field)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_datascans_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataplex_v1_datascans_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_datascans_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_datascans_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_datascans_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_datascans_proto = out.File
	file_google_cloud_dataplex_v1_datascans_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_datascans_proto_goTypes = nil
	file_google_cloud_dataplex_v1_datascans_proto_depIdxs = nil
}
