// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes details about Capacity Blocks in the Amazon Web Services Region that
// you're currently using.
func (c *Client) DescribeCapacityBlocks(ctx context.Context, params *DescribeCapacityBlocksInput, optFns ...func(*Options)) (*DescribeCapacityBlocksOutput, error) {
	if params == nil {
		params = &DescribeCapacityBlocksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCapacityBlocks", params, optFns, c.addOperationDescribeCapacityBlocksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCapacityBlocksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCapacityBlocksInput struct {

	// The IDs of the Capacity Blocks.
	CapacityBlockIds []string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	//  One or more filters.
	//
	//   - capacity-block-id - The ID of the Capacity Block.
	//
	//   - ultraserver-type - The Capacity Block type. The type can be instances or
	//   ultraservers .
	//
	//   - availability-zone - The Availability Zone of the Capacity Block.
	//
	//   - start-date - The date and time at which the Capacity Block was started.
	//
	//   - end-date - The date and time at which the Capacity Block expires. When a
	//   Capacity Block expires, all instances in the Capacity Block are terminated.
	//
	//   - create-date - The date and time at which the Capacity Block was created.
	//
	//   - state - The state of the Capacity Block ( active | expired | unavailable |
	//   cancelled | failed | scheduled | payment-pending | payment-failed ).
	//
	//   - tags - The tags assigned to the Capacity Block.
	Filters []types.Filter

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCapacityBlocksOutput struct {

	// The Capacity Blocks.
	CapacityBlocks []types.CapacityBlock

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCapacityBlocksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeCapacityBlocks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeCapacityBlocks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCapacityBlocks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCapacityBlocks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCapacityBlocksPaginatorOptions is the paginator options for
// DescribeCapacityBlocks
type DescribeCapacityBlocksPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCapacityBlocksPaginator is a paginator for DescribeCapacityBlocks
type DescribeCapacityBlocksPaginator struct {
	options   DescribeCapacityBlocksPaginatorOptions
	client    DescribeCapacityBlocksAPIClient
	params    *DescribeCapacityBlocksInput
	nextToken *string
	firstPage bool
}

// NewDescribeCapacityBlocksPaginator returns a new DescribeCapacityBlocksPaginator
func NewDescribeCapacityBlocksPaginator(client DescribeCapacityBlocksAPIClient, params *DescribeCapacityBlocksInput, optFns ...func(*DescribeCapacityBlocksPaginatorOptions)) *DescribeCapacityBlocksPaginator {
	if params == nil {
		params = &DescribeCapacityBlocksInput{}
	}

	options := DescribeCapacityBlocksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCapacityBlocksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCapacityBlocksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeCapacityBlocks page.
func (p *DescribeCapacityBlocksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCapacityBlocksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeCapacityBlocks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeCapacityBlocksAPIClient is a client that implements the
// DescribeCapacityBlocks operation.
type DescribeCapacityBlocksAPIClient interface {
	DescribeCapacityBlocks(context.Context, *DescribeCapacityBlocksInput, ...func(*Options)) (*DescribeCapacityBlocksOutput, error)
}

var _ DescribeCapacityBlocksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeCapacityBlocks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCapacityBlocks",
	}
}
