// Code generated by protoc-gen-go-aip. DO NOT EDIT.
//
// versions:
// 	protoc-gen-go-aip development
// 	protoc (unknown)
// source: test/single/testdata.proto

package single

import (
	fmt "fmt"
	resourcename "go.einride.tech/aip/resourcename"
	strings "strings"
)

type ShelfResourceName struct {
	Shelf string
}

func (n ShelfResourceName) Validate() error {
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	return nil
}

func (n ShelfResourceName) ContainsWildcard() bool {
	return false || n.Shelf == "-"
}

func (n ShelfResourceName) String() string {
	return resourcename.Sprint(
		"shelves/{shelf}",
		n.Shelf,
	)
}

func (n ShelfResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n ShelfResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *ShelfResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"shelves/{shelf}",
		&n.Shelf,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *ShelfResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n ShelfResourceName) Type() string {
	return "test1.testdata/Shelf"
}

type BookResourceName struct {
	Shelf string
	Book  string
}

func (n ShelfResourceName) BookResourceName(
	book string,
) BookResourceName {
	return BookResourceName{
		Shelf: n.Shelf,
		Book:  book,
	}
}

func (n BookResourceName) Validate() error {
	if n.Shelf == "" {
		return fmt.Errorf("shelf: empty")
	}
	if strings.IndexByte(n.Shelf, '/') != -1 {
		return fmt.Errorf("shelf: contains illegal character '/'")
	}
	if n.Book == "" {
		return fmt.Errorf("book: empty")
	}
	if strings.IndexByte(n.Book, '/') != -1 {
		return fmt.Errorf("book: contains illegal character '/'")
	}
	return nil
}

func (n BookResourceName) ContainsWildcard() bool {
	return false || n.Shelf == "-" || n.Book == "-"
}

func (n BookResourceName) String() string {
	return resourcename.Sprint(
		"shelves/{shelf}/books/{book}",
		n.Shelf,
		n.Book,
	)
}

func (n BookResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

// MarshalText implements the encoding.TextMarshaler interface.
func (n BookResourceName) MarshalText() ([]byte, error) {
	if err := n.Validate(); err != nil {
		return nil, err
	}
	return []byte(n.String()), nil
}

func (n *BookResourceName) UnmarshalString(name string) error {
	err := resourcename.Sscan(
		name,
		"shelves/{shelf}/books/{book}",
		&n.Shelf,
		&n.Book,
	)
	if err != nil {
		return err
	}
	return n.Validate()
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (n *BookResourceName) UnmarshalText(text []byte) error {
	return n.UnmarshalString(string(text))
}

func (n BookResourceName) Type() string {
	return "test1.testdata/Book"
}

func (n BookResourceName) ShelfResourceName() ShelfResourceName {
	return ShelfResourceName{
		Shelf: n.Shelf,
	}
}
