;; Tests for i8x16 [min_s, min_u, max_s, max_u, avgr_u, abs] operations.

(module
  (func (export "i8x16.min_s") (param v128 v128) (result v128) (i8x16.min_s (local.get 0) (local.get 1)))
  (func (export "i8x16.min_u") (param v128 v128) (result v128) (i8x16.min_u (local.get 0) (local.get 1)))
  (func (export "i8x16.max_s") (param v128 v128) (result v128) (i8x16.max_s (local.get 0) (local.get 1)))
  (func (export "i8x16.max_u") (param v128 v128) (result v128) (i8x16.max_u (local.get 0) (local.get 1)))
  (func (export "i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.avgr_u (local.get 0) (local.get 1)))
  (func (export "i8x16.abs") (param v128) (result v128) (i8x16.abs (local.get 0)))
  (func (export "i8x16.popcnt") (param v128) (result v128) (i8x16.popcnt (local.get 0)))
  (func (export "i8x16.min_s_with_const_0") (result v128) (i8x16.min_s (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.min_s_with_const_1") (result v128) (i8x16.min_s (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.min_u_with_const_2") (result v128) (i8x16.min_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.min_u_with_const_3") (result v128) (i8x16.min_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.max_s_with_const_4") (result v128) (i8x16.max_s (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.max_s_with_const_5") (result v128) (i8x16.max_s (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.max_u_with_const_6") (result v128) (i8x16.max_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.max_u_with_const_7") (result v128) (i8x16.max_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.avgr_u_with_const_8") (result v128) (i8x16.avgr_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.avgr_u_with_const_9") (result v128) (i8x16.avgr_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.abs_with_const_10") (result v128) (i8x16.abs (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.popcnt_with_const_11") (result v128) (i8x16.popcnt (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_s_with_const_12") (param v128) (result v128) (i8x16.min_s (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_s_with_const_13") (param v128) (result v128) (i8x16.min_s (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.min_u_with_const_14") (param v128) (result v128) (i8x16.min_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_u_with_const_15") (param v128) (result v128) (i8x16.min_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.max_s_with_const_16") (param v128) (result v128) (i8x16.max_s (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.max_s_with_const_17") (param v128) (result v128) (i8x16.max_s (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.max_u_with_const_18") (param v128) (result v128) (i8x16.max_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.max_u_with_const_19") (param v128) (result v128) (i8x16.max_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.avgr_u_with_const_20") (param v128) (result v128) (i8x16.avgr_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.avgr_u_with_const_21") (param v128) (result v128) (i8x16.avgr_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
)

(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1)
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123)
                                     (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1)
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123)
                                     (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1)
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                     (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123)
                                     (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1)
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1))
                                     (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                     (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                     (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                     (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123)
                                     (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                     (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                     (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                     (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                      (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                      (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1)
                                      (v128.const i8x16 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1))
                                      (v128.const i8x16 0 0 0 0 128 128 128 128 128 128 128 128 255 255 255 255))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                      (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                      (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                      (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                      (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                      (v128.const i8x16 192 192 192 192 192 192 192 192 192 192 192 192 192 192 192 192))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                      (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                      (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                      (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                      (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123)
                                      (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                      (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                      (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                      (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                   (v128.const i8x16 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1 0x1))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                   (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                   (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                   (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3))
                                   (v128.const i8x16 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123 123))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0))
                                   (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                      (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                      (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                      (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3 01_2_3))
                                      (v128.const i8x16 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3 -01_2_3))
                                      (v128.const i8x16 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0 0x0_8_0))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0 -0x0_8_0))
                                      (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))

;; Const vs const
(assert_return (invoke "i8x16.min_s_with_const_0") (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_s_with_const_1") (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0))
(assert_return (invoke "i8x16.min_u_with_const_2") (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_u_with_const_3") (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0))
(assert_return (invoke "i8x16.max_s_with_const_4") (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_s_with_const_5") (v128.const i8x16 3 3 3 3 2 2 2 2 2 2 2 2 3 3 3 3))
(assert_return (invoke "i8x16.max_u_with_const_6") (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_u_with_const_7") (v128.const i8x16 3 3 3 3 2 2 2 2 2 2 2 2 3 3 3 3))
(assert_return (invoke "i8x16.avgr_u_with_const_8") (v128.const i8x16 192 192 192 192 96 96 96 96 96 96 96 96 192 192 192 192))
(assert_return (invoke "i8x16.avgr_u_with_const_9") (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.abs_with_const_10") (v128.const i8x16 128 128 128 128 127 127 127 127 64 64 64 64 1 1 1 1))
(assert_return (invoke "i8x16.popcnt_with_const_11") (v128.const i8x16 1 1 1 1 7 7 7 7 1 1 1 1 8 8 8 8))

;; Param vs const
(assert_return (invoke "i8x16.min_s_with_const_12" (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                                   (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_s_with_const_13" (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0))
(assert_return (invoke "i8x16.min_u_with_const_14" (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                                   (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_u_with_const_15" (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0))
(assert_return (invoke "i8x16.max_s_with_const_16" (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                                   (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_s_with_const_17" (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0))
                                                   (v128.const i8x16 3 3 3 3 2 2 2 2 2 2 2 2 3 3 3 3))
(assert_return (invoke "i8x16.max_u_with_const_18" (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                                   (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_u_with_const_19" (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0))
                                                   (v128.const i8x16 3 3 3 3 2 2 2 2 2 2 2 2 3 3 3 3))
(assert_return (invoke "i8x16.avgr_u_with_const_20" (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                                    (v128.const i8x16 192 192 192 192 96 96 96 96 96 96 96 96 192 192 192 192))
(assert_return (invoke "i8x16.avgr_u_with_const_21" (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0))
                                                    (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))

;; Test different lanes go through different if-then clauses
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)
                                     (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                     (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 128 128 128 128)
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 1 1 1 1 128 128 128 128))
                                     (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 128 128 128 128))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)
                                     (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                     (v128.const i8x16 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 128 128 128 128)
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 1 1 1 1 128 128 128 128))
                                     (v128.const i8x16 0 0 0 0 1 1 1 1 1 1 1 1 128 128 128 128))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)
                                     (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                     (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 128 128 128 128)
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 1 1 1 1 128 128 128 128))
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 2 2 2 2 128 128 128 128))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)
                                     (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                     (v128.const i8x16 255 255 255 255 127 127 127 127 127 127 127 127 255 255 255 255))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 128 128 128 128)
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 1 1 1 1 128 128 128 128))
                                     (v128.const i8x16 0 0 0 0 2 2 2 2 2 2 2 2 128 128 128 128))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)
                                      (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128))
                                      (v128.const i8x16 192 192 192 192 96 96 96 96 96 96 96 96 192 192 192 192))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 128 128 128 128)
                                      (v128.const i8x16 0 0 0 0 2 2 2 2 1 1 1 1 128 128 128 128))
                                      (v128.const i8x16 0 0 0 0 2 2 2 2 2 2 2 2 128 128 128 128))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255))
                                   (v128.const i8x16 128 128 128 128 127 127 127 127 64 64 64 64 1 1 1 1))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255))
                                      (v128.const i8x16 1 1 1 1 7 7 7 7 1 1 1 1 8 8 8 8))

;; Test opposite signs of zero
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0)
                                     (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.min_s" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0)
                                     (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.min_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0)
                                     (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.max_s" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0)
                                     (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.max_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0)
                                     (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                     (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0)
                                      (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.avgr_u" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0)
                                      (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
                                   (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                   (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
                                   (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
(assert_return (invoke "i8x16.abs" (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                   (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 +0 +0 +0 +0 +0 +0 +0 +0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 +0 +0 +0 +0 0 0 0 0 -0 -0 -0 -0 0 0 0 0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0 -0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.popcnt" (v128.const i8x16 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0 +0))
                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))

;; Unknown operators
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (f32x4.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (f64x2.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.avgr (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.avgr_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))") "unknown operator")

;; Type check
(assert_invalid (module (func (result v128) (i8x16.min_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.min_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.max_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.max_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.avgr_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.abs (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.popcnt (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i8x16.min_s-1st-arg-empty (result v128)
      (i8x16.min_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.min_s-arg-empty (result v128)
      (i8x16.min_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.min_u-1st-arg-empty (result v128)
      (i8x16.min_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.min_u-arg-empty (result v128)
      (i8x16.min_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.max_s-1st-arg-empty (result v128)
      (i8x16.max_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.max_s-arg-empty (result v128)
      (i8x16.max_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.max_u-1st-arg-empty (result v128)
      (i8x16.max_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.max_u-arg-empty (result v128)
      (i8x16.max_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.avgr_u-1st-arg-empty (result v128)
      (i8x16.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.avgr_u-arg-empty (result v128)
      (i8x16.avgr_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.abs-arg-empty (result v128)
      (i8x16.abs)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.popcnt-arg-empty (result v128)
      (i8x16.popcnt)
    )
  )
  "type mismatch"
)

;; Combination
(module
  (func (export "i8x16.min_s-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.abs") (param v128 v128) (result v128) (i8x16.min_s (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.min_s") (param v128 v128) (result v128) (i8x16.abs (i8x16.min_s (local.get 0) (local.get 1))))
  (func (export "i8x16.min_s-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.min_s (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.min_s") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.min_s (local.get 0) (local.get 1))))
  (func (export "i8x16.min_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.min_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.min_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.min_u (local.get 0) (local.get 1))))
  (func (export "i8x16.min_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.min_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.min_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.min_u (local.get 0) (local.get 1))))
  (func (export "i8x16.max_s-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.abs") (param v128 v128) (result v128) (i8x16.max_s (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.max_s") (param v128 v128) (result v128) (i8x16.abs (i8x16.max_s (local.get 0) (local.get 1))))
  (func (export "i8x16.max_s-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.max_s (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.max_s") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.max_s (local.get 0) (local.get 1))))
  (func (export "i8x16.max_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.max_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.max_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.max_u (local.get 0) (local.get 1))))
  (func (export "i8x16.max_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.max_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.max_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.max_u (local.get 0) (local.get 1))))
  (func (export "i8x16.avgr_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.avgr_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.avgr_u (local.get 0) (local.get 1))))
  (func (export "i8x16.avgr_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.avgr_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.avgr_u (local.get 0) (local.get 1))))
  (func (export "i8x16.abs-i8x16.popcnt") (param v128) (result v128) (i8x16.abs (i8x16.popcnt (local.get 0))))
  (func (export "i8x16.abs-i8x16.abs") (param v128) (result v128) (i8x16.abs (i8x16.abs (local.get 0))))
  (func (export "i8x16.popcnt-i8x16.popcnt") (param v128) (result v128) (i8x16.popcnt (i8x16.popcnt (local.get 0))))
  (func (export "i8x16.popcnt-i8x16.abs") (param v128) (result v128) (i8x16.popcnt (i8x16.abs (local.get 0))))
)

(assert_return (invoke "i8x16.min_s-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_s-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_s-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_s-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_s-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_s-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.abs-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                               (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_s-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.popcnt-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.min_u-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_u-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_u-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.min_u-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.abs-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                               (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.min_u-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.popcnt-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_s-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_s-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_s-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_s-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_s-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_s-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                               (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                               (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_s-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.popcnt-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.max_u-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_u-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_u-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_u-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_u-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                 (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                 (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.max_u-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                               (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                               (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                               (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                               (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.max_u-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.popcnt-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.avgr_u-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                   (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                   (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.avgr_u-i8x16.max_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.avgr_u-i8x16.max_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.avgr_u-i8x16.min_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.avgr_u-i8x16.min_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.avgr_u-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.avgr_u-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4))
(assert_return (invoke "i8x16.popcnt-i8x16.avgr_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.abs-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                (v128.const i8x16 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8))
(assert_return (invoke "i8x16.abs-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt-i8x16.popcnt" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.popcnt-i8x16.abs" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
