/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.identifier;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.RelatedObjectSet;
import org.apache.guacamole.rest.identifier.RelatedObjectSetPatch;
import org.apache.guacamole.rest.identifier.RelatedObjectSetResource;
import org.apache.guacamole.rest.jsonpatch.APIPatch;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RelatedObjectSetResource {
    private static final String OBJECT_PATH = "/";
    private final RelatedObjectSet objects;

    public RelatedObjectSetResource(RelatedObjectSet objects) {
        this.objects = objects;
    }

    @GET
    public Set<String> getObjects() throws GuacamoleException {
        return this.objects.getObjects();
    }

    private void updateRelatedObjectSet(APIPatch.Operation operation, RelatedObjectSetPatch relatedObjectSetPatch, String identifier) throws GuacamoleException {
        switch (1.$SwitchMap$org$apache$guacamole$rest$jsonpatch$APIPatch$Operation[operation.ordinal()]) {
            case 1: {
                relatedObjectSetPatch.addObject(identifier);
                break;
            }
            case 2: {
                relatedObjectSetPatch.removeObject(identifier);
                break;
            }
            default: {
                throw new GuacamoleClientException("Unsupported patch operation: \"" + operation + "\"");
            }
        }
    }

    @PATCH
    public void patchObjects(List<APIPatch<String>> patches) throws GuacamoleException {
        RelatedObjectSetPatch objectPatch = new RelatedObjectSetPatch();
        for (APIPatch<String> patch : patches) {
            String path = patch.getPath();
            if (path.equals(OBJECT_PATH)) {
                String identifier = (String)patch.getValue();
                this.updateRelatedObjectSet(patch.getOp(), objectPatch, identifier);
                continue;
            }
            throw new GuacamoleClientException("Unsupported patch path: \"" + path + "\"");
        }
        objectPatch.apply(this.objects);
    }
}

