/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.event;

import org.apache.guacamole.event.AffectedObject;
import org.apache.guacamole.event.LoggableDetail;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Nameable;
import org.apache.guacamole.net.event.IdentifiableObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffectedObject
implements LoggableDetail {
    private static final Logger logger = LoggerFactory.getLogger(AffectedObject.class);
    private final IdentifiableObjectEvent<?> event;

    public AffectedObject(IdentifiableObjectEvent<?> event) {
        this.event = event;
    }

    public String toString() {
        String objectType;
        Identifiable object = this.event.getObject();
        String identifier = this.event.getObjectIdentifier();
        String dataSource = this.event.getAuthenticationProvider().getIdentifier();
        String name = null;
        if (object instanceof Nameable) {
            try {
                name = ((Nameable)object).getName();
            }
            catch (Error | RuntimeException e) {
                logger.debug("Name of object \"{}\" could not be retrieved.", (Object)identifier, (Object)e);
            }
        }
        switch (1.$SwitchMap$org$apache$guacamole$net$auth$Directory$Type[this.event.getDirectoryType().ordinal()]) {
            case 1: {
                objectType = "active connection";
                break;
            }
            case 2: {
                objectType = "connection";
                break;
            }
            case 3: {
                objectType = "connection group";
                break;
            }
            case 4: {
                objectType = "sharing profile";
                break;
            }
            case 5: {
                if (identifier != null && identifier.equals(this.event.getAuthenticatedUser().getIdentifier())) {
                    return "their own user account within \"" + dataSource + "\"";
                }
                objectType = "user";
                break;
            }
            case 6: {
                objectType = "user group";
                break;
            }
            default: {
                String string = objectType = object != null ? object.getClass().toString() : "an unknown object";
            }
        }
        if (identifier != null) {
            if (name != null) {
                return objectType + " \"" + identifier + "\" within \"" + dataSource + "\" (currently named \"" + name + "\")";
            }
            return objectType + " \"" + identifier + "\" within \"" + dataSource + "\"";
        }
        return objectType + " within \"" + dataSource + "\"";
    }
}

