package main

import (
	"context"
	"log"

	"github.com/spotinst/spotinst-sdk-go/service/organization"
	"github.com/spotinst/spotinst-sdk-go/spotinst"
	"github.com/spotinst/spotinst-sdk-go/spotinst/session"
	"github.com/spotinst/spotinst-sdk-go/spotinst/util/stringutil"
)

func main() {
	// All clients require a Session. The Session provides the client with
	// shared configuration such as account and credentials.
	// A Session should be shared where possible to take advantage of
	// configuration and credential caching. See the session package for
	// more information.
	sess := session.New()

	// Create a new instance of the service's client with a Session.
	// Optional spotinst.Config values can also be provided as variadic
	// arguments to the New function. This option allows you to provide
	// service specific configuration.
	svc := organization.New(sess)

	// Create a new context.
	ctx := context.Background()

	// Create a new group.
	out, err := svc.CreateProgUser(ctx, &organization.ProgrammaticUser{
		Name:        spotinst.String("test-programmatic-user"),
		Description: spotinst.String("description"),
		Accounts: []*organization.Account{
			{
				Id:   spotinst.String("act-a1b2c3d4"),
				Role: spotinst.String("viewer"),
			},
		}, //Accounts and Policies are exclusive
		/*Policies: []*organization.ProgPolicy{
			{
				PolicyId: spotinst.String("pol-abcd1234"),
				AccountIds: []string{
					"act-a1b2c3d4",
				},
			},
		},*/
	})

	if err != nil {
		log.Fatalf("spotinst: failed to create user: %v", err)
	}

	// Output.
	if out.ProgrammaticUser != nil {
		log.Printf("User %q: %s",
			spotinst.StringValue(out.ProgrammaticUser.ProgUserId),
			stringutil.Stringify(out.ProgrammaticUser))
	}
}
