/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.AbstractExtractedModelRule;
import org.gradle.model.internal.inspect.AbstractMethodRuleAction;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.component.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.DefaultTypeBuilder;
import org.gradle.platform.base.plugins.BinaryBasePlugin;
import org.gradle.platform.base.plugins.ComponentBasePlugin;

public class ComponentTypeModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<ComponentType> {
    public static final ModelType<ComponentSpecFactory> COMPONENT_SPEC_FACTORY_CLASS = ModelType.of(ComponentSpecFactory.class);
    private static final ModelReference<ComponentSpecFactory> COMPONENT_SPEC_FACTORY_MODEL_REFERENCE = ModelReference.of(COMPONENT_SPEC_FACTORY_CLASS);
    private static final ModelType<ComponentSpec> COMPONENT_SPEC_MODEL_TYPE = ModelType.of(ComponentSpec.class);
    private static final ModelType<LanguageSourceSet> LANGUAGE_SOURCE_SET_MODEL_TYPE = ModelType.of(LanguageSourceSet.class);
    private static final ModelType<BinarySpec> BINARY_SPEC_MODEL_TYPE = ModelType.of(BinarySpec.class);
    private static final ModelType<SourceComponentSpec> SOURCE_COMPONENT_SPEC_MODEL_TYPE = ModelType.of(SourceComponentSpec.class);
    private static final ModelType<VariantComponentSpec> VARIANT_COMPONENT_SPEC_MODEL_TYPE = ModelType.of(VariantComponentSpec.class);
    private final ModelSchemaStore schemaStore;
    private final ModelReference<ComponentSpecFactory> registryRef;

    public ComponentTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
        this.registryRef = COMPONENT_SPEC_FACTORY_MODEL_REFERENCE;
    }

    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        this.validateIsVoidMethod(ruleDefinition, (RuleSourceValidationProblemCollector)context);
        if (ruleDefinition.getReferences().size() != 1) {
            context.add(ruleDefinition, String.format("A method %s must have a single parameter of type %s.", this.getDescription(), TypeBuilder.class.getName()));
            return null;
        }
        ModelReference subjectReference = ruleDefinition.getSubjectReference();
        ModelType subjectType = subjectReference.getType();
        Class rawSubjectType = subjectType.getRawClass();
        if (!rawSubjectType.equals(TypeBuilder.class)) {
            context.add(ruleDefinition, String.format("A method %s must have a single parameter of type %s.", this.getDescription(), TypeBuilder.class.getName()));
            return null;
        }
        List typeVariables = subjectType.getTypeVariables();
        if (typeVariables.size() != 1) {
            context.add(ruleDefinition, String.format("Parameter of type %s must declare a type parameter.", rawSubjectType.getName()));
            return null;
        }
        ModelType builtType = (ModelType)typeVariables.get(0);
        if (builtType.isWildcard()) {
            context.add(ruleDefinition, String.format("Type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", builtType.toString()));
            return null;
        }
        ComponentTypeRegistrationInfo info = this.componentTypeRegistrationInfoFor(builtType);
        if (info == null) {
            context.add(ruleDefinition, String.format("Type '%s' is not a subtype of '%s'.", builtType.toString(), COMPONENT_SPEC_MODEL_TYPE.toString()));
            return null;
        }
        return new ExtractedTypeRule(ruleDefinition, info, (ModelType<? extends ComponentSpec>)builtType.asSubtype(info.baseInterface));
    }

    private ComponentTypeRegistrationInfo componentTypeRegistrationInfoFor(ModelType<?> builtType) {
        if (LANGUAGE_SOURCE_SET_MODEL_TYPE.isAssignableFrom(builtType)) {
            return new ComponentTypeRegistrationInfo("language", LANGUAGE_SOURCE_SET_MODEL_TYPE, LanguageBasePlugin.class);
        }
        if (BINARY_SPEC_MODEL_TYPE.isAssignableFrom(builtType)) {
            return new ComponentTypeRegistrationInfo("binary", BINARY_SPEC_MODEL_TYPE, BinaryBasePlugin.class);
        }
        if (COMPONENT_SPEC_MODEL_TYPE.isAssignableFrom(builtType)) {
            Class<ComponentModelBasePlugin> requiredPlugin = SOURCE_COMPONENT_SPEC_MODEL_TYPE.isAssignableFrom(builtType) || VARIANT_COMPONENT_SPEC_MODEL_TYPE.isAssignableFrom(builtType) ? ComponentModelBasePlugin.class : ComponentBasePlugin.class;
            return new ComponentTypeRegistrationInfo("component", COMPONENT_SPEC_MODEL_TYPE, requiredPlugin);
        }
        return null;
    }

    private ModelType<?> determineImplementationType(TypeBuilderInternal<?> builder) {
        this.validateInternalViewsAreInterfaces(builder);
        Class<?> implementation = builder.getDefaultImplementation();
        if (implementation == null) {
            return null;
        }
        return ModelType.of(implementation);
    }

    private void validateInternalViewsAreInterfaces(TypeBuilderInternal<?> builder) {
        for (Class<?> internalView : builder.getInternalViews()) {
            if (internalView.isInterface()) continue;
            throw new InvalidModelException(String.format("Internal view %s must be an interface.", internalView.getName()));
        }
    }

    private static class ComponentTypeRegistrationInfo {
        private final String modelName;
        private final ModelType<? extends ComponentSpec> baseInterface;
        private final List<Class<?>> requiredPlugins;

        private ComponentTypeRegistrationInfo(String modelName, ModelType<? extends ComponentSpec> baseInterface, Class<?> requiredPlugins) {
            this.modelName = modelName;
            this.baseInterface = baseInterface;
            this.requiredPlugins = ImmutableList.of(requiredPlugins);
        }
    }

    private class ExtractedTypeRule
    extends AbstractExtractedModelRule {
        private final ComponentTypeRegistrationInfo info;
        private final ModelType<? extends ComponentSpec> modelType;

        public ExtractedTypeRule(MethodRuleDefinition<?, ?> ruleDefinition, ComponentTypeRegistrationInfo info, ModelType<? extends ComponentSpec> modelType) {
            super(ruleDefinition);
            this.info = info;
            this.modelType = modelType;
        }

        public List<? extends Class<?>> getRuleDependencies() {
            return this.info.requiredPlugins;
        }

        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            context.getRegistry().configure(ModelActionRole.Mutate, context.contextualize((MethodRuleAction)new TypeRegistrationAction()));
        }

        private class TypeRegistrationAction
        extends AbstractMethodRuleAction<ComponentSpecFactory> {
            public TypeRegistrationAction() {
                super(ComponentTypeModelRuleExtractor.this.registryRef, ExtractedTypeRule.this.getRuleDefinition().getDescriptor());
            }

            public List<? extends ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }

            protected void execute(ModelRuleInvoker<?> invoker, ComponentSpecFactory registry, List<ModelView<?>> inputs) {
                try {
                    ModelSchema schema = ComponentTypeModelRuleExtractor.this.schemaStore.getSchema(ExtractedTypeRule.this.modelType);
                    DefaultTypeBuilder builder = new DefaultTypeBuilder(ComponentTypeModelRuleExtractor.this.getAnnotationType(), schema);
                    invoker.invoke(new Object[]{builder});
                    ModelType implModelType = ComponentTypeModelRuleExtractor.this.determineImplementationType(builder);
                    registry.register(ExtractedTypeRule.this.modelType, builder.getInternalViews(), implModelType, this.getDescriptor());
                }
                catch (InvalidModelException e) {
                    throw this.invalidModelRule(ExtractedTypeRule.this.getRuleDefinition(), ExtractedTypeRule.this.info.modelName, e);
                }
            }

            private InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, String modelName, InvalidModelException e) {
                StringBuilder sb = new StringBuilder();
                ruleDefinition.getDescriptor().describeTo((Appendable)sb);
                sb.append(String.format(" is not a valid %s model rule method.", modelName));
                return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
            }
        }
    }
}

