// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ContainerScanSettings A collection of container scan settings
type ContainerScanSettings struct {

	// The scan level
	ScanLevel ContainerScanSettingsScanLevelEnum `mandatory:"true" json:"scanLevel"`
}

func (m ContainerScanSettings) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ContainerScanSettings) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingContainerScanSettingsScanLevelEnum(string(m.ScanLevel)); !ok && m.ScanLevel != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ScanLevel: %s. Supported values are: %s.", m.ScanLevel, strings.Join(GetContainerScanSettingsScanLevelEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ContainerScanSettingsScanLevelEnum Enum with underlying type: string
type ContainerScanSettingsScanLevelEnum string

// Set of constants representing the allowable values for ContainerScanSettingsScanLevelEnum
const (
	ContainerScanSettingsScanLevelNone     ContainerScanSettingsScanLevelEnum = "NONE"
	ContainerScanSettingsScanLevelStandard ContainerScanSettingsScanLevelEnum = "STANDARD"
)

var mappingContainerScanSettingsScanLevelEnum = map[string]ContainerScanSettingsScanLevelEnum{
	"NONE":     ContainerScanSettingsScanLevelNone,
	"STANDARD": ContainerScanSettingsScanLevelStandard,
}

var mappingContainerScanSettingsScanLevelEnumLowerCase = map[string]ContainerScanSettingsScanLevelEnum{
	"none":     ContainerScanSettingsScanLevelNone,
	"standard": ContainerScanSettingsScanLevelStandard,
}

// GetContainerScanSettingsScanLevelEnumValues Enumerates the set of values for ContainerScanSettingsScanLevelEnum
func GetContainerScanSettingsScanLevelEnumValues() []ContainerScanSettingsScanLevelEnum {
	values := make([]ContainerScanSettingsScanLevelEnum, 0)
	for _, v := range mappingContainerScanSettingsScanLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetContainerScanSettingsScanLevelEnumStringValues Enumerates the set of values in String for ContainerScanSettingsScanLevelEnum
func GetContainerScanSettingsScanLevelEnumStringValues() []string {
	return []string{
		"NONE",
		"STANDARD",
	}
}

// GetMappingContainerScanSettingsScanLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingContainerScanSettingsScanLevelEnum(val string) (ContainerScanSettingsScanLevelEnum, bool) {
	enum, ok := mappingContainerScanSettingsScanLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
