#!/usr/bin/env bash

[[ "$RELEASE_TARGETS" == *"darwin/amd64"* ]] && (echo "Building Darwin AMD64 binary" && GOOS=darwin GOARCH=amd64 $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && tar zcvf ../darwin_amd64.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"darwin/arm64"* ]] && (echo "Building Darwin ARM64 binary" && GOOS=darwin GOARCH=arm64 $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && tar zcvf ../darwin_arm64.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"linux/amd64"* ]] && (echo "Building Linux AMD64 binary" && GOOS=linux GOARCH=amd64 $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && echo "git hash-object: $(git hash-object *)" && tar zcvf ../linux_amd64.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"linux/dbg-amd64"* ]] && (echo "Building Debug Linux AMD64 binary" && GOOS=linux GOARCH=amd64 CGO_ENABLED=1 $GO build -race -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && tar zcvf ../linux_amd64_dbg.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"linux/arm64"* ]] && (echo "Building Linux ARM64 binary" && GOOS=linux GOARCH=arm64 $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && tar zcvf ../linux_arm64.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"linux/arm32"* ]] && (echo "Building Linux ARM binary" && GOOS=linux GOARCH=arm $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && tar zcvf ../linux_arm.tar.gz * && rm *) || :
[[ "$RELEASE_TARGETS" == *"windows/amd64"* ]] && (echo "Building Windows AMD64 binary" && GOOS=windows GOARCH=amd64 $GO build -ldflags "$(bash $DEVGO_SCRIPTS/version-ldflags.sh && echo $BUILD_LDFLAGS)" -o $BUILD_DIR/ $BUILD_PKG && cd $BUILD_DIR && zip -9 -j ../windows_amd64.zip * && rm *) || :
