// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package supplychain

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateBillOfMaterialsImportJob = "CreateBillOfMaterialsImportJob"

// CreateBillOfMaterialsImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateBillOfMaterialsImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBillOfMaterialsImportJob for more information on using the CreateBillOfMaterialsImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBillOfMaterialsImportJobRequest method.
//	req, resp := client.CreateBillOfMaterialsImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob
func (c *SupplyChain) CreateBillOfMaterialsImportJobRequest(input *CreateBillOfMaterialsImportJobInput) (req *request.Request, output *CreateBillOfMaterialsImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateBillOfMaterialsImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/api/configuration/instances/{instanceId}/bill-of-materials-import-jobs",
	}

	if input == nil {
		input = &CreateBillOfMaterialsImportJobInput{}
	}

	output = &CreateBillOfMaterialsImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBillOfMaterialsImportJob API operation for AWS Supply Chain.
//
// CreateBillOfMaterialsImportJob creates an import job for the Product Bill
// Of Materials (BOM) entity. For information on the product_bom entity, see
// the AWS Supply Chain User Guide.
//
// The CSV file must be located in an Amazon S3 location accessible to AWS Supply
// Chain. It is recommended to use the same Amazon S3 bucket created during
// your AWS Supply Chain instance creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Supply Chain's
// API operation CreateBillOfMaterialsImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     You do not have the required privileges to perform this action.
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/CreateBillOfMaterialsImportJob
func (c *SupplyChain) CreateBillOfMaterialsImportJob(input *CreateBillOfMaterialsImportJobInput) (*CreateBillOfMaterialsImportJobOutput, error) {
	req, out := c.CreateBillOfMaterialsImportJobRequest(input)
	return out, req.Send()
}

// CreateBillOfMaterialsImportJobWithContext is the same as CreateBillOfMaterialsImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBillOfMaterialsImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupplyChain) CreateBillOfMaterialsImportJobWithContext(ctx aws.Context, input *CreateBillOfMaterialsImportJobInput, opts ...request.Option) (*CreateBillOfMaterialsImportJobOutput, error) {
	req, out := c.CreateBillOfMaterialsImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBillOfMaterialsImportJob = "GetBillOfMaterialsImportJob"

// GetBillOfMaterialsImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetBillOfMaterialsImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBillOfMaterialsImportJob for more information on using the GetBillOfMaterialsImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBillOfMaterialsImportJobRequest method.
//	req, resp := client.GetBillOfMaterialsImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob
func (c *SupplyChain) GetBillOfMaterialsImportJobRequest(input *GetBillOfMaterialsImportJobInput) (req *request.Request, output *GetBillOfMaterialsImportJobOutput) {
	op := &request.Operation{
		Name:       opGetBillOfMaterialsImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/api/configuration/instances/{instanceId}/bill-of-materials-import-jobs/{jobId}",
	}

	if input == nil {
		input = &GetBillOfMaterialsImportJobInput{}
	}

	output = &GetBillOfMaterialsImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBillOfMaterialsImportJob API operation for AWS Supply Chain.
//
// Get status and details of a BillOfMaterialsImportJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Supply Chain's
// API operation GetBillOfMaterialsImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have the required privileges to perform this action.
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/GetBillOfMaterialsImportJob
func (c *SupplyChain) GetBillOfMaterialsImportJob(input *GetBillOfMaterialsImportJobInput) (*GetBillOfMaterialsImportJobOutput, error) {
	req, out := c.GetBillOfMaterialsImportJobRequest(input)
	return out, req.Send()
}

// GetBillOfMaterialsImportJobWithContext is the same as GetBillOfMaterialsImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetBillOfMaterialsImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupplyChain) GetBillOfMaterialsImportJobWithContext(ctx aws.Context, input *GetBillOfMaterialsImportJobInput, opts ...request.Option) (*GetBillOfMaterialsImportJobOutput, error) {
	req, out := c.GetBillOfMaterialsImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendDataIntegrationEvent = "SendDataIntegrationEvent"

// SendDataIntegrationEventRequest generates a "aws/request.Request" representing the
// client's request for the SendDataIntegrationEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendDataIntegrationEvent for more information on using the SendDataIntegrationEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendDataIntegrationEventRequest method.
//	req, resp := client.SendDataIntegrationEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent
func (c *SupplyChain) SendDataIntegrationEventRequest(input *SendDataIntegrationEventInput) (req *request.Request, output *SendDataIntegrationEventOutput) {
	op := &request.Operation{
		Name:       opSendDataIntegrationEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/api-data/data-integration/instance/{instanceId}/data-integration-events",
	}

	if input == nil {
		input = &SendDataIntegrationEventInput{}
	}

	output = &SendDataIntegrationEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendDataIntegrationEvent API operation for AWS Supply Chain.
//
// Send transactional data events with real-time data for analysis or monitoring.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Supply Chain's
// API operation SendDataIntegrationEvent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have the required privileges to perform this action.
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/SendDataIntegrationEvent
func (c *SupplyChain) SendDataIntegrationEvent(input *SendDataIntegrationEventInput) (*SendDataIntegrationEventOutput, error) {
	req, out := c.SendDataIntegrationEventRequest(input)
	return out, req.Send()
}

// SendDataIntegrationEventWithContext is the same as SendDataIntegrationEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SendDataIntegrationEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupplyChain) SendDataIntegrationEventWithContext(ctx aws.Context, input *SendDataIntegrationEventInput, opts ...request.Option) (*SendDataIntegrationEventOutput, error) {
	req, out := c.SendDataIntegrationEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have the required privileges to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The BillOfMaterialsImportJob details.
type BillOfMaterialsImportJob struct {
	_ struct{} `type:"structure"`

	// The BillOfMaterialsImportJob instanceId.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" min:"36" type:"string" required:"true"`

	// The BillOfMaterialsImportJob jobId.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"36" type:"string" required:"true"`

	// When the BillOfMaterialsImportJob has reached a terminal state, there will
	// be a message.
	Message *string `locationName:"message" type:"string"`

	// The S3 URI from which the CSV is read.
	//
	// S3uri is a required field
	S3uri *string `locationName:"s3uri" min:"10" type:"string" required:"true"`

	// The BillOfMaterialsImportJob ConfigurationJobStatus.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ConfigurationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillOfMaterialsImportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillOfMaterialsImportJob) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *BillOfMaterialsImportJob) SetInstanceId(v string) *BillOfMaterialsImportJob {
	s.InstanceId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *BillOfMaterialsImportJob) SetJobId(v string) *BillOfMaterialsImportJob {
	s.JobId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BillOfMaterialsImportJob) SetMessage(v string) *BillOfMaterialsImportJob {
	s.Message = &v
	return s
}

// SetS3uri sets the S3uri field's value.
func (s *BillOfMaterialsImportJob) SetS3uri(v string) *BillOfMaterialsImportJob {
	s.S3uri = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BillOfMaterialsImportJob) SetStatus(v string) *BillOfMaterialsImportJob {
	s.Status = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request parameters for CreateBillOfMaterialsImportJob.
type CreateBillOfMaterialsImportJobInput struct {
	_ struct{} `type:"structure"`

	// An idempotency token.
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The AWS Supply Chain instance identifier.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"instanceId" min:"36" type:"string" required:"true"`

	// The S3 URI of the CSV file to be imported. The bucket must grant permissions
	// for AWS Supply Chain to read the file.
	//
	// S3uri is a required field
	S3uri *string `locationName:"s3uri" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillOfMaterialsImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillOfMaterialsImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBillOfMaterialsImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBillOfMaterialsImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 36))
	}
	if s.S3uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3uri"))
	}
	if s.S3uri != nil && len(*s.S3uri) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("S3uri", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateBillOfMaterialsImportJobInput) SetClientToken(v string) *CreateBillOfMaterialsImportJobInput {
	s.ClientToken = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateBillOfMaterialsImportJobInput) SetInstanceId(v string) *CreateBillOfMaterialsImportJobInput {
	s.InstanceId = &v
	return s
}

// SetS3uri sets the S3uri field's value.
func (s *CreateBillOfMaterialsImportJobInput) SetS3uri(v string) *CreateBillOfMaterialsImportJobInput {
	s.S3uri = &v
	return s
}

// The response parameters of CreateBillOfMaterialsImportJob.
type CreateBillOfMaterialsImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The new BillOfMaterialsImportJob identifier.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillOfMaterialsImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillOfMaterialsImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateBillOfMaterialsImportJobOutput) SetJobId(v string) *CreateBillOfMaterialsImportJobOutput {
	s.JobId = &v
	return s
}

// The request parameters for GetBillOfMaterialsImportJob.
type GetBillOfMaterialsImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The AWS Supply Chain instance identifier.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"instanceId" min:"36" type:"string" required:"true"`

	// The BillOfMaterialsImportJob identifier.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBillOfMaterialsImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBillOfMaterialsImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBillOfMaterialsImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBillOfMaterialsImportJobInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 36))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetBillOfMaterialsImportJobInput) SetInstanceId(v string) *GetBillOfMaterialsImportJobInput {
	s.InstanceId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetBillOfMaterialsImportJobInput) SetJobId(v string) *GetBillOfMaterialsImportJobInput {
	s.JobId = &v
	return s
}

// The response parameters for GetBillOfMaterialsImportJob.
type GetBillOfMaterialsImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The BillOfMaterialsImportJob.
	//
	// Job is a required field
	Job *BillOfMaterialsImportJob `locationName:"job" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBillOfMaterialsImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBillOfMaterialsImportJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *GetBillOfMaterialsImportJobOutput) SetJob(v *BillOfMaterialsImportJob) *GetBillOfMaterialsImportJobOutput {
	s.Job = v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request parameters for SendDataIntegrationEvent.
type SendDataIntegrationEventInput struct {
	_ struct{} `type:"structure"`

	// The idempotent client token.
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The data payload of the event.
	//
	// Data is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendDataIntegrationEventInput's
	// String and GoString methods.
	//
	// Data is a required field
	Data *string `locationName:"data" min:"1" type:"string" required:"true" sensitive:"true"`

	// Event identifier (for example, orderId for InboundOrder) used for data sharing
	// or partitioning.
	//
	// EventGroupId is a required field
	EventGroupId *string `locationName:"eventGroupId" min:"1" type:"string" required:"true"`

	// The event timestamp (in epoch seconds).
	EventTimestamp *time.Time `locationName:"eventTimestamp" type:"timestamp" timestampFormat:"unixTimestamp"`

	// The data event type.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"DataIntegrationEventType"`

	// The AWS Supply Chain instance identifier.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"instanceId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataIntegrationEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataIntegrationEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendDataIntegrationEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendDataIntegrationEventInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Data != nil && len(*s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.EventGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventGroupId"))
	}
	if s.EventGroupId != nil && len(*s.EventGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventGroupId", 1))
	}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SendDataIntegrationEventInput) SetClientToken(v string) *SendDataIntegrationEventInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *SendDataIntegrationEventInput) SetData(v string) *SendDataIntegrationEventInput {
	s.Data = &v
	return s
}

// SetEventGroupId sets the EventGroupId field's value.
func (s *SendDataIntegrationEventInput) SetEventGroupId(v string) *SendDataIntegrationEventInput {
	s.EventGroupId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *SendDataIntegrationEventInput) SetEventTimestamp(v time.Time) *SendDataIntegrationEventInput {
	s.EventTimestamp = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *SendDataIntegrationEventInput) SetEventType(v string) *SendDataIntegrationEventInput {
	s.EventType = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *SendDataIntegrationEventInput) SetInstanceId(v string) *SendDataIntegrationEventInput {
	s.InstanceId = &v
	return s
}

// The response parameters for SendDataIntegrationEvent.
type SendDataIntegrationEventOutput struct {
	_ struct{} `type:"structure"`

	// The unique event identifier.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataIntegrationEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataIntegrationEventOutput) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *SendDataIntegrationEventOutput) SetEventId(v string) *SendDataIntegrationEventOutput {
	s.EventId = &v
	return s
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input does not satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The status of the job.
const (
	// ConfigurationJobStatusNew is a ConfigurationJobStatus enum value
	ConfigurationJobStatusNew = "NEW"

	// ConfigurationJobStatusFailed is a ConfigurationJobStatus enum value
	ConfigurationJobStatusFailed = "FAILED"

	// ConfigurationJobStatusInProgress is a ConfigurationJobStatus enum value
	ConfigurationJobStatusInProgress = "IN_PROGRESS"

	// ConfigurationJobStatusQueued is a ConfigurationJobStatus enum value
	ConfigurationJobStatusQueued = "QUEUED"

	// ConfigurationJobStatusSuccess is a ConfigurationJobStatus enum value
	ConfigurationJobStatusSuccess = "SUCCESS"
)

// ConfigurationJobStatus_Values returns all elements of the ConfigurationJobStatus enum
func ConfigurationJobStatus_Values() []string {
	return []string{
		ConfigurationJobStatusNew,
		ConfigurationJobStatusFailed,
		ConfigurationJobStatusInProgress,
		ConfigurationJobStatusQueued,
		ConfigurationJobStatusSuccess,
	}
}

const (
	// DataIntegrationEventTypeScnDataForecast is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataForecast = "scn.data.forecast"

	// DataIntegrationEventTypeScnDataInventorylevel is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataInventorylevel = "scn.data.inventorylevel"

	// DataIntegrationEventTypeScnDataInboundorder is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataInboundorder = "scn.data.inboundorder"

	// DataIntegrationEventTypeScnDataInboundorderline is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataInboundorderline = "scn.data.inboundorderline"

	// DataIntegrationEventTypeScnDataInboundorderlineschedule is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataInboundorderlineschedule = "scn.data.inboundorderlineschedule"

	// DataIntegrationEventTypeScnDataOutboundorderline is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataOutboundorderline = "scn.data.outboundorderline"

	// DataIntegrationEventTypeScnDataOutboundshipment is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataOutboundshipment = "scn.data.outboundshipment"

	// DataIntegrationEventTypeScnDataProcessheader is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataProcessheader = "scn.data.processheader"

	// DataIntegrationEventTypeScnDataProcessoperation is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataProcessoperation = "scn.data.processoperation"

	// DataIntegrationEventTypeScnDataProcessproduct is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataProcessproduct = "scn.data.processproduct"

	// DataIntegrationEventTypeScnDataReservation is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataReservation = "scn.data.reservation"

	// DataIntegrationEventTypeScnDataShipment is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataShipment = "scn.data.shipment"

	// DataIntegrationEventTypeScnDataShipmentstop is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataShipmentstop = "scn.data.shipmentstop"

	// DataIntegrationEventTypeScnDataShipmentstoporder is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataShipmentstoporder = "scn.data.shipmentstoporder"

	// DataIntegrationEventTypeScnDataSupplyplan is a DataIntegrationEventType enum value
	DataIntegrationEventTypeScnDataSupplyplan = "scn.data.supplyplan"
)

// DataIntegrationEventType_Values returns all elements of the DataIntegrationEventType enum
func DataIntegrationEventType_Values() []string {
	return []string{
		DataIntegrationEventTypeScnDataForecast,
		DataIntegrationEventTypeScnDataInventorylevel,
		DataIntegrationEventTypeScnDataInboundorder,
		DataIntegrationEventTypeScnDataInboundorderline,
		DataIntegrationEventTypeScnDataInboundorderlineschedule,
		DataIntegrationEventTypeScnDataOutboundorderline,
		DataIntegrationEventTypeScnDataOutboundshipment,
		DataIntegrationEventTypeScnDataProcessheader,
		DataIntegrationEventTypeScnDataProcessoperation,
		DataIntegrationEventTypeScnDataProcessproduct,
		DataIntegrationEventTypeScnDataReservation,
		DataIntegrationEventTypeScnDataShipment,
		DataIntegrationEventTypeScnDataShipmentstop,
		DataIntegrationEventTypeScnDataShipmentstoporder,
		DataIntegrationEventTypeScnDataSupplyplan,
	}
}
