// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/maps/places/v1/place.proto

package placespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	date "google.golang.org/genproto/googleapis/type/date"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Price level of the place.
type PriceLevel int32

const (
	// Place price level is unspecified or unknown.
	PriceLevel_PRICE_LEVEL_UNSPECIFIED PriceLevel = 0
	PriceLevel_FREE                    PriceLevel = 1
	// Place provides inexpensive services.
	PriceLevel_INEXPENSIVE PriceLevel = 2
	// Place provides moderately priced services.
	PriceLevel_MODERATE PriceLevel = 3
	// Place provides expensive services.
	PriceLevel_EXPENSIVE PriceLevel = 4
	// Place provides very expensive services.
	PriceLevel_VERY_EXPENSIVE PriceLevel = 5
)

// Enum value maps for PriceLevel.
var (
	PriceLevel_name = map[int32]string{
		0: "PRICE_LEVEL_UNSPECIFIED",
		1: "FREE",
		2: "INEXPENSIVE",
		3: "MODERATE",
		4: "EXPENSIVE",
		5: "VERY_EXPENSIVE",
	}
	PriceLevel_value = map[string]int32{
		"PRICE_LEVEL_UNSPECIFIED": 0,
		"FREE":                    1,
		"INEXPENSIVE":             2,
		"MODERATE":                3,
		"EXPENSIVE":               4,
		"VERY_EXPENSIVE":          5,
	}
)

func (x PriceLevel) Enum() *PriceLevel {
	p := new(PriceLevel)
	*p = x
	return p
}

func (x PriceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PriceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[0].Descriptor()
}

func (PriceLevel) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[0]
}

func (x PriceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PriceLevel.Descriptor instead.
func (PriceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0}
}

// Business status for the place.
type Place_BusinessStatus int32

const (
	// Default value. This value is unused.
	Place_BUSINESS_STATUS_UNSPECIFIED Place_BusinessStatus = 0
	// The establishment is operational, not necessarily open now.
	Place_OPERATIONAL Place_BusinessStatus = 1
	// The establishment is temporarily closed.
	Place_CLOSED_TEMPORARILY Place_BusinessStatus = 2
	// The establishment is permanently closed.
	Place_CLOSED_PERMANENTLY Place_BusinessStatus = 3
)

// Enum value maps for Place_BusinessStatus.
var (
	Place_BusinessStatus_name = map[int32]string{
		0: "BUSINESS_STATUS_UNSPECIFIED",
		1: "OPERATIONAL",
		2: "CLOSED_TEMPORARILY",
		3: "CLOSED_PERMANENTLY",
	}
	Place_BusinessStatus_value = map[string]int32{
		"BUSINESS_STATUS_UNSPECIFIED": 0,
		"OPERATIONAL":                 1,
		"CLOSED_TEMPORARILY":          2,
		"CLOSED_PERMANENTLY":          3,
	}
)

func (x Place_BusinessStatus) Enum() *Place_BusinessStatus {
	p := new(Place_BusinessStatus)
	*p = x
	return p
}

func (x Place_BusinessStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Place_BusinessStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[1].Descriptor()
}

func (Place_BusinessStatus) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[1]
}

func (x Place_BusinessStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Place_BusinessStatus.Descriptor instead.
func (Place_BusinessStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 0}
}

// A type used to identify the type of secondary hours.
type Place_OpeningHours_SecondaryHourType int32

const (
	// Default value when secondary hour type is not specified.
	Place_OpeningHours_SECONDARY_HOUR_TYPE_UNSPECIFIED Place_OpeningHours_SecondaryHourType = 0
	// The drive-through hour for banks, restaurants, or pharmacies.
	Place_OpeningHours_DRIVE_THROUGH Place_OpeningHours_SecondaryHourType = 1
	// The happy hour.
	Place_OpeningHours_HAPPY_HOUR Place_OpeningHours_SecondaryHourType = 2
	// The delivery hour.
	Place_OpeningHours_DELIVERY Place_OpeningHours_SecondaryHourType = 3
	// The takeout hour.
	Place_OpeningHours_TAKEOUT Place_OpeningHours_SecondaryHourType = 4
	// The kitchen hour.
	Place_OpeningHours_KITCHEN Place_OpeningHours_SecondaryHourType = 5
	// The breakfast hour.
	Place_OpeningHours_BREAKFAST Place_OpeningHours_SecondaryHourType = 6
	// The lunch hour.
	Place_OpeningHours_LUNCH Place_OpeningHours_SecondaryHourType = 7
	// The dinner hour.
	Place_OpeningHours_DINNER Place_OpeningHours_SecondaryHourType = 8
	// The brunch hour.
	Place_OpeningHours_BRUNCH Place_OpeningHours_SecondaryHourType = 9
	// The pickup hour.
	Place_OpeningHours_PICKUP Place_OpeningHours_SecondaryHourType = 10
	// The access hours for storage places.
	Place_OpeningHours_ACCESS Place_OpeningHours_SecondaryHourType = 11
	// The special hours for seniors.
	Place_OpeningHours_SENIOR_HOURS Place_OpeningHours_SecondaryHourType = 12
	// The online service hours.
	Place_OpeningHours_ONLINE_SERVICE_HOURS Place_OpeningHours_SecondaryHourType = 13
)

// Enum value maps for Place_OpeningHours_SecondaryHourType.
var (
	Place_OpeningHours_SecondaryHourType_name = map[int32]string{
		0:  "SECONDARY_HOUR_TYPE_UNSPECIFIED",
		1:  "DRIVE_THROUGH",
		2:  "HAPPY_HOUR",
		3:  "DELIVERY",
		4:  "TAKEOUT",
		5:  "KITCHEN",
		6:  "BREAKFAST",
		7:  "LUNCH",
		8:  "DINNER",
		9:  "BRUNCH",
		10: "PICKUP",
		11: "ACCESS",
		12: "SENIOR_HOURS",
		13: "ONLINE_SERVICE_HOURS",
	}
	Place_OpeningHours_SecondaryHourType_value = map[string]int32{
		"SECONDARY_HOUR_TYPE_UNSPECIFIED": 0,
		"DRIVE_THROUGH":                   1,
		"HAPPY_HOUR":                      2,
		"DELIVERY":                        3,
		"TAKEOUT":                         4,
		"KITCHEN":                         5,
		"BREAKFAST":                       6,
		"LUNCH":                           7,
		"DINNER":                          8,
		"BRUNCH":                          9,
		"PICKUP":                          10,
		"ACCESS":                          11,
		"SENIOR_HOURS":                    12,
		"ONLINE_SERVICE_HOURS":            13,
	}
)

func (x Place_OpeningHours_SecondaryHourType) Enum() *Place_OpeningHours_SecondaryHourType {
	p := new(Place_OpeningHours_SecondaryHourType)
	*p = x
	return p
}

func (x Place_OpeningHours_SecondaryHourType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Place_OpeningHours_SecondaryHourType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[2].Descriptor()
}

func (Place_OpeningHours_SecondaryHourType) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[2]
}

func (x Place_OpeningHours_SecondaryHourType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Place_OpeningHours_SecondaryHourType.Descriptor instead.
func (Place_OpeningHours_SecondaryHourType) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3, 0}
}

// All the information representing a Place.
type Place struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of a place.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The localized name of the place, suitable as a short human-readable
	// description. For example, "Google Sydney", "Starbucks", "Pyrmont", etc.
	DisplayName *localized_text.LocalizedText `protobuf:"bytes,31,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A set of type tags for this result. For example, "political" and
	// "locality".
	Types []string `protobuf:"bytes,5,rep,name=types,proto3" json:"types,omitempty"`
	// A human-readable phone number for the place, in national format.
	NationalPhoneNumber string `protobuf:"bytes,7,opt,name=national_phone_number,json=nationalPhoneNumber,proto3" json:"national_phone_number,omitempty"`
	// A human-readable phone number for the place, in international format.
	InternationalPhoneNumber string `protobuf:"bytes,8,opt,name=international_phone_number,json=internationalPhoneNumber,proto3" json:"international_phone_number,omitempty"`
	// A full, human-readable address for this place.
	FormattedAddress string `protobuf:"bytes,9,opt,name=formatted_address,json=formattedAddress,proto3" json:"formatted_address,omitempty"`
	// Repeated components for each locality level.
	AddressComponents []*Place_AddressComponent `protobuf:"bytes,10,rep,name=address_components,json=addressComponents,proto3" json:"address_components,omitempty"`
	// Plus code of the place location lat/long.
	PlusCode *Place_PlusCode `protobuf:"bytes,11,opt,name=plus_code,json=plusCode,proto3" json:"plus_code,omitempty"`
	// The position of this place.
	Location *latlng.LatLng `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
	// A viewport suitable for displaying the place on an average-sized map.
	Viewport *viewport.Viewport `protobuf:"bytes,13,opt,name=viewport,proto3" json:"viewport,omitempty"`
	// A rating between 1.0 and 5.0, based on user reviews of this place.
	Rating float64 `protobuf:"fixed64,14,opt,name=rating,proto3" json:"rating,omitempty"`
	// A URL providing more information about this place.
	GoogleMapsUri string `protobuf:"bytes,15,opt,name=google_maps_uri,json=googleMapsUri,proto3" json:"google_maps_uri,omitempty"`
	// The authoritative website for this place, e.g. a business' homepage.
	// Note that for places that are part of a chain (e.g. an IKEA store), this
	// will usually be the website for the individual store, not the overall
	// chain.
	WebsiteUri string `protobuf:"bytes,16,opt,name=website_uri,json=websiteUri,proto3" json:"website_uri,omitempty"`
	// List of reviews about this place.
	Reviews []*Place_Review `protobuf:"bytes,20,rep,name=reviews,proto3" json:"reviews,omitempty"`
	// The regular hours of operation.
	OpeningHours *Place_OpeningHours `protobuf:"bytes,21,opt,name=opening_hours,json=openingHours,proto3" json:"opening_hours,omitempty"`
	// Number of minutes this place's timezone is currently offset from UTC.
	// This is expressed in minutes to support timezones that are offset by
	// fractions of an hour, e.g. X hours and 15 minutes.
	UtcOffsetMinutes int32 `protobuf:"varint,22,opt,name=utc_offset_minutes,json=utcOffsetMinutes,proto3" json:"utc_offset_minutes,omitempty"`
	// The place's address in adr microformat: http://microformats.org/wiki/adr.
	AdrFormatAddress string `protobuf:"bytes,24,opt,name=adr_format_address,json=adrFormatAddress,proto3" json:"adr_format_address,omitempty"`
	// The business status for the place.
	BusinessStatus Place_BusinessStatus `protobuf:"varint,25,opt,name=business_status,json=businessStatus,proto3,enum=google.maps.places.v1.Place_BusinessStatus" json:"business_status,omitempty"`
	// Price level of the place.
	PriceLevel PriceLevel `protobuf:"varint,26,opt,name=price_level,json=priceLevel,proto3,enum=google.maps.places.v1.PriceLevel" json:"price_level,omitempty"`
	// A set of data provider that must be shown with this result.
	Attributions []*Place_Attribution `protobuf:"bytes,27,rep,name=attributions,proto3" json:"attributions,omitempty"`
	// The total number of reviews (with or without text) for this place.
	UserRatingCount int32 `protobuf:"varint,28,opt,name=user_rating_count,json=userRatingCount,proto3" json:"user_rating_count,omitempty"`
	// A truncated URL to an v2 icon mask. User can access different icon type by
	// appending type suffix to the end (eg, ".svg" or ".png").
	IconMaskBaseUri string `protobuf:"bytes,29,opt,name=icon_mask_base_uri,json=iconMaskBaseUri,proto3" json:"icon_mask_base_uri,omitempty"`
	// Background color for icon_mask in hex format, e.g. #909CE1.
	IconBackgroundColor string `protobuf:"bytes,30,opt,name=icon_background_color,json=iconBackgroundColor,proto3" json:"icon_background_color,omitempty"`
	// Specifies if the business supports takeout.
	Takeout *bool `protobuf:"varint,33,opt,name=takeout,proto3,oneof" json:"takeout,omitempty"`
	// Specifies if the business supports delivery.
	Delivery *bool `protobuf:"varint,34,opt,name=delivery,proto3,oneof" json:"delivery,omitempty"`
	// Specifies if the business supports indoor or outdoor seating options.
	DineIn *bool `protobuf:"varint,35,opt,name=dine_in,json=dineIn,proto3,oneof" json:"dine_in,omitempty"`
	// Specifies if the business supports curbside pickup.
	CurbsidePickup *bool `protobuf:"varint,36,opt,name=curbside_pickup,json=curbsidePickup,proto3,oneof" json:"curbside_pickup,omitempty"`
	// Specifies if the place has an entrance that is wheelchair-accessible.
	WheelchairAccessibleEntrance *bool `protobuf:"varint,37,opt,name=wheelchair_accessible_entrance,json=wheelchairAccessibleEntrance,proto3,oneof" json:"wheelchair_accessible_entrance,omitempty"`
	// Specifies if the place supports reservations.
	Reservable *bool `protobuf:"varint,38,opt,name=reservable,proto3,oneof" json:"reservable,omitempty"`
	// Specifies if the place serves breakfast.
	ServesBreakfast *bool `protobuf:"varint,39,opt,name=serves_breakfast,json=servesBreakfast,proto3,oneof" json:"serves_breakfast,omitempty"`
	// Specifies if the place serves lunch.
	ServesLunch *bool `protobuf:"varint,40,opt,name=serves_lunch,json=servesLunch,proto3,oneof" json:"serves_lunch,omitempty"`
	// Specifies if the place serves dinner.
	ServesDinner *bool `protobuf:"varint,41,opt,name=serves_dinner,json=servesDinner,proto3,oneof" json:"serves_dinner,omitempty"`
	// Specifies if the place serves beer.
	ServesBeer *bool `protobuf:"varint,42,opt,name=serves_beer,json=servesBeer,proto3,oneof" json:"serves_beer,omitempty"`
	// Specifies if the place serves wine.
	ServesWine *bool `protobuf:"varint,43,opt,name=serves_wine,json=servesWine,proto3,oneof" json:"serves_wine,omitempty"`
	// Specifies if the place serves brunch.
	ServesBrunch *bool `protobuf:"varint,44,opt,name=serves_brunch,json=servesBrunch,proto3,oneof" json:"serves_brunch,omitempty"`
	// Specifies if the place serves vegetarian food.
	ServesVegetarianFood *bool `protobuf:"varint,45,opt,name=serves_vegetarian_food,json=servesVegetarianFood,proto3,oneof" json:"serves_vegetarian_food,omitempty"`
	// The hours of operation for the next seven days (including today). The time
	// period starts at midnight on the date of the request and ends at 11:59 pm
	// six days later. This field includes the special_days subfield of all hours,
	// set for dates that have exceptional hours.
	CurrentOpeningHours *Place_OpeningHours `protobuf:"bytes,46,opt,name=current_opening_hours,json=currentOpeningHours,proto3" json:"current_opening_hours,omitempty"`
	// Contains an array of entries for the next seven days including information
	// about secondary hours of a business. Secondary hours are different from a
	// business's main hours. For example, a restaurant can specify drive through
	// hours or delivery hours as its secondary hours. This field populates the
	// type subfield, which draws from a predefined list of opening hours types
	// (such as DRIVE_THROUGH, PICKUP, or TAKEOUT) based on the types of the
	// place. This field includes the special_days subfield of all hours, set for
	// dates that have exceptional hours.
	CurrentSecondaryOpeningHours []*Place_OpeningHours `protobuf:"bytes,47,rep,name=current_secondary_opening_hours,json=currentSecondaryOpeningHours,proto3" json:"current_secondary_opening_hours,omitempty"`
	// Contains an array of entries for information about regular secondary hours
	// of a business. Secondary hours are different from a business's main hours.
	// For example, a restaurant can specify drive through hours or delivery hours
	// as its secondary hours. This field populates the type subfield, which draws
	// from a predefined list of opening hours types (such as DRIVE_THROUGH,
	// PICKUP, or TAKEOUT) based on the types of the place.
	SecondaryOpeningHours []*Place_OpeningHours `protobuf:"bytes,49,rep,name=secondary_opening_hours,json=secondaryOpeningHours,proto3" json:"secondary_opening_hours,omitempty"`
	// Contains a summary of the place. A summary is comprised of a textual
	// overview, and also includes the language code for these if applicable.
	// Summary text must be presented as-is and can not be modified or altered.
	EditorialSummary *Place_EditorialSummary `protobuf:"bytes,48,opt,name=editorial_summary,json=editorialSummary,proto3" json:"editorial_summary,omitempty"`
}

func (x *Place) Reset() {
	*x = Place{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place) ProtoMessage() {}

func (x *Place) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place.ProtoReflect.Descriptor instead.
func (*Place) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0}
}

func (x *Place) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Place) GetDisplayName() *localized_text.LocalizedText {
	if x != nil {
		return x.DisplayName
	}
	return nil
}

func (x *Place) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Place) GetNationalPhoneNumber() string {
	if x != nil {
		return x.NationalPhoneNumber
	}
	return ""
}

func (x *Place) GetInternationalPhoneNumber() string {
	if x != nil {
		return x.InternationalPhoneNumber
	}
	return ""
}

func (x *Place) GetFormattedAddress() string {
	if x != nil {
		return x.FormattedAddress
	}
	return ""
}

func (x *Place) GetAddressComponents() []*Place_AddressComponent {
	if x != nil {
		return x.AddressComponents
	}
	return nil
}

func (x *Place) GetPlusCode() *Place_PlusCode {
	if x != nil {
		return x.PlusCode
	}
	return nil
}

func (x *Place) GetLocation() *latlng.LatLng {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Place) GetViewport() *viewport.Viewport {
	if x != nil {
		return x.Viewport
	}
	return nil
}

func (x *Place) GetRating() float64 {
	if x != nil {
		return x.Rating
	}
	return 0
}

func (x *Place) GetGoogleMapsUri() string {
	if x != nil {
		return x.GoogleMapsUri
	}
	return ""
}

func (x *Place) GetWebsiteUri() string {
	if x != nil {
		return x.WebsiteUri
	}
	return ""
}

func (x *Place) GetReviews() []*Place_Review {
	if x != nil {
		return x.Reviews
	}
	return nil
}

func (x *Place) GetOpeningHours() *Place_OpeningHours {
	if x != nil {
		return x.OpeningHours
	}
	return nil
}

func (x *Place) GetUtcOffsetMinutes() int32 {
	if x != nil {
		return x.UtcOffsetMinutes
	}
	return 0
}

func (x *Place) GetAdrFormatAddress() string {
	if x != nil {
		return x.AdrFormatAddress
	}
	return ""
}

func (x *Place) GetBusinessStatus() Place_BusinessStatus {
	if x != nil {
		return x.BusinessStatus
	}
	return Place_BUSINESS_STATUS_UNSPECIFIED
}

func (x *Place) GetPriceLevel() PriceLevel {
	if x != nil {
		return x.PriceLevel
	}
	return PriceLevel_PRICE_LEVEL_UNSPECIFIED
}

func (x *Place) GetAttributions() []*Place_Attribution {
	if x != nil {
		return x.Attributions
	}
	return nil
}

func (x *Place) GetUserRatingCount() int32 {
	if x != nil {
		return x.UserRatingCount
	}
	return 0
}

func (x *Place) GetIconMaskBaseUri() string {
	if x != nil {
		return x.IconMaskBaseUri
	}
	return ""
}

func (x *Place) GetIconBackgroundColor() string {
	if x != nil {
		return x.IconBackgroundColor
	}
	return ""
}

func (x *Place) GetTakeout() bool {
	if x != nil && x.Takeout != nil {
		return *x.Takeout
	}
	return false
}

func (x *Place) GetDelivery() bool {
	if x != nil && x.Delivery != nil {
		return *x.Delivery
	}
	return false
}

func (x *Place) GetDineIn() bool {
	if x != nil && x.DineIn != nil {
		return *x.DineIn
	}
	return false
}

func (x *Place) GetCurbsidePickup() bool {
	if x != nil && x.CurbsidePickup != nil {
		return *x.CurbsidePickup
	}
	return false
}

func (x *Place) GetWheelchairAccessibleEntrance() bool {
	if x != nil && x.WheelchairAccessibleEntrance != nil {
		return *x.WheelchairAccessibleEntrance
	}
	return false
}

func (x *Place) GetReservable() bool {
	if x != nil && x.Reservable != nil {
		return *x.Reservable
	}
	return false
}

func (x *Place) GetServesBreakfast() bool {
	if x != nil && x.ServesBreakfast != nil {
		return *x.ServesBreakfast
	}
	return false
}

func (x *Place) GetServesLunch() bool {
	if x != nil && x.ServesLunch != nil {
		return *x.ServesLunch
	}
	return false
}

func (x *Place) GetServesDinner() bool {
	if x != nil && x.ServesDinner != nil {
		return *x.ServesDinner
	}
	return false
}

func (x *Place) GetServesBeer() bool {
	if x != nil && x.ServesBeer != nil {
		return *x.ServesBeer
	}
	return false
}

func (x *Place) GetServesWine() bool {
	if x != nil && x.ServesWine != nil {
		return *x.ServesWine
	}
	return false
}

func (x *Place) GetServesBrunch() bool {
	if x != nil && x.ServesBrunch != nil {
		return *x.ServesBrunch
	}
	return false
}

func (x *Place) GetServesVegetarianFood() bool {
	if x != nil && x.ServesVegetarianFood != nil {
		return *x.ServesVegetarianFood
	}
	return false
}

func (x *Place) GetCurrentOpeningHours() *Place_OpeningHours {
	if x != nil {
		return x.CurrentOpeningHours
	}
	return nil
}

func (x *Place) GetCurrentSecondaryOpeningHours() []*Place_OpeningHours {
	if x != nil {
		return x.CurrentSecondaryOpeningHours
	}
	return nil
}

func (x *Place) GetSecondaryOpeningHours() []*Place_OpeningHours {
	if x != nil {
		return x.SecondaryOpeningHours
	}
	return nil
}

func (x *Place) GetEditorialSummary() *Place_EditorialSummary {
	if x != nil {
		return x.EditorialSummary
	}
	return nil
}

// The structured components that form the formatted address, if this
// information is available.
type Place_AddressComponent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full text description or name of the address component. For example,
	// an address component for the country Australia may have a long_name of
	// "Australia".
	LongText string `protobuf:"bytes,1,opt,name=long_text,json=longText,proto3" json:"long_text,omitempty"`
	// An abbreviated textual name for the address component, if available. For
	// example, an address component for the country of Australia may have a
	// short_name of "AU".
	ShortText string `protobuf:"bytes,2,opt,name=short_text,json=shortText,proto3" json:"short_text,omitempty"`
	// An array indicating the type(s) of the address component.
	Types []string `protobuf:"bytes,3,rep,name=types,proto3" json:"types,omitempty"`
	// The language used to format this components, in CLDR notation.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Place_AddressComponent) Reset() {
	*x = Place_AddressComponent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_AddressComponent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_AddressComponent) ProtoMessage() {}

func (x *Place_AddressComponent) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_AddressComponent.ProtoReflect.Descriptor instead.
func (*Place_AddressComponent) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Place_AddressComponent) GetLongText() string {
	if x != nil {
		return x.LongText
	}
	return ""
}

func (x *Place_AddressComponent) GetShortText() string {
	if x != nil {
		return x.ShortText
	}
	return ""
}

func (x *Place_AddressComponent) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Place_AddressComponent) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Plus code (http://plus.codes) is a location reference with two formats:
// global code defining a 14mx14m (1/8000th of a degree) or smaller rectangle,
// and compound code, replacing the prefix with a reference location.
type Place_PlusCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place's global (full) code, such as `9FWM33GV+HQ`, representing an
	// 1/8000 by 1/8000 degree area (~14 by 14 meters).
	GlobalCode string `protobuf:"bytes,1,opt,name=global_code,json=globalCode,proto3" json:"global_code,omitempty"`
	// Place's compound code, such as `33GV+HQ, Ramberg, Norway`, containing
	// the suffix of the global code and replacing the prefix with a formatted
	// name of a reference entity.
	CompoundCode string `protobuf:"bytes,2,opt,name=compound_code,json=compoundCode,proto3" json:"compound_code,omitempty"`
}

func (x *Place_PlusCode) Reset() {
	*x = Place_PlusCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_PlusCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_PlusCode) ProtoMessage() {}

func (x *Place_PlusCode) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_PlusCode.ProtoReflect.Descriptor instead.
func (*Place_PlusCode) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Place_PlusCode) GetGlobalCode() string {
	if x != nil {
		return x.GlobalCode
	}
	return ""
}

func (x *Place_PlusCode) GetCompoundCode() string {
	if x != nil {
		return x.CompoundCode
	}
	return ""
}

// Information about a review of the place.
type Place_Review struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp for the review, expressed in seconds since epoch.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// A string of formatted recent time, expressing the review time relative
	// to the current time in a form appropriate for the language and country.
	RelativePublishTimeDescription string `protobuf:"bytes,2,opt,name=relative_publish_time_description,json=relativePublishTimeDescription,proto3" json:"relative_publish_time_description,omitempty"`
	// The localized text of the review.
	Text *localized_text.LocalizedText `protobuf:"bytes,9,opt,name=text,proto3" json:"text,omitempty"`
	// The name of the review author.
	Author string `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	// A link to the review author's profile.
	AuthorUri string `protobuf:"bytes,5,opt,name=author_uri,json=authorUri,proto3" json:"author_uri,omitempty"`
	// The author's profile photo.
	AuthorPhotoUri string `protobuf:"bytes,6,opt,name=author_photo_uri,json=authorPhotoUri,proto3" json:"author_photo_uri,omitempty"`
	// A whole number between 1.0 and 5.0, a.k.a. the number of stars.
	Rating float64 `protobuf:"fixed64,7,opt,name=rating,proto3" json:"rating,omitempty"`
	// A BCP-47 language code indicating the original language of the review.
	// If the review has been translated, then original_language != language.
	// This field contains the main language tag only, and not the secondary tag
	// indicating country or region. For example, all the English reviews are
	// tagged as 'en', and not 'en-AU' or 'en-UK' and so on.This field is empty
	// if there is only a rating with no review text.
	OriginalLanguageCode string `protobuf:"bytes,10,opt,name=original_language_code,json=originalLanguageCode,proto3" json:"original_language_code,omitempty"`
	// A boolean value indicating if the review was translated from the original
	// language it was written in. If a review has been translated,
	// corresponding to a value of true, Google recommends that you indicate
	// this to your users. For example, you can add the following string,
	// “Translated by Google”, to the review.
	Translated bool `protobuf:"varint,11,opt,name=translated,proto3" json:"translated,omitempty"`
}

func (x *Place_Review) Reset() {
	*x = Place_Review{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_Review) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_Review) ProtoMessage() {}

func (x *Place_Review) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_Review.ProtoReflect.Descriptor instead.
func (*Place_Review) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Place_Review) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *Place_Review) GetRelativePublishTimeDescription() string {
	if x != nil {
		return x.RelativePublishTimeDescription
	}
	return ""
}

func (x *Place_Review) GetText() *localized_text.LocalizedText {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *Place_Review) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *Place_Review) GetAuthorUri() string {
	if x != nil {
		return x.AuthorUri
	}
	return ""
}

func (x *Place_Review) GetAuthorPhotoUri() string {
	if x != nil {
		return x.AuthorPhotoUri
	}
	return ""
}

func (x *Place_Review) GetRating() float64 {
	if x != nil {
		return x.Rating
	}
	return 0
}

func (x *Place_Review) GetOriginalLanguageCode() string {
	if x != nil {
		return x.OriginalLanguageCode
	}
	return ""
}

func (x *Place_Review) GetTranslated() bool {
	if x != nil {
		return x.Translated
	}
	return false
}

// Information about business hour of the place.
type Place_OpeningHours struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Is this place open right now?  Always present unless we lack time-of-day
	// or timezone data for these opening hours.
	OpenNow bool `protobuf:"varint,1,opt,name=open_now,json=openNow,proto3" json:"open_now,omitempty"`
	// The periods that this place is open during the week. The periods are in
	// chronological order, starting with Sunday in the place-local timezone. An
	// empty (but not absent) value indicates a place that is never open, e.g.
	// because it is closed temporarily for renovations.
	Periods []*Place_OpeningHours_OpeningHoursPeriod `protobuf:"bytes,2,rep,name=periods,proto3" json:"periods,omitempty"`
	// Localized strings describing the opening hours of this place, one string
	// for each day of the week.  Will be empty if the hours are unknown or
	// could not be converted to localized text. Example: "Sun: 18:00–06:00"
	WeekdayDescriptions []string `protobuf:"bytes,3,rep,name=weekday_descriptions,json=weekdayDescriptions,proto3" json:"weekday_descriptions,omitempty"`
	// A type string used to identify the type of secondary hours.
	SecondaryHourType Place_OpeningHours_SecondaryHourType `protobuf:"varint,4,opt,name=secondary_hour_type,json=secondaryHourType,proto3,enum=google.maps.places.v1.Place_OpeningHours_SecondaryHourType" json:"secondary_hour_type,omitempty"`
	// Structured information for special days that fall within the period that
	// the returned opening hours cover. Special days are days that could impact
	// the business hours of a place, e.g. Christmas day. Set for
	// current_opening_hours and current_secondary_opening_hours if there are
	// exceptional hours.
	SpecialDays []*Place_OpeningHours_SpecialDay `protobuf:"bytes,5,rep,name=special_days,json=specialDays,proto3" json:"special_days,omitempty"`
}

func (x *Place_OpeningHours) Reset() {
	*x = Place_OpeningHours{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_OpeningHours) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours) ProtoMessage() {}

func (x *Place_OpeningHours) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Place_OpeningHours) GetOpenNow() bool {
	if x != nil {
		return x.OpenNow
	}
	return false
}

func (x *Place_OpeningHours) GetPeriods() []*Place_OpeningHours_OpeningHoursPeriod {
	if x != nil {
		return x.Periods
	}
	return nil
}

func (x *Place_OpeningHours) GetWeekdayDescriptions() []string {
	if x != nil {
		return x.WeekdayDescriptions
	}
	return nil
}

func (x *Place_OpeningHours) GetSecondaryHourType() Place_OpeningHours_SecondaryHourType {
	if x != nil {
		return x.SecondaryHourType
	}
	return Place_OpeningHours_SECONDARY_HOUR_TYPE_UNSPECIFIED
}

func (x *Place_OpeningHours) GetSpecialDays() []*Place_OpeningHours_SpecialDay {
	if x != nil {
		return x.SpecialDays
	}
	return nil
}

// Information about data providers of this place.
type Place_Attribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Place's data provider.
	Provider string `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	// URI to the Place's data provider.
	ProviderUri string `protobuf:"bytes,2,opt,name=provider_uri,json=providerUri,proto3" json:"provider_uri,omitempty"`
}

func (x *Place_Attribution) Reset() {
	*x = Place_Attribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_Attribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_Attribution) ProtoMessage() {}

func (x *Place_Attribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_Attribution.ProtoReflect.Descriptor instead.
func (*Place_Attribution) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Place_Attribution) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *Place_Attribution) GetProviderUri() string {
	if x != nil {
		return x.ProviderUri
	}
	return ""
}

// Contains a summary of the place.
type Place_EditorialSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A summary is comprised of a textual overview, and also includes the
	// language code for these if applicable. Summary text must be presented
	// as-is and can not be modified or altered.
	Overview *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *Place_EditorialSummary) Reset() {
	*x = Place_EditorialSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_EditorialSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_EditorialSummary) ProtoMessage() {}

func (x *Place_EditorialSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_EditorialSummary.ProtoReflect.Descriptor instead.
func (*Place_EditorialSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Place_EditorialSummary) GetOverview() *localized_text.LocalizedText {
	if x != nil {
		return x.Overview
	}
	return nil
}

// A period the place remains in open_now status.
type Place_OpeningHours_OpeningHoursPeriod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the place starts to be open.
	Open *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint `protobuf:"bytes,1,opt,name=open,proto3" json:"open,omitempty"`
	// The time that the place starts to be closed.
	Close *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint `protobuf:"bytes,2,opt,name=close,proto3" json:"close,omitempty"`
}

func (x *Place_OpeningHours_OpeningHoursPeriod) Reset() {
	*x = Place_OpeningHours_OpeningHoursPeriod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_OpeningHours_OpeningHoursPeriod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_OpeningHoursPeriod) ProtoMessage() {}

func (x *Place_OpeningHours_OpeningHoursPeriod) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_OpeningHoursPeriod.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_OpeningHoursPeriod) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *Place_OpeningHours_OpeningHoursPeriod) GetOpen() *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint {
	if x != nil {
		return x.Open
	}
	return nil
}

func (x *Place_OpeningHours_OpeningHoursPeriod) GetClose() *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint {
	if x != nil {
		return x.Close
	}
	return nil
}

// Structured information for special days that fall within the period that
// the returned opening hours cover. Special days are days that could impact
// the business hours of a place, e.g. Christmas day.
type Place_OpeningHours_SpecialDay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date of this special day.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
}

func (x *Place_OpeningHours_SpecialDay) Reset() {
	*x = Place_OpeningHours_SpecialDay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_OpeningHours_SpecialDay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_SpecialDay) ProtoMessage() {}

func (x *Place_OpeningHours_SpecialDay) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_SpecialDay.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_SpecialDay) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3, 1}
}

func (x *Place_OpeningHours_SpecialDay) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

// Status changing points.
type Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A day of the week, as an integer in the range 0-6.  0 is Sunday, 1 is
	// Monday, etc.
	Day *int32 `protobuf:"varint,1,opt,name=day,proto3,oneof" json:"day,omitempty"`
	// The hour in 2 digits. Ranges from 00 to 23.
	Hour *int32 `protobuf:"varint,2,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// The minute in 2 digits. Ranges from 00 to 59.
	Minute *int32 `protobuf:"varint,3,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Date of the endpoint expressed in `RFC3339` format in the local
	// timezone for the place. For example 2010-12-31.
	//
	// Deprecated: Marked as deprecated in google/maps/places/v1/place.proto.
	DateDeprecated string `protobuf:"bytes,4,opt,name=date_deprecated,json=dateDeprecated,proto3" json:"date_deprecated,omitempty"`
	// Date in the local timezone for the place.
	Date *date.Date `protobuf:"bytes,6,opt,name=date,proto3" json:"date,omitempty"`
	// Whether or not this endpoint was truncated. Truncation occurs when
	// the real hours are outside the times we are willing to return hours
	// between, so we truncate the hours back to these boundaries. This
	// ensures that at most `24 * 7` hours from midnight of the day of the
	// request are returned.
	Truncated bool `protobuf:"varint,5,opt,name=truncated,proto3" json:"truncated,omitempty"`
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) Reset() {
	*x = Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_place_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) ProtoMessage() {}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3, 0, 0}
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetDay() int32 {
	if x != nil && x.Day != nil {
		return *x.Day
	}
	return 0
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetHour() int32 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetMinute() int32 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

// Deprecated: Marked as deprecated in google/maps/places/v1/place.proto.
func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetDateDeprecated() string {
	if x != nil {
		return x.DateDeprecated
	}
	return ""
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint) GetTruncated() bool {
	if x != nil {
		return x.Truncated
	}
	return false
}

var File_google_maps_places_v1_place_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_place_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65,
	0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x8a, 0x23, 0x0a, 0x05, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x3d, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x68, 0x6f,
	0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x68, 0x6f, 0x6e, 0x65,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x5c, 0x0a, 0x12, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x11,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x42, 0x0a, 0x09, 0x70, 0x6c, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x50, 0x6c, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x70, 0x6c, 0x75,
	0x73, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x6d, 0x61, 0x70, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a,
	0x0b, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x55, 0x72, 0x69, 0x12, 0x3d,
	0x0a, 0x07, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x52, 0x07, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x4e, 0x0a,
	0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52,
	0x0c, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x75, 0x74, 0x63, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x75, 0x74, 0x63, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61,
	0x64, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x64, 0x72, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x0f, 0x62, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x19, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x0e, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x42, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x1a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x4c, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2a, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x75, 0x73,
	0x65, 0x72, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a,
	0x12, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x63, 0x6f, 0x6e, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x61, 0x73, 0x65, 0x55, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x63,
	0x6f, 0x6e, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f,
	0x6c, 0x6f, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x63, 0x6f, 0x6e, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1d,
	0x0a, 0x07, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x21, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x07, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a,
	0x08, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x01, 0x52, 0x08, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1c,
	0x0a, 0x07, 0x64, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6e, 0x18, 0x23, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x02, 0x52, 0x06, 0x64, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f,
	0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x18,
	0x24, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0e, 0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64,
	0x65, 0x50, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1e, 0x77, 0x68,
	0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x25, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x04, 0x52, 0x1c, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x61, 0x6e,
	0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x74, 0x18, 0x27,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x06, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x73, 0x5f, 0x6c, 0x75, 0x6e, 0x63, 0x68, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x07, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x4c, 0x75, 0x6e, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x6e,
	0x6e, 0x65, 0x72, 0x18, 0x29, 0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52, 0x0c, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x73, 0x44, 0x69, 0x6e, 0x6e, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x65, 0x65, 0x72, 0x18, 0x2a, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x65, 0x65, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x6e,
	0x65, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0a, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x73, 0x57, 0x69, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x73, 0x5f, 0x62, 0x72, 0x75, 0x6e, 0x63, 0x68, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x0b, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x72, 0x75, 0x6e, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x67,
	0x65, 0x74, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x5f, 0x66, 0x6f, 0x6f, 0x64, 0x18, 0x2d, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x0c, 0x52, 0x14, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x56, 0x65, 0x67, 0x65,
	0x74, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x46, 0x6f, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x12, 0x5d, 0x0a,
	0x15, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69,
	0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x70, 0x0a, 0x1f,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18,
	0x2f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73,
	0x52, 0x1c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x61,
	0x0a, 0x17, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x31, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70,
	0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x15, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72,
	0x73, 0x12, 0x5a, 0x0a, 0x11, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x10, 0x65, 0x64, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x1a, 0x89, 0x01,
	0x0a, 0x10, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x78, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x50, 0x0a, 0x08, 0x50, 0x6c, 0x75,
	0x73, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x91, 0x03, 0x0a, 0x06,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x21, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x1e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x54, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2e, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x55, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x5f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x55, 0x72,
	0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x1a,
	0xfd, 0x08, 0x0a, 0x0c, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x6f, 0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x77, 0x12, 0x56, 0x0a, 0x07, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69,
	0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48,
	0x6f, 0x75, 0x72, 0x73, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x07, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x77, 0x65, 0x65, 0x6b, 0x64, 0x61, 0x79, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x13, 0x77, 0x65, 0x65, 0x6b, 0x64, 0x61, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6b, 0x0a, 0x13, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x75, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x11, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x75, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x5f, 0x64,
	0x61, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48,
	0x6f, 0x75, 0x72, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x52,
	0x0b, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x73, 0x1a, 0xcf, 0x03, 0x0a,
	0x12, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x62, 0x0a, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x52, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x12, 0x64, 0x0a, 0x05, 0x63, 0x6c, 0x6f, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72,
	0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72,
	0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x1a, 0xee, 0x01,
	0x0a, 0x11, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x03, 0x64, 0x61, 0x79, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f,
	0x75, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x04, 0x68, 0x6f, 0x75, 0x72,
	0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x2b, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x64, 0x61, 0x79, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68,
	0x6f, 0x75, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x1a, 0x33,
	0x0a, 0x0a, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x12, 0x25, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x48, 0x6f, 0x75, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x54, 0x48, 0x52, 0x4f, 0x55, 0x47, 0x48, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x41, 0x50, 0x50, 0x59, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x54, 0x41, 0x4b, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07,
	0x4b, 0x49, 0x54, 0x43, 0x48, 0x45, 0x4e, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x52, 0x45,
	0x41, 0x4b, 0x46, 0x41, 0x53, 0x54, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x55, 0x4e, 0x43,
	0x48, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x08, 0x12,
	0x0a, 0x0a, 0x06, 0x42, 0x52, 0x55, 0x4e, 0x43, 0x48, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x50,
	0x49, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x4e, 0x49, 0x4f, 0x52, 0x5f, 0x48, 0x4f,
	0x55, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x0d, 0x1a,
	0x4c, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x55, 0x72, 0x69, 0x1a, 0x4a, 0x0a,
	0x10, 0x45, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x36, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52,
	0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x22, 0x72, 0x0a, 0x0e, 0x42, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x42,
	0x55, 0x53, 0x49, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x16, 0x0a,
	0x12, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52,
	0x49, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x5f,
	0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x4c, 0x59, 0x10, 0x03, 0x42, 0x0a, 0x0a,
	0x08, 0x5f, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x64, 0x69, 0x6e, 0x65, 0x5f,
	0x69, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64, 0x65, 0x5f,
	0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x77, 0x68, 0x65, 0x65, 0x6c,
	0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65,
	0x5f, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x74, 0x42, 0x0f, 0x0a,
	0x0d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x6c, 0x75, 0x6e, 0x63, 0x68, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x6e, 0x6e, 0x65, 0x72,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x65, 0x65, 0x72,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x6e, 0x65,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x75, 0x6e,
	0x63, 0x68, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x76, 0x65,
	0x67, 0x65, 0x74, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x5f, 0x66, 0x6f, 0x6f, 0x64, 0x2a, 0x75, 0x0a,
	0x0a, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x17, 0x50,
	0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x52, 0x45, 0x45,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x44, 0x45, 0x52, 0x41, 0x54, 0x45, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45, 0x10, 0x04,
	0x12, 0x12, 0x0a, 0x0e, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49,
	0x56, 0x45, 0x10, 0x05, 0x42, 0x9e, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x42, 0x0a, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62,
	0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x06, 0x47,
	0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d,
	0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_place_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_place_proto_rawDescData = file_google_maps_places_v1_place_proto_rawDesc
)

func file_google_maps_places_v1_place_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_place_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_place_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_place_proto_rawDescData)
	})
	return file_google_maps_places_v1_place_proto_rawDescData
}

var file_google_maps_places_v1_place_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_maps_places_v1_place_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_maps_places_v1_place_proto_goTypes = []interface{}{
	(PriceLevel)(0),                                                 // 0: google.maps.places.v1.PriceLevel
	(Place_BusinessStatus)(0),                                       // 1: google.maps.places.v1.Place.BusinessStatus
	(Place_OpeningHours_SecondaryHourType)(0),                       // 2: google.maps.places.v1.Place.OpeningHours.SecondaryHourType
	(*Place)(nil),                                                   // 3: google.maps.places.v1.Place
	(*Place_AddressComponent)(nil),                                  // 4: google.maps.places.v1.Place.AddressComponent
	(*Place_PlusCode)(nil),                                          // 5: google.maps.places.v1.Place.PlusCode
	(*Place_Review)(nil),                                            // 6: google.maps.places.v1.Place.Review
	(*Place_OpeningHours)(nil),                                      // 7: google.maps.places.v1.Place.OpeningHours
	(*Place_Attribution)(nil),                                       // 8: google.maps.places.v1.Place.Attribution
	(*Place_EditorialSummary)(nil),                                  // 9: google.maps.places.v1.Place.EditorialSummary
	(*Place_OpeningHours_OpeningHoursPeriod)(nil),                   // 10: google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod
	(*Place_OpeningHours_SpecialDay)(nil),                           // 11: google.maps.places.v1.Place.OpeningHours.SpecialDay
	(*Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint)(nil), // 12: google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.OpeningHoursPoint
	(*localized_text.LocalizedText)(nil),                            // 13: google.type.LocalizedText
	(*latlng.LatLng)(nil),                                           // 14: google.type.LatLng
	(*viewport.Viewport)(nil),                                       // 15: google.geo.type.Viewport
	(*timestamppb.Timestamp)(nil),                                   // 16: google.protobuf.Timestamp
	(*date.Date)(nil),                                               // 17: google.type.Date
}
var file_google_maps_places_v1_place_proto_depIdxs = []int32{
	13, // 0: google.maps.places.v1.Place.display_name:type_name -> google.type.LocalizedText
	4,  // 1: google.maps.places.v1.Place.address_components:type_name -> google.maps.places.v1.Place.AddressComponent
	5,  // 2: google.maps.places.v1.Place.plus_code:type_name -> google.maps.places.v1.Place.PlusCode
	14, // 3: google.maps.places.v1.Place.location:type_name -> google.type.LatLng
	15, // 4: google.maps.places.v1.Place.viewport:type_name -> google.geo.type.Viewport
	6,  // 5: google.maps.places.v1.Place.reviews:type_name -> google.maps.places.v1.Place.Review
	7,  // 6: google.maps.places.v1.Place.opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	1,  // 7: google.maps.places.v1.Place.business_status:type_name -> google.maps.places.v1.Place.BusinessStatus
	0,  // 8: google.maps.places.v1.Place.price_level:type_name -> google.maps.places.v1.PriceLevel
	8,  // 9: google.maps.places.v1.Place.attributions:type_name -> google.maps.places.v1.Place.Attribution
	7,  // 10: google.maps.places.v1.Place.current_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	7,  // 11: google.maps.places.v1.Place.current_secondary_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	7,  // 12: google.maps.places.v1.Place.secondary_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	9,  // 13: google.maps.places.v1.Place.editorial_summary:type_name -> google.maps.places.v1.Place.EditorialSummary
	16, // 14: google.maps.places.v1.Place.Review.publish_time:type_name -> google.protobuf.Timestamp
	13, // 15: google.maps.places.v1.Place.Review.text:type_name -> google.type.LocalizedText
	10, // 16: google.maps.places.v1.Place.OpeningHours.periods:type_name -> google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod
	2,  // 17: google.maps.places.v1.Place.OpeningHours.secondary_hour_type:type_name -> google.maps.places.v1.Place.OpeningHours.SecondaryHourType
	11, // 18: google.maps.places.v1.Place.OpeningHours.special_days:type_name -> google.maps.places.v1.Place.OpeningHours.SpecialDay
	13, // 19: google.maps.places.v1.Place.EditorialSummary.overview:type_name -> google.type.LocalizedText
	12, // 20: google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.open:type_name -> google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.OpeningHoursPoint
	12, // 21: google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.close:type_name -> google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.OpeningHoursPoint
	17, // 22: google.maps.places.v1.Place.OpeningHours.SpecialDay.date:type_name -> google.type.Date
	17, // 23: google.maps.places.v1.Place.OpeningHours.OpeningHoursPeriod.OpeningHoursPoint.date:type_name -> google.type.Date
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_place_proto_init() }
func file_google_maps_places_v1_place_proto_init() {
	if File_google_maps_places_v1_place_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_maps_places_v1_place_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_AddressComponent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_PlusCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_Review); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_OpeningHours); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_Attribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_EditorialSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_OpeningHours_OpeningHoursPeriod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_OpeningHours_SpecialDay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_place_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place_OpeningHours_OpeningHoursPeriod_OpeningHoursPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_places_v1_place_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_maps_places_v1_place_proto_msgTypes[9].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_place_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_place_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_place_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_place_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_place_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_place_proto = out.File
	file_google_maps_places_v1_place_proto_rawDesc = nil
	file_google_maps_places_v1_place_proto_goTypes = nil
	file_google_maps_places_v1_place_proto_depIdxs = nil
}
