// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/bouncer"
)

// BouncerCreate is the builder for creating a Bouncer entity.
type BouncerCreate struct {
	config
	mutation *BouncerMutation
	hooks    []Hook
}

// SetCreatedAt sets the "created_at" field.
func (bc *BouncerCreate) SetCreatedAt(t time.Time) *BouncerCreate {
	bc.mutation.SetCreatedAt(t)
	return bc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableCreatedAt(t *time.Time) *BouncerCreate {
	if t != nil {
		bc.SetCreatedAt(*t)
	}
	return bc
}

// SetUpdatedAt sets the "updated_at" field.
func (bc *BouncerCreate) SetUpdatedAt(t time.Time) *BouncerCreate {
	bc.mutation.SetUpdatedAt(t)
	return bc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableUpdatedAt(t *time.Time) *BouncerCreate {
	if t != nil {
		bc.SetUpdatedAt(*t)
	}
	return bc
}

// SetName sets the "name" field.
func (bc *BouncerCreate) SetName(s string) *BouncerCreate {
	bc.mutation.SetName(s)
	return bc
}

// SetAPIKey sets the "api_key" field.
func (bc *BouncerCreate) SetAPIKey(s string) *BouncerCreate {
	bc.mutation.SetAPIKey(s)
	return bc
}

// SetRevoked sets the "revoked" field.
func (bc *BouncerCreate) SetRevoked(b bool) *BouncerCreate {
	bc.mutation.SetRevoked(b)
	return bc
}

// SetIPAddress sets the "ip_address" field.
func (bc *BouncerCreate) SetIPAddress(s string) *BouncerCreate {
	bc.mutation.SetIPAddress(s)
	return bc
}

// SetNillableIPAddress sets the "ip_address" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableIPAddress(s *string) *BouncerCreate {
	if s != nil {
		bc.SetIPAddress(*s)
	}
	return bc
}

// SetType sets the "type" field.
func (bc *BouncerCreate) SetType(s string) *BouncerCreate {
	bc.mutation.SetType(s)
	return bc
}

// SetNillableType sets the "type" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableType(s *string) *BouncerCreate {
	if s != nil {
		bc.SetType(*s)
	}
	return bc
}

// SetVersion sets the "version" field.
func (bc *BouncerCreate) SetVersion(s string) *BouncerCreate {
	bc.mutation.SetVersion(s)
	return bc
}

// SetNillableVersion sets the "version" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableVersion(s *string) *BouncerCreate {
	if s != nil {
		bc.SetVersion(*s)
	}
	return bc
}

// SetLastPull sets the "last_pull" field.
func (bc *BouncerCreate) SetLastPull(t time.Time) *BouncerCreate {
	bc.mutation.SetLastPull(t)
	return bc
}

// SetNillableLastPull sets the "last_pull" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableLastPull(t *time.Time) *BouncerCreate {
	if t != nil {
		bc.SetLastPull(*t)
	}
	return bc
}

// SetAuthType sets the "auth_type" field.
func (bc *BouncerCreate) SetAuthType(s string) *BouncerCreate {
	bc.mutation.SetAuthType(s)
	return bc
}

// SetNillableAuthType sets the "auth_type" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableAuthType(s *string) *BouncerCreate {
	if s != nil {
		bc.SetAuthType(*s)
	}
	return bc
}

// SetOsname sets the "osname" field.
func (bc *BouncerCreate) SetOsname(s string) *BouncerCreate {
	bc.mutation.SetOsname(s)
	return bc
}

// SetNillableOsname sets the "osname" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableOsname(s *string) *BouncerCreate {
	if s != nil {
		bc.SetOsname(*s)
	}
	return bc
}

// SetOsversion sets the "osversion" field.
func (bc *BouncerCreate) SetOsversion(s string) *BouncerCreate {
	bc.mutation.SetOsversion(s)
	return bc
}

// SetNillableOsversion sets the "osversion" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableOsversion(s *string) *BouncerCreate {
	if s != nil {
		bc.SetOsversion(*s)
	}
	return bc
}

// SetFeatureflags sets the "featureflags" field.
func (bc *BouncerCreate) SetFeatureflags(s string) *BouncerCreate {
	bc.mutation.SetFeatureflags(s)
	return bc
}

// SetNillableFeatureflags sets the "featureflags" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableFeatureflags(s *string) *BouncerCreate {
	if s != nil {
		bc.SetFeatureflags(*s)
	}
	return bc
}

// SetAutoCreated sets the "auto_created" field.
func (bc *BouncerCreate) SetAutoCreated(b bool) *BouncerCreate {
	bc.mutation.SetAutoCreated(b)
	return bc
}

// SetNillableAutoCreated sets the "auto_created" field if the given value is not nil.
func (bc *BouncerCreate) SetNillableAutoCreated(b *bool) *BouncerCreate {
	if b != nil {
		bc.SetAutoCreated(*b)
	}
	return bc
}

// Mutation returns the BouncerMutation object of the builder.
func (bc *BouncerCreate) Mutation() *BouncerMutation {
	return bc.mutation
}

// Save creates the Bouncer in the database.
func (bc *BouncerCreate) Save(ctx context.Context) (*Bouncer, error) {
	bc.defaults()
	return withHooks(ctx, bc.sqlSave, bc.mutation, bc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (bc *BouncerCreate) SaveX(ctx context.Context) *Bouncer {
	v, err := bc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bc *BouncerCreate) Exec(ctx context.Context) error {
	_, err := bc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bc *BouncerCreate) ExecX(ctx context.Context) {
	if err := bc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bc *BouncerCreate) defaults() {
	if _, ok := bc.mutation.CreatedAt(); !ok {
		v := bouncer.DefaultCreatedAt()
		bc.mutation.SetCreatedAt(v)
	}
	if _, ok := bc.mutation.UpdatedAt(); !ok {
		v := bouncer.DefaultUpdatedAt()
		bc.mutation.SetUpdatedAt(v)
	}
	if _, ok := bc.mutation.IPAddress(); !ok {
		v := bouncer.DefaultIPAddress
		bc.mutation.SetIPAddress(v)
	}
	if _, ok := bc.mutation.AuthType(); !ok {
		v := bouncer.DefaultAuthType
		bc.mutation.SetAuthType(v)
	}
	if _, ok := bc.mutation.AutoCreated(); !ok {
		v := bouncer.DefaultAutoCreated
		bc.mutation.SetAutoCreated(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (bc *BouncerCreate) check() error {
	if _, ok := bc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "Bouncer.created_at"`)}
	}
	if _, ok := bc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "Bouncer.updated_at"`)}
	}
	if _, ok := bc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`ent: missing required field "Bouncer.name"`)}
	}
	if _, ok := bc.mutation.APIKey(); !ok {
		return &ValidationError{Name: "api_key", err: errors.New(`ent: missing required field "Bouncer.api_key"`)}
	}
	if _, ok := bc.mutation.Revoked(); !ok {
		return &ValidationError{Name: "revoked", err: errors.New(`ent: missing required field "Bouncer.revoked"`)}
	}
	if _, ok := bc.mutation.AuthType(); !ok {
		return &ValidationError{Name: "auth_type", err: errors.New(`ent: missing required field "Bouncer.auth_type"`)}
	}
	if _, ok := bc.mutation.AutoCreated(); !ok {
		return &ValidationError{Name: "auto_created", err: errors.New(`ent: missing required field "Bouncer.auto_created"`)}
	}
	return nil
}

func (bc *BouncerCreate) sqlSave(ctx context.Context) (*Bouncer, error) {
	if err := bc.check(); err != nil {
		return nil, err
	}
	_node, _spec := bc.createSpec()
	if err := sqlgraph.CreateNode(ctx, bc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	bc.mutation.id = &_node.ID
	bc.mutation.done = true
	return _node, nil
}

func (bc *BouncerCreate) createSpec() (*Bouncer, *sqlgraph.CreateSpec) {
	var (
		_node = &Bouncer{config: bc.config}
		_spec = sqlgraph.NewCreateSpec(bouncer.Table, sqlgraph.NewFieldSpec(bouncer.FieldID, field.TypeInt))
	)
	if value, ok := bc.mutation.CreatedAt(); ok {
		_spec.SetField(bouncer.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := bc.mutation.UpdatedAt(); ok {
		_spec.SetField(bouncer.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if value, ok := bc.mutation.Name(); ok {
		_spec.SetField(bouncer.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := bc.mutation.APIKey(); ok {
		_spec.SetField(bouncer.FieldAPIKey, field.TypeString, value)
		_node.APIKey = value
	}
	if value, ok := bc.mutation.Revoked(); ok {
		_spec.SetField(bouncer.FieldRevoked, field.TypeBool, value)
		_node.Revoked = value
	}
	if value, ok := bc.mutation.IPAddress(); ok {
		_spec.SetField(bouncer.FieldIPAddress, field.TypeString, value)
		_node.IPAddress = value
	}
	if value, ok := bc.mutation.GetType(); ok {
		_spec.SetField(bouncer.FieldType, field.TypeString, value)
		_node.Type = value
	}
	if value, ok := bc.mutation.Version(); ok {
		_spec.SetField(bouncer.FieldVersion, field.TypeString, value)
		_node.Version = value
	}
	if value, ok := bc.mutation.LastPull(); ok {
		_spec.SetField(bouncer.FieldLastPull, field.TypeTime, value)
		_node.LastPull = &value
	}
	if value, ok := bc.mutation.AuthType(); ok {
		_spec.SetField(bouncer.FieldAuthType, field.TypeString, value)
		_node.AuthType = value
	}
	if value, ok := bc.mutation.Osname(); ok {
		_spec.SetField(bouncer.FieldOsname, field.TypeString, value)
		_node.Osname = value
	}
	if value, ok := bc.mutation.Osversion(); ok {
		_spec.SetField(bouncer.FieldOsversion, field.TypeString, value)
		_node.Osversion = value
	}
	if value, ok := bc.mutation.Featureflags(); ok {
		_spec.SetField(bouncer.FieldFeatureflags, field.TypeString, value)
		_node.Featureflags = value
	}
	if value, ok := bc.mutation.AutoCreated(); ok {
		_spec.SetField(bouncer.FieldAutoCreated, field.TypeBool, value)
		_node.AutoCreated = value
	}
	return _node, _spec
}

// BouncerCreateBulk is the builder for creating many Bouncer entities in bulk.
type BouncerCreateBulk struct {
	config
	err      error
	builders []*BouncerCreate
}

// Save creates the Bouncer entities in the database.
func (bcb *BouncerCreateBulk) Save(ctx context.Context) ([]*Bouncer, error) {
	if bcb.err != nil {
		return nil, bcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(bcb.builders))
	nodes := make([]*Bouncer, len(bcb.builders))
	mutators := make([]Mutator, len(bcb.builders))
	for i := range bcb.builders {
		func(i int, root context.Context) {
			builder := bcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*BouncerMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, bcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, bcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, bcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (bcb *BouncerCreateBulk) SaveX(ctx context.Context) []*Bouncer {
	v, err := bcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bcb *BouncerCreateBulk) Exec(ctx context.Context) error {
	_, err := bcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bcb *BouncerCreateBulk) ExecX(ctx context.Context) {
	if err := bcb.Exec(ctx); err != nil {
		panic(err)
	}
}
