// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/configitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// ConfigItemUpdate is the builder for updating ConfigItem entities.
type ConfigItemUpdate struct {
	config
	hooks    []Hook
	mutation *ConfigItemMutation
}

// Where appends a list predicates to the ConfigItemUpdate builder.
func (ciu *ConfigItemUpdate) Where(ps ...predicate.ConfigItem) *ConfigItemUpdate {
	ciu.mutation.Where(ps...)
	return ciu
}

// SetUpdatedAt sets the "updated_at" field.
func (ciu *ConfigItemUpdate) SetUpdatedAt(t time.Time) *ConfigItemUpdate {
	ciu.mutation.SetUpdatedAt(t)
	return ciu
}

// SetValue sets the "value" field.
func (ciu *ConfigItemUpdate) SetValue(s string) *ConfigItemUpdate {
	ciu.mutation.SetValue(s)
	return ciu
}

// SetNillableValue sets the "value" field if the given value is not nil.
func (ciu *ConfigItemUpdate) SetNillableValue(s *string) *ConfigItemUpdate {
	if s != nil {
		ciu.SetValue(*s)
	}
	return ciu
}

// Mutation returns the ConfigItemMutation object of the builder.
func (ciu *ConfigItemUpdate) Mutation() *ConfigItemMutation {
	return ciu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ciu *ConfigItemUpdate) Save(ctx context.Context) (int, error) {
	ciu.defaults()
	return withHooks(ctx, ciu.sqlSave, ciu.mutation, ciu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ciu *ConfigItemUpdate) SaveX(ctx context.Context) int {
	affected, err := ciu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ciu *ConfigItemUpdate) Exec(ctx context.Context) error {
	_, err := ciu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ciu *ConfigItemUpdate) ExecX(ctx context.Context) {
	if err := ciu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ciu *ConfigItemUpdate) defaults() {
	if _, ok := ciu.mutation.UpdatedAt(); !ok {
		v := configitem.UpdateDefaultUpdatedAt()
		ciu.mutation.SetUpdatedAt(v)
	}
}

func (ciu *ConfigItemUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(configitem.Table, configitem.Columns, sqlgraph.NewFieldSpec(configitem.FieldID, field.TypeInt))
	if ps := ciu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ciu.mutation.UpdatedAt(); ok {
		_spec.SetField(configitem.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := ciu.mutation.Value(); ok {
		_spec.SetField(configitem.FieldValue, field.TypeString, value)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, ciu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{configitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ciu.mutation.done = true
	return n, nil
}

// ConfigItemUpdateOne is the builder for updating a single ConfigItem entity.
type ConfigItemUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *ConfigItemMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (ciuo *ConfigItemUpdateOne) SetUpdatedAt(t time.Time) *ConfigItemUpdateOne {
	ciuo.mutation.SetUpdatedAt(t)
	return ciuo
}

// SetValue sets the "value" field.
func (ciuo *ConfigItemUpdateOne) SetValue(s string) *ConfigItemUpdateOne {
	ciuo.mutation.SetValue(s)
	return ciuo
}

// SetNillableValue sets the "value" field if the given value is not nil.
func (ciuo *ConfigItemUpdateOne) SetNillableValue(s *string) *ConfigItemUpdateOne {
	if s != nil {
		ciuo.SetValue(*s)
	}
	return ciuo
}

// Mutation returns the ConfigItemMutation object of the builder.
func (ciuo *ConfigItemUpdateOne) Mutation() *ConfigItemMutation {
	return ciuo.mutation
}

// Where appends a list predicates to the ConfigItemUpdate builder.
func (ciuo *ConfigItemUpdateOne) Where(ps ...predicate.ConfigItem) *ConfigItemUpdateOne {
	ciuo.mutation.Where(ps...)
	return ciuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ciuo *ConfigItemUpdateOne) Select(field string, fields ...string) *ConfigItemUpdateOne {
	ciuo.fields = append([]string{field}, fields...)
	return ciuo
}

// Save executes the query and returns the updated ConfigItem entity.
func (ciuo *ConfigItemUpdateOne) Save(ctx context.Context) (*ConfigItem, error) {
	ciuo.defaults()
	return withHooks(ctx, ciuo.sqlSave, ciuo.mutation, ciuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ciuo *ConfigItemUpdateOne) SaveX(ctx context.Context) *ConfigItem {
	node, err := ciuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ciuo *ConfigItemUpdateOne) Exec(ctx context.Context) error {
	_, err := ciuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ciuo *ConfigItemUpdateOne) ExecX(ctx context.Context) {
	if err := ciuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ciuo *ConfigItemUpdateOne) defaults() {
	if _, ok := ciuo.mutation.UpdatedAt(); !ok {
		v := configitem.UpdateDefaultUpdatedAt()
		ciuo.mutation.SetUpdatedAt(v)
	}
}

func (ciuo *ConfigItemUpdateOne) sqlSave(ctx context.Context) (_node *ConfigItem, err error) {
	_spec := sqlgraph.NewUpdateSpec(configitem.Table, configitem.Columns, sqlgraph.NewFieldSpec(configitem.FieldID, field.TypeInt))
	id, ok := ciuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "ConfigItem.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ciuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, configitem.FieldID)
		for _, f := range fields {
			if !configitem.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != configitem.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ciuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ciuo.mutation.UpdatedAt(); ok {
		_spec.SetField(configitem.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := ciuo.mutation.Value(); ok {
		_spec.SetField(configitem.FieldValue, field.TypeString, value)
	}
	_node = &ConfigItem{config: ciuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ciuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{configitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ciuo.mutation.done = true
	return _node, nil
}
