// Code generated by ent, DO NOT EDIT.

package decision

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the decision type in the database.
	Label = "decision"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// FieldUntil holds the string denoting the until field in the database.
	FieldUntil = "until"
	// FieldScenario holds the string denoting the scenario field in the database.
	FieldScenario = "scenario"
	// FieldType holds the string denoting the type field in the database.
	FieldType = "type"
	// FieldStartIP holds the string denoting the start_ip field in the database.
	FieldStartIP = "start_ip"
	// FieldEndIP holds the string denoting the end_ip field in the database.
	FieldEndIP = "end_ip"
	// FieldStartSuffix holds the string denoting the start_suffix field in the database.
	FieldStartSuffix = "start_suffix"
	// FieldEndSuffix holds the string denoting the end_suffix field in the database.
	FieldEndSuffix = "end_suffix"
	// FieldIPSize holds the string denoting the ip_size field in the database.
	FieldIPSize = "ip_size"
	// FieldScope holds the string denoting the scope field in the database.
	FieldScope = "scope"
	// FieldValue holds the string denoting the value field in the database.
	FieldValue = "value"
	// FieldOrigin holds the string denoting the origin field in the database.
	FieldOrigin = "origin"
	// FieldSimulated holds the string denoting the simulated field in the database.
	FieldSimulated = "simulated"
	// FieldUUID holds the string denoting the uuid field in the database.
	FieldUUID = "uuid"
	// FieldAlertDecisions holds the string denoting the alert_decisions field in the database.
	FieldAlertDecisions = "alert_decisions"
	// EdgeOwner holds the string denoting the owner edge name in mutations.
	EdgeOwner = "owner"
	// Table holds the table name of the decision in the database.
	Table = "decisions"
	// OwnerTable is the table that holds the owner relation/edge.
	OwnerTable = "decisions"
	// OwnerInverseTable is the table name for the Alert entity.
	// It exists in this package in order to avoid circular dependency with the "alert" package.
	OwnerInverseTable = "alerts"
	// OwnerColumn is the table column denoting the owner relation/edge.
	OwnerColumn = "alert_decisions"
)

// Columns holds all SQL columns for decision fields.
var Columns = []string{
	FieldID,
	FieldCreatedAt,
	FieldUpdatedAt,
	FieldUntil,
	FieldScenario,
	FieldType,
	FieldStartIP,
	FieldEndIP,
	FieldStartSuffix,
	FieldEndSuffix,
	FieldIPSize,
	FieldScope,
	FieldValue,
	FieldOrigin,
	FieldSimulated,
	FieldUUID,
	FieldAlertDecisions,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
	// DefaultSimulated holds the default value on creation for the "simulated" field.
	DefaultSimulated bool
)

// OrderOption defines the ordering options for the Decision queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByUntil orders the results by the until field.
func ByUntil(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUntil, opts...).ToFunc()
}

// ByScenario orders the results by the scenario field.
func ByScenario(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScenario, opts...).ToFunc()
}

// ByType orders the results by the type field.
func ByType(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldType, opts...).ToFunc()
}

// ByStartIP orders the results by the start_ip field.
func ByStartIP(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartIP, opts...).ToFunc()
}

// ByEndIP orders the results by the end_ip field.
func ByEndIP(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndIP, opts...).ToFunc()
}

// ByStartSuffix orders the results by the start_suffix field.
func ByStartSuffix(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartSuffix, opts...).ToFunc()
}

// ByEndSuffix orders the results by the end_suffix field.
func ByEndSuffix(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndSuffix, opts...).ToFunc()
}

// ByIPSize orders the results by the ip_size field.
func ByIPSize(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIPSize, opts...).ToFunc()
}

// ByScope orders the results by the scope field.
func ByScope(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldScope, opts...).ToFunc()
}

// ByValue orders the results by the value field.
func ByValue(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldValue, opts...).ToFunc()
}

// ByOrigin orders the results by the origin field.
func ByOrigin(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOrigin, opts...).ToFunc()
}

// BySimulated orders the results by the simulated field.
func BySimulated(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSimulated, opts...).ToFunc()
}

// ByUUID orders the results by the uuid field.
func ByUUID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUUID, opts...).ToFunc()
}

// ByAlertDecisions orders the results by the alert_decisions field.
func ByAlertDecisions(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAlertDecisions, opts...).ToFunc()
}

// ByOwnerField orders the results by owner field.
func ByOwnerField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newOwnerStep(), sql.OrderByField(field, opts...))
	}
}
func newOwnerStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(OwnerInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
	)
}
