# The Utilization Tests

The Utilization tests ensure that the appropriate information is being gathered for pricing. It is centered around ensuring that the JSON generated by all agents is correct. Each JSON block is a test case, with potentially the following fields:
  - `testname`: The name of the test.
  - `input_total_ram_mib`: The total ram number calculated by the agent.
  - `input_logical_processors`: The number of logical processors calculated by the agent.
  - `input_hostname`: The `hostname` calculated by the agent.
  - `input_full_hostname`: The `full_hostname` calculated by the agent.
  - `input_ip_address`: A string array containing all the values in `ip_address` calculated by the agent.
  - `input_aws_id`: The aws `id` determined by the agent.
  - `input_aws_type`: The aws `type` determined by the agent.
  - `input_aws_zone`: The aws `zone` determined by the agent.
  - `input_environment_variables`: Any environment variables which have been set.
  - `expected_output_json`: The expected JSON output from the agent for the `utilization` hash.

New fields for Google Cloud Platform (gcp), Pivotal Cloud Foundry (pcf), and Azure added as of [Utilization spec version 8](https://source.datanerd.us/agents/agent-specs/blob/master/Utilization.md):
  - `input_gcp_id`: The gcp `id` determined by the agent.
  - `input_gcp_type`: The gcp `machineType` determined by the agent.
  - `input_gcp_name`: The gcp `name` determined by the agent.
  - `input_gcp_zone`: The gcp `zone` determined by the agent.
  - `input_pcf_guid`: The pcf `cf_instance_guid` determined by the agent.
  - `input_pcf_ip`: The pcf `cf_instance_ip` determined by the agent.
  - `input_pcf_mem_limit`: The pcf `memory_limit` determined by the agent.
  - `input_azure_location`: The azure `location` determined by the agent.
  - `input_azure_name`: The azure `name` determined by the agent.
  - `input_azure_id`: The azure `vmId` determined by the agent.
  - `input_azure_size`: The azure `vmSize` determined by the agent.
 
Test cases for `boot_id.json` added as of [Utilization spec version 8](https://source.datanerd.us/agents/agent-specs/blob/master/Utilization.md):
  - `testname`: The name of the test.
  - `input_total_ram_mib`: The total ram number calculated by the agent.
  - `input_logical_processors`: The number of logical processors calculated by the agent.
  - `input_hostname`: The hostname calculated by the agent.
  - `input_boot_id`: The `boot_id` determined by the agent.
  - `expected_output_json`: The expected JSON output from the agent for the utilization hash.
  - `expected_metrics`: Supportability metrics that are either expected or unexpected in a given case. If the `call_count` is 0 it should be asserted that the Supportability metric was not sent.
