// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.27.0
// source: query.sql

package store

import (
	"context"
	"database/sql"
)

const createGame = `-- name: CreateGame :one
INSERT INTO game (answer)
VALUES (?)
RETURNING id, answer
`

func (q *Queries) CreateGame(ctx context.Context, answer sql.NullString) (Game, error) {
	row := q.db.QueryRowContext(ctx, createGame, answer)
	var i Game
	err := row.Scan(&i.ID, &i.Answer)
	return i, err
}

const createGuess = `-- name: CreateGuess :one
INSERT INTO guess (game_id, guess)
VALUES (?, ?)
RETURNING id, game_id, guess
`

type CreateGuessParams struct {
	GameID sql.NullInt64
	Guess  sql.NullString
}

func (q *Queries) CreateGuess(ctx context.Context, arg CreateGuessParams) (Guess, error) {
	row := q.db.QueryRowContext(ctx, createGuess, arg.GameID, arg.Guess)
	var i Guess
	err := row.Scan(&i.ID, &i.GameID, &i.Guess)
	return i, err
}

const getTotalScore = `-- name: GetTotalScore :one
WITH game_scores AS (
    SELECT game.id, (10 * (11 - COUNT(guess.id))) AS score
    FROM game
    INNER JOIN guess victory ON game.id = victory.game_id AND game.answer = victory.guess
    INNER JOIN guess ON game.id = guess.game_id
    GROUP BY game.id
)
SELECT SUM(score) FROM game_scores
`

func (q *Queries) GetTotalScore(ctx context.Context) (sql.NullFloat64, error) {
	row := q.db.QueryRowContext(ctx, getTotalScore)
	var sum sql.NullFloat64
	err := row.Scan(&sum)
	return sum, err
}
