/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.spi.support;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.JDKDerbyHelper;
import org.netbeans.modules.derby.RegisterDerby;
import org.openide.filesystems.FileUtil;

public class DerbySupport {
    private static final Logger LOGGER = Logger.getLogger(DerbySupport.class.getName());

    private DerbySupport() {
    }

    public static void setLocation(String location) {
        LOGGER.log(Level.FINE, "setLocation called for {0}", location);
        String jdkDerbyLocation = JDKDerbyHelper.forDefault().findDerbyLocation();
        String realLocation = jdkDerbyLocation != null ? jdkDerbyLocation : location;
        DerbyOptions.getDefault().trySetLocation(realLocation);
    }

    public static String getLocation() {
        return DerbyOptions.getDefault().getLocation();
    }

    public static void setSystemHome(String systemHome) {
        DerbyOptions.getDefault().setSystemHome(systemHome);
    }

    public static String getSystemHome() {
        return DerbyOptions.getDefault().getSystemHome();
    }

    public static String getDefaultSystemHome() {
        String propertySystemHome = System.getProperty("netbeans.derby.system.home");
        if (propertySystemHome != null) {
            return propertySystemHome;
        }
        String userHome = System.getProperty("user.home");
        String dbDir = ".netbeans-derby";
        String dbDirWindows = "NetBeans/Derby";
        File dbFile = FileUtil.normalizeFile((File)new File(userHome, dbDir));
        if (System.getProperty("os.name").contains("Windows")) {
            String appdataDir = System.getenv("AppData");
            File dbFileWindows = (appdataDir = System.getProperty("org.netbeans.modules.derby.spi.support.DerbySupport.overrideAppData", appdataDir)) != null ? FileUtil.normalizeFile((File)new File(appdataDir, dbDirWindows)) : FileUtil.normalizeFile((File)new File(userHome, dbDirWindows));
            if (dbFileWindows.exists()) {
                return dbFileWindows.getAbsolutePath();
            }
            if (dbFile.exists()) {
                return dbFile.getAbsolutePath();
            }
            return dbFileWindows.getAbsolutePath();
        }
        return dbFile.getAbsolutePath();
    }

    public static void ensureStarted() {
        RegisterDerby.getDefault().ensureStarted(false);
    }
}

