/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConnectionDialog {
    private transient ConnectionDialogMediator mediator;
    private transient Exception storedExp;
    final DialogDescriptor descriptor;
    final Dialog dialog;
    final JButton cancelButton = new JButton(NbBundle.getMessage(ConnectionDialog.class, (String)"ConnectionDlg.CancelOption"));

    public ConnectionDialog(ConnectionDialogMediator mediator, FocusablePanel basePane, String dlgTitle, HelpCtx helpCtx, ActionListener actionListener) {
        this.mediator = mediator;
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            @Override
            public void connectionStarted() {
                ConnectionDialog.this.descriptor.setValid(false);
            }

            @Override
            public void connectionStep(String step) {
            }

            @Override
            public void connectionFinished() {
                ConnectionDialog.this.descriptor.setValid(true);
            }

            @Override
            public void connectionFailed() {
                ConnectionDialog.this.descriptor.setValid(true);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
        PropertyChangeListener propChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName == null || propertyName.equals("valid")) {
                    ConnectionDialog.this.updateValid();
                }
            }
        };
        mediator.addPropertyChangeListener(propChangeListener);
        basePane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectionDialog.class, (String)"ACS_ConnectDialogA11yName"));
        basePane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionDialog.class, (String)"ACS_ConnectDialogA11yDesc"));
        this.descriptor = new DialogDescriptor((Object)basePane, dlgTitle, true, new Object[]{DialogDescriptor.OK_OPTION, this.cancelButton}, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        this.descriptor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("valid".equals(e.getPropertyName())) {
                    ConnectionDialog.this.cancelButton.setEnabled((Boolean)e.getNewValue());
                }
            }
        });
        this.descriptor.setClosingOptions(new Object[0]);
        this.updateValid();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.dialog.setVisible(false);
            }
        });
        basePane.initializeFocus();
        this.dialog.setVisible(false);
    }

    public Window getWindow() {
        return this.dialog;
    }

    public void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void setVisible(boolean mode) {
        this.dialog.setVisible(mode);
    }

    public void setException(Exception e) {
        this.storedExp = e;
    }

    public boolean isException() {
        return this.storedExp != null;
    }

    private void updateValid() {
        boolean valid = this.mediator.getValid();
        this.descriptor.setValid(valid);
    }

    public static abstract class FocusablePanel
    extends JPanel {
        public abstract void initializeFocus();
    }
}

