/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.sql.Blob;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.dataview.table.BlobCellRenderer;
import org.netbeans.modules.db.dataview.table.BooleanCellRenderer;
import org.netbeans.modules.db.dataview.table.CellFocusCustomRenderer;
import org.netbeans.modules.db.dataview.table.ClobCellRenderer;
import org.netbeans.modules.db.dataview.table.NullObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.NumberObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.SQLConstantsCellRenderer;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.netbeans.modules.db.dataview.util.FormatStringValue;
import org.netbeans.modules.db.dataview.util.StringValue;

public class ResultSetCellRenderer
extends DefaultTableCellRenderer {
    protected static final FormatStringValue DATETIME_TO_STRING = new FormatStringValue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    protected static final FormatStringValue TIME_TO_STRING = new FormatStringValue(new SimpleDateFormat("HH:mm:ss"));
    protected static final FormatStringValue Date_TO_STRING = new FormatStringValue(new SimpleDateFormat("yyyy-MM-dd"));
    private final TableCellRenderer NULL_RENDERER = new NullObjectCellRenderer();
    private final TableCellRenderer DEFAULT_RENDERER = new SQLConstantsCellRenderer();
    private final TableCellRenderer NUMBER_RENDERER = new NumberObjectCellRenderer();
    private final TableCellRenderer BOOLEAN_RENDERER = new BooleanCellRenderer();
    private final TableCellRenderer CELL_FOCUS_RENDERER = new CellFocusCustomRenderer();
    private final TableCellRenderer BLOB_RENDERER = new BlobCellRenderer();
    private final TableCellRenderer CLOB_RENDERER = new ClobCellRenderer();
    private StringValue stringValue = null;

    public ResultSetCellRenderer() {
        this(new StringValue(){

            @Override
            public String getString(Object o) {
                return o == null ? "null" : o.toString();
            }
        });
    }

    public ResultSetCellRenderer(StringValue converter) {
        this.stringValue = converter;
    }

    public ResultSetCellRenderer(StringValue converter, float alignment) {
        this(converter);
        this.setAlignmentX(alignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (null == value) {
            return this.NULL_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Number) {
            return this.NUMBER_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (DataViewUtils.isSQLConstantString(value, null)) {
            Component c = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setTableCellToolTip(c, value);
            return c;
        }
        if (value instanceof Boolean) {
            return this.BOOLEAN_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Blob) {
            return this.BLOB_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Clob) {
            return this.CLOB_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (this.stringValue != null) {
            value = this.stringValue.getString(value);
        }
        Component c = this.CELL_FOCUS_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setTableCellToolTip(c, value);
        return c;
    }

    protected void setTableCellToolTip(Component c, Object value) {
        if (c instanceof JComponent) {
            String text = null;
            if (value instanceof String) {
                text = (String)value;
            } else if (value != null) {
                text = value.toString();
            }
            if (text == null) {
                ((JComponent)c).setToolTipText(null);
            } else {
                int limit = Math.min(255, text.length());
                String tooltip = "<html><table border=0 cellspacing=0 cellpadding=0 width=40><tr><td>";
                tooltip = tooltip + DataViewUtils.escapeHTML(text.substring(0, limit)).replace("\n", "<br>").replace(" ", "&nbsp;");
                if (text.length() > 255) {
                    tooltip = tooltip + "<br><br>&hellip;";
                }
                tooltip = tooltip + "</td></tr></table></html>";
                ((JComponent)c).setToolTipText(tooltip);
            }
        }
    }
}

