/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.DecimalAxisUtils;
import org.netbeans.lib.profiler.charts.axis.LongMark;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;

public class DecimalXYItemMarksComputer
extends XYItemMarksComputer {
    private double scale = -1.0;
    private long step = -1L;

    public DecimalXYItemMarksComputer(XYItem item, XYItemPainter painter, ChartContext context, int orientation) {
        super(item, painter, context, orientation);
    }

    @Override
    protected boolean refreshConfiguration() {
        double oldScale = this.scale;
        this.scale = this.context.getViewWidth() == 0L ? -1.0 : this.painter.getItemValueScale(this.item, this.context);
        if (oldScale != this.scale) {
            this.step = this.scale == -1.0 ? -1L : DecimalAxisUtils.getDecimalUnits(this.scale, this.getMinMarksDistance());
            oldScale = this.scale;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int start, int end) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long dataStart = (long)this.painter.getItemValue(start, this.item, this.context) / this.step * this.step;
        long dataEnd = (long)this.painter.getItemValue(end, this.item, this.context) / this.step * this.step;
        final long iterCount = Math.abs(dataEnd - dataStart) / this.step + 2L;
        final long[] iterIndex = new long[]{0L};
        return new AxisMarksComputer.AbstractIterator(){

            @Override
            public boolean hasNext() {
                return iterIndex[0] < iterCount;
            }

            @Override
            public AxisMark next() {
                long value = DecimalXYItemMarksComputer.this.reverse ? dataStart - iterIndex[0] * DecimalXYItemMarksComputer.this.step : dataStart + iterIndex[0] * DecimalXYItemMarksComputer.this.step;
                iterIndex[0] = iterIndex[0] + 1L;
                int position = Utils.checkedInt(DecimalXYItemMarksComputer.this.painter.getItemView(value, DecimalXYItemMarksComputer.this.item, DecimalXYItemMarksComputer.this.context));
                return new LongMark(value, position);
            }
        };
    }
}

