/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CommitInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="repositoryBranch")
    private final String repositoryBranch;
    @JsonProperty(value="commitHash")
    private final String commitHash;

    @Deprecated
    @ConstructorProperties(value={"repositoryUrl", "repositoryBranch", "commitHash"})
    public CommitInfo(String repositoryUrl, String repositoryBranch, String commitHash) {
        this.repositoryUrl = repositoryUrl;
        this.repositoryBranch = repositoryBranch;
        this.commitHash = commitHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getRepositoryBranch() {
        return this.repositoryBranch;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CommitInfo(");
        sb.append("super=").append(super.toString());
        sb.append("repositoryUrl=").append(String.valueOf(this.repositoryUrl));
        sb.append(", repositoryBranch=").append(String.valueOf(this.repositoryBranch));
        sb.append(", commitHash=").append(String.valueOf(this.commitHash));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommitInfo)) {
            return false;
        }
        CommitInfo other = (CommitInfo)((Object)o);
        return Objects.equals(this.repositoryUrl, other.repositoryUrl) && Objects.equals(this.repositoryBranch, other.repositoryBranch) && Objects.equals(this.commitHash, other.commitHash) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.repositoryUrl == null ? 43 : this.repositoryUrl.hashCode());
        result = result * 59 + (this.repositoryBranch == null ? 43 : this.repositoryBranch.hashCode());
        result = result * 59 + (this.commitHash == null ? 43 : this.commitHash.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="repositoryBranch")
        private String repositoryBranch;
        @JsonProperty(value="commitHash")
        private String commitHash;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.__explicitlySet__.add("repositoryUrl");
            return this;
        }

        public Builder repositoryBranch(String repositoryBranch) {
            this.repositoryBranch = repositoryBranch;
            this.__explicitlySet__.add("repositoryBranch");
            return this;
        }

        public Builder commitHash(String commitHash) {
            this.commitHash = commitHash;
            this.__explicitlySet__.add("commitHash");
            return this;
        }

        public CommitInfo build() {
            CommitInfo model = new CommitInfo(this.repositoryUrl, this.repositoryBranch, this.commitHash);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CommitInfo model) {
            if (model.wasPropertyExplicitlySet("repositoryUrl")) {
                this.repositoryUrl(model.getRepositoryUrl());
            }
            if (model.wasPropertyExplicitlySet("repositoryBranch")) {
                this.repositoryBranch(model.getRepositoryBranch());
            }
            if (model.wasPropertyExplicitlySet("commitHash")) {
                this.commitHash(model.getCommitHash());
            }
            return this;
        }
    }
}

