/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.File;
import java.net.URI;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpLocation;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestLocation;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.util.BaseUtilities;

@RunnerHttpClass(runner=RunnerHttpLocation.class)
@RunnerRestClass(runner=RunnerRestLocation.class)
public class CommandLocation
extends Command {
    private static final String COMMAND = "__locations";
    public static final String DOMAIN_ROOT_RESULT_KEY = "Domain-Root_value";
    public static final String BASIC_ROOT_RESULT_KEY = "Base-Root_value";

    public static boolean verifyResult(ResultMap<String, String> resultMap, PayaraServer server) {
        if (!server.isRemote()) {
            boolean result = false;
            String domainRootResult = (String)resultMap.getValue().get(DOMAIN_ROOT_RESULT_KEY);
            String domainRootServer = ServerUtils.getDomainPath(server);
            if (domainRootResult != null && domainRootServer != null) {
                URI rootResult = BaseUtilities.normalizeURI((URI)new File(domainRootResult).toURI());
                URI rootServer = BaseUtilities.normalizeURI((URI)new File(domainRootServer).toURI());
                if (rootResult != null && rootServer != null) {
                    result = rootServer.equals(rootResult);
                }
            }
            return result;
        }
        return true;
    }

    public CommandLocation() {
        super(COMMAND);
    }
}

