/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.ReferencesPanel;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class IndexOverviewAction
extends SystemAction
implements Presenter.Menu {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexOverviewAction.IndexMenu");

    public IndexOverviewAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public String getName() {
        return NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_INDICES_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("javadoc.search");
    }

    public JMenuItem getMenuPresenter() {
        return new IndexMenu();
    }

    private final class IndexMenu
    extends JMenu
    implements HelpCtx.Provider,
    DynamicMenuContent {
        private static final int MAX_ITEMS = 20;
        private int itemHash = 0;

        public IndexMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)IndexOverviewAction.this.getName());
            this.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (IndexMenu.this.getModel().isSelected()) {
                        IndexMenu.this.getPopupMenu2();
                    }
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return items;
        }

        public void getPopupMenu2() {
            List<IndexBuilder.Index> data = IndexBuilder.getDefault().getIndices(false);
            if (data == null) {
                this.itemHash = 0;
                this.removeAll();
                this.add(new MoreReferencesMenuItem());
                return;
            }
            int newHash = data.hashCode();
            if (newHash != this.itemHash) {
                if (err.isLoggable(1)) {
                    err.log("recreating popup menu (" + this.itemHash + " -> " + newHash + ")");
                }
                this.itemHash = newHash;
                this.removeAll();
                int size = data.size();
                if (size != data.size()) {
                    throw new IllegalStateException();
                }
                if (size > 0) {
                    for (int i = 0; i < size && i < 20; ++i) {
                        IndexBuilder.Index index = data.get(i);
                        this.add(new IndexMenuItem(index.display, index.fo));
                    }
                    this.add(new MoreReferencesMenuItem());
                } else {
                    JMenuItem dummy = new JMenuItem(NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_no_indices_found"));
                    dummy.setEnabled(false);
                    this.add(dummy);
                }
            }
        }
    }

    private static final class MoreReferencesMenuItem
    extends JMenuItem
    implements ActionListener {
        public MoreReferencesMenuItem() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_MORE_INDICES_MenuItem"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URL u = ReferencesPanel.showInWindow();
            if (u != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(u);
            }
        }
    }

    private final class IndexMenuItem
    extends JMenuItem
    implements ActionListener,
    HelpCtx.Provider {
        private final URL loc;

        public IndexMenuItem(String display, URL index) {
            super(display);
            this.loc = index;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.loc);
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            if (isIncluded) {
                StatusDisplayer.getDefault().setStatusText(this.loc.toString());
            }
        }
    }
}

