/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

class LinearBoundary {
    private Map<Coordinate, Integer> vertexDegree = new HashMap<Coordinate, Integer>();
    private boolean hasBoundary;
    private BoundaryNodeRule boundaryNodeRule;

    public LinearBoundary(List<LineString> lines, BoundaryNodeRule bnRule) {
        this.boundaryNodeRule = bnRule;
        this.vertexDegree = LinearBoundary.computeBoundaryPoints(lines);
        this.hasBoundary = this.checkBoundary(this.vertexDegree);
    }

    private boolean checkBoundary(Map<Coordinate, Integer> vertexDegree) {
        for (int degree : vertexDegree.values()) {
            if (!this.boundaryNodeRule.isInBoundary(degree)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBoundary() {
        return this.hasBoundary;
    }

    public boolean isBoundary(Coordinate pt) {
        if (!this.vertexDegree.containsKey(pt)) {
            return false;
        }
        int degree = this.vertexDegree.get(pt);
        return this.boundaryNodeRule.isInBoundary(degree);
    }

    private static Map<Coordinate, Integer> computeBoundaryPoints(List<LineString> lines) {
        HashMap<Coordinate, Integer> vertexDegree = new HashMap<Coordinate, Integer>();
        for (LineString line : lines) {
            if (line.isEmpty()) continue;
            LinearBoundary.addEndpoint(line.getCoordinateN(0), vertexDegree);
            LinearBoundary.addEndpoint(line.getCoordinateN(line.getNumPoints() - 1), vertexDegree);
        }
        return vertexDegree;
    }

    private static void addEndpoint(Coordinate p, Map<Coordinate, Integer> degree) {
        int dim = 0;
        if (degree.containsKey(p)) {
            dim = degree.get(p);
        }
        degree.put(p, ++dim);
    }
}

