/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.stages.FindNearestOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Value;

@BetaApi
public final class FindNearest
extends Stage {
    private final Expression property;
    private final VectorValue vector;
    private final DistanceMeasure distanceMeasure;

    @InternalApi
    public FindNearest(Expression property, VectorValue vector, DistanceMeasure distanceMeasure, FindNearestOptions options) {
        super("find_nearest", options.options);
        this.property = property;
        this.vector = vector;
        this.distanceMeasure = distanceMeasure;
    }

    @Override
    Iterable<Value> toStageArgs() {
        return ImmutableList.of((Object)PipelineUtils.encodeValue(this.property), (Object)PipelineUtils.encodeValue(this.vector), (Object)this.distanceMeasure.toProto());
    }

    public static final class DistanceMeasure {
        final String protoString;
        public static final DistanceMeasure EUCLIDEAN = new DistanceMeasure("euclidean");
        public static final DistanceMeasure COSINE = new DistanceMeasure("cosine");
        public static final DistanceMeasure DOT_PRODUCT = new DistanceMeasure("dot_product");

        private DistanceMeasure(String protoString) {
            this.protoString = protoString;
        }

        public static DistanceMeasure generic(String name) {
            return new DistanceMeasure(name);
        }

        Value toProto() {
            return PipelineUtils.encodeValue(this.protoString);
        }
    }
}

