/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.stages.InternalOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Value;
import javax.annotation.Nonnull;

public class ReplaceWith
extends Stage {
    private final Expression expr;
    private final Mode mode;

    public ReplaceWith(@Nonnull Expression field) {
        this(field, Mode.FULL_REPLACE);
    }

    public ReplaceWith(@Nonnull Expression expr, @Nonnull Mode mode) {
        super("replace_with", InternalOptions.EMPTY);
        this.expr = expr;
        this.mode = mode;
    }

    @Override
    Iterable<Value> toStageArgs() {
        return ImmutableList.of((Object)PipelineUtils.encodeValue(this.expr), (Object)this.mode.value);
    }

    public static enum Mode {
        FULL_REPLACE(Value.newBuilder().setStringValue("full_replace").build()),
        MERGE_PREFER_NEXT(Value.newBuilder().setStringValue("merge_prefer_nest").build()),
        MERGE_PREFER_PARENT(Value.newBuilder().setStringValue("merge_prefer_parent").build());

        public final Value value;

        private Mode(Value value) {
            this.value = value;
        }
    }
}

