/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.jetty.util.URIUtil;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public final class WebHelper {
    private static final List<String> PROXY_HEADERS = List.of("CF-Connecting-IP", "X-Real-IP", "X-Forwarded-For");

    private WebHelper() {
    }

    public static String retrieveRemoteAddress(HttpServletRequest request) {
        if (request != null) {
            for (String proxyHeader : PROXY_HEADERS) {
                String originalAddress = request.getHeader(proxyHeader);
                if (originalAddress == null || originalAddress.isEmpty()) continue;
                int delimiter = originalAddress.indexOf(",");
                return delimiter > 0 ? originalAddress.substring(0, delimiter) : originalAddress;
            }
            return request.getRemoteAddr();
        }
        return null;
    }

    public static String retrieveWebUrl(Config config) {
        String address;
        if (config.hasKey(Keys.WEB_URL)) {
            return config.getString(Keys.WEB_URL).replaceAll("/$", "");
        }
        try {
            address = config.getString(Keys.WEB_ADDRESS, InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            address = "localhost";
        }
        return URIUtil.newURI((String)"http", (String)address, (int)config.getInteger(Keys.WEB_PORT));
    }
}

