/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class IotmProtocolEncoder
extends BaseProtocolEncoder {
    public IotmProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Command command) {
        if (!command.getType().equals("outputControl")) {
            return null;
        }
        String uniqueId = this.getUniqueId(command.getDeviceId());
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(2);
        buf.writeByte(2);
        buf.writeShortLE(8);
        buf.writeLongLE(Long.parseLong(uniqueId));
        buf.writeByte(4);
        buf.writeShortLE(10);
        buf.writeIntLE(Integer.MAX_VALUE);
        buf.writeByte(command.getInteger("index") - 1);
        buf.writeByte(0);
        buf.writeByte(3);
        buf.writeByte(command.getInteger("data"));
        buf.writeByte(176);
        buf.writeByte(177);
        buf.writeByte(Checksum.sum(buf.nioBuffer()));
        return MqttMessageBuilders.publish().topicName(uniqueId + "/OUTC").qos(MqttQoS.AT_LEAST_ONCE).payload(buf).messageId(0).build();
    }
}

